/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.lombok;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.modules.lombok.LombokGeneratedGetter;
import com.webcohesion.enunciate.modules.lombok.LombokGeneratedSetter;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

public class LombokMethodGenerator {
    private DecoratedTypeElement decoratedTypeElement;
    private DecoratedProcessingEnvironment env;

    public LombokMethodGenerator(DecoratedTypeElement decoratedTypeElement, DecoratedProcessingEnvironment env) {
        this.decoratedTypeElement = decoratedTypeElement;
        this.env = env;
    }

    public void generateLombokGettersAndSetters() {
        List fields = this.decoratedTypeElement.getFields();
        for (VariableElement field : fields) {
            if (this.shouldGenerateGetter(field)) {
                this.decoratedTypeElement.getMethods().add(new DecoratedExecutableElement((ExecutableElement)((Object)new LombokGeneratedGetter(field, this.env)), this.env));
            }
            if (!this.shouldGenerateSetter(field)) continue;
            this.decoratedTypeElement.getMethods().add(new DecoratedExecutableElement((ExecutableElement)((Object)new LombokGeneratedSetter(field, this.env)), this.env));
        }
    }

    private boolean shouldGenerateGetter(Element field) {
        String fieldSimpleName = field.getSimpleName().toString();
        for (ExecutableElement method : this.decoratedTypeElement.getMethods()) {
            DecoratedExecutableElement decoratedMethod = (DecoratedExecutableElement)method;
            if (decoratedMethod.getPropertyName() == null || !decoratedMethod.getPropertyName().equals(fieldSimpleName) || !decoratedMethod.isGetter()) continue;
            return false;
        }
        if (field.getAnnotation(Getter.class) != null) {
            return true;
        }
        if (this.decoratedTypeElement.getAnnotation(Getter.class) != null) {
            return true;
        }
        return this.decoratedTypeElement.getAnnotation(Data.class) != null;
    }

    private boolean shouldGenerateSetter(Element field) {
        String fieldSimpleName = field.getSimpleName().toString();
        for (ExecutableElement method : this.decoratedTypeElement.getMethods()) {
            DecoratedExecutableElement decoratedMethod = (DecoratedExecutableElement)method;
            if (decoratedMethod.getPropertyName() == null || !decoratedMethod.getPropertyName().equals(fieldSimpleName) || !decoratedMethod.isSetter()) continue;
            return false;
        }
        if (field.getAnnotation(Setter.class) != null) {
            return true;
        }
        if (this.decoratedTypeElement.getAnnotation(Setter.class) != null) {
            return true;
        }
        return this.decoratedTypeElement.getAnnotation(Data.class) != null;
    }
}

