/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.model;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.ElementDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertySpec;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import com.webcohesion.enunciate.modules.jaxrs.model.PathContext;
import com.webcohesion.enunciate.modules.jaxrs.model.PathSegment;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameterConstraints;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameterDataType;
import com.webcohesion.enunciate.util.IgnoreUtils;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;

public class ResourceParameter
extends DecoratedElement<Element>
implements Comparable<ResourceParameter> {
    public static final List<String> FORM_BEAN_ANNOTATIONS = Arrays.asList("org.jboss.resteasy.annotations.Form", "javax.ws.rs.BeanParam", "com.sun.jersey.api.core.InjectParam");
    private final PathContext context;
    private final String parameterName;
    private final String defaultValue;
    private final String typeName;
    private final boolean matrixParam;
    private final boolean queryParam;
    private final boolean pathParam;
    private final boolean cookieParam;
    private final boolean headerParam;
    private final boolean formParam;
    private final boolean multivalued;
    private ResourceParameterConstraints constraints;
    private ResourceParameterDataType dataType;

    public ResourceParameter(Element declaration, PathContext context) {
        this(declaration, context, null);
    }

    protected ResourceParameter(Element declaration, PathContext context, @Nullable Boolean multivalued) {
        super(declaration, context.getContext().getContext().getProcessingEnvironment());
        FormParam formParam;
        HeaderParam headerParam;
        CookieParam cookieParam;
        PathParam pathParam;
        QueryParam queryParam;
        this.context = context;
        String parameterName = null;
        String typeName = null;
        boolean matrix = false;
        boolean query = false;
        boolean path = false;
        boolean cookie = false;
        boolean header = false;
        boolean form = false;
        MatrixParam matrixParam = declaration.getAnnotation(MatrixParam.class);
        if (matrixParam != null) {
            parameterName = matrixParam.value();
            typeName = "matrix";
            matrix = true;
        }
        if ((queryParam = declaration.getAnnotation(QueryParam.class)) != null) {
            parameterName = queryParam.value();
            typeName = "query";
            query = true;
        }
        if ((pathParam = declaration.getAnnotation(PathParam.class)) != null) {
            parameterName = pathParam.value();
            typeName = "path";
            path = true;
        }
        if ((cookieParam = declaration.getAnnotation(CookieParam.class)) != null) {
            parameterName = cookieParam.value();
            typeName = "cookie";
            cookie = true;
        }
        if ((headerParam = declaration.getAnnotation(HeaderParam.class)) != null) {
            parameterName = headerParam.value();
            typeName = "header";
            header = true;
        }
        if ((formParam = declaration.getAnnotation(FormParam.class)) != null) {
            parameterName = formParam.value();
            typeName = "form";
            form = true;
        }
        if (typeName == null) {
            for (AnnotationMirror annotationMirror : declaration.getAnnotationMirrors()) {
                TypeElement decl = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (decl == null) continue;
                String fqn = decl.getQualifiedName().toString();
                if (!this.context.getContext().getCustomResourceParameterAnnotations().contains(fqn)) continue;
                parameterName = declaration.getSimpleName().toString();
                typeName = decl.getSimpleName().toString().toLowerCase().replaceAll("param", "");
                break;
            }
        }
        if (typeName == null) {
            typeName = "custom";
        }
        this.multivalued = multivalued != null ? multivalued.booleanValue() : this.multivaluedAutoDetection();
        this.parameterName = parameterName;
        this.matrixParam = matrix;
        this.queryParam = query;
        this.pathParam = path;
        this.cookieParam = cookie;
        this.headerParam = header;
        this.formParam = form;
        this.typeName = typeName;
        DefaultValue defaultValue = declaration.getAnnotation(DefaultValue.class);
        this.defaultValue = defaultValue != null ? defaultValue.value() : null;
    }

    private boolean multivaluedAutoDetection() {
        DecoratedTypeMirror parameterType = this.loadType();
        return parameterType.isArray() || parameterType.isCollection();
    }

    public DecoratedTypeMirror loadType() {
        TypeHint hint = (TypeHint)this.getAnnotation(TypeHint.class);
        if (hint != null) {
            return (DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)hint, (DecoratedProcessingEnvironment)this.getContext().getContext().getContext().getProcessingEnvironment(), (TypeMirror)this.asType());
        }
        return (DecoratedTypeMirror)this.asType();
    }

    public static boolean isResourceParameter(Element candidate, EnunciateJaxrsContext context) {
        if (IgnoreUtils.isIgnored((Element)candidate)) {
            return false;
        }
        if (!ResourceParameter.isSystemParameter(candidate, context)) {
            for (AnnotationMirror annotationMirror : candidate.getAnnotationMirrors()) {
                TypeElement declaration = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (declaration == null) continue;
                String fqn = declaration.getQualifiedName().toString();
                if (MatrixParam.class.getName().equals(fqn) || QueryParam.class.getName().equals(fqn) || PathParam.class.getName().equals(fqn) || CookieParam.class.getName().equals(fqn) || HeaderParam.class.getName().equals(fqn) || FormParam.class.getName().equals(fqn)) {
                    return true;
                }
                if (context.getSystemResourceParameterAnnotations().contains(fqn)) {
                    return false;
                }
                if (!context.getCustomResourceParameterAnnotations().contains(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSystemParameter(Element candidate, EnunciateJaxrsContext context) {
        for (AnnotationMirror annotationMirror : candidate.getAnnotationMirrors()) {
            TypeElement declaration = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (declaration == null) continue;
            String fqn = declaration.getQualifiedName().toString();
            if (Context.class.getName().equals(fqn) && candidate.getAnnotation(TypeHint.class) == null) {
                return true;
            }
            if (Suspended.class.getName().equals(fqn) && candidate.getAnnotation(TypeHint.class) == null) {
                return true;
            }
            if (!context.getSystemResourceParameterAnnotations().contains(fqn)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBeanParameter(Element candidate) {
        for (AnnotationMirror annotationMirror : candidate.getAnnotationMirrors()) {
            String fqn;
            TypeElement declaration = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (declaration == null || !FORM_BEAN_ANNOTATIONS.contains(fqn = declaration.getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    public static List<ResourceParameter> getFormBeanParameters(VariableElement parameterDeclaration, PathContext context) {
        ArrayList<ResourceParameter> formBeanParameters = new ArrayList<ResourceParameter>();
        ResourceParameter.gatherFormBeanParameters(parameterDeclaration.asType(), formBeanParameters, context);
        return formBeanParameters;
    }

    private static void gatherFormBeanParameters(TypeMirror type, ArrayList<ResourceParameter> beanParams, PathContext context) {
        if (type instanceof DeclaredType) {
            DecoratedTypeElement typeDeclaration = (DecoratedTypeElement)ElementDecorator.decorate((Element)((DeclaredType)type).asElement(), (DecoratedProcessingEnvironment)context.getContext().getContext().getProcessingEnvironment());
            for (VariableElement field : ElementFilter.fieldsIn(typeDeclaration.getEnclosedElements())) {
                if (ResourceParameter.isResourceParameter(field, context.getContext())) {
                    beanParams.add(new ResourceParameter(field, context));
                    continue;
                }
                if (!ResourceParameter.isBeanParameter(field)) continue;
                ResourceParameter.gatherFormBeanParameters(field.asType(), beanParams, context);
            }
            ArrayList properties = new ArrayList(typeDeclaration.getProperties((PropertySpec)new JaxRsResourceParameterPropertySpec(context.getContext().getContext().getProcessingEnvironment())));
            for (PropertyElement property : properties) {
                if (ResourceParameter.isResourceParameter((Element)property, context.getContext())) {
                    beanParams.add(new ResourceParameter((Element)property, context));
                    continue;
                }
                if (!ResourceParameter.isBeanParameter((Element)property)) continue;
                ResourceParameter.gatherFormBeanParameters(property.getPropertyType(), beanParams, context);
            }
            if (typeDeclaration.getKind() == ElementKind.CLASS) {
                ResourceParameter.gatherFormBeanParameters(typeDeclaration.getSuperclass(), beanParams, context);
            }
        }
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMatrixParam() {
        return this.matrixParam;
    }

    public boolean isQueryParam() {
        return this.queryParam;
    }

    public boolean isPathParam() {
        return this.pathParam;
    }

    public boolean isCookieParam() {
        return this.cookieParam;
    }

    public boolean isHeaderParam() {
        return this.headerParam;
    }

    public boolean isFormParam() {
        return this.formParam;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isMultivalued() {
        return this.multivalued;
    }

    public ResourceParameterConstraints getConstraints() {
        if (this.constraints == null) {
            this.constraints = this.loadConstraints();
        }
        return this.constraints;
    }

    public ResourceParameterConstraints loadConstraints() {
        String regex = null;
        String componentName = "{" + this.getParameterName() + "}";
        for (PathSegment component : this.context.getPathComponents()) {
            if (!componentName.equals(component.getValue())) continue;
            regex = component.getRegex();
            break;
        }
        if (regex != null) {
            return new ResourceParameterConstraints.Regex(regex);
        }
        DecoratedTypeMirror type = this.loadType();
        DecoratedTypeMirror componentType = TypeMirrorUtils.getComponentType((DecoratedTypeMirror)type, (DecoratedProcessingEnvironment)this.context.getContext().getContext().getProcessingEnvironment());
        if (componentType != null) {
            type = componentType;
        }
        try {
            type = (DecoratedTypeMirror)this.context.getContext().getContext().getProcessingEnvironment().getTypeUtils().unboxedType((TypeMirror)type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type.isPrimitive()) {
            return new ResourceParameterConstraints.Primitive(type.getKind());
        }
        if (type.isEnum()) {
            List enumConstants = ((DecoratedTypeElement)((DeclaredType)type).asElement()).enumValues();
            TreeSet<String> values = new TreeSet<String>();
            for (VariableElement enumConstant : enumConstants) {
                values.add(enumConstant.getSimpleName().toString());
            }
            return new ResourceParameterConstraints.Enumeration(values);
        }
        return ResourceParameterConstraints.Unbound.STRING;
    }

    public ResourceParameterDataType getDataType() {
        if (this.dataType == null) {
            this.dataType = this.loadDataType();
        }
        return this.dataType;
    }

    private ResourceParameterDataType loadDataType() {
        DecoratedTypeMirror type = this.loadType();
        DecoratedTypeMirror componentType = TypeMirrorUtils.getComponentType((DecoratedTypeMirror)type, (DecoratedProcessingEnvironment)this.context.getContext().getContext().getProcessingEnvironment());
        if (componentType != null) {
            type = componentType;
        }
        try {
            type = (DecoratedTypeMirror)this.context.getContext().getContext().getProcessingEnvironment().getTypeUtils().unboxedType((TypeMirror)type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type.isPrimitive()) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    return ResourceParameterDataType.BOOLEAN;
                }
                case SHORT: 
                case INT: {
                    return ResourceParameterDataType.INT32;
                }
                case LONG: {
                    return ResourceParameterDataType.INT64;
                }
                case DOUBLE: {
                    return ResourceParameterDataType.DOUBLE;
                }
                case FLOAT: {
                    return ResourceParameterDataType.FLOAT;
                }
            }
            return ResourceParameterDataType.STRING;
        }
        if (type.isEnum()) {
            return ResourceParameterDataType.STRING;
        }
        if (this.isFormParam()) {
            return ResourceParameterDataType.STRING;
        }
        if (this.getTypeName().contains("form")) {
            if (type.isInstanceOf(String.class)) {
                return ResourceParameterDataType.STRING;
            }
            return ResourceParameterDataType.FILE;
        }
        return ResourceParameterDataType.STRING;
    }

    protected JavaDoc getJavaDoc(JavaDocTagHandler tagHandler, boolean useDelegate) {
        return super.getJavaDoc(tagHandler, true);
    }

    public PathContext getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceParameter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceParameter that = (ResourceParameter)o;
        return !(this.getParameterName() == null ? that.getParameterName() != null : !this.getParameterName().equals(that.getParameterName())) && !(this.getTypeName() == null ? that.getTypeName() != null : !this.getTypeName().equals(that.getTypeName()));
    }

    public int hashCode() {
        String pName = this.getParameterName();
        String tName = this.getTypeName();
        int result = pName != null ? pName.hashCode() : 0;
        result = 31 * result + (tName != null ? tName.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ResourceParameter other) {
        return (this.getTypeName() + this.getParameterName()).compareTo(other.getTypeName() + other.getParameterName());
    }

    private static class JaxRsResourceParameterPropertySpec
    extends ElementUtils.DefaultPropertySpec {
        JaxRsResourceParameterPropertySpec(DecoratedProcessingEnvironment env) {
            super(env);
        }

        public boolean isGetter(DecoratedExecutableElement executable) {
            return executable.isGetter();
        }

        public boolean isSetter(DecoratedExecutableElement executable) {
            return executable.isSetter();
        }
    }
}

