/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.PathSummary;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.metadata.Label;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.PathSummaryImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.util.PathSummaryComparator;
import com.webcohesion.enunciate.util.ResourceComparator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class ResourceClassResourceGroupImpl
implements ResourceGroup {
    private final com.webcohesion.enunciate.modules.jaxrs.model.Resource resourceClass;
    private final List<Resource> resources = new ArrayList<Resource>();
    private final String contextPath;
    private final String slug;
    private final ApiRegistrationContext registrationContext;

    public ResourceClassResourceGroupImpl(com.webcohesion.enunciate.modules.jaxrs.model.Resource resourceClass, String slug, String contextPath, ApiRegistrationContext registrationContext) {
        this.resourceClass = resourceClass;
        this.contextPath = contextPath;
        this.slug = slug;
        FacetFilter facetFilter = resourceClass.getContext().getContext().getConfiguration().getFacetFilter();
        for (ResourceMethod resourceMethod : resourceClass.getResourceMethods(true)) {
            if (!facetFilter.accept((HasFacets)resourceMethod)) continue;
            this.resources.add(new ResourceImpl(resourceMethod, this, registrationContext));
        }
        Collections.sort(this.resources, new ResourceComparator(resourceClass.getContext().getPathSortStrategy()));
        this.registrationContext = registrationContext;
    }

    public String getSlug() {
        return "resource_" + this.slug;
    }

    public String getLabel() {
        JavaDoc.JavaDocTagList tags;
        Label generic;
        String label = this.resourceClass.getSimpleName().toString();
        ResourceLabel resourceLabel = (ResourceLabel)this.resourceClass.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && !"##default".equals(resourceLabel.value())) {
            label = resourceLabel.value();
        }
        if ((generic = (Label)this.resourceClass.getAnnotation(Label.class)) != null) {
            label = generic.value();
        }
        if ((tags = (JavaDoc.JavaDocTagList)this.resourceClass.getJavaDoc().get((Object)"label")) != null && tags.size() > 0) {
            String tag = ((String)tags.get(0)).trim();
            label = tag.isEmpty() ? label : tag;
        }
        return label;
    }

    public String getSortKey() {
        String sortKey = this.getLabel();
        ResourceLabel resourceLabel = (ResourceLabel)this.resourceClass.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && !"##default".equals(resourceLabel.sortKey())) {
            sortKey = resourceLabel.sortKey();
        }
        return sortKey;
    }

    public String getRelativeContextPath() {
        return this.contextPath;
    }

    public String getDescription() {
        return this.resourceClass.getJavaDoc(this.registrationContext.getTagHandler()).toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.resourceClass, (JavaDocTagHandler)this.registrationContext.getTagHandler());
    }

    public List<PathSummary> getPaths() {
        HashMap<String, PathSummary> summaries = new HashMap<String, PathSummary>();
        for (Resource resource : this.resources) {
            TreeSet<String> methods = new TreeSet<String>();
            for (Method method : resource.getMethods()) {
                methods.add(method.getHttpMethod());
            }
            PathSummary summary = (PathSummary)summaries.get(resource.getPath());
            if (summary == null) {
                summary = new PathSummaryImpl(resource.getPath(), methods, resource.getStyles());
                summaries.put(resource.getPath(), summary);
                continue;
            }
            summary.getMethods().addAll(methods);
        }
        ArrayList<PathSummary> pathSummaries = new ArrayList<PathSummary>(summaries.values());
        Collections.sort(pathSummaries, new PathSummaryComparator(this.resourceClass.getContext().getPathSortStrategy()));
        return pathSummaries;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.resourceClass.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.resourceClass.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.resourceClass.getFacets();
    }

    public JavaDoc getJavaDoc() {
        return this.resourceClass.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.resourceClass), (Map)this.resourceClass.getContext().getContext().getConfiguration().getAnnotationStyles());
    }
}

