/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.Example;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Parameter;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.api.resources.StatusCode;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.MethodExampleImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.ParameterImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.RequestEntityImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.ResponseEntityImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.ResponseHeaderParameterImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.StatusCodeImpl;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.jaxrs.model.ResponseCode;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class MethodImpl
implements Method {
    private static final MediaType MULTIPART_FORM_DATA = new MediaType("multipart/form-data", 1.0f);
    private final String httpMethod;
    private final ResourceMethod resourceMethod;
    private final ResourceGroup group;
    private final MethodExampleImpl example;
    private final ApiRegistrationContext registrationContext;

    public MethodImpl(String httpMethod, ResourceMethod resourceMethod, ResourceGroup group, ApiRegistrationContext registrationContext) {
        this.httpMethod = httpMethod;
        this.resourceMethod = resourceMethod;
        this.group = group;
        this.registrationContext = registrationContext;
        this.example = this.resourceMethod.getContext().isDisableExamples() ? null : new MethodExampleImpl(this.httpMethod, this.resourceMethod, this.registrationContext);
    }

    public Resource getResource() {
        return new ResourceImpl(this.resourceMethod, this.group, this.registrationContext);
    }

    public String getLabel() {
        return this.resourceMethod.getLabel() == null ? this.httpMethod : this.resourceMethod.getLabel();
    }

    public String getDeveloperLabel() {
        return this.resourceMethod.getSimpleName().toString();
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getSlug() {
        return this.group.getSlug() + "_" + this.resourceMethod.getSlug() + "_" + this.httpMethod;
    }

    public String getDescription() {
        return this.resourceMethod.getJavaDoc(this.registrationContext.getTagHandler()).toString();
    }

    public String getDeprecated() {
        String deprecated = ElementUtils.findDeprecationMessage((DecoratedElement)this.resourceMethod, (JavaDocTagHandler)this.registrationContext.getTagHandler());
        if (deprecated == null) {
            deprecated = ElementUtils.findDeprecationMessage((DecoratedElement)this.resourceMethod.getParent(), (JavaDocTagHandler)this.registrationContext.getTagHandler());
        }
        return deprecated;
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"since");
        return tags == null ? null : tags.toString();
    }

    public List<String> getSeeAlso() {
        return (List)this.resourceMethod.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"see");
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public boolean isIncludeDefaultParameterValues() {
        for (ResourceParameter parameter : this.resourceMethod.getResourceParameters()) {
            if (parameter.getDefaultValue() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isHasParameterConstraints() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.getConstraints() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isHasParameterMultiplicity() {
        for (ResourceParameter parameter : this.resourceMethod.getResourceParameters()) {
            if (!parameter.isMultivalued()) continue;
            return true;
        }
        return false;
    }

    public List<? extends Parameter> getParameters() {
        Set<ResourceParameter> resourceParams = this.resourceMethod.getResourceParameters();
        ArrayList<ParameterImpl> parameters = new ArrayList<ParameterImpl>(resourceParams.size());
        for (ResourceParameter param : resourceParams) {
            parameters.add(new ParameterImpl(param, this.registrationContext));
        }
        return parameters;
    }

    public Entity getRequestEntity() {
        ResourceEntityParameter entityParameter = this.resourceMethod.getEntityParameter();
        if (entityParameter != null || this.resourceMethod.getConsumesMediaTypes().contains(MULTIPART_FORM_DATA)) {
            return new RequestEntityImpl(this.resourceMethod, entityParameter, this.registrationContext);
        }
        return null;
    }

    public List<? extends StatusCode> getResponseCodes() {
        ArrayList<StatusCodeImpl> statusCodes = new ArrayList<StatusCodeImpl>();
        for (ResponseCode responseCode : this.resourceMethod.getStatusCodes()) {
            statusCodes.add(new StatusCodeImpl(responseCode, this.registrationContext));
        }
        return statusCodes;
    }

    public Entity getResponseEntity() {
        ResourceRepresentationMetadata responseMetadata = this.resourceMethod.getRepresentationMetadata();
        return responseMetadata == null ? null : new ResponseEntityImpl(this.resourceMethod, responseMetadata, this.registrationContext);
    }

    public List<? extends StatusCode> getWarnings() {
        ArrayList<StatusCodeImpl> statusCodes = new ArrayList<StatusCodeImpl>();
        for (ResponseCode responseCode : this.resourceMethod.getWarnings()) {
            statusCodes.add(new StatusCodeImpl(responseCode, this.registrationContext));
        }
        return statusCodes;
    }

    public List<? extends Parameter> getResponseHeaders() {
        Map<String, String> responseHeaders = this.resourceMethod.getResponseHeaders();
        ArrayList<ResponseHeaderParameterImpl> headerValues = new ArrayList<ResponseHeaderParameterImpl>();
        for (Map.Entry<String, String> responseHeader : responseHeaders.entrySet()) {
            headerValues.add(new ResponseHeaderParameterImpl(responseHeader.getKey(), responseHeader.getValue(), Collections.emptySet()));
        }
        return headerValues;
    }

    public Set<String> getSecurityRoles() {
        return this.resourceMethod.getSecurityRoles();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.resourceMethod.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.resourceMethod.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.resourceMethod.getFacets();
    }

    public JavaDoc getJavaDoc() {
        return this.resourceMethod.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.resourceMethod), (Map)this.resourceMethod.getContext().getContext().getConfiguration().getAnnotationStyles());
    }

    public Example getExample() {
        return this.example;
    }

    public ResourceMethod getResourceMethod() {
        return this.resourceMethod;
    }
}

