/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ExtinctionFilter;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.SearchMode;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NameLNLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.RollbackTracker;
import com.sleepycat.je.rep.LogFileRewriteListener;
import com.sleepycat.je.rep.SyncupProgress;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.ReplayStatDefinition;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.txn.ReplayTxn;
import com.sleepycat.je.rep.utilint.LongMinZeroStat;
import com.sleepycat.je.rep.utilint.SimpleTxnMap;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.RollbackEnd;
import com.sleepycat.je.txn.RollbackStart;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnEnd;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongMaxStat;
import com.sleepycat.je.utilint.LongMaxZeroStat;
import com.sleepycat.je.utilint.LongMinStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.NanoTimeUtil;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import com.sleepycat.utilint.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Replay {
    private static final String RBSTATUS_START = "Started Rollback";
    private static final String RBSTATUS_NO_ACTIVE = "No active txns, nothing to rollback";
    private static final String RBSTATUS_RANGE_EQUALS = "End of range equals matchpoint, nothing to rollback";
    private static final String RBSTATUS_LOG_RBSTART = "Logged RollbackStart entry";
    private static final String RBSTATUS_MEM_ROLLBACK = "Finished in-memory rollback";
    private static final String RBSTATUS_INVISIBLE = "Finished invisible setting";
    private static final String RBSTATUS_FINISH = "Finished rollback";
    final DatabaseEntry replayKeyEntry = new DatabaseEntry();
    final DatabaseEntry replayDataEntry = new DatabaseEntry();
    final DatabaseEntry delDataEntry = new DatabaseEntry();
    private final RepImpl repImpl;
    private final long ackTimeoutLogThresholdNs;
    private final SimpleTxnMap<ReplayTxn> activeTxns;
    private volatile TxnInfo lastReplayedTxn = null;
    private volatile VLSN lastReplayedVLSN = null;
    private long lastReplayedDTVLSN = -1L;
    private final Durability.SyncPolicy noAckSyncPolicy = Durability.SyncPolicy.NO_SYNC;
    private final long replayLoggingThresholdNs;
    private final BlockingQueue<Long> outputQueue;
    private final GroupCommit groupCommit;
    private final StatGroup statistics;
    private final LongStat nCommits;
    private final LongStat nCommitAcks;
    private final LongStat nCommitSyncs;
    private final LongStat nCommitNoSyncs;
    private final LongStat nCommitWriteNoSyncs;
    private final LongStat nAborts;
    private final LongStat nNameLNs;
    private final LongStat nLNs;
    private final LongStat nElapsedTxnTime;
    private final LongStat nMessageQueueOverflows;
    private final LongMinStat minCommitProcessingNanos;
    private final LongMaxStat maxCommitProcessingNanos;
    private final LongStat totalCommitProcessingNanos;
    private final LongStat totalCommitLagMs;
    private final LongStat latestCommitLagMs;
    private final Logger logger;

    public Replay(RepImpl repImpl, NameIdPair nameIdPair) {
        if (repImpl.isReadOnly()) {
            throw EnvironmentFailureException.unexpectedState("Replay created with readonly ReplicatedEnvironment");
        }
        this.repImpl = repImpl;
        DbConfigManager configManager = repImpl.getConfigManager();
        this.ackTimeoutLogThresholdNs = TimeUnit.MILLISECONDS.toNanos(configManager.getDuration(RepParams.REPLICA_ACK_TIMEOUT));
        int outputQueueSize = 2 * configManager.getInt(RepParams.REPLICA_MESSAGE_QUEUE_SIZE);
        this.outputQueue = new ArrayBlockingQueue<Long>(outputQueueSize);
        this.activeTxns = new SimpleTxnMap(1024);
        this.delDataEntry.setPartial(0, 0, true);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.statistics = new StatGroup("Replay", "The Replay unit applies the incoming replication stream at a Replica. These stats show the load the Replica incurs when processing updates.");
        this.groupCommit = new GroupCommit(configManager);
        this.nCommits = new LongStat(this.statistics, ReplayStatDefinition.N_COMMITS);
        this.nCommitAcks = new LongStat(this.statistics, ReplayStatDefinition.N_COMMIT_ACKS);
        this.nCommitSyncs = new LongStat(this.statistics, ReplayStatDefinition.N_COMMIT_SYNCS);
        this.nCommitNoSyncs = new LongStat(this.statistics, ReplayStatDefinition.N_COMMIT_NO_SYNCS);
        this.nCommitWriteNoSyncs = new LongStat(this.statistics, ReplayStatDefinition.N_COMMIT_WRITE_NO_SYNCS);
        this.nAborts = new LongStat(this.statistics, ReplayStatDefinition.N_ABORTS);
        this.nNameLNs = new LongStat(this.statistics, ReplayStatDefinition.N_NAME_LNS);
        this.nLNs = new LongStat(this.statistics, ReplayStatDefinition.N_LNS);
        this.nElapsedTxnTime = new LongStat(this.statistics, ReplayStatDefinition.N_ELAPSED_TXN_TIME);
        this.nMessageQueueOverflows = new LongStat(this.statistics, ReplayStatDefinition.N_MESSAGE_QUEUE_OVERFLOWS);
        this.minCommitProcessingNanos = new LongMinZeroStat(this.statistics, ReplayStatDefinition.MIN_COMMIT_PROCESSING_NANOS);
        this.maxCommitProcessingNanos = new LongMaxZeroStat(this.statistics, ReplayStatDefinition.MAX_COMMIT_PROCESSING_NANOS);
        this.totalCommitProcessingNanos = new LongStat(this.statistics, ReplayStatDefinition.TOTAL_COMMIT_PROCESSING_NANOS);
        this.totalCommitLagMs = new LongStat(this.statistics, ReplayStatDefinition.TOTAL_COMMIT_LAG_MS);
        this.latestCommitLagMs = new LongStat(this.statistics, ReplayStatDefinition.LATEST_COMMIT_LAG_MS);
        this.replayLoggingThresholdNs = TimeUnit.MILLISECONDS.toNanos(configManager.getDuration(RepParams.REPLAY_LOGGING_THRESHOLD));
    }

    public BlockingQueue<Long> getOutputQueue() {
        return this.outputQueue;
    }

    public void reset() {
        this.outputQueue.clear();
    }

    LongStat getMessageQueueOverflows() {
        return this.nMessageQueueOverflows;
    }

    public void preRecoveryCheckpointInit(RecoveryInfo recoveryInfo) {
        for (Txn txn : recoveryInfo.replayTxns.values()) {
            ((ReplayTxn)txn).registerWithActiveTxns(this.activeTxns);
        }
        this.lastReplayedVLSN = this.repImpl.getVLSNIndex().getRange().getLast();
    }

    public TxnInfo getLastReplayedTxn() {
        return this.lastReplayedTxn;
    }

    public VLSN getLastReplayedVLSN() {
        return this.lastReplayedVLSN;
    }

    public void abortOldTxns() throws DatabaseException {
        int masterNodeId = this.repImpl.getNodeId();
        for (ReplayTxn replayTxn : this.copyActiveTxns().values()) {
            replayTxn.abort(ReplicationContext.MASTER, masterNodeId, -1L);
        }
        assert (this.activeTxns.isEmpty()) : "Unexpected txns in activeTxns = " + this.activeTxns;
    }

    private void updateCommitStats(boolean needsAck, Durability.SyncPolicy syncPolicy, long startTimeNanos, long masterCommitTimeMs, long replicaCommitTimeMs) {
        long now = System.nanoTime();
        long commitNanos = now - startTimeNanos;
        if (commitNanos > this.ackTimeoutLogThresholdNs && this.logger.isLoggable(Level.INFO)) {
            LoggerUtils.info(this.logger, this.repImpl, "Replay commit time: " + commitNanos / 1000000L + " ms exceeded log threshold: " + this.ackTimeoutLogThresholdNs / 1000000L);
        }
        this.nCommits.increment();
        if (needsAck) {
            this.nCommitAcks.increment();
        }
        if (syncPolicy == Durability.SyncPolicy.SYNC) {
            this.nCommitSyncs.increment();
        } else if (syncPolicy == Durability.SyncPolicy.NO_SYNC) {
            this.nCommitNoSyncs.increment();
        } else if (syncPolicy == Durability.SyncPolicy.WRITE_NO_SYNC) {
            this.nCommitWriteNoSyncs.increment();
        } else {
            throw EnvironmentFailureException.unexpectedState("Unknown sync policy: " + (Object)((Object)syncPolicy));
        }
        this.totalCommitProcessingNanos.add(commitNanos);
        this.minCommitProcessingNanos.setMin(commitNanos);
        this.maxCommitProcessingNanos.setMax(commitNanos);
        long replicaLagMs = replicaCommitTimeMs - masterCommitTimeMs;
        this.totalCommitLagMs.add(replicaLagMs);
        this.latestCommitLagMs.set(replicaLagMs);
    }

    public void replayEntry(long startNs, BaseProtocol.Entry entry) throws DatabaseException, IOException, InterruptedException, MasterStatus.MasterSyncException {
        InputWireRecord wireRecord = entry.getWireRecord();
        LogEntry logEntry = wireRecord.getLogEntry();
        if (!wireRecord.getVLSN().follows(this.lastReplayedVLSN)) {
            throw EnvironmentFailureException.unexpectedState(this.repImpl, "Rep stream not sequential. Current VLSN: " + this.lastReplayedVLSN + " next log entry VLSN: " + wireRecord.getVLSN());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            LoggerUtils.finest(this.logger, this.repImpl, "Replaying " + wireRecord);
        }
        ReplayTxn repTxn = this.getReplayTxn(logEntry.getTransactionId(), true);
        this.updateReplicaSequences(logEntry);
        byte entryType = wireRecord.getEntryType();
        this.lastReplayedVLSN = wireRecord.getVLSN();
        try {
            long txnId = repTxn.getId();
            if (LogEntryType.LOG_TXN_COMMIT.equalsType(entryType)) {
                BaseProtocol.Commit commitEntry = (BaseProtocol.Commit)entry;
                boolean needsAck = commitEntry.getNeedsAck();
                Durability.SyncPolicy txnSyncPolicy = commitEntry.getReplicaSyncPolicy();
                Durability.SyncPolicy implSyncPolicy = needsAck ? this.groupCommit.getImplSyncPolicy(txnSyncPolicy) : this.noAckSyncPolicy;
                this.logReplay(repTxn, needsAck, implSyncPolicy);
                TxnCommit commit = (TxnCommit)logEntry.getMainItem();
                long dtvlsn = this.updateDTVLSN(commit);
                if (needsAck) {
                    this.repImpl.getRepNode().getVLSNFreezeLatch().awaitThaw();
                    this.repImpl.getRepNode().getMasterStatus().assertSync();
                }
                repTxn.commit(implSyncPolicy, new ReplicationContext(this.lastReplayedVLSN), commit.getMasterNodeId(), dtvlsn);
                long masterCommitTimeMs = commit.getTime().getTime();
                this.lastReplayedTxn = new TxnInfo(this.lastReplayedVLSN, masterCommitTimeMs);
                this.updateCommitStats(needsAck, implSyncPolicy, startNs, masterCommitTimeMs, repTxn.getEndTime());
                if (needsAck && !this.groupCommit.bufferAck(startNs, repTxn, txnSyncPolicy)) {
                    this.queueAck(txnId);
                }
                if (repTxn.getRepGroupDbChange() && this.canRefreshGroup(repTxn)) {
                    this.repImpl.getRepNode().refreshCachedGroup();
                    this.repImpl.getRepNode().recalculateGlobalCBVLSN();
                }
                this.nElapsedTxnTime.add(repTxn.elapsedTime());
            } else if (LogEntryType.LOG_TXN_ABORT.equalsType(entryType)) {
                this.nAborts.increment();
                TxnAbort abort = (TxnAbort)logEntry.getMainItem();
                ReplicationContext abortContext = new ReplicationContext(wireRecord.getVLSN());
                if (this.logger.isLoggable(Level.FINEST)) {
                    LoggerUtils.finest(this.logger, this.repImpl, "abort called for " + txnId + " masterId=" + abort.getMasterNodeId() + " repContext=" + abortContext);
                }
                long dtvlsn = this.updateDTVLSN(abort);
                repTxn.abort(abortContext, abort.getMasterNodeId(), dtvlsn);
                this.lastReplayedTxn = new TxnInfo(this.lastReplayedVLSN, abort.getTime().getTime());
                if (repTxn.getRepGroupDbChange() && this.canRefreshGroup(repTxn)) {
                    this.repImpl.getRepNode().refreshCachedGroup();
                }
                this.nElapsedTxnTime.add(repTxn.elapsedTime());
            } else if (LogEntryType.LOG_NAMELN_TRANSACTIONAL.equalsType(entryType)) {
                this.repImpl.getRepNode().getReplica().clearDbTreeCache();
                this.nNameLNs.increment();
                this.applyNameLN(repTxn, wireRecord);
            } else {
                this.nLNs.increment();
                assert (wireRecord.getLogEntry() instanceof LNLogEntry);
                this.applyLN(repTxn, wireRecord);
            }
            repTxn.setLastAppliedVLSN(this.lastReplayedVLSN);
        }
        catch (DatabaseException e) {
            e.addErrorMessage("Problem seen replaying entry " + wireRecord);
            throw e;
        }
        finally {
            long elapsedNs = System.nanoTime() - startNs;
            if (elapsedNs > this.replayLoggingThresholdNs) {
                LoggerUtils.info(this.logger, this.repImpl, "Replay time for entry type:" + LogEntryType.findType(entryType) + " " + TimeUnit.NANOSECONDS.toMillis(elapsedNs) + "ms exceeded threshold:" + TimeUnit.NANOSECONDS.toMillis(this.replayLoggingThresholdNs) + "ms");
            }
        }
    }

    private long updateDTVLSN(TxnEnd txnEnd) {
        long txnDTVLSN = txnEnd.getDTVLSN();
        if (txnDTVLSN == 0L) {
            long prevDTVLSN = this.repImpl.getRepNode().setDTVLSN(txnDTVLSN);
            if (prevDTVLSN != 0L) {
                LoggerUtils.info(this.logger, this.repImpl, "Transitioned to pre DTVLSN stream. DTVLSN:" + prevDTVLSN + " at VLSN:" + this.lastReplayedVLSN);
            }
            this.lastReplayedDTVLSN = txnDTVLSN;
            return txnDTVLSN;
        }
        if (txnDTVLSN < this.lastReplayedDTVLSN) {
            String msg = "DTVLSNs must be in ascending order in the stream.  prev DTVLSN:" + this.lastReplayedDTVLSN + " next DTVLSN:" + txnDTVLSN + " at VLSN: " + this.lastReplayedVLSN.getSequence();
            throw EnvironmentFailureException.unexpectedState(this.repImpl, msg);
        }
        if (this.lastReplayedDTVLSN == 0L && txnDTVLSN > 0L) {
            LoggerUtils.info(this.logger, this.repImpl, "Transitioned to post DTVLSN stream. DTVLSN:" + txnDTVLSN + " at VLSN:" + this.lastReplayedVLSN);
        }
        this.lastReplayedDTVLSN = txnDTVLSN;
        this.repImpl.getRepNode().setDTVLSN(txnDTVLSN);
        return txnDTVLSN;
    }

    void queueAck(long txnId) throws IOException {
        try {
            this.outputQueue.put(txnId);
        }
        catch (InterruptedException ie) {
            throw new IOException("Ack I/O interrupted", ie);
        }
    }

    private void logReplay(ReplayTxn repTxn, boolean needsAck, Durability.SyncPolicy syncPolicy) {
        if (!this.logger.isLoggable(Level.FINE)) {
            return;
        }
        if (needsAck) {
            LoggerUtils.fine(this.logger, this.repImpl, "Replay: got commit for txn=" + repTxn.getId() + ", ack needed, replica sync policy=" + (Object)((Object)syncPolicy) + " vlsn=" + this.lastReplayedVLSN);
        } else {
            LoggerUtils.fine(this.logger, this.repImpl, "Replay: got commit for txn=" + repTxn.getId() + " ack not needed vlsn=" + this.lastReplayedVLSN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canRefreshGroup(ReplayTxn txn) {
        SimpleTxnMap<ReplayTxn> simpleTxnMap = this.activeTxns;
        synchronized (simpleTxnMap) {
            for (ReplayTxn atxn : this.activeTxns.getMap().values()) {
                if (atxn == txn || !atxn.getRepGroupDbChange()) continue;
                return false;
            }
        }
        return true;
    }

    private void updateReplicaSequences(LogEntry logEntry) {
        this.repImpl.getTxnManager().updateFromReplay(logEntry.getTransactionId());
        if (logEntry instanceof NameLNLogEntry) {
            NameLNLogEntry nameLogEntry = (NameLNLogEntry)logEntry;
            nameLogEntry.postFetchInit(false);
            NameLN nameLN = (NameLN)nameLogEntry.getLN();
            this.repImpl.getDbTree().updateFromReplay(nameLN.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplayTxn getReplayTxn(long txnId, boolean registerTxnImmediately) throws DatabaseException {
        ReplayTxn useTxn = null;
        SimpleTxnMap<ReplayTxn> simpleTxnMap = this.activeTxns;
        synchronized (simpleTxnMap) {
            useTxn = this.activeTxns.get(txnId);
            if (useTxn == null) {
                useTxn = registerTxnImmediately ? new ReplayTxn(this.repImpl, TransactionConfig.DEFAULT, txnId, this.activeTxns, this.logger) : new ReplayTxn(this.repImpl, TransactionConfig.DEFAULT, txnId, this.activeTxns, this.logger){

                    @Override
                    protected boolean registerImmediately() {
                        return false;
                    }
                };
            }
        }
        return useTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNameLN(ReplayTxn repTxn, InputWireRecord wireRecord) throws DatabaseException {
        NameLNLogEntry nameLNEntry = (NameLNLogEntry)wireRecord.getLogEntry();
        NameLN nameLN = (NameLN)nameLNEntry.getLN();
        String databaseName = StringUtils.fromUTF8(nameLNEntry.getKey());
        DbOpReplicationContext repContext = new DbOpReplicationContext(wireRecord.getVLSN(), nameLNEntry);
        DbOperationType opType = repContext.getDbOperationType();
        DatabaseImpl dbImpl = null;
        try {
            switch (opType) {
                case CREATE: {
                    DatabaseConfig dbConfig = repContext.getCreateConfig().getReplicaConfig(this.repImpl);
                    dbImpl = this.repImpl.getDbTree().createReplicaDb(repTxn, databaseName, dbConfig, nameLN, repContext);
                    if (dbImpl.getId().getId() == -257L && !DbType.REP_GROUP.getInternalName().equals(databaseName)) {
                        throw EnvironmentFailureException.unexpectedState("Database: " + DbType.REP_GROUP.getInternalName() + " is associated with id: " + dbImpl.getId().getId() + " and not the reserved database id: " + -257L);
                    }
                    TriggerManager.runOpenTriggers((Locker)repTxn, dbImpl, true);
                    break;
                }
                case REMOVE: {
                    dbImpl = this.repImpl.getDbTree().getDb(nameLN.getId());
                    try {
                        this.repImpl.getDbTree().removeReplicaDb(repTxn, databaseName, nameLN.getId(), repContext);
                        TriggerManager.runRemoveTriggers(repTxn, dbImpl);
                        break;
                    }
                    catch (DatabaseNotFoundException e) {
                        throw EnvironmentFailureException.unexpectedState("Database: " + dbImpl.getName() + " Id: " + nameLN.getId() + " not found on the Replica.");
                    }
                }
                case TRUNCATE: {
                    dbImpl = this.repImpl.getDbTree().getDb(repContext.getTruncateOldDbId());
                    try {
                        DbTree.TruncateDbResult result = this.repImpl.getDbTree().truncateReplicaDb(repTxn, databaseName, false, nameLN, repContext);
                        TriggerManager.runTruncateTriggers(repTxn, result.newDb);
                        break;
                    }
                    catch (DatabaseNotFoundException e) {
                        throw EnvironmentFailureException.unexpectedState("Database: " + dbImpl.getName() + " Id: " + nameLN.getId() + " not found on the Replica.");
                    }
                }
                case RENAME: {
                    dbImpl = this.repImpl.getDbTree().getDb(nameLN.getId());
                    try {
                        dbImpl = this.repImpl.getDbTree().renameReplicaDb(repTxn, dbImpl.getName(), databaseName, nameLN, repContext);
                        TriggerManager.runRenameTriggers(repTxn, dbImpl, databaseName);
                        break;
                    }
                    catch (DatabaseNotFoundException e) {
                        throw EnvironmentFailureException.unexpectedState("Database rename from: " + dbImpl.getName() + " to " + databaseName + " failed, name not found on the Replica.");
                    }
                }
                case UPDATE_CONFIG: {
                    DatabaseConfig dbConfig = repContext.getCreateConfig().getReplicaConfig(this.repImpl);
                    dbImpl = this.repImpl.getDbTree().getDb(nameLN.getId());
                    String dbName = dbImpl.getName();
                    this.repImpl.getDbTree().updateNameLN(repTxn, dbName, repContext);
                    dbImpl.setConfigProperties(repTxn, dbName, dbConfig, this.repImpl);
                    this.repImpl.getDbTree().modifyDbRoot(dbImpl);
                    break;
                }
                default: {
                    throw EnvironmentFailureException.unexpectedState("Illegal database op type of " + opType.toString() + " from " + wireRecord + " database=" + databaseName);
                }
            }
            if (dbImpl != null) {
                this.repImpl.getDbTree().releaseDb(dbImpl);
            }
        }
        catch (Throwable throwable) {
            if (dbImpl != null) {
                this.repImpl.getDbTree().releaseDb(dbImpl);
            }
            throw throwable;
        }
    }

    private void applyLN(ReplayTxn repTxn, InputWireRecord wireRecord) throws DatabaseException {
        LNLogEntry lnEntry = (LNLogEntry)wireRecord.getLogEntry();
        DatabaseId dbId = lnEntry.getDbId();
        if (dbId.getId() == -257L) {
            repTxn.noteRepGroupDbChange();
        }
        DatabaseImpl dbImpl = this.repImpl.getRepNode().getReplica().getDbCache().get(dbId, repTxn);
        lnEntry.postFetchInit(dbImpl);
        ReplicationContext repContext = new ReplicationContext(wireRecord.getVLSN());
        try (Cursor cursor = DbInternal.makeCursor(dbImpl, (Locker)repTxn, null);){
            OperationResult result;
            LN ln = lnEntry.getLN();
            if (dbImpl.getSortedDuplicates() && (lnEntry.isEmbeddedLN() || ln.getData() != null && ln.getData().length > 0)) {
                throw EnvironmentFailureException.unexpectedState(dbImpl.getEnv(), "[#25288] emb=" + lnEntry.isEmbeddedLN() + " key=" + Key.getNoFormatString(lnEntry.getKey()) + " data=" + Key.getNoFormatString(ln.getData()) + " vlsn=" + ln.getVLSNSequence());
            }
            if (ln.isDeleted()) {
                this.replayKeyEntry.setData(lnEntry.getKey());
                result = DbInternal.searchForReplay(cursor, this.replayKeyEntry, this.delDataEntry, LockMode.RMW, SearchMode.SET);
                if (result != null) {
                    result = DbInternal.deleteWithRepContext(cursor, repContext);
                }
            } else {
                this.replayKeyEntry.setData(lnEntry.getKey());
                this.replayDataEntry.setData(ln.getData());
                result = DbInternal.putForReplay(cursor, this.replayKeyEntry, this.replayDataEntry, ln, lnEntry.getExpiration(), lnEntry.isExpirationInHours(), PutMode.OVERWRITE, repContext);
            }
            if (result == null) {
                String expTime;
                ExtinctionFilter.ExtinctionStatus extinctionState = this.repImpl.getExtinctionState(dbImpl, lnEntry.getKey());
                boolean isExpired = this.repImpl.expiresWithin(lnEntry.getExpiration(), lnEntry.isExpirationInHours(), this.repImpl.getTtlClockTolerance());
                String string = expTime = lnEntry.getExpiration() == 0 ? "none" : TTL.formatExpiration(lnEntry.getExpiration(), lnEntry.isExpirationInHours());
                if (!isExpired && extinctionState == ExtinctionFilter.ExtinctionStatus.NOT_EXTINCT) {
                    throw new EnvironmentFailureException((EnvironmentImpl)this.repImpl, EnvironmentFailureReason.LOG_INCOMPLETE, "Replicated operation could  not be applied.  vlsn=" + wireRecord.getVLSN() + " expirationTime=" + expTime + " key=" + Key.dumpString(lnEntry.getKey(), 0) + wireRecord);
                }
            }
        }
        if (lnEntry.getLogType().equals(LogEntryType.LOG_EXTINCT_SCAN_LN_TRANSACTIONAL)) {
            this.repImpl.getExtinctionScanner().replay(lnEntry.getKey(), lnEntry.getData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(VLSN matchpointVLSN, long matchpointLsn) {
        String rollbackStatus = RBSTATUS_START;
        Map<Long, ReplayTxn> localActiveTxns = this.copyActiveTxns();
        try {
            if (localActiveTxns.size() == 0) {
                rollbackStatus = RBSTATUS_NO_ACTIVE;
                return;
            }
            VLSNRange range = this.repImpl.getVLSNIndex().getRange();
            if (range.getLast().equals(matchpointVLSN)) {
                rollbackStatus = RBSTATUS_RANGE_EQUALS;
                return;
            }
            this.repImpl.setSyncupProgress(SyncupProgress.DO_ROLLBACK);
            this.repImpl.getRepNode().shutdownNetworkBackup();
            this.repImpl.setBackupProhibited(true);
            this.repImpl.invalidateBackups(DbLsn.getFileNumber(matchpointLsn));
            LogManager logManager = this.repImpl.getLogManager();
            SingleItemEntry<RollbackStart> rollbackStart = SingleItemEntry.create(LogEntryType.LOG_ROLLBACK_START, new RollbackStart(matchpointVLSN, matchpointLsn, localActiveTxns.keySet()));
            long rollbackStartLsn = logManager.logForceFlush(rollbackStart, true, ReplicationContext.NO_REPLICATE);
            rollbackStatus = RBSTATUS_LOG_RBSTART;
            ArrayList<Long> rollbackLsns = new ArrayList<Long>();
            for (ReplayTxn replayTxn : localActiveTxns.values()) {
                Collection<Long> txnRollbackLsns = replayTxn.rollback(matchpointLsn);
                assert (this.checkRemoved(replayTxn)) : "Should have removed " + replayTxn;
                rollbackLsns.addAll(txnRollbackLsns);
            }
            rollbackStatus = RBSTATUS_MEM_ROLLBACK;
            assert (rollbackLsns.size() != 0) : this.dumpActiveTxns(matchpointLsn);
            LogFileRewriteListener listener = this.repImpl.getLogRewriteListener();
            if (listener != null) {
                listener.rewriteLogFiles(this.getFileNames(rollbackLsns));
            }
            RollbackTracker.makeInvisible(this.repImpl, rollbackLsns);
            rollbackStatus = RBSTATUS_INVISIBLE;
            logManager.logForceFlush(SingleItemEntry.create(LogEntryType.LOG_ROLLBACK_END, new RollbackEnd(matchpointLsn, rollbackStartLsn)), true, ReplicationContext.NO_REPLICATE);
            this.repImpl.getRepNode().restartNetworkBackup();
            this.repImpl.setBackupProhibited(false);
            rollbackStatus = RBSTATUS_FINISH;
        }
        finally {
            this.lastReplayedVLSN = matchpointVLSN;
            LoggerUtils.info(this.logger, this.repImpl, "Rollback to matchpoint " + matchpointVLSN + " at " + DbLsn.getNoFormatString(matchpointLsn) + " status=" + rollbackStatus);
        }
    }

    private String dumpActiveTxns(long matchpointLsn) {
        StringBuilder sb = new StringBuilder();
        sb.append("matchpointLsn=");
        sb.append(DbLsn.getNoFormatString(matchpointLsn));
        for (ReplayTxn replayTxn : this.copyActiveTxns().values()) {
            sb.append("txn id=").append(replayTxn.getId());
            sb.append(" locks=").append(replayTxn.getWriteLockIds());
            sb.append("lastLogged=");
            sb.append(DbLsn.getNoFormatString(replayTxn.getLastLsn()));
            sb.append("\n");
        }
        return sb.toString();
    }

    private Set<File> getFileNames(List<Long> lsns) {
        HashSet<Long> fileNums = new HashSet<Long>();
        HashSet<File> files = new HashSet<File>();
        for (long lsn : lsns) {
            fileNums.add(DbLsn.getFileNumber(lsn));
        }
        for (long fileNum : fileNums) {
            files.add(new File(FileManager.getFileName(fileNum)));
        }
        return files;
    }

    private boolean checkRemoved(ReplayTxn txn) {
        return !txn.isClosed() || this.activeTxns.get(txn.getId()) == null;
    }

    private Map<Long, ReplayTxn> copyActiveTxns() {
        return this.activeTxns.getMap();
    }

    public void close() {
        for (ReplayTxn replayTxn : this.copyActiveTxns().values()) {
            try {
                if (this.logger.isLoggable(Level.FINE)) {
                    LoggerUtils.fine(this.logger, this.repImpl, "Unregistering open replay txn: " + replayTxn.getId());
                }
                replayTxn.cleanup();
            }
            catch (DatabaseException e) {
                LoggerUtils.fine(this.logger, this.repImpl, "Replay txn: " + replayTxn.getId() + " unregistration failed: " + e.getMessage());
            }
        }
        assert (this.activeTxns.isEmpty());
    }

    public StatGroup getStats(StatsConfig config) {
        StatGroup ret = this.statistics.cloneGroup(config.getClear());
        return ret;
    }

    public void resetStats() {
        this.statistics.clear();
    }

    public SimpleTxnMap<ReplayTxn> getActiveTxns() {
        return this.activeTxns;
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        sb.append("lastReplayedTxn=").append(this.lastReplayedTxn);
        sb.append(" lastReplayedVLSN=").append(this.lastReplayedVLSN);
        sb.append(" numActiveReplayTxns=").append(this.activeTxns.size());
        sb.append("\n");
        return sb.toString();
    }

    void flushPendingAcks(long nowNs) throws IOException {
        this.groupCommit.flushPendingAcks(nowNs);
    }

    long getPollIntervalNs(long defaultNs) {
        return this.groupCommit.getPollIntervalNs(defaultNs);
    }

    public static class TxnInfo {
        final VLSN txnVLSN;
        final long masterTxnEndTime;

        private TxnInfo(VLSN txnVLSN, long masterTxnEndTime) {
            this.txnVLSN = txnVLSN;
            this.masterTxnEndTime = masterTxnEndTime;
        }

        public VLSN getTxnVLSN() {
            return this.txnVLSN;
        }

        public long getMasterTxnEndTime() {
            return this.masterTxnEndTime;
        }

        public String toString() {
            return " VLSN: " + this.txnVLSN + " masterTxnEndTime=" + new Date(this.masterTxnEndTime);
        }
    }

    private class GroupCommit {
        private final long[] pendingCommitAcks;
        private int nPendingAcks;
        private long limitGroupCommitNs = 0L;
        private final long groupCommitIntervalNs;
        private final LongStat nGroupCommitTimeouts;
        private final LongStat nGroupCommitMaxExceeded;
        private final LongStat nGroupCommits;
        private final LongStat nGroupCommitTxns;

        private GroupCommit(DbConfigManager configManager) {
            this.pendingCommitAcks = new long[configManager.getInt(RepParams.REPLICA_MAX_GROUP_COMMIT)];
            this.nPendingAcks = 0;
            long groupCommitIntervalMs = configManager.getDuration(RepParams.REPLICA_GROUP_COMMIT_INTERVAL);
            this.groupCommitIntervalNs = TimeUnit.NANOSECONDS.convert(groupCommitIntervalMs, TimeUnit.MILLISECONDS);
            this.nGroupCommitTimeouts = new LongStat(Replay.this.statistics, ReplayStatDefinition.N_GROUP_COMMIT_TIMEOUTS);
            this.nGroupCommitMaxExceeded = new LongStat(Replay.this.statistics, ReplayStatDefinition.N_GROUP_COMMIT_MAX_EXCEEDED);
            this.nGroupCommitTxns = new LongStat(Replay.this.statistics, ReplayStatDefinition.N_GROUP_COMMIT_TXNS);
            this.nGroupCommits = new LongStat(Replay.this.statistics, ReplayStatDefinition.N_GROUP_COMMITS);
        }

        private boolean isEnabled() {
            return this.pendingCommitAcks.length > 0;
        }

        private long getPollIntervalNs(long defaultNs) {
            if (this.nPendingAcks == 0) {
                return defaultNs;
            }
            long now = System.nanoTime();
            long interval = this.limitGroupCommitNs - now;
            return Math.min(interval, defaultNs);
        }

        private Durability.SyncPolicy getImplSyncPolicy(Durability.SyncPolicy txnSyncPolicy) {
            return txnSyncPolicy == Durability.SyncPolicy.SYNC && this.isEnabled() ? Durability.SyncPolicy.NO_SYNC : txnSyncPolicy;
        }

        private final boolean bufferAck(long nowNs, ReplayTxn ackTxn, Durability.SyncPolicy txnSyncPolicy) throws IOException {
            if (!this.isEnabled() || txnSyncPolicy != Durability.SyncPolicy.SYNC && this.nPendingAcks <= 0) {
                return false;
            }
            this.pendingCommitAcks[this.nPendingAcks++] = ackTxn.getId();
            if (this.nPendingAcks == 1) {
                this.limitGroupCommitNs = nowNs + this.groupCommitIntervalNs;
            } else {
                this.flushPendingAcks(nowNs);
            }
            return true;
        }

        private final void flushPendingAcks(long nowNs) throws IOException {
            if (this.nPendingAcks == 0 || this.nPendingAcks != this.pendingCommitAcks.length && NanoTimeUtil.compare(nowNs, this.limitGroupCommitNs) < 0L) {
                return;
            }
            this.nGroupCommits.increment();
            this.nGroupCommitTxns.add(this.nPendingAcks);
            if (NanoTimeUtil.compare(nowNs, this.limitGroupCommitNs) >= 0L) {
                this.nGroupCommitTimeouts.increment();
            } else if (this.nPendingAcks >= this.pendingCommitAcks.length) {
                this.nGroupCommitMaxExceeded.increment();
            }
            Replay.this.repImpl.getLogManager().flushSync();
            for (int i = 0; i < this.nPendingAcks; ++i) {
                Replay.this.queueAck(this.pendingCommitAcks[i]);
                this.pendingCommitAcks[i] = 0L;
            }
            this.nPendingAcks = 0;
            this.limitGroupCommitNs = 0L;
        }
    }
}

