/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.rep.AppStateMonitor;
import com.sleepycat.je.rep.GroupShutdownException;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MasterTransferFailureException;
import com.sleepycat.je.rep.MemberActiveException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicaStateException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.arbitration.Arbiter;
import com.sleepycat.je.rep.elections.Elections;
import com.sleepycat.je.rep.elections.ElectionsConfig;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.impl.BinaryNodeStateProtocol;
import com.sleepycat.je.rep.impl.BinaryNodeStateService;
import com.sleepycat.je.rep.impl.GroupService;
import com.sleepycat.je.rep.impl.MinJEVersionUnsupportedException;
import com.sleepycat.je.rep.impl.NodeStateService;
import com.sleepycat.je.rep.impl.PointConsistencyPolicy;
import com.sleepycat.je.rep.impl.RepGroupDB;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepGroupProtocol;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.ChannelTimeoutTask;
import com.sleepycat.je.rep.impl.node.CommitFreezeLatch;
import com.sleepycat.je.rep.impl.node.DurabilityQuorum;
import com.sleepycat.je.rep.impl.node.ElectionQuorum;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.JoinGroupTimeouts;
import com.sleepycat.je.rep.impl.node.MasterTransfer;
import com.sleepycat.je.rep.impl.node.MonitorEventManager;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.NodeState;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.rep.impl.node.ReplicaFactory;
import com.sleepycat.je.rep.impl.node.cbvlsn.CleanerBarrierState;
import com.sleepycat.je.rep.impl.node.cbvlsn.GlobalCBVLSN;
import com.sleepycat.je.rep.impl.node.cbvlsn.LocalCBVLSNTracker;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.stream.FeederTxns;
import com.sleepycat.je.rep.stream.MasterChangeListener;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.stream.MasterSuggestionGenerator;
import com.sleepycat.je.rep.subscription.StreamAuthenticator;
import com.sleepycat.je.rep.txn.ReplayTxn;
import com.sleepycat.je.rep.util.AtomicLongMax;
import com.sleepycat.je.rep.util.ldiff.LDiffService;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class RepNode
extends StoppableThread {
    private final NameIdPair nameIdPair;
    private final ServiceDispatcher serviceDispatcher;
    private Elections elections;
    private final Replica replica;
    private FeederManager feederManager;
    private final MasterStatus masterStatus;
    private final MasterChangeListener changeListener;
    private final MasterSuggestionGenerator suggestionGenerator;
    private final NodeState nodeState;
    private final RepImpl repImpl;
    final RepGroupDB repGroupDB;
    private volatile RepUtils.ExceptionAwareCountDownLatch readyLatch = null;
    private final CommitFreezeLatch vlsnFreezeLatch = new CommitFreezeLatch();
    private volatile RepGroupImpl group;
    private volatile boolean needsAcks = false;
    private QuorumPolicy electionQuorumPolicy = QuorumPolicy.SIMPLE_MAJORITY;
    private static final int MASTER_QUERY_INTERVAL = 10000;
    private static final int JOIN_RETRIES = 10;
    private final RepUtils.Clock clock;
    private com.sleepycat.je.rep.impl.networkRestore.FeederManager logFeederManager;
    private LDiffService ldiff;
    private NodeStateService nodeStateService;
    private BinaryNodeStateService binaryNodeStateService;
    private GroupService groupService;
    final LocalCBVLSNTracker cbvlsnTracker;
    private MasterTransfer xfrInProgress;
    final GlobalCBVLSN globalCBVLSN;
    private long replicaCloseCatchupMs = -1L;
    private MonitorEventManager monitorEventManager;
    private AppStateMonitor appStateMonitor;
    private final Timer timer;
    private final ChannelTimeoutTask channelTimeoutTask;
    final Logger logger;
    private final ElectionQuorum electionQuorum;
    private final DurabilityQuorum durabilityQuorum;
    private final Arbiter arbiter;
    private final NodeType nodeType;
    private final TransientIds transientIds = new TransientIds(1024);
    private final Object minJEVersionLock = new Object();
    private int logVersion = 16;
    private Set<TestHook<Integer>> convertHooks;
    private final AtomicLongMax dtvlsn = new AtomicLongMax(-1L);
    public static volatile TestHook<String> queryGroupForMembershipBeforeSleepHook;
    public static volatile TestHook<String> queryGroupForMembershipBeforeQueryForMaster;
    public static volatile TestHook<String> beforeFindRestoreSupplierHook;

    public RepNode(RepImpl repImpl, Replay replay, NodeState nodeState) throws IOException, DatabaseException {
        super(repImpl, "RepNode " + repImpl.getNameIdPair());
        this.repImpl = repImpl;
        this.readyLatch = new RepUtils.ExceptionAwareCountDownLatch(repImpl, 1);
        this.nameIdPair = repImpl.getNameIdPair();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.serviceDispatcher = new ServiceDispatcher(this.getSocket(), repImpl, repImpl.getChannelFactory());
        this.serviceDispatcher.start();
        this.clock = new RepUtils.Clock(RepImpl.getClockSkewMs());
        this.repGroupDB = new RepGroupDB(repImpl);
        this.masterStatus = new MasterStatus(this.nameIdPair);
        this.replica = ReplicaFactory.create(this, replay);
        this.feederManager = new FeederManager(this);
        this.changeListener = new MasterChangeListener(this);
        this.suggestionGenerator = new MasterSuggestionGenerator(this);
        this.nodeState = nodeState;
        this.electionQuorum = new ElectionQuorum(repImpl);
        this.durabilityQuorum = new DurabilityQuorum(repImpl);
        this.utilityServicesStart();
        this.globalCBVLSN = new GlobalCBVLSN(this);
        this.cbvlsnTracker = new LocalCBVLSNTracker(this, this.globalCBVLSN);
        this.monitorEventManager = new MonitorEventManager(this);
        this.timer = new Timer(true);
        this.channelTimeoutTask = new ChannelTimeoutTask(this.timer);
        this.arbiter = new Arbiter(repImpl);
        this.nodeType = NodeType.valueOf(this.getConfigManager().get(RepParams.NODE_TYPE));
        this.dtvlsn.updateMax(repImpl.getLoggedDTVLSN());
        LoggerUtils.info(this.logger, repImpl, String.format("DTVLSN at start:%,d", this.dtvlsn.get()));
    }

    private void utilityServicesStart() {
        this.ldiff = new LDiffService(this.serviceDispatcher, this.repImpl);
        this.logFeederManager = new com.sleepycat.je.rep.impl.networkRestore.FeederManager(this.serviceDispatcher, this.repImpl, this.nameIdPair);
        this.nodeStateService = new NodeStateService(this.serviceDispatcher, this);
        this.serviceDispatcher.register(this.nodeStateService);
        this.binaryNodeStateService = new BinaryNodeStateService(this.serviceDispatcher, this);
        this.groupService = new GroupService(this.serviceDispatcher, this);
        this.serviceDispatcher.register(this.groupService);
    }

    public RepNode(NameIdPair nameIdPair) {
        this(nameIdPair, null);
    }

    public RepNode() {
        this(NameIdPair.NULL);
    }

    public RepNode(NameIdPair nameIdPair, ServiceDispatcher serviceDispatcher) {
        super("RepNode " + nameIdPair);
        this.repImpl = null;
        this.clock = new RepUtils.Clock(0);
        this.nameIdPair = nameIdPair;
        this.serviceDispatcher = serviceDispatcher;
        this.repGroupDB = null;
        this.masterStatus = new MasterStatus(NameIdPair.NULL);
        this.replica = null;
        this.feederManager = null;
        this.changeListener = null;
        this.suggestionGenerator = null;
        this.nodeState = null;
        this.cbvlsnTracker = null;
        this.globalCBVLSN = null;
        this.logger = null;
        this.timer = null;
        this.channelTimeoutTask = null;
        this.electionQuorum = null;
        this.durabilityQuorum = null;
        this.arbiter = null;
        this.nodeType = NodeType.ELECTABLE;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public ServiceDispatcher getServiceDispatcher() {
        return this.serviceDispatcher;
    }

    public ReplicatedEnvironmentStats getStats(StatsConfig config) {
        return RepInternal.makeReplicatedEnvironmentStats(this.repImpl, config);
    }

    public void resetStats() {
        this.feederManager.resetStats();
        this.replica.resetStats();
    }

    public RepUtils.ExceptionAwareCountDownLatch getReadyLatch() {
        return this.readyLatch;
    }

    public CommitFreezeLatch getVLSNFreezeLatch() {
        return this.vlsnFreezeLatch;
    }

    public void resetReadyLatch(Exception exception) {
        RepUtils.ExceptionAwareCountDownLatch old = this.readyLatch;
        this.readyLatch = new RepUtils.ExceptionAwareCountDownLatch(this.repImpl, 1);
        if (old.getCount() != 0L) {
            old.releaseAwait(exception);
        }
    }

    public FeederManager feederManager() {
        return this.feederManager;
    }

    public Replica replica() {
        return this.replica;
    }

    public RepUtils.Clock getClock() {
        return this.clock;
    }

    public Replica getReplica() {
        return this.replica;
    }

    public RepGroupDB getRepGroupDB() {
        return this.repGroupDB;
    }

    public RepGroupImpl getGroup() {
        return this.group;
    }

    public UUID getUUID() {
        if (this.group == null) {
            throw EnvironmentFailureException.unexpectedState("Group info is not available");
        }
        return this.group.getUUID();
    }

    public String getNodeName() {
        return this.nameIdPair.getName();
    }

    public int getNodeId() {
        return this.nameIdPair.getId();
    }

    public NameIdPair getNameIdPair() {
        return this.nameIdPair;
    }

    public InetSocketAddress getSocket() {
        return this.repImpl.getSocket();
    }

    public String getHostName() {
        return this.repImpl.getHostName();
    }

    public int getPort() {
        return this.repImpl.getPort();
    }

    public MasterStatus getMasterStatus() {
        return this.masterStatus;
    }

    public boolean isAuthoritativeMaster() {
        return this.electionQuorum.isAuthoritativeMaster(this.getMasterStatus(), this.feederManager);
    }

    public int getHeartbeatInterval() {
        return this.getConfigManager().getInt(RepParams.HEARTBEAT_INTERVAL);
    }

    public void setVersion(int version) {
        this.logVersion = version;
    }

    public int getLogVersion() {
        return this.logVersion;
    }

    public int getElectionPriority() {
        if (this.repImpl.getDiskLimitViolation() != null) {
            return 0;
        }
        int priority = this.getConfigManager().getInt(RepParams.NODE_PRIORITY);
        int defaultPriority = Integer.parseInt(RepParams.NODE_PRIORITY.getDefault());
        return this.getConfigManager().getBoolean(RepParams.DESIGNATED_PRIMARY) && priority == defaultPriority ? defaultPriority + 1 : priority;
    }

    public int getThreadWaitInterval() {
        return this.getHeartbeatInterval() * 4;
    }

    int getDbTreeCacheClearingOpCount() {
        return this.getConfigManager().getInt(RepParams.DBTREE_CACHE_CLEAR_COUNT);
    }

    public RepImpl getRepImpl() {
        return this.repImpl;
    }

    public LogManager getLogManager() {
        return this.repImpl.getLogManager();
    }

    DbConfigManager getConfigManager() {
        return this.repImpl.getConfigManager();
    }

    public VLSNIndex getVLSNIndex() {
        return this.repImpl.getVLSNIndex();
    }

    public FeederTxns getFeederTxns() {
        return this.repImpl.getFeederTxns();
    }

    public Elections getElections() {
        return this.elections;
    }

    public MasterSuggestionGenerator getSuggestionGenerator() {
        return this.suggestionGenerator;
    }

    public QuorumPolicy getElectionPolicy() {
        return this.electionQuorumPolicy;
    }

    public RepNodeImpl[] getLogProviders() {
        Set<RepNodeImpl> nodes = this.getGroup().getDataMembers();
        return nodes.toArray(new RepNodeImpl[nodes.size()]);
    }

    public ChannelTimeoutTask getChannelTimeoutTask() {
        return this.channelTimeoutTask;
    }

    public boolean isMaster() {
        return this.masterStatus.isNodeMaster();
    }

    public MonitorEventManager getMonitorEventManager() {
        return this.monitorEventManager;
    }

    public void registerAppStateMonitor(AppStateMonitor stateMonitor) {
        this.appStateMonitor = stateMonitor;
    }

    public byte[] getAppState() {
        if (this.appStateMonitor == null || this.appStateMonitor.getAppState() == null) {
            return null;
        }
        if (this.appStateMonitor.getAppState().length == 0) {
            throw new IllegalStateException("Application state should be a byte array larger than 0.");
        }
        return this.appStateMonitor.getAppState();
    }

    public String getMasterName() {
        if (this.masterStatus.getGroupMasterNameId().getId() == -1) {
            return null;
        }
        return this.masterStatus.getGroupMasterNameId().getName();
    }

    public VLSN getCurrentTxnEndVLSN() {
        return this.repImpl.getLastTxnEnd();
    }

    public long getDTVLSN() {
        long retValue = this.dtvlsn.get();
        if (VLSN.isNull(retValue)) {
            throw new IllegalStateException("DTVLSN cannot be null");
        }
        return retValue;
    }

    public long getAnyDTVLSN() {
        return this.dtvlsn.get();
    }

    public long updateDTVLSN(long candidateDTVLSN) {
        if (RepImpl.isSimulatePreDTVLSNMaster()) {
            return 0L;
        }
        return this.dtvlsn.updateMax(candidateDTVLSN);
    }

    public long setDTVLSN(long newDTVLSN) {
        return this.dtvlsn.set(newDTVLSN);
    }

    public void setGroup(RepGroupImpl repGroupImpl) {
        this.group = repGroupImpl;
        this.needsAcks = this.durabilityQuorum.getCurrentRequiredAckCount(Durability.ReplicaAckPolicy.SIMPLE_MAJORITY) > 0;
    }

    public void forceMaster(boolean force) throws InterruptedException, DatabaseException {
        this.suggestionGenerator.forceMaster(force);
        this.refreshCachedGroup();
        this.elections.initiateElection(this.group, this.electionQuorumPolicy);
    }

    int getSecurityCheckInterval() {
        return this.getConfigManager().getInt(RepParams.SECURITY_CHECK_INTERVAL);
    }

    StreamAuthenticator getAuthenticator() {
        if (this.repImpl == null) {
            return null;
        }
        return this.repImpl.getAuthenticator();
    }

    private void startup(QuorumPolicy initialElectionPolicy) throws DatabaseException {
        if (this.isAlive()) {
            return;
        }
        if (this.nodeState.getRepEnvState().isDetached()) {
            this.nodeState.changeAndNotify(ReplicatedEnvironment.State.UNKNOWN, NameIdPair.NULL);
        }
        this.elections = new Elections(new RepElectionsConfig(this), this.changeListener, this.suggestionGenerator);
        this.repImpl.getStartupTracker().start(StartupTracker.Phase.FIND_MASTER);
        try {
            if (this.repImpl.getConfigManager().getBoolean(RepParams.RESET_REP_GROUP)) {
                this.reinitSelfElect();
            } else {
                this.findMaster();
            }
            this.electionQuorumPolicy = initialElectionPolicy;
            if (this.electionQuorum.nodeTypeParticipates(this.nodeType)) {
                this.elections.participate();
            }
        }
        finally {
            this.repImpl.getStartupTracker().stop(StartupTracker.Phase.FIND_MASTER);
        }
        this.start();
    }

    public RepGroupImpl refreshCachedGroup() throws DatabaseException {
        RepNodeImpl n;
        this.setGroup(this.repGroupDB.getGroup());
        this.elections.updateRepGroup(this.group);
        if (!(!this.nameIdPair.hasNullId() || (n = this.group.getMember(this.nameIdPair.getName())) == null || this.nodeType.isSecondary() && this.getConfigManager().getBoolean(RepParams.IGNORE_SECONDARY_NODE_ID))) {
            this.nameIdPair.update(n.getNameIdPair());
        }
        return this.group;
    }

    public void removeMember(String nodeName) {
        this.removeMember(nodeName, false);
    }

    public void removeMember(String nodeName, boolean delete) {
        this.checkValidity(nodeName, delete ? "Deleting member" : "Removing member");
        if (delete && this.feederManager.activeReplicas().contains(nodeName)) {
            throw new MemberActiveException("Attempt to delete an active node: " + nodeName);
        }
        RepNodeImpl node = this.group.removeMember(nodeName, delete);
        this.feederManager.shutdownFeeder(node);
        this.repGroupDB.removeMember(node, delete);
    }

    public void updateAddress(String nodeName, String newHostName, int newPort) {
        RepNodeImpl node = this.checkValidity(nodeName, "Updating node's address");
        if (this.feederManager.getFeeder(nodeName) != null) {
            throw new ReplicaStateException("Can't update the network address for a live node.");
        }
        node.setHostName(newHostName);
        node.setPort(newPort);
        node.setQuorumAck(false);
        this.repGroupDB.updateMember(node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transferMaster(Set<String> replicas, long timeout, boolean force) {
        if (replicas == null || replicas.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'replicas' cannot be null or empty");
        }
        if (!this.nodeState.getRepEnvState().isMaster()) {
            throw new IllegalStateException("Not currently master");
        }
        if (replicas.contains(this.getNodeName())) {
            return this.getNodeName();
        }
        for (String rep : replicas) {
            RepNodeImpl node = this.group.getNode(rep);
            if (node == null || node.isRemoved()) {
                throw new IllegalArgumentException("Node '" + rep + "' is not currently an active member of the group");
            }
            if (node.getType().isElectable()) continue;
            throw new IllegalArgumentException("Node '" + rep + "' must have node type ELECTABLE, but had type " + (Object)((Object)node.getType()));
        }
        MasterTransfer xfr = this.setUpTransfer(replicas, timeout, force);
        boolean done = false;
        try {
            String winner = xfr.transfer();
            done = true;
            String string = winner;
            return string;
        }
        finally {
            RepNode repNode = this;
            synchronized (repNode) {
                if (this.xfrInProgress == xfr && !done) {
                    this.xfrInProgress = null;
                }
            }
        }
    }

    private synchronized MasterTransfer setUpTransfer(Set<String> replicas, long timeout, boolean force) {
        boolean reject = false;
        if (this.xfrInProgress != null) {
            reject = true;
            if (force && this.xfrInProgress.abort(new MasterTransferFailureException("superseded"))) {
                reject = false;
                this.repImpl.unblockTxnCompletion();
            }
        }
        if (reject) {
            throw new MasterTransferFailureException("another Master Transfer (started at " + new Date(this.xfrInProgress.getStartTime()) + ") is already in progress");
        }
        this.xfrInProgress = new MasterTransfer(replicas, timeout, this);
        return this.xfrInProgress;
    }

    public MasterTransfer getActiveTransfer() {
        return this.xfrInProgress;
    }

    public synchronized void clearActiveTransfer() {
        this.xfrInProgress = null;
    }

    private RepNodeImpl checkValidity(String nodeName, String actionName) throws MemberNotFoundException {
        if (!this.nodeState.getRepEnvState().isMaster()) {
            throw EnvironmentFailureException.unexpectedState("Not currently a master. " + actionName + " must be invoked on the node that's currently the master.");
        }
        RepNodeImpl node = this.group.getNode(nodeName);
        if (node == null) {
            throw new MemberNotFoundException("Node:" + nodeName + "is not a member of the group:" + this.group.getName());
        }
        if (node.isRemoved() && node.isQuorumAck()) {
            throw new MemberNotFoundException("Node:" + nodeName + "is not currently a member of the group:" + this.group.getName() + " It had been removed.");
        }
        if (nodeName.equals(this.getNodeName())) {
            throw new MasterStateException(this.getRepImpl().getStateChangeEvent());
        }
        return node;
    }

    public void updateGroupInfo(NameIdPair updateNameIdPair, CleanerBarrierState barrierState) {
        this.globalCBVLSN.updateGroupInfo(updateNameIdPair, barrierState);
    }

    public void recalculateGlobalCBVLSN() {
        this.globalCBVLSN.recalculate(this.group);
    }

    LocalCBVLSNTracker getCBVLSNTracker() {
        return this.cbvlsnTracker;
    }

    private void findMaster() throws DatabaseException {
        this.refreshCachedGroup();
        this.elections.startLearner();
        LoggerUtils.info(this.logger, this.repImpl, "Current group size: " + this.group.getElectableGroupSize());
        RepNodeImpl thisNode = this.group.getNode(this.nameIdPair.getName());
        if (thisNode == null && (this.nodeType.isElectable() || this.group.hasUnknownUUID())) {
            LoggerUtils.info(this.logger, this.repImpl, "New node " + this.nameIdPair + " unknown to rep group");
            Set<InetSocketAddress> helperSockets = this.repImpl.getHelperSockets();
            if (this.group.getElectableGroupSize() == 0 && helperSockets.size() == 1 && this.nodeType.isElectable() && this.serviceDispatcher.getSocketAddress().equals(helperSockets.iterator().next())) {
                this.selfElect();
                this.elections.updateRepGroup(this.group);
                this.globalCBVLSN.setDefunctJEVersion(this);
                return;
            }
            try {
                this.queryGroupForMembership();
            }
            catch (InterruptedException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
        } else {
            if (thisNode != null && thisNode.isRemoved()) {
                throw EnvironmentFailureException.unexpectedState("Node: " + this.nameIdPair.getName() + " was previously deleted.");
            }
            LoggerUtils.info(this.logger, this.repImpl, "Existing node " + this.nameIdPair.getName() + " querying for a current master.");
            Set<InetSocketAddress> helperSockets = this.repImpl.getHelperSockets();
            helperSockets.addAll(this.group.getAllHelperSockets());
            this.elections.getLearner().queryForMaster(helperSockets);
        }
    }

    private void checkLoopbackAddresses(Set<InetSocketAddress> helperSockets) {
        InetAddress myAddress = this.getSocket().getAddress();
        boolean isLoopback = myAddress.isLoopbackAddress();
        for (InetSocketAddress socketAddress : helperSockets) {
            boolean nodeAddressIsLoopback;
            InetAddress nodeAddress = socketAddress.getAddress();
            boolean bl = nodeAddressIsLoopback = nodeAddress != null && nodeAddress.isLoopbackAddress();
            if (nodeAddressIsLoopback == isLoopback) continue;
            String message = this.getSocket() + " the address associated with this node, " + (isLoopback ? "is " : "is not ") + "a loopback address. It conflicts with an existing use, by a different node  of the address:" + socketAddress + (!isLoopback ? " which is a loopback address." : " which is not a loopback address.") + " Such mixing of addresses within a group is not allowed, since the nodes will not be able to communicate with each other.";
            throw new IllegalArgumentException(message);
        }
    }

    private void queryGroupForMembership() throws InterruptedException {
        NameIdPair groupMasterNameId;
        Set<InetSocketAddress> helperSockets = this.repImpl.getHelperSockets();
        this.checkLoopbackAddresses(helperSockets);
        HashSet<InetSocketAddress> helpers = new HashSet<InetSocketAddress>(helperSockets);
        helpers.addAll(this.group.getAllHelperSockets());
        if (helpers.isEmpty()) {
            throw EnvironmentFailureException.unexpectedState("Need a helper to add a new node into the group");
        }
        while (true) {
            assert (TestHookExecute.doHookIfSet(queryGroupForMembershipBeforeQueryForMaster, this.nameIdPair.getName()));
            this.elections.getLearner().queryForMaster(helpers);
            if (this.isShutdownOrInvalid()) {
                throw new InterruptedException("Node is shutdown or invalid");
            }
            groupMasterNameId = this.masterStatus.getGroupMasterNameId();
            if (!groupMasterNameId.hasNullId()) {
                if (this.nameIdPair.hasNullId() && groupMasterNameId.getName().equals(this.nameIdPair.getName())) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                }
                if (this.checkGroupMasterIsAlive(groupMasterNameId)) break;
            }
            this.findRestoreSuppliers(helpers);
            assert (TestHookExecute.doHookIfSet(queryGroupForMembershipBeforeSleepHook, this.nameIdPair.getName()));
            if (this.isShutdownOrInvalid()) {
                throw new InterruptedException("Node is shutdown or invalid");
            }
            Thread.sleep(10000L);
        }
        LoggerUtils.info(this.logger, this.repImpl, "New node " + this.nameIdPair.getName() + " located master: " + groupMasterNameId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkGroupMasterIsAlive(NameIdPair groupMasterNameId) {
        DataChannel channel = null;
        try {
            InetSocketAddress masterSocket = this.masterStatus.getGroupMaster();
            BinaryNodeStateProtocol protocol = new BinaryNodeStateProtocol(NameIdPair.NOCHECK, null);
            channel = this.repImpl.getChannelFactory().connect(masterSocket, new DataChannelFactory.ConnectOptions().setTcpNoDelay(true).setOpenTimeout(5000).setReadTimeout(5000));
            ServiceDispatcher.doServiceHandshake(channel, "BinaryNodeState");
            BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
            binaryNodeStateProtocol.getClass();
            protocol.write((BinaryProtocol.Message)binaryNodeStateProtocol.new BinaryNodeStateProtocol.BinaryNodeStateRequest(groupMasterNameId.getName(), this.group.getName()), channel);
            BinaryNodeStateProtocol.BinaryNodeStateResponse response = protocol.read(channel, BinaryNodeStateProtocol.BinaryNodeStateResponse.class);
            ReplicatedEnvironment.State state = response.getNodeState();
            boolean bl = state != null && state.isMaster();
            return bl;
        }
        catch (Exception e) {
            LoggerUtils.info(this.logger, this.repImpl, "Queried master:" + groupMasterNameId + " unavailable. Reason:" + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void findRestoreSuppliers(Set<InetSocketAddress> helpers) throws InterruptedException {
        HashSet<ReplicationNode> suppliers = new HashSet<ReplicationNode>();
        RepGroupProtocol protocol = new RepGroupProtocol(this.group.getName(), this.nameIdPair, this.repImpl, this.repImpl.getChannelFactory());
        for (InetSocketAddress helper : helpers) {
            RepNodeImpl supplier;
            assert (TestHookExecute.doHookIfSet(beforeFindRestoreSupplierHook, this.nameIdPair.getName()));
            if (this.isShutdownOrInvalid()) {
                throw new InterruptedException("Node is shutdown or invalid");
            }
            RepGroupProtocol repGroupProtocol = protocol;
            repGroupProtocol.getClass();
            TextProtocol.MessageExchange msg = repGroupProtocol.new TextProtocol.MessageExchange(helper, "Group", protocol.new RepGroupProtocol.GroupRequest());
            msg.run();
            TextProtocol.ResponseMessage response = msg.getResponseMessage();
            if (response == null || protocol.RGFAIL_RESP.equals(response.getOp())) continue;
            if (!protocol.GROUP_RESP.equals(response.getOp())) {
                LoggerUtils.warning(this.logger, this.repImpl, "Expected GROUP_RESP, got " + response.getOp() + ": " + response);
                continue;
            }
            RepGroupProtocol.GroupResponse groupResp = (RepGroupProtocol.GroupResponse)response;
            RepGroupImpl groupInfo = groupResp.getGroup();
            RepNodeImpl me = groupInfo.getNode(this.nameIdPair.getName());
            if (me == null || me.isRemoved() || !me.isQuorumAck() || (supplier = groupInfo.getMember(helper)) == null) continue;
            suppliers.add(supplier);
        }
        if (suppliers.isEmpty()) {
            return;
        }
        throw new InsufficientLogException(this, suppliers);
    }

    private void selfElect() throws DatabaseException {
        if (!this.nodeType.isElectable()) {
            throw new IllegalStateException("Cannot elect node " + this.nameIdPair.getName() + " as master because its node type, " + (Object)((Object)this.nodeType) + ", is not ELECTABLE");
        }
        this.nameIdPair.setId(RepGroupImpl.getFirstNodeId());
        Proposer.Proposal proposal = new TimebasedProposalGenerator().nextProposal();
        this.elections.getLearner().processResult(proposal, this.suggestionGenerator.get(proposal));
        LoggerUtils.info(this.logger, this.repImpl, "Nascent group. " + this.nameIdPair.getName() + " is master by virtue of being the first node.");
        this.masterStatus.sync();
        this.nodeState.changeAndNotify(ReplicatedEnvironment.State.MASTER, this.masterStatus.getNodeMasterNameId());
        this.repImpl.getVLSNIndex().initAsMaster();
        this.dtvlsn.updateMax(0L);
        this.repGroupDB.addFirstNode();
        this.refreshCachedGroup();
        this.masterStatus.unSync();
    }

    private void reinitSelfElect() {
        if (!this.nodeType.isElectable()) {
            throw new IllegalStateException("Cannot elect node " + this.nameIdPair.getName() + " as master because its node type, " + (Object)((Object)this.nodeType) + ", is not ELECTABLE");
        }
        this.setGroup(this.repGroupDB.emptyGroup);
        LoggerUtils.info(this.logger, this.repImpl, "Reinitializing group to node " + this.nameIdPair);
        this.nodeState.changeAndNotify(ReplicatedEnvironment.State.MASTER, this.masterStatus.getNodeMasterNameId());
        this.repImpl.getVLSNIndex().initAsMaster();
        for (ReplayTxn replayTxn : this.repImpl.getTxnManager().getTxns(ReplayTxn.class)) {
            boolean nodeId = true;
            LoggerUtils.info(this.logger, this.repImpl, "Aborting incomplete replay txn:" + this.nameIdPair + " as part of group reset");
            replayTxn.abort(ReplicationContext.MASTER, 1, -1L);
        }
        this.repImpl.forceLogFileFlip();
        CheckpointConfig ckptConfig = new CheckpointConfig();
        ckptConfig.setForce(true);
        this.repImpl.invokeCheckpoint(ckptConfig, "Reinit of RepGroup");
        VLSN lastOldVLSN = this.repImpl.getVLSNIndex().getRange().getLast();
        this.repGroupDB.reinitFirstNode(lastOldVLSN);
        this.refreshCachedGroup();
        long lastOldFile = this.repImpl.getVLSNIndex().getLTEFileNumber(lastOldVLSN);
        boolean retainUUID = this.getConfigManager().getBoolean(RepParams.RESET_REP_GROUP_RETAIN_UUID);
        if (!retainUUID) {
            this.repImpl.getVLSNIndex().truncateFromHead(lastOldVLSN, lastOldFile);
        }
        this.elections.startLearner();
        this.masterStatus.unSync();
        this.globalCBVLSN.setDefunctJEVersion(this);
    }

    private void waitWhileDiskLimitViolation() throws InterruptedException {
        LoggerUtils.info(this.logger, this.repImpl, "Node waiting for disk space to become available. Disk limit violation:" + this.getRepImpl().getDiskLimitViolation());
        while (this.getRepImpl().getDiskLimitViolation() != null) {
            if (this.isShutdownOrInvalid()) {
                return;
            }
            Thread.sleep(1000L);
        }
        LoggerUtils.info(this.logger, this.repImpl, "Disk limit violation cleared.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Error repNodeError = null;
        try {
            LoggerUtils.info(this.logger, this.repImpl, "Node " + this.nameIdPair.getName() + " started" + (!this.nodeType.isElectable() ? " as " + (Object)((Object)this.nodeType) : ""));
            while (!this.isShutdownOrInvalid()) {
                if (this.nodeState.getRepEnvState() != ReplicatedEnvironment.State.UNKNOWN) {
                    this.nodeState.changeAndNotify(ReplicatedEnvironment.State.UNKNOWN, NameIdPair.NULL);
                }
                if (this.getRepImpl().getDiskLimitViolation() != null) {
                    this.waitWhileDiskLimitViolation();
                }
                if (this.masterStatus.getGroupMasterNameId().hasNullId() || this.masterStatus.inSync()) {
                    if (this.nameIdPair.hasNullId() || !this.nodeType.isElectable()) {
                        this.queryGroupForMembership();
                    } else {
                        this.elections.initiateElection(this.group, this.electionQuorumPolicy);
                        this.electionQuorumPolicy = QuorumPolicy.SIMPLE_MAJORITY;
                    }
                    if (this.isShutdownOrInvalid()) {
                        return;
                    }
                }
                this.masterStatus.sync();
                if (this.masterStatus.isNodeMaster()) {
                    this.repImpl.getVLSNIndex().initAsMaster();
                    this.replica.masterTransitionCleanup();
                    this.nodeState.changeAndNotify(ReplicatedEnvironment.State.MASTER, this.masterStatus.getNodeMasterNameId());
                    this.maybeUpdateMasterJEVersion();
                    this.feederManager.runFeeders();
                    this.nodeState.changeAndNotify(ReplicatedEnvironment.State.UNKNOWN, NameIdPair.NULL);
                    this.repImpl.getVLSNIndex().initAsReplica();
                    assert (this.runConvertHooks());
                    this.feederManager = new FeederManager(this);
                    continue;
                }
                this.replica.replicaTransitionCleanup();
                this.replica.runReplicaLoop();
            }
        }
        catch (InterruptedException e) {
            LoggerUtils.fine(this.logger, this.repImpl, "RepNode main thread interrupted -  forced shutdown.");
        }
        catch (GroupShutdownException e) {
            this.saveShutdownException(e);
            LoggerUtils.fine(this.logger, this.repImpl, "RepNode main thread sees group shutdown - " + e);
        }
        catch (InsufficientLogException e) {
            this.saveShutdownException(e);
        }
        catch (RuntimeException e) {
            LoggerUtils.fine(this.logger, this.repImpl, "RepNode main thread sees runtime ex - " + e);
            this.saveShutdownException(e);
            throw e;
        }
        catch (Error e) {
            LoggerUtils.fine(this.logger, this.repImpl, e + " incurred during repnode loop");
            repNodeError = e;
            this.repImpl.invalidate(e);
        }
        finally {
            try {
                LoggerUtils.info(this.logger, this.repImpl, "RepNode main thread shutting down.");
                if (repNodeError != null) {
                    LoggerUtils.info(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                    throw repNodeError;
                }
                Exception exception = this.getSavedShutdownException();
                if (exception == null) {
                    LoggerUtils.fine(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                } else {
                    LoggerUtils.info(this.logger, this.repImpl, "RepNode shutdown exception:\n" + exception.getMessage() + this.repImpl.dumpState());
                }
                try {
                    this.shutdown();
                }
                catch (DatabaseException e) {
                    RepUtils.chainExceptionCause(e, exception);
                    LoggerUtils.severe(this.logger, this.repImpl, "Unexpected exception during shutdown" + e);
                    throw e;
                }
            }
            catch (InterruptedException exception) {}
            this.nodeState.changeAndNotify(ReplicatedEnvironment.State.DETACHED, NameIdPair.NULL);
            this.cleanup();
        }
    }

    private void maybeUpdateMasterJEVersion() {
        RepNodeImpl node;
        if (this.group.getFormatVersion() < 3) {
            return;
        }
        JEVersion currentJEVersion = this.repImpl.getCurrentJEVersion();
        if (currentJEVersion.equals((node = this.group.getMember(this.nameIdPair.getName())).getJEVersion())) {
            return;
        }
        node.updateJEVersion(currentJEVersion);
        this.repGroupDB.updateMember(node, false);
    }

    void notifyReplicaConnected() {
        this.nodeState.changeAndNotify(ReplicatedEnvironment.State.REPLICA, this.masterStatus.getNodeMasterNameId());
    }

    public boolean isShutdownOrInvalid() {
        if (this.isShutdown()) {
            return true;
        }
        if (this.getRepImpl().wasInvalidated()) {
            this.saveShutdownException(this.getRepImpl().getInvalidatingException());
            return true;
        }
        return false;
    }

    public void shutdown() throws InterruptedException, DatabaseException {
        if (this.shutdownDone(this.logger)) {
            return;
        }
        LoggerUtils.info(this.logger, this.repImpl, "Shutting down node " + this.nameIdPair + " DTVLSN:" + this.getAnyDTVLSN());
        if (this.repImpl.isValid()) {
            this.monitorEventManager.notifyLeaveGroup(this.getLeaveReason());
        }
        this.serviceDispatcher.preShutdown();
        if (this.elections != null) {
            this.elections.shutdown();
        }
        this.feederManager.shutdownQueue();
        if (this.getReplicaCloseCatchupMs() >= 0L && this.nodeState.getRepEnvState().isMaster()) {
            this.join();
        }
        this.replica.shutdown();
        this.shutdownThread(this.logger);
        LoggerUtils.info(this.logger, this.repImpl, "RepNode main thread: " + this.getName() + " exited.");
        this.utilityServicesShutdown();
        MasterTransfer mt = this.getActiveTransfer();
        if (mt != null) {
            Exception ex = this.getSavedShutdownException();
            if (ex == null) {
                ex = new MasterTransferFailureException("shutting down");
            }
            mt.abort(ex);
        }
        this.serviceDispatcher.shutdown();
        LoggerUtils.info(this.logger, this.repImpl, this.nameIdPair + " shutdown completed.");
        this.masterStatus.setGroupMaster(null, 0, NameIdPair.NULL);
        this.readyLatch.releaseAwait(this.getSavedShutdownException());
        this.channelTimeoutTask.cancel();
        this.timer.cancel();
    }

    @Override
    protected int initiateSoftShutdown() {
        return this.getThreadWaitInterval();
    }

    private LeaveGroupEvent.LeaveReason getLeaveReason() {
        LeaveGroupEvent.LeaveReason reason = null;
        Exception exception = this.getSavedShutdownException();
        reason = exception == null ? LeaveGroupEvent.LeaveReason.NORMAL_SHUTDOWN : (exception instanceof GroupShutdownException ? LeaveGroupEvent.LeaveReason.MASTER_SHUTDOWN_GROUP : LeaveGroupEvent.LeaveReason.ABNORMAL_TERMINATION);
        return reason;
    }

    private void utilityServicesShutdown() {
        if (this.ldiff != null) {
            this.ldiff.shutdown();
        }
        if (this.logFeederManager != null) {
            this.logFeederManager.shutdown();
        }
        if (this.binaryNodeStateService != null) {
            this.binaryNodeStateService.shutdown();
        }
        if (this.nodeStateService != null) {
            this.serviceDispatcher.cancel("NodeState");
        }
        if (this.groupService != null) {
            this.serviceDispatcher.cancel("Group");
        }
    }

    public void shutdownGroupOnClose(long timeoutMs) throws IllegalStateException {
        if (!this.nodeState.getRepEnvState().isMaster()) {
            throw new IllegalStateException("Node state must be " + (Object)((Object)ReplicatedEnvironment.State.MASTER) + ", not " + (Object)((Object)this.nodeState.getRepEnvState()));
        }
        this.replicaCloseCatchupMs = timeoutMs < 0L ? 0L : timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReplicatedEnvironment.State joinGroup(ReplicaConsistencyPolicy consistency, QuorumPolicy initialElectionPolicy) throws ReplicaConsistencyException, DatabaseException {
        JoinGroupTimeouts timeouts = new JoinGroupTimeouts(this.getConfigManager());
        this.startup(initialElectionPolicy);
        LoggerUtils.finest(this.logger, this.repImpl, "joinGroup " + (Object)((Object)this.nodeState.getRepEnvState()));
        DatabaseException exitException = null;
        int retries = 0;
        this.repImpl.getStartupTracker().start(StartupTracker.Phase.BECOME_CONSISTENT);
        this.repImpl.getStartupTracker().setProgress(RecoveryProgress.BECOME_CONSISTENT);
        try {
            block17: for (retries = 0; retries < 10; ++retries) {
                ReplicatedEnvironment.State finalState;
                try {
                    boolean done = this.getReadyLatch().awaitOrException(timeouts.getTimeout(), TimeUnit.MILLISECONDS);
                    finalState = this.nodeState.getRepEnvState();
                    if (!done) {
                        if (finalState.isReplica()) {
                            if (!timeouts.timeoutIsForUnknownState()) {
                                throw new ReplicaConsistencyException(String.format("Setup time exceeded %,d ms", timeouts.getSetupTimeout()), null);
                            }
                            timeouts.setSetupTimeout();
                            continue;
                        }
                        if (finalState.isUnknown() && timeouts.timeoutIsForUnknownState()) {
                            ReplicatedEnvironment.State state = ReplicatedEnvironment.State.UNKNOWN;
                            return state;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                catch (MasterStateException e) {
                    LoggerUtils.warning(this.logger, this.repImpl, "Join retry due to master transition: " + e.getMessage());
                    continue;
                }
                catch (RestartRequiredException e) {
                    LoggerUtils.warning(this.logger, this.repImpl, "Environment needs to be restarted: " + e.getMessage());
                    throw e;
                }
                catch (DatabaseException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) throw e;
                    if (cause.getClass() != Replica.ConnectRetryException.class) throw e;
                    exitException = e;
                    if (timeouts.getTimeout() <= 0) throw e;
                    LoggerUtils.warning(this.logger, this.repImpl, "Join retry due to exception: " + cause.getMessage());
                    continue;
                }
                {
                    switch (finalState) {
                        case UNKNOWN: {
                            continue block17;
                        }
                        case REPLICA: {
                            this.joinAsReplica(consistency);
                            break;
                        }
                        case MASTER: {
                            LoggerUtils.info(this.logger, this.repImpl, "Joining group as master");
                            break;
                        }
                        case DETACHED: {
                            throw EnvironmentFailureException.unexpectedState("Node in DETACHED state while joining group.");
                        }
                    }
                    ReplicatedEnvironment.State state = finalState;
                    return state;
                }
            }
        }
        finally {
            this.repImpl.getStartupTracker().stop(StartupTracker.Phase.BECOME_CONSISTENT);
        }
        if (exitException == null) throw new UnknownMasterException(null, this.repImpl.getStateChangeEvent());
        LoggerUtils.warning(this.logger, this.repImpl, "Exiting joinGroup after " + retries + " retries." + exitException);
        throw exitException;
    }

    private void joinAsReplica(ReplicaConsistencyPolicy consistency) throws InterruptedException {
        if (consistency == null) {
            int consistencyTimeout = this.getConfigManager().getDuration(RepParams.ENV_CONSISTENCY_TIMEOUT);
            consistency = new PointConsistencyPolicy(new VLSN(this.replica.getMasterTxnEndVLSN()), consistencyTimeout, TimeUnit.MILLISECONDS);
        }
        consistency.ensureConsistency(this.repImpl);
        this.repImpl.getLogManager().flushNoSync();
        LoggerUtils.info(this.logger, this.repImpl, "Joined group as a replica.  join consistencyPolicy=" + consistency + " " + this.repImpl.getVLSNIndex().getRange());
    }

    public void trackSyncableVLSN(VLSN syncableVLSN, long lsn) {
        this.cbvlsnTracker.track(syncableVLSN, lsn);
    }

    public VLSN getGlobalCBVLSN() {
        return this.globalCBVLSN.getCBVLSN();
    }

    public boolean isGlobalCBVLSNDefunct() {
        return this.globalCBVLSN.isDefunct();
    }

    public VLSN getRestoreResponseVLSN(VLSNRange range) {
        return this.globalCBVLSN.getRestoreResponseVLSN(range);
    }

    public FileProtector.ProtectedFileSet syncupStarted(NameIdPair syncupNode) {
        return this.getVLSNIndex().protectRangeHead("Syncup-" + syncupNode.toString());
    }

    public void syncupEnded(FileProtector.ProtectedFileSet fileSet) {
        this.repImpl.getFileProtector().removeFileProtection(fileSet);
    }

    long getReplicaCloseCatchupMs() {
        return this.replicaCloseCatchupMs;
    }

    public Arbiter getArbiter() {
        return this.arbiter;
    }

    public final void shutdownNetworkBackup() {
        this.logFeederManager.shutdown();
        this.logFeederManager = null;
    }

    public final void restartNetworkBackup() {
        if (this.logFeederManager != null) {
            throw EnvironmentFailureException.unexpectedState(this.repImpl);
        }
        this.logFeederManager = new com.sleepycat.je.rep.impl.networkRestore.FeederManager(this.serviceDispatcher, this.repImpl, this.nameIdPair);
    }

    public String dumpState() {
        return "\n" + this.feederManager.dumpState(false) + "\n" + this.getGroup();
    }

    public String dumpAckFeederState() {
        return "\n" + this.feederManager.dumpState(true) + "\n";
    }

    public ElectionQuorum getElectionQuorum() {
        return this.electionQuorum;
    }

    public DurabilityQuorum getDurabilityQuorum() {
        return this.durabilityQuorum;
    }

    public void setConvertHook(TestHook<Integer> hook) {
        if (this.convertHooks == null) {
            this.convertHooks = new HashSet<TestHook<Integer>>();
        }
        this.convertHooks.add(hook);
    }

    private boolean runConvertHooks() {
        if (this.convertHooks == null) {
            return true;
        }
        for (TestHook<Integer> h : this.convertHooks) {
            assert (TestHookExecute.doHookIfSet(h, 0));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JEVersion getMinJEVersion() {
        Object object = this.minJEVersionLock;
        synchronized (object) {
            return this.group.getMinJEVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinJEVersion(JEVersion newMinJEVersion) throws MinJEVersionUnsupportedException {
        Object object = this.minJEVersionLock;
        synchronized (object) {
            JEVersion groupMinJEVersion = this.group.getMinJEVersion();
            if (groupMinJEVersion.compareTo(newMinJEVersion) >= 0) {
                return;
            }
            for (RepNodeImpl node : this.group.getDataMembers()) {
                JEVersion nodeJEVersion = node.getJEVersion();
                if (this.getNodeName().equals(node.getName())) {
                    nodeJEVersion = this.repImpl.getCurrentJEVersion();
                } else {
                    JEVersion currentReplicaJEVersion;
                    Feeder feeder = this.feederManager.getFeeder(node.getName());
                    if (feeder != null && (currentReplicaJEVersion = feeder.getReplicaJEVersion()) != null) {
                        nodeJEVersion = currentReplicaJEVersion;
                    }
                }
                if (nodeJEVersion != null && newMinJEVersion.compareTo(nodeJEVersion) <= 0) continue;
                throw new MinJEVersionUnsupportedException(newMinJEVersion, node.getName(), nodeJEVersion);
            }
            this.repGroupDB.setMinJEVersion(newMinJEVersion);
        }
    }

    public boolean isNeedsAcks() {
        return this.needsAcks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransientIdNode(RepNodeImpl node) {
        if (!node.getType().hasTransientId()) {
            throw new IllegalArgumentException("Attempt to call addTransientIdNode with a node without transient ID: " + node);
        }
        JEVersion requiredJEVersion = RepGroupImpl.FORMAT_VERSION_3_JE_VERSION;
        try {
            this.setMinJEVersion(requiredJEVersion);
        }
        catch (MinJEVersionUnsupportedException e) {
            if (e.nodeVersion == null) {
                throw new IllegalStateException("Secondary nodes are not currently supported. The version running on node " + e.nodeName + " could not be determined, but this feature requires version " + requiredJEVersion.getNumericVersionString() + " or later.");
            }
            throw new IllegalStateException("Secondary nodes are not currently supported. Node " + e.nodeName + " is running version " + e.nodeVersion.getNumericVersionString() + ", but this feature requires version " + requiredJEVersion.getNumericVersionString() + " or later.");
        }
        Object object = this.minJEVersionLock;
        synchronized (object) {
            JEVersion minJEVersion = this.group.getMinJEVersion();
            if (node.getJEVersion().compareTo(minJEVersion) < 0) {
                throw new IllegalStateException("The node does not meet the minimum required version for the group. Node " + node.getNameIdPair().getName() + " is running version " + node.getJEVersion() + ", but the minimum required version is " + minJEVersion);
            }
            if (!node.getNameIdPair().hasNullId()) {
                throw new IllegalStateException("New " + node.getType().toString().toLowerCase() + " node " + node.getNameIdPair().getName() + " already has an ID: " + node.getNameIdPair().getId());
            }
            node.getNameIdPair().setId(this.transientIds.allocateId());
            this.group.addTransientIdNode(node);
        }
    }

    public void removeTransientNode(RepNodeImpl node) {
        if (!node.getType().hasTransientId()) {
            throw new IllegalArgumentException("Attempt to call removeTransientNode with a node without transient ID: " + node);
        }
        this.group.removeTransientNode(node);
        this.transientIds.deallocateId(node.getNodeId());
    }

    static class TransientIds {
        private final int size;
        private final BitSet bits;

        TransientIds(int size) {
            this.size = size;
            assert (size > 0);
            this.bits = new BitSet(size);
        }

        synchronized int allocateId() {
            int pos = this.bits.nextClearBit(0);
            if (pos >= this.size) {
                throw new IllegalStateException("No more secondary node IDs");
            }
            this.bits.set(pos);
            return Integer.MAX_VALUE - pos;
        }

        synchronized void deallocateId(int id) {
            if (id < Integer.MAX_VALUE - this.size) {
                throw new IllegalArgumentException("Illegal secondary node ID: " + id);
            }
            int pos = Integer.MAX_VALUE - id;
            if (!this.bits.get(pos)) {
                throw new IllegalArgumentException("Secondary node ID is not currently allocated: " + id);
            }
            this.bits.clear(pos);
        }
    }

    private class RepElectionsConfig
    implements ElectionsConfig {
        private final RepNode repNode;

        RepElectionsConfig(RepNode repNode2) {
            this.repNode = repNode2;
        }

        @Override
        public String getGroupName() {
            return this.repNode.getRepImpl().getConfigManager().get(RepParams.GROUP_NAME);
        }

        @Override
        public NameIdPair getNameIdPair() {
            return this.repNode.getNameIdPair();
        }

        @Override
        public ServiceDispatcher getServiceDispatcher() {
            return this.repNode.getServiceDispatcher();
        }

        @Override
        public int getElectionPriority() {
            return this.repNode.getElectionPriority();
        }

        @Override
        public int getLogVersion() {
            return this.repNode.getLogVersion();
        }

        @Override
        public RepImpl getRepImpl() {
            return this.repNode.getRepImpl();
        }

        @Override
        public RepNode getRepNode() {
            return this.repNode;
        }
    }
}

