/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchFactory;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileHandle {
    private RandomAccessFile file;
    private Latch fileLatch;
    private int logVersion;
    private long fileNum;

    FileHandle(EnvironmentImpl envImpl, long fileNum, String label) {
        this.fileLatch = LatchFactory.createExclusiveLatch(envImpl, "file_" + label + "_fileHandle", false);
        this.fileNum = fileNum;
    }

    void init(RandomAccessFile file, int logVersion) {
        assert (this.file == null);
        this.file = file;
        this.logVersion = logVersion;
    }

    RandomAccessFile getFile() {
        return this.file;
    }

    long getFileNum() {
        return this.fileNum;
    }

    public int getLogVersion() {
        return this.logVersion;
    }

    boolean isOldHeaderVersion() {
        return this.logVersion < 16;
    }

    void latch() throws DatabaseException {
        this.fileLatch.acquireExclusive();
    }

    boolean latchNoWait() throws DatabaseException {
        return this.fileLatch.acquireExclusiveNoWait();
    }

    public void release() throws DatabaseException {
        this.fileLatch.release();
    }

    void close() throws IOException {
        if (this.file != null) {
            try {
                this.file.close();
            }
            finally {
                this.file = null;
            }
        }
    }
}

