/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.lite.controller;

import com.plumelog.core.client.AbstractServerClient;
import com.plumelog.core.constant.LogMessageConstant;
import com.plumelog.lite.client.AppNameCache;
import com.plumelog.lite.client.IndexUtil;
import com.plumelog.lite.client.InitConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/plumelog"})
public class PlumeLogMainController {
    @Autowired
    private AbstractServerClient abstractServerClient;
    private String adminPassWord = "123456";

    @RequestMapping(value={"/queryAppName"})
    public String queryAppName(@RequestBody String queryStr) {
        String[] indexs = new String[InitConfig.keepDays];
        for (int i = 0; i < InitConfig.keepDays; ++i) {
            indexs[i] = IndexUtil.getRunLogIndex(System.currentTimeMillis() - (long)i * 86400000L) + "*";
        }
        List reindexs = this.abstractServerClient.getExistIndices(indexs);
        String indexStr = String.join((CharSequence)",", reindexs);
        if ("".equals(indexStr)) {
            return "";
        }
        try {
            return this.abstractServerClient.get(indexStr, queryStr, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @RequestMapping(value={"/queryAppNames"})
    public Set<String> queryAppNames(@RequestBody String queryStr) {
        String[] indexs = new String[InitConfig.keepDays];
        for (int i = 0; i < InitConfig.keepDays; ++i) {
            indexs[i] = IndexUtil.getRunLogIndex(System.currentTimeMillis() - (long)i * 86400000L) + "*";
        }
        List reindexs = this.abstractServerClient.getExistIndices(indexs);
        String indexStr = String.join((CharSequence)",", reindexs);
        if ("".equals(indexStr)) {
            return Collections.emptySet();
        }
        HashSet<String> appNameSet = new HashSet<String>();
        boolean isQueryWithEnv = queryStr.contains("appNameWithEnv");
        TreeSet<String> appNameWithEnvSet = new TreeSet<String>(this.queryAppNameWithEnvSet(indexStr, queryStr, appNameSet, isQueryWithEnv));
        if (isQueryWithEnv) {
            queryStr = queryStr.replaceAll("appNameWithEnv", "appName");
            appNameWithEnvSet.addAll(this.queryAppNameWithEnvSet(indexStr, queryStr, appNameSet, false));
        }
        return appNameWithEnvSet;
    }

    @RequestMapping(value={"/clientQuery"})
    public String clientQuery(@RequestBody String queryStr, String size, String from, String clientStartDate, String clientEndDate, String trace) {
        Long clientStartDateTime = 0L;
        try {
            clientStartDateTime = Long.valueOf(clientStartDate);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (clientStartDateTime <= 0L) {
            clientStartDateTime = System.currentTimeMillis();
        }
        Long clientEndDateTime = 0L;
        try {
            clientEndDateTime = Long.valueOf(clientEndDate);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (clientEndDateTime <= 0L) {
            clientEndDateTime = System.currentTimeMillis();
        }
        LinkedHashSet<String> indexSet = new LinkedHashSet<String>();
        while (clientStartDateTime <= clientEndDateTime) {
            indexSet.add(("true".equalsIgnoreCase(trace) ? IndexUtil.getTraceLogIndex(clientStartDateTime) : IndexUtil.getRunLogIndex(clientStartDateTime)) + "*");
            clientStartDateTime = clientStartDateTime + 86400000L;
        }
        indexSet.add(("true".equalsIgnoreCase(trace) ? IndexUtil.getTraceLogIndex(clientEndDateTime) : IndexUtil.getRunLogIndex(clientEndDateTime)) + "*");
        List existIndices = this.abstractServerClient.getExistIndices(indexSet.toArray(new String[0]));
        String indexStr = String.join((CharSequence)",", existIndices);
        if ("".equals(indexStr)) {
            return "";
        }
        try {
            return this.abstractServerClient.get(indexStr, queryStr, from, size);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @RequestMapping(value={"/query"})
    public String query(@RequestBody String queryStr, String index, String size, String from, String range) {
        String message = "";
        String indexStr = "";
        try {
            List reindexs;
            List indexs;
            TreeSet<Object> indexSet = new TreeSet<Object>();
            if (!StringUtils.isEmpty((Object)index) && !(indexs = Stream.of(index.split(",")).map(String::trim).filter(s -> !StringUtils.isEmpty((Object)s)).collect(Collectors.toList())).isEmpty()) {
                indexSet.addAll(indexs);
            }
            if (!StringUtils.isEmpty((Object)range)) {
                int rangeDays = 0;
                if ("day".equalsIgnoreCase(range)) {
                    rangeDays = 1;
                } else if ("week".equalsIgnoreCase(range)) {
                    rangeDays = 7;
                } else if ("month".equalsIgnoreCase(range)) {
                    rangeDays = 30;
                }
                for (int i = 0; i < rangeDays; ++i) {
                    indexSet.add(IndexUtil.getRunLogIndex(System.currentTimeMillis() - (long)i * 86400000L) + "*");
                }
            }
            if ("".equals(indexStr = (reindexs = this.abstractServerClient.getExistIndices(indexSet.toArray(new String[0]))).stream().filter(s -> !StringUtils.isEmpty((Object)s)).collect(Collectors.joining(",")))) {
                return message;
            }
            return this.abstractServerClient.get(indexStr, queryStr, from, size);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @RequestMapping(value={"/deleteByQuery"})
    public String deleteByQuery(@RequestBody String queryStr, String index, String size, String from) {
        String message = "";
        String indexStr = "";
        try {
            String[] indexs = (String[])Stream.of(index.split(",")).map(String::trim).filter(s -> !StringUtils.isEmpty((Object)s)).toArray(String[]::new);
            List reindexs = this.abstractServerClient.getExistIndices(indexs);
            indexStr = String.join((CharSequence)",", reindexs);
            if ("".equals(indexStr)) {
                return message;
            }
            String url = "/" + indexStr + "/_delete_by_query?from=" + from + "&size=" + size;
            return this.abstractServerClient.get(url, queryStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @RequestMapping(value={"/getServerInfo"})
    public String query(String index) {
        return this.abstractServerClient.cat(index);
    }

    @RequestMapping(value={"/deleteIndex"})
    public Map<String, Object> deleteIndex(String index, String adminPassWord) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (adminPassWord.equals(this.adminPassWord)) {
            boolean re = this.abstractServerClient.deleteIndex(index);
            if (index.startsWith("plume_log_run")) {
                this.creatIndiceLog(index);
            }
            if (index.startsWith("plume_log_trace")) {
                this.creatIndiceTrace(index);
            }
            map.put("acknowledged", re);
        } else {
            map.put("acknowledged", false);
            map.put("message", "\u7ba1\u7406\u5bc6\u7801\u9519\u8bef\uff01");
        }
        return map;
    }

    private void creatIndiceLog(String index) {
        if (!this.abstractServerClient.existIndice(index)) {
            this.abstractServerClient.creatIndice(index, LogMessageConstant.ES_TYPE);
        }
    }

    private void creatIndiceTrace(String index) {
        if (!this.abstractServerClient.existIndice(index)) {
            this.abstractServerClient.creatIndiceTrace(index, LogMessageConstant.ES_TYPE);
        }
    }

    @RequestMapping(value={"/getAppNames"})
    public Object getAppNames() {
        return AppNameCache.appName;
    }

    private Set<String> queryAppNameWithEnvSet(String indexStr, String queryStr, Set<String> appNameSet, boolean isQueryWithEnv) {
        try {
            String result = this.abstractServerClient.group(indexStr, queryStr);
            if (!"".equals(result)) {
                HashSet<String> appNameWithEnvSet = new HashSet<String>();
                JSONObject jsonObject = JSONObject.fromObject((Object)result);
                jsonObject = (JSONObject)jsonObject.get("aggregations");
                jsonObject = (JSONObject)jsonObject.get("dataCount");
                JSONArray jsonArray = jsonObject.getJSONArray("buckets");
                if (isQueryWithEnv) {
                    jsonArray.forEach(key -> {
                        JSONObject keyJsonObject = (JSONObject)key;
                        String appNameWithEnv = (String)keyJsonObject.get("key");
                        appNameWithEnvSet.add(appNameWithEnv);
                        appNameSet.add(appNameWithEnv.split("-_-")[0]);
                    });
                } else {
                    jsonArray.forEach(key -> {
                        JSONObject keyJsonObject = (JSONObject)key;
                        String appName = (String)keyJsonObject.get("key");
                        if (!appNameSet.contains(appName)) {
                            appNameSet.add(appName);
                            appNameWithEnvSet.add(appName + "-_-");
                        }
                    });
                }
                return appNameWithEnvSet;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return Collections.emptySet();
    }

    @GetMapping(value={"/getRunModel"})
    public Object getRunModel() {
        return InitConfig.START_MODEL;
    }
}

