/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.lite.client;

import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.StringUtils;
import com.plumelog.lite.client.Filter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.Session;

public class WebSocketSession {
    public static CopyOnWriteArraySet<Session> sessions = new CopyOnWriteArraySet();
    public static ConcurrentHashMap<Session, Filter> sessionAppName = new ConcurrentHashMap();

    public static void sendToConsole(String message) {
        try {
            if (sessions.size() == 0) {
                return;
            }
            for (Session session : sessions) {
                RunLogMessage runLogMessage = (RunLogMessage)GfJsonUtil.parseObject((String)message, RunLogMessage.class);
                WebSocketSession.send(session, runLogMessage, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendToConsole(RunLogMessage runLogMessage) {
        try {
            if (sessions.size() == 0) {
                return;
            }
            String message = GfJsonUtil.toJSONString((Object)runLogMessage);
            for (Session session : sessions) {
                WebSocketSession.send(session, runLogMessage, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void send(Session session, RunLogMessage runLogMessage, String message) throws Exception {
        Filter filter = sessionAppName.get(session);
        if (filter != null && filter.getAppName() != null) {
            String appName = filter.getAppName();
            String env = filter.getEnv();
            String serverName = filter.getServerName();
            String level = filter.getLevel();
            if (StringUtils.isNotEmpty((String)appName)) {
                if (StringUtils.isEmpty((String)env) && StringUtils.isEmpty((String)serverName) && StringUtils.isEmpty((String)level)) {
                    if (runLogMessage.getAppName().equals(appName)) {
                        session.getBasicRemote().sendText(message);
                    }
                } else if (StringUtils.isNotEmpty((String)env) && StringUtils.isEmpty((String)serverName) && StringUtils.isEmpty((String)level)) {
                    if (runLogMessage.getAppName().equals(appName) && runLogMessage.getEnv().equals(env)) {
                        session.getBasicRemote().sendText(message);
                    }
                } else if (StringUtils.isNotEmpty((String)env) && StringUtils.isNotEmpty((String)serverName) && StringUtils.isEmpty((String)level)) {
                    if (runLogMessage.getAppName().equals(appName) && runLogMessage.getEnv().equals(env) && runLogMessage.getServerName().equals(serverName)) {
                        session.getBasicRemote().sendText(message);
                    }
                } else if (StringUtils.isEmpty((String)env) && StringUtils.isNotEmpty((String)serverName) && StringUtils.isEmpty((String)level)) {
                    if (runLogMessage.getAppName().equals(appName) && runLogMessage.getServerName().equals(serverName)) {
                        session.getBasicRemote().sendText(message);
                    }
                } else if (StringUtils.isNotEmpty((String)env) && StringUtils.isNotEmpty((String)serverName) && StringUtils.isNotEmpty((String)level)) {
                    if (runLogMessage.getAppName().equals(appName) && runLogMessage.getEnv().equals(env) && runLogMessage.getServerName().equals(serverName) && runLogMessage.getLogLevel().equals(level)) {
                        session.getBasicRemote().sendText(message);
                    }
                } else if (StringUtils.isNotEmpty((String)env) && StringUtils.isEmpty((String)serverName) && StringUtils.isNotEmpty((String)level)) {
                    if (runLogMessage.getAppName().equals(appName) && runLogMessage.getEnv().equals(env) && runLogMessage.getLogLevel().equals(level)) {
                        session.getBasicRemote().sendText(message);
                    }
                } else if (StringUtils.isEmpty((String)env) && StringUtils.isNotEmpty((String)serverName) && StringUtils.isNotEmpty((String)level)) {
                    if (runLogMessage.getAppName().equals(appName) && runLogMessage.getServerName().equals(serverName) && runLogMessage.getLogLevel().equals(level)) {
                        session.getBasicRemote().sendText(message);
                    }
                } else if (StringUtils.isEmpty((String)env) && StringUtils.isEmpty((String)serverName) && StringUtils.isNotEmpty((String)level) && runLogMessage.getAppName().equals(appName) && runLogMessage.getLogLevel().equals(level)) {
                    session.getBasicRemote().sendText(message);
                }
            }
        }
    }
}

