/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.lite.client;

import com.plumelog.core.client.AbstractServerClient;
import com.plumelog.lite.client.IndexUtil;
import com.plumelog.lite.client.InitConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoDeleteLogs {
    private final Logger logger = LoggerFactory.getLogger(AutoDeleteLogs.class);
    @Autowired
    private AbstractServerClient abstractServerClient;

    @Scheduled(cron="0 0 0 * * ?")
    public void deleteLogs() {
        String hour;
        int a;
        if (InitConfig.keepDays > 0) {
            try {
                this.logger.info("begin delete {} days ago run logs!", (Object)InitConfig.keepDays);
                String runLogIndex = IndexUtil.getRunLogIndex(System.currentTimeMillis() - (long)InitConfig.keepDays * 86400000L);
                this.abstractServerClient.deleteIndex(runLogIndex);
                for (a = 0; a < 24; ++a) {
                    hour = String.format("%02d", a);
                    this.abstractServerClient.deleteIndex(runLogIndex + hour);
                }
                this.logger.info("delete success! index:" + runLogIndex);
            }
            catch (Exception e) {
                this.logger.error("delete logs error!", (Throwable)e);
            }
        } else {
            this.logger.info("unwanted delete logs");
        }
        if (InitConfig.traceKeepDays > 0) {
            try {
                this.logger.info("begin delete {} days ago trace logs!", (Object)InitConfig.traceKeepDays);
                String traceLogIndex = IndexUtil.getTraceLogIndex(System.currentTimeMillis() - (long)InitConfig.traceKeepDays * 86400000L);
                this.abstractServerClient.deleteIndex(traceLogIndex);
                for (a = 0; a < 24; ++a) {
                    hour = String.format("%02d", a);
                    this.abstractServerClient.deleteIndex(traceLogIndex + hour);
                }
                this.logger.info("delete success! index:" + traceLogIndex);
            }
            catch (Exception e) {
                this.logger.error("delete logs error!", (Throwable)e);
            }
        } else {
            this.logger.info("unwanted delete logs");
        }
    }
}

