/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.query.Failover;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableFailover
extends Failover {
    private final Optional<Integer> nearestN;
    private final Optional<String> datacenters;

    private ImmutableFailover(Optional<Integer> nearestN, Optional<String> datacenters) {
        this.nearestN = nearestN;
        this.datacenters = datacenters;
    }

    @Override
    @JsonProperty(value="NearestN")
    public Optional<Integer> getNearestN() {
        return this.nearestN;
    }

    @Override
    @JsonProperty(value="Datacenters")
    public Optional<String> datacenters() {
        return this.datacenters;
    }

    public final ImmutableFailover withNearestN(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.nearestN.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFailover((Optional<Integer>)newValue, this.datacenters);
    }

    public final ImmutableFailover withNearestN(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"nearestN");
        if (this.nearestN.equals((Object)value)) {
            return this;
        }
        return new ImmutableFailover((Optional<Integer>)value, this.datacenters);
    }

    public final ImmutableFailover withDatacenters(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.datacenters.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFailover(this.nearestN, (Optional<String>)newValue);
    }

    public final ImmutableFailover withDatacenters(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"datacenters");
        if (this.datacenters.equals((Object)value)) {
            return this;
        }
        return new ImmutableFailover(this.nearestN, (Optional<String>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFailover && this.equalTo((ImmutableFailover)another);
    }

    private boolean equalTo(ImmutableFailover another) {
        return this.nearestN.equals(another.nearestN) && this.datacenters.equals(another.datacenters);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.nearestN.hashCode();
        h = h * 17 + this.datacenters.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Failover").omitNullValues().add("nearestN", this.nearestN.orNull()).add("datacenters", this.datacenters.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableFailover fromJson(Json json) {
        Builder builder = ImmutableFailover.builder();
        if (json.nearestN != null) {
            builder.nearestN(json.nearestN);
        }
        if (json.datacenters != null) {
            builder.datacenters(json.datacenters);
        }
        return builder.build();
    }

    public static ImmutableFailover copyOf(Failover instance) {
        if (instance instanceof ImmutableFailover) {
            return (ImmutableFailover)instance;
        }
        return ImmutableFailover.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<Integer> nearestN = Optional.absent();
        private Optional<String> datacenters = Optional.absent();

        private Builder() {
        }

        public final Builder from(Failover instance) {
            Optional<String> datacentersOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Integer> nearestNOptional = instance.getNearestN();
            if (nearestNOptional.isPresent()) {
                this.nearestN(nearestNOptional);
            }
            if ((datacentersOptional = instance.datacenters()).isPresent()) {
                this.datacenters(datacentersOptional);
            }
            return this;
        }

        public final Builder nearestN(int nearestN) {
            this.nearestN = Optional.of((Object)nearestN);
            return this;
        }

        public final Builder nearestN(Optional<Integer> nearestN) {
            this.nearestN = (Optional)Preconditions.checkNotNull(nearestN, (Object)"nearestN");
            return this;
        }

        public final Builder datacenters(String datacenters) {
            this.datacenters = Optional.of((Object)datacenters);
            return this;
        }

        public final Builder datacenters(Optional<String> datacenters) {
            this.datacenters = (Optional)Preconditions.checkNotNull(datacenters, (Object)"datacenters");
            return this;
        }

        public ImmutableFailover build() {
            return new ImmutableFailover(this.nearestN, this.datacenters);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Failover {
        Optional<Integer> nearestN = Optional.absent();
        Optional<String> datacenters = Optional.absent();

        Json() {
        }

        @JsonProperty(value="NearestN")
        public void setNearestN(Optional<Integer> nearestN) {
            this.nearestN = nearestN;
        }

        @JsonProperty(value="Datacenters")
        public void setDatacenters(Optional<String> datacenters) {
            this.datacenters = datacenters;
        }

        @Override
        public Optional<Integer> getNearestN() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> datacenters() {
            throw new UnsupportedOperationException();
        }
    }
}

