/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.model.PersistentProxy;
import com.sleepycat.persist.raw.RawObject;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxiedFormat
extends Format {
    private static final long serialVersionUID = -1000032651995478768L;
    private Format proxyFormat;
    private transient String proxyClassName;

    ProxiedFormat(Class proxiedType, String proxyClassName) {
        super(proxiedType);
        this.proxyClassName = proxyClassName;
    }

    private String getProxyClassName() {
        if (this.proxyClassName != null) {
            return this.proxyClassName;
        }
        assert (this.proxyFormat != null);
        return this.proxyFormat.getClassName();
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
        assert (this.proxyClassName != null);
        catalog.createFormat(this.proxyClassName, newFormats);
    }

    @Override
    void initialize(Catalog catalog) {
        if (this.proxyFormat == null) {
            assert (this.proxyClassName != null);
            this.proxyFormat = catalog.getFormat(this.proxyClassName);
        }
        this.proxyFormat.setProxiedFormat(this);
    }

    @Override
    Object newArray(int len) {
        return Array.newInstance(this.getType(), len);
    }

    @Override
    public Object newInstance(EntityInput input, boolean rawAccess) {
        Reader reader = this.proxyFormat.getReader();
        if (rawAccess) {
            return reader.newInstance(null, true);
        }
        PersistentProxy proxy = (PersistentProxy)reader.newInstance(null, false);
        proxy = (PersistentProxy)reader.readObject(proxy, input, false);
        return proxy.convertProxy();
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) {
        if (rawAccess) {
            o = this.proxyFormat.getReader().readObject(o, input, true);
        }
        return o;
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        if (rawAccess) {
            this.proxyFormat.writeObject(o, output, true);
        } else {
            PersistentProxy proxy = (PersistentProxy)this.proxyFormat.newInstance(null, false);
            proxy.initializeProxy(o);
            this.proxyFormat.writeObject(proxy, output, false);
        }
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) {
        PersistentProxy proxy = (PersistentProxy)this.proxyFormat.convertRawObject(catalog, rawAccess, rawObject, converted);
        Object o = proxy.convertProxy();
        converted.put(rawObject, o);
        return o;
    }

    @Override
    void skipContents(RecordInput input) {
        this.proxyFormat.skipContents(input);
    }

    @Override
    void copySecMultiKey(RecordInput input, Format keyFormat, Set results) {
        CollectionProxy.copyElements(input, this, keyFormat, results);
    }

    @Override
    boolean evolve(Format newFormatParam, Evolver evolver) {
        if (!(newFormatParam instanceof ProxiedFormat)) {
            evolver.addEvolveError(this, newFormatParam, null, "A proxied class may not be changed to a different type");
            return false;
        }
        ProxiedFormat newFormat = (ProxiedFormat)newFormatParam;
        if (!evolver.evolveFormat(this.proxyFormat)) {
            return false;
        }
        Format newProxyFormat = this.proxyFormat.getLatestVersion();
        if (!newProxyFormat.getClassName().equals(newFormat.getProxyClassName())) {
            evolver.addEvolveError(this, newFormat, null, "The proxy class for this type has been changed from: " + newProxyFormat.getClassName() + " to: " + newFormat.getProxyClassName());
            return false;
        }
        if (newProxyFormat != this.proxyFormat) {
            evolver.useEvolvedFormat(this, this, newFormat);
        } else {
            evolver.useOldFormat(this, newFormat);
        }
        return true;
    }
}

