/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.TxnPrepare;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;

public class Txn
extends Locker
implements Loggable {
    public static final byte TXN_NOSYNC = 0;
    public static final byte TXN_WRITE_NOSYNC = 1;
    public static final byte TXN_SYNC = 2;
    private static final String DEBUG_NAME;
    private byte txnState;
    private CursorImpl cursorSet;
    private static final byte USABLE = 0;
    private static final byte CLOSED = 1;
    private static final byte ONLY_ABORTABLE = 2;
    private static final byte STATE_BITS = 3;
    private static final byte IS_PREPARED = 4;
    private static final byte XA_SUSPENDED = 8;
    private Set readLocks;
    private Map writeInfo;
    private final int READ_LOCK_OVERHEAD = MemoryBudget.HASHSET_ENTRY_OVERHEAD;
    private final int WRITE_LOCK_OVERHEAD = MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.WRITE_LOCKINFO_OVERHEAD;
    private Set deletedDatabases;
    private Map undoDatabases;
    private long lastLoggedLsn = -1L;
    private long firstLoggedLsn = -1L;
    private byte defaultFlushSyncBehavior;
    private boolean serializableIsolation;
    private boolean readCommittedIsolation;
    private int inMemorySize;
    private int accumulatedDelta = 0;
    public static int ACCUMULATED_LIMIT;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Txn(EnvironmentImpl envImpl, TransactionConfig config) throws DatabaseException {
        super(envImpl, config.getReadUncommitted(), config.getNoWait());
        this.init(envImpl, config);
    }

    public Txn(EnvironmentImpl envImpl, TransactionConfig config, long id) throws DatabaseException {
        super(envImpl, config.getReadUncommitted(), config.getNoWait());
        this.init(envImpl, config);
        this.id = id;
    }

    private void init(EnvironmentImpl envImpl, TransactionConfig config) throws DatabaseException {
        this.serializableIsolation = config.getSerializableIsolation();
        this.readCommittedIsolation = config.getReadCommitted();
        this.defaultFlushSyncBehavior = config.getSync() ? (byte)2 : (config.getWriteNoSync() ? (byte)1 : (config.getNoSync() ? (byte)0 : (byte)2));
        this.lastLoggedLsn = -1L;
        this.firstLoggedLsn = -1L;
        this.txnState = 0;
        this.updateMemoryUsage(MemoryBudget.TXN_OVERHEAD);
        this.envImpl.getTxnManager().registerTxn(this);
    }

    public Txn() {
        this.lastLoggedLsn = -1L;
    }

    protected long generateId(TxnManager txnManager) {
        return txnManager.incTxnId();
    }

    long getLastLsn() {
        return this.lastLoggedLsn;
    }

    public void setPrepared(boolean prepared) {
        this.txnState = prepared ? (byte)(this.txnState | 4) : (byte)(this.txnState & 0xFFFFFFFB);
    }

    public void setSuspended(boolean suspended) {
        this.txnState = suspended ? (byte)(this.txnState | 8) : (byte)(this.txnState & 0xFFFFFFF7);
    }

    public boolean isSuspended() {
        return (this.txnState & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LockResult lockInternal(long nodeId, LockType lockType, boolean noWait, DatabaseImpl database) throws DatabaseException {
        long timeout = 0L;
        boolean useNoWait = noWait || this.defaultNoWait;
        Txn txn = this;
        synchronized (txn) {
            this.checkState(false);
            if (!useNoWait) {
                timeout = this.lockTimeOutMillis;
            }
        }
        LockGrantType grant = this.lockManager.lock(nodeId, this, lockType, timeout, useNoWait, database);
        WriteLockInfo info = null;
        if (this.writeInfo != null && grant != LockGrantType.DENIED && lockType.isWriteLock()) {
            Txn txn2 = this;
            synchronized (txn2) {
                info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
                this.undoDatabases.put(database.getId(), database);
            }
        }
        return new LockResult(grant, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws DatabaseException {
        if ((this.txnState & 4) != 0) {
            throw new DatabaseException("prepare() has already been called for Transaction " + this.id + ".");
        }
        Txn txn = this;
        synchronized (txn) {
            this.checkState(false);
            if (this.checkCursorsForClose()) {
                throw new DatabaseException("Transaction " + this.id + " prepare failed because there were open cursors.");
            }
            SingleItemEntry prepareEntry = new SingleItemEntry(LogEntryType.LOG_TXN_PREPARE, new TxnPrepare(this.id, xid));
            LogManager logManager = this.envImpl.getLogManager();
            logManager.logForceFlush(prepareEntry, true);
        }
        this.setPrepared(true);
        return 0;
    }

    public void commit(Xid xid) throws DatabaseException {
        this.commit((byte)2);
        this.envImpl.getTxnManager().unRegisterXATxn(xid, true);
    }

    public void abort(Xid xid) throws DatabaseException {
        this.abort(true);
        this.envImpl.getTxnManager().unRegisterXATxn(xid, false);
    }

    public long commit() throws DatabaseException {
        return this.commit(this.defaultFlushSyncBehavior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long commit(byte flushSyncBehavior) throws DatabaseException {
        try {
            long commitLsn = -1L;
            Txn txn = this;
            synchronized (txn) {
                this.checkState(false);
                if (this.checkCursorsForClose()) {
                    throw new DatabaseException("Transaction " + this.id + " commit failed because there were open cursors.");
                }
                ArrayList<WriteLockInfo> transferredWriteLockInfo = null;
                if (this.handleLockToHandleMap != null) {
                    Iterator handleLockIter = this.handleLockToHandleMap.entrySet().iterator();
                    while (handleLockIter.hasNext()) {
                        WriteLockInfo info;
                        Map.Entry entry = handleLockIter.next();
                        Long nodeId = (Long)entry.getKey();
                        if (this.writeInfo != null && (info = (WriteLockInfo)this.writeInfo.get(nodeId)) != null) {
                            if (transferredWriteLockInfo == null) {
                                transferredWriteLockInfo = new ArrayList<WriteLockInfo>();
                            }
                            transferredWriteLockInfo.add(info);
                        }
                        this.transferHandleLockToHandleSet(nodeId, (Set)entry.getValue());
                    }
                }
                LogManager logManager = this.envImpl.getLogManager();
                int numReadLocks = this.clearReadLocks();
                int numWriteLocks = 0;
                if (this.writeInfo != null) {
                    numWriteLocks = this.writeInfo.size();
                    SingleItemEntry commitEntry = new SingleItemEntry(LogEntryType.LOG_TXN_COMMIT, new TxnCommit(this.id, this.lastLoggedLsn));
                    commitLsn = flushSyncBehavior == 2 ? logManager.logForceFlush(commitEntry, true) : (flushSyncBehavior == 1 ? logManager.logForceFlush(commitEntry, false) : logManager.log(commitEntry));
                    this.setDeletedDatabaseState(true);
                    HashSet alreadyCountedLsnSet = new HashSet();
                    Iterator iter = this.writeInfo.values().iterator();
                    while (iter.hasNext()) {
                        WriteLockInfo info = (WriteLockInfo)iter.next();
                        this.lockManager.release(info.lock, (Locker)this);
                        this.countWriteAbortLSN(info, alreadyCountedLsnSet);
                    }
                    this.writeInfo = null;
                    if (transferredWriteLockInfo != null) {
                        for (int i = 0; i < transferredWriteLockInfo.size(); ++i) {
                            WriteLockInfo info = (WriteLockInfo)transferredWriteLockInfo.get(i);
                            this.countWriteAbortLSN(info, alreadyCountedLsnSet);
                        }
                    }
                    if (this.deleteInfo != null && this.deleteInfo.size() > 0) {
                        this.envImpl.addToCompressorQueue(this.deleteInfo.values(), false);
                        this.deleteInfo.clear();
                    }
                }
                this.traceCommit(numWriteLocks, numReadLocks);
            }
            this.cleanupDatabaseImpls(true);
            this.close(true);
            return commitLsn;
        }
        catch (RunRecoveryException e) {
            throw e;
        }
        catch (Throwable t) {
            try {
                this.abortInternal(flushSyncBehavior == 2, !(t instanceof DatabaseException));
                Tracer.trace(this.envImpl, "Txn", "commit", "Commit of transaction " + this.id + " failed", t);
            }
            catch (Throwable abortT2) {
                throw new DatabaseException("Failed while attempting to commit transaction " + this.id + ". The attempt to abort and clean up also failed. " + "The original exception seen from commit = " + t.getMessage() + " The exception from the cleanup = " + abortT2.getMessage(), t);
            }
            throw new DatabaseException("Failed while attempting to commit transaction " + this.id + ", aborted instead. Original exception = " + t.getMessage(), t);
        }
    }

    private void countWriteAbortLSN(WriteLockInfo info, Set alreadyCountedLsnSet) throws DatabaseException {
        Long longLsn;
        if (info.abortLsn != -1L && !info.abortKnownDeleted && !alreadyCountedLsnSet.contains(longLsn = new Long(info.abortLsn))) {
            this.envImpl.getLogManager().countObsoleteNode(info.abortLsn, null, info.abortLogSize);
            alreadyCountedLsnSet.add(longLsn);
        }
    }

    public long abort(boolean forceFlush) throws DatabaseException {
        return this.abortInternal(forceFlush, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long abortInternal(boolean forceFlush, boolean writeAbortRecord) throws DatabaseException {
        try {
            int numWriteLocks;
            int numReadLocks;
            long abortLsn;
            Txn txn = this;
            synchronized (txn) {
                this.checkState(true);
                SingleItemEntry abortEntry = new SingleItemEntry(LogEntryType.LOG_TXN_ABORT, new TxnAbort(this.id, this.lastLoggedLsn));
                abortLsn = -1L;
                if (this.writeInfo != null && writeAbortRecord) {
                    abortLsn = forceFlush ? this.envImpl.getLogManager().logForceFlush(abortEntry, true) : this.envImpl.getLogManager().log(abortEntry);
                }
                this.undo();
                numReadLocks = this.readLocks == null ? 0 : this.clearReadLocks();
                this.setDeletedDatabaseState(false);
                numWriteLocks = this.writeInfo == null ? 0 : this.clearWriteLocks();
                this.deleteInfo = null;
            }
            this.cleanupDatabaseImpls(false);
            txn = this;
            synchronized (txn) {
                boolean openCursors = this.checkCursorsForClose();
                Tracer.trace(Level.FINE, this.envImpl, "Abort:id = " + this.id + " numWriteLocks= " + numWriteLocks + " numReadLocks= " + numReadLocks + " openCursors= " + openCursors);
                if (openCursors) {
                    throw new DatabaseException("Transaction " + this.id + " detected open cursors while aborting");
                }
                if (this.handleToHandleLockMap != null) {
                    Iterator handleIter = this.handleToHandleLockMap.keySet().iterator();
                    while (handleIter.hasNext()) {
                        Database handle = (Database)handleIter.next();
                        DbInternal.dbInvalidate(handle);
                    }
                }
                long l = abortLsn;
                return l;
            }
        }
        finally {
            this.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undo() throws DatabaseException {
        Long nodeId = null;
        long undoLsn = this.lastLoggedLsn;
        LogManager logManager = this.envImpl.getLogManager();
        try {
            HashSet<Long> alreadyUndone = new HashSet<Long>();
            TreeLocation location = new TreeLocation();
            while (undoLsn != -1L) {
                LNLogEntry undoEntry = (LNLogEntry)logManager.getLogEntry(undoLsn);
                LN undoLN = undoEntry.getLN();
                nodeId = new Long(undoLN.getNodeId());
                if (!alreadyUndone.contains(nodeId)) {
                    alreadyUndone.add(nodeId);
                    DatabaseId dbId = undoEntry.getDbId();
                    DatabaseImpl db = (DatabaseImpl)this.undoDatabases.get(dbId);
                    undoLN.postFetchInit(db, undoLsn);
                    long abortLsn = undoEntry.getAbortLsn();
                    boolean abortKnownDeleted = undoEntry.getAbortKnownDeleted();
                    try {
                        RecoveryManager.undo(Level.FINER, db, location, undoLN, undoEntry.getKey(), undoEntry.getDupKey(), undoLsn, abortLsn, abortKnownDeleted, null, false);
                    }
                    finally {
                        if (location.bin != null) {
                            location.bin.releaseLatchIfOwner();
                        }
                    }
                    if (!undoLN.isDeleted()) {
                        logManager.countObsoleteNode(undoLsn, null, undoLN.getLastLoggedSize());
                    }
                }
                undoLsn = undoEntry.getUserTxn().getLastLsn();
            }
        }
        catch (RuntimeException e) {
            throw new DatabaseException("Txn undo for node=" + nodeId + " LSN=" + DbLsn.getNoFormatString(undoLsn), e);
        }
        catch (DatabaseException e) {
            Tracer.trace(this.envImpl, "Txn", "undo", "for node=" + nodeId + " LSN=" + DbLsn.getNoFormatString(undoLsn), e);
            throw e;
        }
    }

    private int clearWriteLocks() throws DatabaseException {
        int numWriteLocks = this.writeInfo.size();
        Iterator iter = this.writeInfo.values().iterator();
        while (iter.hasNext()) {
            WriteLockInfo info = (WriteLockInfo)iter.next();
            this.lockManager.release(info.lock, (Locker)this);
        }
        this.writeInfo = null;
        return numWriteLocks;
    }

    private int clearReadLocks() throws DatabaseException {
        int numReadLocks = 0;
        if (this.readLocks != null) {
            numReadLocks = this.readLocks.size();
            Iterator iter = this.readLocks.iterator();
            while (iter.hasNext()) {
                Lock rLock = (Lock)iter.next();
                this.lockManager.release(rLock, (Locker)this);
            }
            this.readLocks = null;
        }
        return numReadLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogInfo(long lastLsn) throws DatabaseException {
        this.lastLoggedLsn = lastLsn;
        Txn txn = this;
        synchronized (txn) {
            if (this.firstLoggedLsn == -1L) {
                this.firstLoggedLsn = lastLsn;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getFirstActiveLsn() throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            return this.firstLoggedLsn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDeleteAtTxnEnd(DatabaseImpl dbImpl, boolean deleteAtCommit) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            int delta = 0;
            if (this.deletedDatabases == null) {
                this.deletedDatabases = new HashSet();
                delta += MemoryBudget.HASHSET_OVERHEAD;
            }
            this.deletedDatabases.add(new DatabaseCleanupInfo(dbImpl, deleteAtCommit));
            this.updateMemoryUsage(delta += MemoryBudget.HASHSET_ENTRY_OVERHEAD + MemoryBudget.OBJECT_OVERHEAD);
        }
    }

    private void setDeletedDatabaseState(boolean isCommit) throws DatabaseException {
        if (this.deletedDatabases != null) {
            Iterator iter = this.deletedDatabases.iterator();
            while (iter.hasNext()) {
                DatabaseCleanupInfo info = (DatabaseCleanupInfo)iter.next();
                if (info.deleteAtCommit != isCommit) continue;
                info.dbImpl.startDeleteProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDatabaseImpls(boolean isCommit) throws DatabaseException {
        if (this.deletedDatabases != null) {
            DatabaseCleanupInfo[] infoArray;
            Txn txn = this;
            synchronized (txn) {
                infoArray = new DatabaseCleanupInfo[this.deletedDatabases.size()];
                this.deletedDatabases.toArray(infoArray);
            }
            for (int i = 0; i < infoArray.length; ++i) {
                DatabaseCleanupInfo info = infoArray[i];
                if (info.deleteAtCommit != isCommit) continue;
                info.dbImpl.releaseDeletedINs();
            }
            this.deletedDatabases = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLock(Long nodeId, Lock lock, LockType type, LockGrantType grantStatus) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            int delta = 0;
            if (type.isWriteLock()) {
                if (this.writeInfo == null) {
                    this.writeInfo = new HashMap();
                    this.undoDatabases = new HashMap();
                    delta += MemoryBudget.TWOHASHMAPS_OVERHEAD;
                }
                this.writeInfo.put(nodeId, new WriteLockInfo(lock));
                delta += this.WRITE_LOCK_OVERHEAD;
                if (grantStatus == LockGrantType.PROMOTION || grantStatus == LockGrantType.WAIT_PROMOTION) {
                    this.readLocks.remove(lock);
                    delta -= this.READ_LOCK_OVERHEAD;
                }
                this.updateMemoryUsage(delta);
            } else {
                this.addReadLock(lock);
            }
        }
    }

    private void addReadLock(Lock lock) {
        int delta = 0;
        if (this.readLocks == null) {
            this.readLocks = new HashSet();
            delta = MemoryBudget.HASHSET_OVERHEAD;
        }
        this.readLocks.add(lock);
        this.updateMemoryUsage(delta += this.READ_LOCK_OVERHEAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLock(long nodeId, Lock lock) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            if (this.readLocks != null && this.readLocks.remove(lock)) {
                this.updateMemoryUsage(0 - this.READ_LOCK_OVERHEAD);
            } else if (this.writeInfo != null && this.writeInfo.remove(new Long(nodeId)) != null) {
                this.updateMemoryUsage(0 - this.WRITE_LOCK_OVERHEAD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveWriteToReadLock(long nodeId, Lock lock) {
        boolean found = false;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null && this.writeInfo.remove(new Long(nodeId)) != null) {
                found = true;
                this.updateMemoryUsage(0 - this.WRITE_LOCK_OVERHEAD);
            }
            if (!$assertionsDisabled && !found) {
                throw new AssertionError((Object)("Couldn't find lock for Node " + nodeId + " in writeInfo Map."));
            }
            this.addReadLock(lock);
        }
    }

    private void updateMemoryUsage(int delta) {
        this.inMemorySize += delta;
        this.accumulatedDelta += delta;
        if (this.accumulatedDelta > ACCUMULATED_LIMIT || this.accumulatedDelta < -ACCUMULATED_LIMIT) {
            this.envImpl.getMemoryBudget().updateMiscMemoryUsage(this.accumulatedDelta);
            this.accumulatedDelta = 0;
        }
    }

    int getAccumulatedDelta() {
        return this.accumulatedDelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createdNode(long nodeId) throws DatabaseException {
        boolean created = false;
        Txn txn = this;
        synchronized (txn) {
            WriteLockInfo info;
            if (this.writeInfo != null && (info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId))) != null) {
                created = info.createdThisTxn;
            }
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAbortLsn(long nodeId) throws DatabaseException {
        WriteLockInfo info = null;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null) {
                info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
            }
        }
        if (info == null) {
            return -1L;
        }
        return info.abortLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteLockInfo getWriteLockInfo(long nodeId) throws DatabaseException {
        WriteLockInfo info = WriteLockInfo.basicWriteLockInfo;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null) {
                info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
            }
        }
        return info;
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean isSerializableIsolation() {
        return this.serializableIsolation;
    }

    public boolean isReadCommittedIsolation() {
        return this.readCommittedIsolation;
    }

    public Txn getTxnLocker() {
        return this;
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        return this;
    }

    public void releaseNonTxnLocks() throws DatabaseException {
    }

    public void operationEnd() throws DatabaseException {
    }

    public void operationEnd(boolean operationOK) throws DatabaseException {
    }

    public void setHandleLockOwner(boolean ignore, Database dbHandle, boolean dbIsClosing) throws DatabaseException {
        if (dbIsClosing) {
            Long handleLockId = (Long)this.handleToHandleLockMap.get(dbHandle);
            if (handleLockId != null) {
                Set dbHandleSet = (Set)this.handleLockToHandleMap.get(handleLockId);
                boolean removed = dbHandleSet.remove(dbHandle);
                if (!$assertionsDisabled && !removed) {
                    throw new AssertionError((Object)("Can't find " + dbHandle + " from dbHandleSet"));
                }
                if (dbHandleSet.size() == 0) {
                    Object foo = this.handleLockToHandleMap.remove(handleLockId);
                    if (!$assertionsDisabled && foo == null) {
                        throw new AssertionError((Object)("Can't find " + handleLockId + " from handleLockIdtoHandleMap."));
                    }
                }
            }
            this.unregisterHandle(dbHandle);
        } else if (dbHandle != null) {
            DbInternal.dbSetHandleLocker(dbHandle, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCursor(CursorImpl cursor) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            cursor.setLockerNext(this.cursorSet);
            if (this.cursorSet != null) {
                this.cursorSet.setLockerPrev(cursor);
            }
            this.cursorSet = cursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterCursor(CursorImpl cursor) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            CursorImpl prev = cursor.getLockerPrev();
            CursorImpl next = cursor.getLockerNext();
            if (prev == null) {
                this.cursorSet = next;
            } else {
                prev.setLockerNext(next);
            }
            if (next != null) {
                next.setLockerPrev(prev);
            }
            cursor.setLockerPrev(null);
            cursor.setLockerNext(null);
        }
    }

    public boolean isHandleLockTransferrable() {
        return false;
    }

    private boolean checkCursorsForClose() throws DatabaseException {
        for (CursorImpl c = this.cursorSet; c != null; c = c.getLockerNext()) {
            if (c.isClosed()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockStats collectStats(LockStats stats) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            int nReadLocks = this.readLocks == null ? 0 : this.readLocks.size();
            stats.setNReadLocks(stats.getNReadLocks() + nReadLocks);
            int nWriteLocks = this.writeInfo == null ? 0 : this.writeInfo.size();
            stats.setNWriteLocks(stats.getNWriteLocks() + nWriteLocks);
        }
        return stats;
    }

    public void setOnlyAbortable() {
        this.txnState = (byte)(this.txnState & 0xFFFFFFFC);
        this.txnState = (byte)(this.txnState | 2);
    }

    public boolean getOnlyAbortable() {
        return (this.txnState & 2) != 0;
    }

    protected void checkState(boolean calledByAbort) throws DatabaseException {
        boolean ok = false;
        boolean onlyAbortable = false;
        byte state = (byte)(this.txnState & 3);
        ok = state == 0;
        boolean bl = onlyAbortable = state == 2;
        if (!calledByAbort && onlyAbortable) {
            throw new DatabaseException("Transaction " + this.id + " must be aborted.");
        }
        if (ok || calledByAbort && onlyAbortable) {
            return;
        }
        throw new DatabaseException("Transaction " + this.id + " has been closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean isCommit) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            this.txnState = (byte)(this.txnState & 0xFFFFFFFC);
            this.txnState = (byte)(this.txnState | 1);
        }
        this.envImpl.getTxnManager().unRegisterTxn(this, isCommit);
    }

    public int getLogSize() {
        return 16;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.id);
        LogUtils.writeLong(logBuffer, this.lastLoggedLsn);
    }

    public void readFromLog(ByteBuffer logBuffer, byte entryTypeVersion) {
        this.id = LogUtils.readLong(logBuffer);
        this.lastLoggedLsn = LogUtils.readLong(logBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<txn id=\"");
        sb.append(super.toString());
        sb.append("\">");
        sb.append(DbLsn.toString(this.lastLoggedLsn));
        sb.append("</txn>");
    }

    public long getTransactionId() {
        return this.getId();
    }

    private void transferHandleLockToHandleSet(Long handleLockId, Set dbHandleSet) throws DatabaseException {
        int numHandles = dbHandleSet.size();
        Database[] dbHandles = new Database[numHandles];
        dbHandles = dbHandleSet.toArray(dbHandles);
        Locker[] destTxns = new Locker[numHandles];
        for (int i = 0; i < numHandles; ++i) {
            destTxns[i] = new BasicLocker(this.envImpl);
        }
        long nodeId = handleLockId;
        this.lockManager.transferMultiple(nodeId, this, destTxns);
        for (int i = 0; i < numHandles; ++i) {
            destTxns[i].addToHandleMaps(handleLockId, dbHandles[i]);
            DbInternal.dbSetHandleLocker(dbHandles[i], destTxns[i]);
        }
    }

    private void traceCommit(int numWriteLocks, int numReadLocks) {
        Logger logger = this.envImpl.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            sb.append(" Commit:id = ").append(this.id);
            sb.append(" numWriteLocks=").append(numWriteLocks);
            sb.append(" numReadLocks = ").append(numReadLocks);
            Tracer.trace(Level.FINE, this.envImpl, sb.toString());
        }
    }

    int getInMemorySize() {
        return this.inMemorySize;
    }

    static {
        $assertionsDisabled = !Txn.class.desiredAssertionStatus();
        DEBUG_NAME = Txn.class.getName();
        ACCUMULATED_LIMIT = 10000;
    }

    private static class DatabaseCleanupInfo {
        DatabaseImpl dbImpl;
        boolean deleteAtCommit;

        DatabaseCleanupInfo(DatabaseImpl dbImpl, boolean deleteAtCommit) {
            this.dbImpl = dbImpl;
            this.deleteAtCommit = deleteAtCommit;
        }
    }
}

