/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.CheckpointFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.INFileReader;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.LevelRecorder;
import com.sleepycat.je.recovery.NoRootException;
import com.sleepycat.je.recovery.RecoveryException;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecoveryManager {
    private static final String TRACE_DUP_ROOT_REPLACE = "DupRootRecover:";
    private static final String TRACE_LN_REDO = "LNRedo:";
    private static final String TRACE_LN_UNDO = "LNUndo";
    private static final String TRACE_IN_REPLACE = "INRecover:";
    private static final String TRACE_ROOT_REPLACE = "RootRecover:";
    private static final String TRACE_IN_DEL_REPLAY = "INDelReplay:";
    private static final String TRACE_IN_DUPDEL_REPLAY = "INDupDelReplay:";
    private static final String TRACE_ROOT_DELETE = "RootDelete:";
    private static final int CLEAR_INCREMENT = 50;
    private EnvironmentImpl env;
    private int readBufferSize;
    private RecoveryInfo info;
    private Set committedTxnIds;
    private Set abortedTxnIds;
    private Map preparedTxns;
    private Set inListRebuildDbIds;
    private Level detailedTraceLevel;
    private Map fileSummaryLsns;
    private int inListClearCounter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RecoveryManager(EnvironmentImpl env) throws DatabaseException {
        this.env = env;
        DbConfigManager cm = env.getConfigManager();
        this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.committedTxnIds = new HashSet();
        this.abortedTxnIds = new HashSet();
        this.preparedTxns = new HashMap();
        this.inListRebuildDbIds = new HashSet();
        this.fileSummaryLsns = new HashMap();
        this.detailedTraceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_RECOVERY);
    }

    public RecoveryInfo recover(boolean readOnly) throws DatabaseException {
        this.info = new RecoveryInfo();
        try {
            FileManager fileManager = this.env.getFileManager();
            DbConfigManager configManager = this.env.getConfigManager();
            boolean forceCheckpoint = configManager.getBoolean(EnvironmentParams.ENV_RECOVERY_FORCE_CHECKPOINT);
            if (fileManager.filesExist()) {
                this.findEndOfLog(readOnly);
                Tracer.trace(Level.CONFIG, this.env, "Recovery underway, found end of log");
                this.findLastCheckpoint();
                this.env.getLogManager().setLastLsnAtRecovery(fileManager.getLastUsedLsn());
                Tracer.trace(Level.CONFIG, this.env, "Recovery checkpoint search, " + this.info);
                this.env.readMapTreeFromLog(this.info.useRootLsn);
                this.buildTree();
            } else {
                this.env.enableDebugLoggingToDbLog();
                Tracer.trace(Level.CONFIG, this.env, "Recovery w/no files.");
                this.env.logMapTreeRoot();
                forceCheckpoint = true;
            }
            if (this.preparedTxns.size() > 0) {
                Tracer.trace(Level.INFO, this.env, "There are " + this.preparedTxns.size() + " prepared but unfinished txns.");
                this.preparedTxns = null;
            }
            if (DbInternal.getCreateUP(this.env.getConfigManager().getEnvironmentConfig())) {
                this.env.getUtilizationProfile().populateCache();
            }
            if (!readOnly && (this.env.getLogManager().getLastLsnAtRecovery() != this.info.checkpointEndLsn || forceCheckpoint)) {
                CheckpointConfig config = new CheckpointConfig();
                config.setForce(true);
                config.setMinimizeRecoveryTime(true);
                this.env.invokeCheckpoint(config, false, "recovery");
            } else {
                this.env.getCheckpointer().initIntervals(this.info.checkpointEndLsn, System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            Tracer.trace(this.env, "RecoveryManager", "recover", "Couldn't recover", e);
            throw new RecoveryException(this.env, "Couldn't recover: " + e.getMessage(), e);
        }
        finally {
            Tracer.trace(Level.CONFIG, this.env, "Recovery finished: " + this.info);
        }
        return this.info;
    }

    private void findEndOfLog(boolean readOnly) throws IOException, DatabaseException {
        LastFileReader reader = new LastFileReader(this.env, this.readBufferSize);
        while (reader.readNextEntry()) {
            LogEntryType type = reader.getEntryType();
            if (LogEntryType.LOG_CKPT_END.equals(type)) {
                this.info.checkpointEndLsn = reader.getLastLsn();
                this.info.partialCheckpointStartLsn = -1L;
                continue;
            }
            if (!LogEntryType.LOG_CKPT_START.equals(type) || this.info.partialCheckpointStartLsn != -1L) continue;
            this.info.partialCheckpointStartLsn = reader.getLastLsn();
        }
        if (!$assertionsDisabled && reader.getLastValidLsn() == reader.getEndOfLog()) {
            throw new AssertionError((Object)("lastUsed=" + DbLsn.getNoFormatString(reader.getLastValidLsn()) + " end=" + DbLsn.getNoFormatString(reader.getEndOfLog())));
        }
        if (!readOnly) {
            reader.setEndOfFile();
        }
        this.info.lastUsedLsn = reader.getLastValidLsn();
        this.info.nextAvailableLsn = reader.getEndOfLog();
        this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        this.env.getFileManager().setLastPosition(this.info.nextAvailableLsn, this.info.lastUsedLsn, reader.getPrevOffset());
        this.env.enableDebugLoggingToDbLog();
    }

    private void findLastCheckpoint() throws IOException, DatabaseException {
        if (this.info.checkpointEndLsn == -1L) {
            CheckpointFileReader searcher = new CheckpointFileReader(this.env, this.readBufferSize, false, this.info.lastUsedLsn, -1L, this.info.nextAvailableLsn);
            while (searcher.readNextEntry()) {
                if (searcher.isCheckpointEnd()) {
                    this.info.checkpointEndLsn = searcher.getLastLsn();
                    break;
                }
                if (searcher.isCheckpointStart()) {
                    this.info.partialCheckpointStartLsn = searcher.getLastLsn();
                    continue;
                }
                if (!searcher.isRoot() || this.info.useRootLsn != -1L) continue;
                this.info.useRootLsn = searcher.getLastLsn();
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + searcher.getNRepeatIteratorReads());
        }
        if (this.info.checkpointEndLsn == -1L) {
            this.info.checkpointStartLsn = -1L;
            this.info.firstActiveLsn = -1L;
        } else {
            CheckpointEnd checkpointEnd;
            this.info.checkpointEnd = checkpointEnd = (CheckpointEnd)this.env.getLogManager().get(this.info.checkpointEndLsn);
            this.info.checkpointStartLsn = checkpointEnd.getCheckpointStartLsn();
            this.info.firstActiveLsn = checkpointEnd.getFirstActiveLsn();
            if (checkpointEnd.getRootLsn() != -1L) {
                this.info.useRootLsn = checkpointEnd.getRootLsn();
            }
            this.env.getCheckpointer().setCheckpointId(checkpointEnd.getId());
            this.env.getCheckpointer().setFirstActiveLsn(checkpointEnd.getFirstActiveLsn());
        }
        if (this.info.useRootLsn == -1L) {
            throw new NoRootException(this.env, "This environment's log file has no root. Since the root is the first entry written into a log at environment creation, this should only happen if the initial creation of the environment was never checkpointed or synced. Please move aside the existing log files to allow the creation of a new environment");
        }
    }

    private void buildTree() throws IOException, DatabaseException {
        this.inListClearCounter = 0;
        int passNum = this.buildINs(1, true, false);
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + "undo map LNs");
        long start = System.currentTimeMillis();
        HashSet<LogEntryType> mapLNSet = new HashSet<LogEntryType>();
        mapLNSet.add(LogEntryType.LOG_MAPLN_TRANSACTIONAL);
        mapLNSet.add(LogEntryType.LOG_TXN_COMMIT);
        mapLNSet.add(LogEntryType.LOG_TXN_ABORT);
        mapLNSet.add(LogEntryType.LOG_TXN_PREPARE);
        this.undoLNs(this.info, mapLNSet);
        long end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(++passNum) + "redo map LNs");
        start = System.currentTimeMillis();
        mapLNSet.add(LogEntryType.LOG_MAPLN);
        this.redoLNs(this.info, mapLNSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        ++passNum;
        passNum = this.buildINs(passNum, false, false);
        passNum = this.buildINs(passNum, false, true);
        this.rebuildINList();
        this.env.invokeEvictor();
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(9) + "undo LNs");
        start = System.currentTimeMillis();
        HashSet<LogEntryType> lnSet = new HashSet<LogEntryType>();
        lnSet.add(LogEntryType.LOG_LN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL);
        this.undoLNs(this.info, lnSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(9, start, end) + this.info.toString());
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(10) + "redo LNs");
        start = System.currentTimeMillis();
        lnSet.add(LogEntryType.LOG_LN);
        lnSet.add(LogEntryType.LOG_NAMELN);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN);
        lnSet.add(LogEntryType.LOG_FILESUMMARYLN);
        this.redoLNs(this.info, lnSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(10, start, end) + this.info.toString());
    }

    private int buildINs(int passNum, boolean mappingTree, boolean dupTree) throws IOException, DatabaseException {
        HashSet<LogEntryType> targetEntries = new HashSet<LogEntryType>();
        HashSet<LogEntryType> deltaType = new HashSet<LogEntryType>();
        String passADesc = null;
        String passBDesc = null;
        String passCDesc = null;
        if (mappingTree) {
            passADesc = "read mapping INs";
            passBDesc = "redo mapping INs";
            passCDesc = "read mapping BINDeltas";
        } else if (dupTree) {
            passADesc = "read dup INs";
            passBDesc = "redo dup INs";
            passCDesc = "read dup BINDeltas";
        } else {
            passADesc = "read main INs";
            passBDesc = "redo main INs";
            passCDesc = "read main BINDeltas";
        }
        if (dupTree) {
            targetEntries.add(LogEntryType.LOG_DIN);
            targetEntries.add(LogEntryType.LOG_DBIN);
            targetEntries.add(LogEntryType.LOG_IN_DUPDELETE_INFO);
            deltaType.add(LogEntryType.LOG_DUP_BIN_DELTA);
        } else {
            targetEntries.add(LogEntryType.LOG_IN);
            targetEntries.add(LogEntryType.LOG_BIN);
            targetEntries.add(LogEntryType.LOG_IN_DELETE_INFO);
            deltaType.add(LogEntryType.LOG_BIN_DELTA);
        }
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + passADesc);
        LevelRecorder recorder = new LevelRecorder();
        long start = System.currentTimeMillis();
        if (mappingTree) {
            this.readINsAndTrackIds(this.info.checkpointStartLsn, recorder);
        } else {
            int numINsSeen = this.readINs(this.info.checkpointStartLsn, false, targetEntries, dupTree, recorder);
            if (dupTree) {
                this.info.numDuplicateINs += numINsSeen;
            } else {
                this.info.numOtherINs += numINsSeen;
            }
        }
        long end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        ++passNum;
        Set redoSet = recorder.getDbsWithDifferentLevels();
        if (redoSet.size() > 0) {
            Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + passBDesc);
            start = System.currentTimeMillis();
            this.repeatReadINs(this.info.checkpointStartLsn, targetEntries, redoSet);
            end = System.currentTimeMillis();
            Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
            ++passNum;
        }
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + passCDesc);
        start = System.currentTimeMillis();
        this.info.numBinDeltas += this.readINs(this.info.checkpointStartLsn, mappingTree, deltaType, true, null);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        return ++passNum;
    }

    private void readINsAndTrackIds(long rollForwardLsn, LevelRecorder recorder) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, true, false, this.info.partialCheckpointStartLsn, this.fileSummaryLsns);
        reader.addTargetType(LogEntryType.LOG_IN);
        reader.addTargetType(LogEntryType.LOG_BIN);
        reader.addTargetType(LogEntryType.LOG_IN_DELETE_INFO);
        reader.setAlwaysValidateChecksum(true);
        try {
            this.info.numMapINs = 0;
            DbTree dbMapTree = this.env.getDbMapTree();
            while (reader.readNextEntry()) {
                DatabaseId dbId = reader.getDatabaseId();
                if (!dbId.equals(DbTree.ID_DB_ID)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                this.replayOneIN(reader, db, false, recorder);
                ++this.info.numMapINs;
            }
            this.info.useMaxNodeId = reader.getMaxNodeId();
            this.info.useMaxDbId = reader.getMaxDbId();
            this.info.useMaxTxnId = reader.getMaxTxnId();
            if (this.info.checkpointEnd != null) {
                if (this.info.useMaxNodeId < this.info.checkpointEnd.getLastNodeId()) {
                    this.info.useMaxNodeId = this.info.checkpointEnd.getLastNodeId();
                }
                if (this.info.useMaxDbId < this.info.checkpointEnd.getLastDbId()) {
                    this.info.useMaxDbId = this.info.checkpointEnd.getLastDbId();
                }
                if (this.info.useMaxTxnId < this.info.checkpointEnd.getLastTxnId()) {
                    this.info.useMaxTxnId = this.info.checkpointEnd.getLastTxnId();
                }
            }
            Node.setLastNodeId(this.info.useMaxNodeId);
            this.env.getDbMapTree().setLastDbId(this.info.useMaxDbId);
            this.env.getTxnManager().setLastTxnId(this.info.useMaxTxnId);
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readMapIns", e);
        }
    }

    private int readINs(long rollForwardLsn, boolean mapDbOnly, Set targetLogEntryTypes, boolean requireExactMatch, LevelRecorder recorder) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, false, mapDbOnly, this.info.partialCheckpointStartLsn, this.fileSummaryLsns);
        Iterator iter = targetLogEntryTypes.iterator();
        while (iter.hasNext()) {
            reader.addTargetType((LogEntryType)iter.next());
        }
        int numINsSeen = 0;
        try {
            DbTree dbMapTree = this.env.getDbMapTree();
            while (reader.readNextEntry()) {
                DatabaseImpl db;
                DatabaseId dbId = reader.getDatabaseId();
                boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
                boolean isTarget = false;
                if (mapDbOnly && isMapDb) {
                    isTarget = true;
                } else if (!mapDbOnly && !isMapDb) {
                    isTarget = true;
                }
                if (!isTarget || (db = dbMapTree.getDb(dbId)) == null) continue;
                this.replayOneIN(reader, db, requireExactMatch, recorder);
                ++numINsSeen;
                this.inListRebuildDbIds.add(dbId);
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
            return numINsSeen;
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
            return 0;
        }
    }

    private void repeatReadINs(long rollForwardLsn, Set targetLogEntryTypes, Set targetDbs) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, false, false, this.info.partialCheckpointStartLsn, this.fileSummaryLsns);
        Iterator iter = targetLogEntryTypes.iterator();
        while (iter.hasNext()) {
            reader.addTargetType((LogEntryType)iter.next());
        }
        try {
            DbTree dbMapTree = this.env.getDbMapTree();
            while (reader.readNextEntry()) {
                DatabaseImpl db;
                DatabaseId dbId = reader.getDatabaseId();
                if (!targetDbs.contains(dbId) || (db = dbMapTree.getDb(dbId)) == null) continue;
                this.replayOneIN(reader, db, true, null);
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
        }
    }

    private void replayOneIN(INFileReader reader, DatabaseImpl db, boolean requireExactMatch, LevelRecorder recorder) throws DatabaseException {
        if (reader.isDeleteInfo()) {
            this.replayINDelete(db, reader.getDeletedNodeId(), false, reader.getDeletedIdKey(), null, reader.getLastLsn());
        } else if (reader.isDupDeleteInfo()) {
            this.replayINDelete(db, reader.getDupDeletedNodeId(), true, reader.getDupDeletedMainKey(), reader.getDupDeletedDupKey(), reader.getLastLsn());
        } else {
            IN in = reader.getIN();
            long inLsn = reader.getLsnOfIN();
            in.postRecoveryInit(db, inLsn);
            in.latch();
            if (recorder != null) {
                recorder.record(db.getId(), in.getLevel());
            }
            this.replaceOrInsert(db, in, reader.getLastLsn(), inLsn, requireExactMatch);
        }
        if (++this.inListClearCounter % 50 == 0) {
            this.env.getInMemoryINs().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoLNs(RecoveryInfo info, Set lnTypes) throws IOException, DatabaseException {
        long firstActiveLsn = info.firstActiveLsn;
        long lastUsedLsn = info.lastUsedLsn;
        long endOfFileLsn = info.nextAvailableLsn;
        LNFileReader reader = new LNFileReader(this.env, this.readBufferSize, lastUsedLsn, false, endOfFileLsn, firstActiveLsn, null);
        Iterator iter = lnTypes.iterator();
        while (iter.hasNext()) {
            LogEntryType lnType = (LogEntryType)iter.next();
            reader.addTargetType(lnType);
        }
        HashMap countedFileSummaries = new HashMap();
        HashSet countedAbortLsnNodes = new HashSet();
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        try {
            while (reader.readNextEntry()) {
                if (reader.isLN()) {
                    Long txnId = reader.getTxnId();
                    if (txnId == null || this.committedTxnIds.contains(txnId)) continue;
                    this.env.invokeEvictor();
                    LN ln = reader.getLN();
                    long logLsn = reader.getLastLsn();
                    long abortLsn = reader.getAbortLsn();
                    boolean abortKnownDeleted = reader.getAbortKnownDeleted();
                    DatabaseId dbId = reader.getDatabaseId();
                    DatabaseImpl db = dbMapTree.getDb(dbId);
                    if (db == null) continue;
                    ln.postFetchInit(db, logLsn);
                    try {
                        RecoveryManager.undo(this.detailedTraceLevel, db, location, ln, reader.getKey(), reader.getDupTreeKey(), logLsn, abortLsn, abortKnownDeleted, info, true);
                    }
                    finally {
                        if (location.bin != null) {
                            location.bin.releaseLatchIfOwner();
                        }
                    }
                    TxnNodeId txnNodeId = new TxnNodeId(reader.getNodeId(), txnId);
                    this.undoUtilizationInfo(ln, logLsn, abortLsn, abortKnownDeleted, reader.getLastEntrySize(), txnNodeId, countedFileSummaries, countedAbortLsnNodes);
                    this.inListRebuildDbIds.add(dbId);
                    continue;
                }
                if (reader.isPrepare()) {
                    long prepareId = reader.getTxnPrepareId();
                    Long prepareIdL = new Long(prepareId);
                    if (this.committedTxnIds.contains(prepareIdL) || this.abortedTxnIds.contains(prepareIdL)) continue;
                    TransactionConfig txnConf = new TransactionConfig();
                    Txn preparedTxn = new Txn(this.env, txnConf, prepareId);
                    preparedTxn.setLockTimeout(0L);
                    this.preparedTxns.put(prepareIdL, preparedTxn);
                    this.env.getTxnManager().registerXATxn(reader.getTxnPrepareXid(), preparedTxn, true);
                    Tracer.trace(Level.INFO, this.env, "Found unfinished prepare record: id: " + reader.getTxnPrepareId() + " Xid: " + reader.getTxnPrepareXid());
                    continue;
                }
                if (reader.isAbort()) {
                    this.abortedTxnIds.add(new Long(reader.getTxnAbortId()));
                    continue;
                }
                this.committedTxnIds.add(new Long(reader.getTxnCommitId()));
            }
            info.nRepeatIteratorReads = (int)((long)info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        }
        catch (RuntimeException e) {
            this.traceAndThrowException(reader.getLastLsn(), "undoLNs", e);
        }
    }

    private void redoLNs(RecoveryInfo info, Set lnTypes) throws IOException, DatabaseException {
        long endOfFileLsn = info.nextAvailableLsn;
        long rollForwardLsn = info.checkpointStartLsn;
        LNFileReader reader = new LNFileReader(this.env, this.readBufferSize, rollForwardLsn, true, -1L, endOfFileLsn, null);
        Iterator iter = lnTypes.iterator();
        while (iter.hasNext()) {
            LogEntryType lnType = (LogEntryType)iter.next();
            reader.addTargetType(lnType);
        }
        HashSet countedAbortLsnNodes = new HashSet();
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        try {
            while (reader.readNextEntry()) {
                if (!reader.isLN()) continue;
                Long txnId = reader.getTxnId();
                boolean processThisLN = false;
                boolean lnIsCommitted = false;
                boolean lnIsPrepared = false;
                Txn preparedTxn = null;
                if (txnId == null) {
                    processThisLN = true;
                } else {
                    lnIsCommitted = this.committedTxnIds.contains(txnId);
                    if (!lnIsCommitted) {
                        preparedTxn = (Txn)this.preparedTxns.get(txnId);
                        boolean bl = lnIsPrepared = preparedTxn != null;
                    }
                    if (lnIsCommitted || lnIsPrepared) {
                        processThisLN = true;
                    }
                }
                if (!processThisLN) continue;
                this.env.invokeEvictor();
                LN ln = reader.getLN();
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = dbMapTree.getDb(dbId);
                long logLsn = reader.getLastLsn();
                long treeLsn = -1L;
                if (db != null) {
                    ln.postFetchInit(db, logLsn);
                    if (preparedTxn != null) {
                        preparedTxn.addLogInfo(logLsn);
                        preparedTxn.lock(ln.getNodeId(), LockType.WRITE, false, db);
                        preparedTxn.setPrepared(true);
                    }
                    treeLsn = this.redo(db, location, ln, reader.getKey(), reader.getDupTreeKey(), logLsn, info);
                    this.inListRebuildDbIds.add(dbId);
                }
                TxnNodeId txnNodeId = null;
                if (txnId != null) {
                    txnNodeId = new TxnNodeId(reader.getNodeId(), txnId);
                }
                this.redoUtilizationInfo(logLsn, treeLsn, reader.getAbortLsn(), reader.getAbortKnownDeleted(), reader.getLastEntrySize(), reader.getKey(), ln, txnNodeId, countedAbortLsnNodes);
            }
            info.nRepeatIteratorReads = (int)((long)info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "redoLns", e);
        }
    }

    private void rebuildINList() throws DatabaseException {
        this.env.getInMemoryINs().clear();
        this.env.getDbMapTree().rebuildINListMapDb();
        Iterator iter = this.inListRebuildDbIds.iterator();
        while (iter.hasNext()) {
            DatabaseImpl db;
            DatabaseId dbId = (DatabaseId)iter.next();
            if (dbId.equals(DbTree.ID_DB_ID) || (db = this.env.getDbMapTree().getDb(dbId)) == null) continue;
            db.getTree().rebuildINList();
        }
    }

    private void replaceOrInsert(DatabaseImpl db, IN inFromLog, long logLsn, long inLsn, boolean requireExactMatch) throws DatabaseException {
        ArrayList trackingList = null;
        boolean inFromLogLatchReleased = false;
        try {
            if (inFromLog.isRoot()) {
                if (inFromLog.containsDuplicates()) {
                    this.replaceOrInsertDuplicateRoot(db, (DIN)inFromLog, logLsn);
                } else {
                    this.replaceOrInsertRoot(db, inFromLog, logLsn);
                    inFromLogLatchReleased = true;
                }
            } else {
                trackingList = new ArrayList();
                this.replaceOrInsertChild(db, inFromLog, logLsn, inLsn, trackingList, requireExactMatch);
                inFromLogLatchReleased = true;
            }
        }
        catch (Exception e) {
            String trace = this.printTrackList(trackingList);
            Tracer.trace(db.getDbEnvironment(), "RecoveryManager", "replaceOrInsert", " lsnFromLog:" + DbLsn.getNoFormatString(logLsn) + " " + trace, e);
            throw new DatabaseException("lsnFromLog=" + DbLsn.getNoFormatString(logLsn), e);
        }
        finally {
            if (!inFromLogLatchReleased) {
                inFromLog.releaseLatchIfOwner();
            }
            if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                throw new AssertionError((Object)(LatchSupport.latchesHeldToString() + "LSN = " + DbLsn.toString(logLsn) + " inFromLog = " + inFromLog.getNodeId()));
            }
        }
    }

    private String printTrackList(List trackingList) {
        if (trackingList != null) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = trackingList.iterator();
            sb.append("Trace list:");
            sb.append('\n');
            while (iter.hasNext()) {
                sb.append((TrackingInfo)iter.next());
                sb.append('\n');
            }
            return sb.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayINDelete(DatabaseImpl db, long nodeId, boolean containsDuplicates, byte[] mainKey, byte[] dupKey, long logLsn) throws DatabaseException {
        boolean found = false;
        boolean deleted = false;
        Tree tree = db.getTree();
        SearchResult result = new SearchResult();
        try {
            result = db.getTree().getParentINForChildIN(nodeId, containsDuplicates, false, mainKey, dupKey, false, false, -1, null, true);
            if (result.parent == null) {
                tree.withRootLatchedExclusive(new RootDeleter(tree));
                DbTree dbTree = db.getDbEnvironment().getDbMapTree();
                dbTree.modifyDbRoot(db);
                RecoveryManager.traceRootDeletion(Level.FINE, db);
                deleted = true;
            } else if (result.exactParentFound) {
                found = true;
                deleted = result.parent.deleteEntry(result.index, false);
            }
        }
        finally {
            if (result.parent != null) {
                result.parent.releaseLatch();
            }
            this.traceINDeleteReplay(nodeId, logLsn, found, deleted, result.index, containsDuplicates);
        }
    }

    private void replaceOrInsertRoot(DatabaseImpl db, IN inFromLog, long lsn) throws DatabaseException {
        boolean success = true;
        Tree tree = db.getTree();
        RootUpdater rootUpdater = new RootUpdater(tree, inFromLog, lsn);
        try {
            tree.withRootLatchedExclusive(rootUpdater);
            if (rootUpdater.updateDone()) {
                EnvironmentImpl env = db.getDbEnvironment();
                env.getDbMapTree().modifyDbRoot(db);
            }
        }
        catch (Exception e) {
            success = false;
            throw new DatabaseException("lsnFromLog=" + DbLsn.getNoFormatString(lsn), e);
        }
        finally {
            RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_ROOT_REPLACE, success, inFromLog, lsn, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), -1L, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceOrInsertDuplicateRoot(DatabaseImpl db, DIN inFromLog, long lsn) throws DatabaseException {
        boolean found = true;
        boolean inserted = false;
        boolean replaced = false;
        long originalLsn = -1L;
        byte[] mainTreeKey = inFromLog.getMainTreeKey();
        IN parent = null;
        int index = -1;
        boolean success = false;
        try {
            parent = db.getTree().searchSplitsAllowed(mainTreeKey, -1L, true);
            if (!$assertionsDisabled && !(parent instanceof BIN)) {
                throw new AssertionError();
            }
            ChildReference newRef = new ChildReference(inFromLog, mainTreeKey, lsn);
            index = parent.insertEntry1(newRef);
            if (index >= 0 && (index & 0x10000) != 0) {
                if (parent.isEntryKnownDeleted(index &= 0xFFFEFFFF)) {
                    parent.setEntry(index, inFromLog, mainTreeKey, lsn, (byte)0);
                    replaced = true;
                } else {
                    originalLsn = parent.getLsn(index);
                    if (DbLsn.compareTo(originalLsn, lsn) < 0) {
                        parent.setEntry(index, inFromLog, mainTreeKey, lsn, parent.getState(index));
                        replaced = true;
                    }
                }
            } else {
                found = false;
            }
            success = true;
        }
        finally {
            if (parent != null) {
                parent.releaseLatch();
            }
            RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_DUP_ROOT_REPLACE, success, inFromLog, lsn, parent, found, replaced, inserted, originalLsn, -1L, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceOrInsertChild(DatabaseImpl db, IN inFromLog, long logLsn, long inLsn, List trackingList, boolean requireExactMatch) throws DatabaseException {
        boolean inserted = false;
        boolean replaced = false;
        long originalLsn = -1L;
        boolean success = false;
        SearchResult result = new SearchResult();
        try {
            result = db.getTree().getParentINForChildIN(inFromLog, requireExactMatch, false, -1, trackingList);
            if (result.parent == null) {
                return;
            }
            if (result.index >= 0 && result.parent.getLsn(result.index) != logLsn && result.exactParentFound && DbLsn.compareTo(originalLsn = result.parent.getLsn(result.index), logLsn) < 0) {
                result.parent.updateEntry(result.index, inFromLog, inLsn);
                replaced = true;
            }
            success = true;
        }
        finally {
            if (result.parent != null) {
                result.parent.releaseLatch();
            }
            RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, -1L, result.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long redo(DatabaseImpl db, TreeLocation location, LN lnFromLog, byte[] mainKey, byte[] dupKey, long logLsn, RecoveryInfo info) throws DatabaseException {
        boolean found = false;
        boolean replaced = false;
        boolean inserted = false;
        boolean success = false;
        try {
            location.reset();
            found = db.getTree().getParentBINForChildLN(location, mainKey, dupKey, lnFromLog, true, false, true, true);
            if (!found && location.bin == null) {
                success = true;
                long l = -1L;
                return l;
            }
            if (lnFromLog.containsDuplicates()) {
                if (found) {
                    DIN duplicateRoot = (DIN)location.bin.fetchTarget(location.index);
                    if (DbLsn.compareTo(logLsn, location.childLsn) >= 0) {
                        duplicateRoot.latch();
                        duplicateRoot.updateDupCountLNRefAndNullTarget(logLsn);
                        duplicateRoot.releaseLatch();
                    }
                }
            } else if (found) {
                ++info.lnFound;
                if (DbLsn.compareTo(logLsn, location.childLsn) > 0) {
                    ++info.lnReplaced;
                    replaced = true;
                    location.bin.updateEntry(location.index, null, logLsn);
                }
                if (DbLsn.compareTo(logLsn, location.childLsn) >= 0 && lnFromLog.isDeleted()) {
                    byte[] deletedKey;
                    location.bin.setKnownDeletedLeaveTarget(location.index);
                    byte[] byArray = deletedKey = location.bin.containsDuplicates() ? dupKey : mainKey;
                    if (deletedKey != null) {
                        db.getDbEnvironment().addToCompressorQueue(location.bin, new Key(deletedKey), false);
                    }
                }
            } else {
                ++info.lnNotFound;
                if (!lnFromLog.isDeleted()) {
                    ++info.lnInserted;
                    inserted = true;
                    boolean insertOk = RecoveryManager.insertRecovery(db, location, logLsn);
                    if (!$assertionsDisabled && !insertOk) {
                        throw new AssertionError();
                    }
                }
            }
            success = true;
            long l = found ? location.childLsn : -1L;
            return l;
        }
        finally {
            if (location.bin != null) {
                location.bin.releaseLatchIfOwner();
            }
            RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_LN_REDO, success, lnFromLog, logLsn, location.bin, found, replaced, inserted, location.childLsn, -1L, location.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void undo(Level traceLevel, DatabaseImpl db, TreeLocation location, LN lnFromLog, byte[] mainKey, byte[] dupKey, long logLsn, long abortLsn, boolean abortKnownDeleted, RecoveryInfo info, boolean splitsAllowed) throws DatabaseException {
        found = false;
        replaced = false;
        success = false;
        try {
            location.reset();
            found = db.getTree().getParentBINForChildLN(location, mainKey, dupKey, lnFromLog, splitsAllowed, true, false, true);
            if (lnFromLog.containsDuplicates()) {
                if (found) {
                    duplicateRoot = (DIN)location.bin.fetchTarget(location.index);
                    duplicateRoot.latch();
                    try {
                        if (DbLsn.compareTo(logLsn, location.childLsn) != 0) ** GOTO lbl42
                        duplicateRoot.updateDupCountLNRefAndNullTarget(abortLsn);
                        replaced = true;
                    }
                    finally {
                        duplicateRoot.releaseLatch();
                    }
                }
            } else if (found) {
                if (info != null) {
                    ++info.lnFound;
                }
                v0 = updateEntry = DbLsn.compareTo(logLsn, location.childLsn) == 0;
                if (updateEntry) {
                    if (abortLsn == -1L) {
                        location.bin.setKnownDeletedLeaveTarget(location.index);
                        deletedKey = location.bin.containsDuplicates() != false ? dupKey : mainKey;
                        db.getDbEnvironment().addToCompressorQueue(location.bin, new Key(deletedKey), false);
                    } else {
                        if (info != null) {
                            ++info.lnReplaced;
                        }
                        replaced = true;
                        location.bin.updateEntry(location.index, null, abortLsn);
                        if (abortKnownDeleted) {
                            location.bin.setKnownDeleted(location.index);
                        } else {
                            location.bin.clearKnownDeleted(location.index);
                        }
                    }
                    location.bin.clearPendingDeleted(location.index);
                }
            } else if (info != null) {
                ++info.lnNotFound;
            }
lbl42:
            // 7 sources

            success = true;
        }
        finally {
            RecoveryManager.trace(traceLevel, db, "LNUndo", success, lnFromLog, logLsn, location.bin, found, replaced, false, location.childLsn, abortLsn, location.index);
        }
    }

    private static boolean insertRecovery(DatabaseImpl db, TreeLocation location, long logLsn) throws DatabaseException {
        BIN parentBIN = location.bin;
        ChildReference newLNRef = new ChildReference(null, location.lnKey, logLsn);
        int entryIndex = parentBIN.insertEntry1(newLNRef);
        if ((entryIndex & 0x20000) == 0) {
            boolean canOverwrite = false;
            if (parentBIN.isEntryKnownDeleted(entryIndex &= 0xFFFEFFFF)) {
                canOverwrite = true;
            } else {
                LN currentLN = (LN)parentBIN.fetchTarget(entryIndex);
                if (currentLN == null || currentLN.isDeleted()) {
                    canOverwrite = true;
                }
                parentBIN.updateEntry(entryIndex, null);
            }
            if (canOverwrite) {
                parentBIN.updateEntry(entryIndex, null, logLsn, location.lnKey);
                parentBIN.clearKnownDeleted(entryIndex);
                location.index = entryIndex;
                return true;
            }
            return false;
        }
        location.index = entryIndex & 0xFFFDFFFF;
        return true;
    }

    private void redoUtilizationInfo(long logLsn, long treeLsn, long abortLsn, boolean abortKnownDeleted, int logEntrySize, byte[] key, LN ln, TxnNodeId txnNodeId, Set countedAbortLsnNodes) throws DatabaseException {
        UtilizationTracker tracker = this.env.getUtilizationTracker();
        if (ln.isDeleted()) {
            int cmpFsLsnToLogLsn;
            Long logFileNum = new Long(DbLsn.getFileNumber(logLsn));
            long fileSummaryLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(logFileNum));
            int n = cmpFsLsnToLogLsn = fileSummaryLsn != -1L ? DbLsn.compareTo(fileSummaryLsn, logLsn) : -1;
            if (cmpFsLsnToLogLsn < 0) {
                tracker.countObsoleteNode(logLsn, null, logEntrySize);
            }
        }
        if (treeLsn != -1L) {
            int cmpLogLsnToTreeLsn = DbLsn.compareTo(logLsn, treeLsn);
            if (cmpLogLsnToTreeLsn != 0) {
                int cmpOldFsLsnToNewLsn;
                long newLsn = cmpLogLsnToTreeLsn < 0 ? treeLsn : logLsn;
                long oldLsn = cmpLogLsnToTreeLsn > 0 ? treeLsn : logLsn;
                Long oldLsnFile = new Long(DbLsn.getFileNumber(oldLsn));
                long oldFsLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(oldLsnFile));
                int n = cmpOldFsLsnToNewLsn = oldFsLsn != -1L ? DbLsn.compareTo(oldFsLsn, newLsn) : -1;
                if (cmpOldFsLsnToNewLsn < 0) {
                    int oldSize = 0;
                    if (oldLsn == logLsn) {
                        oldSize = logEntrySize;
                    } else if (this.env.getCleaner().getFetchObsoleteSize()) {
                        try {
                            LN oldLn = (LN)this.env.getLogManager().get(oldLsn);
                            oldSize = oldLn.getLastLoggedSize();
                        }
                        catch (LogFileNotFoundException e) {
                            // empty catch block
                        }
                    }
                    tracker.countObsoleteNode(oldLsn, null, oldSize);
                }
            }
            if (cmpLogLsnToTreeLsn <= 0 && abortLsn != -1L && !abortKnownDeleted && !countedAbortLsnNodes.contains(txnNodeId)) {
                int cmpAbortFsLsnToLogLsn;
                Long abortFileNum = new Long(DbLsn.getFileNumber(abortLsn));
                long abortFsLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(abortFileNum));
                int n = cmpAbortFsLsnToLogLsn = abortFsLsn != -1L ? DbLsn.compareTo(abortFsLsn, logLsn) : -1;
                if (cmpAbortFsLsnToLogLsn < 0) {
                    tracker.countObsoleteNodeInexact(abortLsn, null, 0);
                    countedAbortLsnNodes.add(txnNodeId);
                }
            }
        }
    }

    private void undoUtilizationInfo(LN ln, long logLsn, long abortLsn, boolean abortKnownDeleted, int logEntrySize, TxnNodeId txnNodeId, Map countedFileSummaries, Set countedAbortLsnNodes) {
        Long countedFile;
        int cmpFsLsnToLogLsn;
        UtilizationTracker tracker = this.env.getUtilizationTracker();
        Long logFileNum = new Long(DbLsn.getFileNumber(logLsn));
        long fileSummaryLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(logFileNum));
        int n = cmpFsLsnToLogLsn = fileSummaryLsn != -1L ? DbLsn.compareTo(fileSummaryLsn, logLsn) : -1;
        if (cmpFsLsnToLogLsn < 0) {
            tracker.countObsoleteNode(logLsn, null, logEntrySize);
        }
        if (cmpFsLsnToLogLsn > 0 && ((countedFile = (Long)countedFileSummaries.get(txnNodeId)) == null || countedFile > logFileNum)) {
            if (!ln.isDeleted()) {
                tracker.countObsoleteNode(logLsn, null, logEntrySize);
            }
            countedFileSummaries.put(txnNodeId, logFileNum);
        }
    }

    private String passStartHeader(int passNum) {
        return "Recovery Pass " + passNum + " start: ";
    }

    private String passEndHeader(int passNum, long start, long end) {
        return "Recovery Pass " + passNum + " end (" + (end - start) + "): ";
    }

    private static void trace(Level level, DatabaseImpl database, String debugType, boolean success, Node node, long logLsn, IN parent, boolean found, boolean replaced, boolean inserted, long replacedLsn, long abortLsn, int index) {
        Logger logger = database.getDbEnvironment().getLogger();
        Level useLevel = level;
        if (!success) {
            useLevel = Level.SEVERE;
        }
        if (logger.isLoggable(useLevel)) {
            StringBuffer sb = new StringBuffer();
            sb.append(debugType);
            sb.append(" success=").append(success);
            sb.append(" node=");
            sb.append(node.getNodeId());
            sb.append(" lsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            if (parent != null) {
                sb.append(" parent=").append(parent.getNodeId());
            }
            sb.append(" found=");
            sb.append(found);
            sb.append(" replaced=");
            sb.append(replaced);
            sb.append(" inserted=");
            sb.append(inserted);
            if (replacedLsn != -1L) {
                sb.append(" replacedLsn=");
                sb.append(DbLsn.getNoFormatString(replacedLsn));
            }
            if (abortLsn != -1L) {
                sb.append(" abortLsn=");
                sb.append(DbLsn.getNoFormatString(abortLsn));
            }
            sb.append(" index=").append(index);
            logger.log(useLevel, sb.toString());
        }
    }

    private void traceINDeleteReplay(long nodeId, long logLsn, boolean found, boolean deleted, int index, boolean isDuplicate) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(this.detailedTraceLevel)) {
            StringBuffer sb = new StringBuffer();
            sb.append(isDuplicate ? TRACE_IN_DUPDEL_REPLAY : TRACE_IN_DEL_REPLAY);
            sb.append(" node=").append(nodeId);
            sb.append(" lsn=").append(DbLsn.getNoFormatString(logLsn));
            sb.append(" found=").append(found);
            sb.append(" deleted=").append(deleted);
            sb.append(" index=").append(index);
            logger.log(this.detailedTraceLevel, sb.toString());
        }
    }

    private void traceAndThrowException(long badLsn, String method, Exception originalException) throws DatabaseException {
        String badLsnString = DbLsn.getNoFormatString(badLsn);
        Tracer.trace(this.env, "RecoveryManager", method, "last LSN = " + badLsnString, originalException);
        throw new DatabaseException("last LSN=" + badLsnString, originalException);
    }

    public static void traceRootDeletion(Level level, DatabaseImpl database) {
        Logger logger = database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_ROOT_DELETE);
            sb.append(" Dbid=").append(database.getId());
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !RecoveryManager.class.desiredAssertionStatus();
    }

    private static class RootUpdater
    implements WithRootLatched {
        private Tree tree;
        private IN inFromLog;
        private long lsn = -1L;
        private boolean inserted = false;
        private boolean replaced = false;
        private long originalLsn = -1L;

        RootUpdater(Tree tree, IN inFromLog, long lsn) {
            this.tree = tree;
            this.inFromLog = inFromLog;
            this.lsn = lsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            ChildReference newRoot = this.tree.makeRootChildReference(this.inFromLog, new byte[0], this.lsn);
            this.inFromLog.releaseLatch();
            if (root == null) {
                this.tree.setRoot(newRoot, false);
                this.inserted = true;
            } else {
                this.originalLsn = root.getLsn();
                if (DbLsn.compareTo(this.originalLsn, this.lsn) < 0) {
                    this.tree.setRoot(newRoot, false);
                    this.replaced = true;
                }
            }
            return null;
        }

        boolean updateDone() {
            return this.inserted || this.replaced;
        }

        boolean getInserted() {
            return this.inserted;
        }

        boolean getReplaced() {
            return this.replaced;
        }

        long getOriginalLsn() {
            return this.originalLsn;
        }
    }

    private static class RootDeleter
    implements WithRootLatched {
        Tree tree;

        RootDeleter(Tree tree) {
            this.tree = tree;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            this.tree.setRoot(null, false);
            return null;
        }
    }

    private static class TxnNodeId {
        long nodeId;
        long txnId;

        TxnNodeId(long nodeId, long txnId) {
            this.nodeId = nodeId;
            this.txnId = txnId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TxnNodeId)) {
                return false;
            }
            return ((TxnNodeId)obj).txnId == this.txnId && ((TxnNodeId)obj).nodeId == this.nodeId;
        }

        public int hashCode() {
            return (int)(this.txnId + this.nodeId);
        }

        public String toString() {
            return "txnId=" + this.txnId + "/nodeId=" + this.nodeId;
        }
    }
}

