/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.entry.BaseEntry;
import com.sleepycat.je.log.entry.LogEntry;
import java.nio.ByteBuffer;

public class SingleItemEntry
extends BaseEntry
implements LogEntry {
    private Loggable item;

    public SingleItemEntry(Class logClass) {
        super(logClass);
    }

    public SingleItemEntry(LogEntryType entryType, Loggable item) {
        this.setLogType(entryType);
        this.item = item;
    }

    public void readEntry(LogEntryHeader header, ByteBuffer entryBuffer, boolean readFullItem) throws DatabaseException {
        try {
            this.item = (Loggable)this.logClass.newInstance();
            this.item.readFromLog(entryBuffer, header.getVersion());
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException(e);
        }
        catch (InstantiationException e) {
            throw new DatabaseException(e);
        }
    }

    public StringBuffer dumpEntry(StringBuffer sb, boolean verbose) {
        this.item.dumpLog(sb, verbose);
        return sb;
    }

    public Object getMainItem() {
        return this.item;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public long getTransactionId() {
        return this.item.getTransactionId();
    }

    public int getSize() {
        return this.item.getLogSize();
    }

    public void writeEntry(LogEntryHeader header, ByteBuffer destBuffer) {
        this.item.writeToLog(destBuffer);
    }
}

