/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.Tracer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Evictor
extends DaemonThread {
    public static final String SOURCE_DAEMON = "daemon";
    public static final String SOURCE_MANUAL = "manual";
    public static final String SOURCE_CRITICAL = "critical";
    private static final boolean DEBUG = false;
    private EnvironmentImpl envImpl;
    private LogManager logManager;
    private Level detailedTraceLevel;
    private volatile boolean active;
    private IN nextNode;
    private long currentRequiredEvictBytes;
    private int nodesPerScan;
    private long evictBytesSetting;
    private boolean evictByLruOnly;
    private boolean forcedYield;
    private NumberFormat formatter;
    private int nEvictPasses = 0;
    private long nNodesSelected = 0L;
    private long nNodesSelectedThisRun;
    private int nNodesScanned = 0;
    private int nNodesScannedThisRun;
    private long nNodesEvicted = 0L;
    private long nNodesEvictedThisRun;
    private long nBINsStripped = 0L;
    private long nBINsStrippedThisRun;
    EvictProfile evictProfile;
    private TestHook runnableHook;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Evictor(EnvironmentImpl envImpl, String name) throws DatabaseException {
        super(0L, name, envImpl);
        this.envImpl = envImpl;
        this.logManager = envImpl.getLogManager();
        this.nextNode = null;
        DbConfigManager configManager = envImpl.getConfigManager();
        this.nodesPerScan = configManager.getInt(EnvironmentParams.EVICTOR_NODES_PER_SCAN);
        this.evictBytesSetting = configManager.getLong(EnvironmentParams.EVICTOR_EVICT_BYTES);
        this.evictByLruOnly = configManager.getBoolean(EnvironmentParams.EVICTOR_LRU_ONLY);
        this.forcedYield = configManager.getBoolean(EnvironmentParams.EVICTOR_FORCED_YIELD);
        this.detailedTraceLevel = Tracer.parseLevel(envImpl, EnvironmentParams.JE_LOGGING_LEVEL_EVICTOR);
        this.evictProfile = new EvictProfile();
        this.formatter = NumberFormat.getNumberInstance();
        this.active = false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Evictor name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void addToQueue(Object o) throws DatabaseException {
        throw new DatabaseException("Evictor.addToQueue should never be called.");
    }

    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setNEvictPasses(this.nEvictPasses);
        stat.setNNodesSelected(this.nNodesSelected);
        stat.setNNodesScanned(this.nNodesScanned);
        stat.setNNodesExplicitlyEvicted(this.nNodesEvicted);
        stat.setNBINsStripped(this.nBINsStripped);
        stat.setRequiredEvictBytes(this.currentRequiredEvictBytes);
        if (config.getClear()) {
            this.nEvictPasses = 0;
            this.nNodesSelected = 0L;
            this.nNodesScanned = 0;
            this.nNodesEvicted = 0L;
            this.nBINsStripped = 0L;
        }
    }

    public synchronized void clearEnv() {
        this.envImpl = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.envImpl.getConfigManager().getInt(EnvironmentParams.EVICTOR_RETRY);
    }

    public void alert() {
        if (!this.active) {
            this.wakeup();
        }
    }

    public void onWakeup() throws DatabaseException {
        if (this.envImpl.isClosed()) {
            return;
        }
        this.doEvict(SOURCE_DAEMON, false, true);
    }

    public void doEvict(String source) throws DatabaseException {
        this.doEvict(source, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doEvict(String source, boolean criticalEviction, boolean backgroundIO) throws DatabaseException {
        if (this.active) {
            return;
        }
        this.active = true;
        try {
            boolean progress = true;
            while (progress && (criticalEviction || !this.isShutdownRequested()) && this.isRunnable(source)) {
                if (this.evictBatch(source, backgroundIO, this.currentRequiredEvictBytes) != 0L) continue;
                progress = false;
            }
        }
        finally {
            this.active = false;
        }
    }

    public void doCriticalEviction(boolean backgroundIO) throws DatabaseException {
        long maxMem;
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        long currentUsage = mb.getCacheMemoryUsage();
        long over = currentUsage - (maxMem = mb.getCacheBudget());
        if (over > mb.getCriticalThreshold()) {
            this.doEvict(SOURCE_CRITICAL, true, backgroundIO);
        }
        if (this.forcedYield) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long evictBatch(String source, boolean backgroundIO, long requiredEvictBytes) throws DatabaseException {
        UtilizationTracker tracker;
        int inListStartSize;
        INList inList;
        long evictBytes;
        boolean finished;
        int nBatchSets;
        block12: {
            this.nNodesSelectedThisRun = 0L;
            this.nNodesEvictedThisRun = 0L;
            this.nNodesScannedThisRun = 0;
            this.nBINsStrippedThisRun = 0L;
            ++this.nEvictPasses;
            if (!$assertionsDisabled && !this.evictProfile.clear()) {
                throw new AssertionError();
            }
            nBatchSets = 0;
            finished = false;
            evictBytes = 0L;
            evictBytes += this.envImpl.getUtilizationTracker().evictMemory();
            inList = this.envImpl.getInMemoryINs();
            inList.latchMajor();
            inListStartSize = inList.getSize();
            tracker = new UtilizationTracker(this.envImpl);
            if (inListStartSize != 0) break block12;
            this.nextNode = null;
            long l = 0L;
            Object var15_12 = null;
            this.nNodesScanned += this.nNodesScannedThisRun;
            inList.releaseMajorLatch();
            Logger logger = this.envImpl.getLogger();
            if (logger.isLoggable(this.detailedTraceLevel)) {
                Tracer.trace(this.detailedTraceLevel, this.envImpl, "Evictor: pass=" + this.nEvictPasses + " finished=" + finished + " source=" + source + " requiredEvictBytes=" + this.formatter.format(requiredEvictBytes) + " evictBytes=" + this.formatter.format(evictBytes) + " inListSize=" + inListStartSize + " nNodesScanned=" + this.nNodesScannedThisRun + " nNodesSelected=" + this.nNodesSelectedThisRun + " nEvicted=" + this.nNodesEvictedThisRun + " nBINsStripped=" + this.nBINsStrippedThisRun + " nBatchSets=" + nBatchSets);
            }
            return l;
        }
        try {
            IN target;
            if (this.nextNode == null) {
                this.nextNode = inList.first();
            }
            ScanIterator scanIter = new ScanIterator(this.nextNode, inList);
            while (evictBytes < requiredEvictBytes && this.nNodesScannedThisRun <= inListStartSize && (target = this.selectIN(inList, scanIter)) != null) {
                if (!$assertionsDisabled && !this.evictProfile.count(target)) {
                    throw new AssertionError();
                }
                evictBytes += this.evict(inList, target, scanIter, backgroundIO, tracker);
                ++nBatchSets;
            }
            this.nextNode = scanIter.mark();
            finished = true;
            Object var15_13 = null;
            this.nNodesScanned += this.nNodesScannedThisRun;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            this.nNodesScanned += this.nNodesScannedThisRun;
            inList.releaseMajorLatch();
            Logger logger = this.envImpl.getLogger();
            if (logger.isLoggable(this.detailedTraceLevel)) {
                Tracer.trace(this.detailedTraceLevel, this.envImpl, "Evictor: pass=" + this.nEvictPasses + " finished=" + finished + " source=" + source + " requiredEvictBytes=" + this.formatter.format(requiredEvictBytes) + " evictBytes=" + this.formatter.format(evictBytes) + " inListSize=" + inListStartSize + " nNodesScanned=" + this.nNodesScannedThisRun + " nNodesSelected=" + this.nNodesSelectedThisRun + " nEvicted=" + this.nNodesEvictedThisRun + " nBINsStripped=" + this.nBINsStrippedThisRun + " nBatchSets=" + nBatchSets);
            }
            throw throwable;
        }
        inList.releaseMajorLatch();
        Logger logger = this.envImpl.getLogger();
        if (logger.isLoggable(this.detailedTraceLevel)) {
            Tracer.trace(this.detailedTraceLevel, this.envImpl, "Evictor: pass=" + this.nEvictPasses + " finished=" + finished + " source=" + source + " requiredEvictBytes=" + this.formatter.format(requiredEvictBytes) + " evictBytes=" + this.formatter.format(evictBytes) + " inListSize=" + inListStartSize + " nNodesScanned=" + this.nNodesScannedThisRun + " nNodesSelected=" + this.nNodesSelectedThisRun + " nEvicted=" + this.nNodesEvictedThisRun + " nBINsStripped=" + this.nBINsStrippedThisRun + " nBatchSets=" + nBatchSets);
        }
        if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
            throw new AssertionError((Object)("latches held = " + LatchSupport.countLatchesHeld()));
        }
        TrackedFileSummary[] summaries = tracker.getTrackedFiles();
        if (summaries.length > 0) {
            this.envImpl.getUtilizationProfile().countAndLogSummaries(summaries);
        }
        return evictBytes;
    }

    boolean isRunnable(String source) throws DatabaseException {
        Logger logger;
        long maxMem;
        boolean doRun;
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        long currentUsage = mb.getCacheMemoryUsage();
        boolean bl = doRun = currentUsage - (maxMem = mb.getCacheBudget()) > 0L;
        if (doRun) {
            this.currentRequiredEvictBytes = currentUsage - maxMem + this.evictBytesSetting;
        }
        if (this.runnableHook != null) {
            doRun = (Boolean)this.runnableHook.getHookValue();
            this.currentRequiredEvictBytes = maxMem;
        }
        if ((logger = this.envImpl.getLogger()).isLoggable(this.detailedTraceLevel)) {
            Runtime r = Runtime.getRuntime();
            long totalBytes = r.totalMemory();
            long freeBytes = r.freeMemory();
            long usedBytes = r.totalMemory() - r.freeMemory();
            StringBuffer sb = new StringBuffer();
            sb.append(" source=").append(source);
            sb.append(" doRun=").append(doRun);
            sb.append(" JEusedBytes=").append(this.formatter.format(currentUsage));
            sb.append(" requiredEvict=").append(this.formatter.format(this.currentRequiredEvictBytes));
            sb.append(" JVMtotalBytes= ").append(this.formatter.format(totalBytes));
            sb.append(" JVMfreeBytes= ").append(this.formatter.format(freeBytes));
            sb.append(" JVMusedBytes= ").append(this.formatter.format(usedBytes));
            logger.log(this.detailedTraceLevel, sb.toString());
        }
        return doRun;
    }

    private IN selectIN(INList inList, ScanIterator scanIter) throws DatabaseException {
        IN target = null;
        long targetGeneration = Long.MAX_VALUE;
        int targetLevel = Integer.MAX_VALUE;
        boolean targetDirty = true;
        boolean envIsReadOnly = this.envImpl.isReadOnly();
        int scanned = 0;
        boolean wrapped = false;
        while (scanned < this.nodesPerScan) {
            if (scanIter.hasNext()) {
                int evictType;
                IN in = scanIter.next();
                ++this.nNodesScannedThisRun;
                DatabaseImpl db = in.getDatabase();
                if (db == null || db.isDeleteFinished()) {
                    String inInfo = " IN type=" + in.getLogType() + " id=" + in.getNodeId() + " not expected on INList";
                    String errMsg = db == null ? inInfo : "Database " + db.getDebugName() + " id=" + db.getId() + " rootLsn=" + DbLsn.getNoFormatString(db.getTree().getRootLsn()) + ' ' + inInfo;
                    throw new DatabaseException(errMsg);
                }
                if (db.isDeleted() || db.getId().equals(DbTree.ID_DB_ID) || envIsReadOnly && target != null && in.getDirty() || (evictType = in.getEvictionType()) == 0) continue;
                if (this.evictByLruOnly) {
                    if (targetGeneration > in.getGeneration()) {
                        targetGeneration = in.getGeneration();
                        target = in;
                    }
                } else {
                    int level = this.normalizeLevel(in, evictType);
                    if (targetLevel != level) {
                        if (targetLevel > level) {
                            targetLevel = level;
                            targetDirty = in.getDirty();
                            targetGeneration = in.getGeneration();
                            target = in;
                        }
                    } else if (targetDirty != in.getDirty()) {
                        if (targetDirty) {
                            targetDirty = false;
                            targetGeneration = in.getGeneration();
                            target = in;
                        }
                    } else if (targetGeneration > in.getGeneration()) {
                        targetGeneration = in.getGeneration();
                        target = in;
                    }
                }
                ++scanned;
                continue;
            }
            if (wrapped) break;
            this.nextNode = inList.first();
            scanIter.reset(this.nextNode);
            wrapped = true;
        }
        if (target != null) {
            ++this.nNodesSelectedThisRun;
            ++this.nNodesSelected;
        }
        return target;
    }

    public int normalizeLevel(IN in, int evictType) {
        int level = in.getLevel() & 0xFFFF;
        if (level == 1 && evictType == 1) {
            level = 0;
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evict(INList inList, IN target, ScanIterator scanIter, boolean backgroundIO, UtilizationTracker tracker) throws DatabaseException {
        boolean envIsReadOnly = this.envImpl.isReadOnly();
        long evictedBytes = 0L;
        if (target.latchNoWait(false)) {
            boolean targetIsLatched = true;
            try {
                if (target instanceof BIN) {
                    this.envImpl.lazyCompress(target, tracker);
                    evictedBytes = ((BIN)target).evictLNs();
                    if (evictedBytes > 0L) {
                        ++this.nBINsStrippedThisRun;
                        ++this.nBINsStripped;
                    }
                }
                if (evictedBytes == 0L && target.isEvictable()) {
                    Tree tree = target.getDatabase().getTree();
                    targetIsLatched = false;
                    SearchResult result = tree.getParentINForChildIN(target, true, false);
                    if (result.exactParentFound) {
                        evictedBytes = this.evictIN(target, result.parent, result.index, inList, scanIter, envIsReadOnly, backgroundIO);
                    }
                }
            }
            finally {
                if (targetIsLatched) {
                    target.releaseLatchIfOwner();
                }
            }
        }
        return evictedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evictIN(IN child, IN parent, int index, INList inlist, ScanIterator scanIter, boolean envIsReadOnly, boolean backgroundIO) throws DatabaseException {
        long evictBytes;
        block14: {
            evictBytes = 0L;
            try {
                if (!$assertionsDisabled && !parent.isLatchOwnerForWrite()) {
                    throw new AssertionError();
                }
                long oldGenerationCount = child.getGeneration();
                IN renewedChild = (IN)parent.getTarget(index);
                if (renewedChild == null || renewedChild.getGeneration() > oldGenerationCount || !renewedChild.latchNoWait(false)) break block14;
                try {
                    if (renewedChild.isEvictable()) {
                        long renewedChildLsn = -1L;
                        boolean newChildLsn = false;
                        if (renewedChild.getDirty()) {
                            if (!envIsReadOnly) {
                                boolean logProvisional = this.isProvisionalRequired(renewedChild);
                                renewedChildLsn = renewedChild.log(this.logManager, false, logProvisional, true, backgroundIO, parent);
                                newChildLsn = true;
                            }
                        } else {
                            renewedChildLsn = parent.getLsn(index);
                        }
                        if (renewedChildLsn != -1L) {
                            scanIter.mark();
                            inlist.removeLatchAlreadyHeld(renewedChild);
                            scanIter.resetToMark();
                            evictBytes = renewedChild.getInMemorySize();
                            if (newChildLsn) {
                                parent.updateEntry(index, null, renewedChildLsn);
                            } else {
                                parent.updateEntry(index, null);
                            }
                            ++this.nNodesEvictedThisRun;
                            ++this.nNodesEvicted;
                        }
                    }
                }
                finally {
                    renewedChild.releaseLatch();
                }
            }
            finally {
                parent.releaseLatch();
            }
        }
        return evictBytes;
    }

    private boolean isProvisionalRequired(IN target) {
        if (target.getDatabase().isDeferredWrite()) {
            return true;
        }
        Checkpointer ckpter = this.envImpl.getCheckpointer();
        return ckpter != null && target.getLevel() < ckpter.getHighestFlushLevel();
    }

    IN getNextNode() {
        return this.nextNode;
    }

    public void setRunnableHook(TestHook hook) {
        this.runnableHook = hook;
    }

    static {
        $assertionsDisabled = !Evictor.class.desiredAssertionStatus();
    }

    private static class ScanIterator {
        private INList inList;
        private Iterator iter;
        private IN nextMark;

        ScanIterator(IN startingIN, INList inList) throws DatabaseException {
            this.inList = inList;
            this.reset(startingIN);
        }

        void reset(IN startingIN) throws DatabaseException {
            this.iter = this.inList.tailSet(startingIN).iterator();
        }

        IN mark() throws DatabaseException {
            this.nextMark = this.iter.hasNext() ? (IN)this.iter.next() : this.inList.first();
            return this.nextMark;
        }

        void resetToMark() throws DatabaseException {
            this.reset(this.nextMark);
        }

        boolean hasNext() {
            return this.iter.hasNext();
        }

        IN next() {
            return (IN)this.iter.next();
        }

        void remove() {
            this.iter.remove();
        }
    }

    public static class EvictProfile {
        private List candidates = new ArrayList();

        public boolean count(IN target) {
            this.candidates.add(new Long(target.getNodeId()));
            return true;
        }

        public List getCandidates() {
            return this.candidates;
        }

        public boolean clear() {
            this.candidates.clear();
            return true;
        }
    }
}

