/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import java.util.Iterator;

public class MemoryBudget
implements EnvConfigObserver {
    private static final int LONG_OVERHEAD_32 = 16;
    private static final int LONG_OVERHEAD_64 = 24;
    private static final int BYTE_ARRAY_OVERHEAD_32 = 16;
    private static final int BYTE_ARRAY_OVERHEAD_64 = 24;
    private static final int OBJECT_OVERHEAD_32 = 8;
    private static final int OBJECT_OVERHEAD_64 = 16;
    private static final int ARRAY_ITEM_OVERHEAD_32 = 4;
    private static final int ARRAY_ITEM_OVERHEAD_64 = 8;
    private static final int HASHMAP_OVERHEAD_32 = 120;
    private static final int HASHMAP_OVERHEAD_64 = 216;
    private static final int HASHMAP_ENTRY_OVERHEAD_32 = 24;
    private static final int HASHMAP_ENTRY_OVERHEAD_64 = 48;
    private static final int HASHSET_OVERHEAD_32 = 136;
    private static final int HASHSET_OVERHEAD_64 = 240;
    private static final int HASHSET_ENTRY_OVERHEAD_32 = 24;
    private static final int HASHSET_ENTRY_OVERHEAD_64 = 48;
    private static final int TWOHASHMAPS_OVERHEAD_32 = 240;
    private static final int TWOHASHMAPS_OVERHEAD_64 = 432;
    private static final int TREEMAP_OVERHEAD_32 = 40;
    private static final int TREEMAP_OVERHEAD_64 = 64;
    private static final int TREEMAP_ENTRY_OVERHEAD_32 = 32;
    private static final int TREEMAP_ENTRY_OVERHEAD_64 = 53;
    private static final int MAPLN_OVERHEAD_32 = 464;
    private static final int MAPLN_OVERHEAD_64 = 776;
    private static final int LN_OVERHEAD_32 = 24;
    private static final int LN_OVERHEAD_64 = 32;
    private static final int DUPCOUNTLN_OVERHEAD_32 = 24;
    private static final int DUPCOUNTLN_OVERHEAD_64 = 40;
    private static final int BIN_FIXED_OVERHEAD_32_14 = 344;
    private static final int BIN_FIXED_OVERHEAD_32_15 = 360;
    private static final int BIN_FIXED_OVERHEAD_64_15 = 528;
    private static final int DIN_FIXED_OVERHEAD_32_14 = 352;
    private static final int DIN_FIXED_OVERHEAD_32_15 = 360;
    private static final int DIN_FIXED_OVERHEAD_64_15 = 536;
    private static final int DBIN_FIXED_OVERHEAD_32_14 = 352;
    private static final int DBIN_FIXED_OVERHEAD_32_15 = 368;
    private static final int DBIN_FIXED_OVERHEAD_64_15 = 544;
    private static final int IN_FIXED_OVERHEAD_32_14 = 312;
    private static final int IN_FIXED_OVERHEAD_32_15 = 320;
    private static final int IN_FIXED_OVERHEAD_64_15 = 472;
    private static final int KEY_OVERHEAD_32 = 16;
    private static final int KEY_OVERHEAD_64 = 24;
    private static final int LOCK_OVERHEAD_32 = 32;
    private static final int LOCK_OVERHEAD_64 = 56;
    private static final int LOCKINFO_OVERHEAD_32 = 16;
    private static final int LOCKINFO_OVERHEAD_64 = 32;
    private static final int WRITE_LOCKINFO_OVERHEAD_32 = 32;
    private static final int WRITE_LOCKINFO_OVERHEAD_64 = 40;
    private static final int TXN_OVERHEAD_32_14 = 167;
    private static final int TXN_OVERHEAD_32_15 = 175;
    private static final int TXN_OVERHEAD_64_15 = 293;
    private static final int CHECKPOINT_REFERENCE_SIZE_32_14 = 56;
    private static final int CHECKPOINT_REFERENCE_SIZE_32_15 = 64;
    private static final int CHECKPOINT_REFERENCE_SIZE_64_15 = 104;
    private static final int UTILIZATION_PROFILE_ENTRY_32 = 96;
    private static final int UTILIZATION_PROFILE_ENTRY_64 = 144;
    private static final int TFS_LIST_INITIAL_OVERHEAD_32 = 464;
    private static final int TFS_LIST_INITIAL_OVERHEAD_64 = 504;
    private static final int TFS_LIST_SEGMENT_OVERHEAD_32 = 440;
    private static final int TFS_LIST_SEGMENT_OVERHEAD_64 = 464;
    private static final int LN_INFO_OVERHEAD_32 = 24;
    private static final int LN_INFO_OVERHEAD_64 = 48;
    private static final int LONG_LIST_PER_ITEM_OVERHEAD_32 = 20;
    private static final int LONG_LIST_PER_ITEM_OVERHEAD_64 = 32;
    public static final int LONG_OVERHEAD;
    public static final int BYTE_ARRAY_OVERHEAD;
    public static final int OBJECT_OVERHEAD;
    public static final int ARRAY_ITEM_OVERHEAD;
    public static final int HASHMAP_OVERHEAD;
    public static final int HASHMAP_ENTRY_OVERHEAD;
    public static final int HASHSET_OVERHEAD;
    public static final int HASHSET_ENTRY_OVERHEAD;
    public static final int TWOHASHMAPS_OVERHEAD;
    public static final int TREEMAP_OVERHEAD;
    public static final int TREEMAP_ENTRY_OVERHEAD;
    public static final int MAPLN_OVERHEAD;
    public static final int LN_OVERHEAD;
    public static final int DUPCOUNTLN_OVERHEAD;
    public static final int BIN_FIXED_OVERHEAD;
    public static final int DIN_FIXED_OVERHEAD;
    public static final int DBIN_FIXED_OVERHEAD;
    public static final int IN_FIXED_OVERHEAD;
    public static final int KEY_OVERHEAD;
    public static final int LOCK_OVERHEAD;
    public static final int LOCKINFO_OVERHEAD;
    public static final int WRITE_LOCKINFO_OVERHEAD;
    public static final int TXN_OVERHEAD;
    public static final int CHECKPOINT_REFERENCE_SIZE;
    public static final int UTILIZATION_PROFILE_ENTRY;
    public static final int TFS_LIST_INITIAL_OVERHEAD;
    public static final int TFS_LIST_SEGMENT_OVERHEAD;
    public static final int LN_INFO_OVERHEAD;
    public static final int LONG_LIST_PER_ITEM_OVERHEAD;
    private static final String JVM_ARCH_PROPERTY = "sun.arch.data.model";
    private static final String FORCE_JVM_ARCH = "je.forceJVMArch";
    public static final long MIN_MAX_MEMORY_SIZE = 98304L;
    public static final String MIN_MAX_MEMORY_SIZE_STRING;
    private static final long N_64MB = 0x4000000L;
    private long treeMemoryUsage;
    private long miscMemoryUsage;
    private Object memoryUsageSynchronizer = new Object();
    private int nLockTables;
    private long[] lockMemoryUsage;
    private long maxMemory;
    private long criticalThreshold;
    private long logBufferBudget;
    private long trackerBudget;
    private long cacheBudget;
    private long inOverhead;
    private long binOverhead;
    private long dinOverhead;
    private long dbinOverhead;
    private EnvironmentImpl envImpl;
    static final /* synthetic */ boolean $assertionsDisabled;

    MemoryBudget(EnvironmentImpl envImpl, DbConfigManager configManager) throws DatabaseException {
        this.envImpl = envImpl;
        envImpl.addConfigObserver(this);
        this.reset(configManager);
        this.inOverhead = IN.computeOverhead(configManager);
        this.binOverhead = BIN.computeOverhead(configManager);
        this.dinOverhead = DIN.computeOverhead(configManager);
        this.dbinOverhead = DBIN.computeOverhead(configManager);
    }

    public void envConfigUpdate(DbConfigManager configManager) throws DatabaseException {
        long oldLogBufferBudget = this.logBufferBudget;
        this.reset(configManager);
        if (oldLogBufferBudget != this.logBufferBudget) {
            this.envImpl.getLogManager().resetPool(configManager);
        }
    }

    private void reset(DbConfigManager configManager) throws DatabaseException {
        long newLogBufferBudget;
        long newMaxMemory = configManager.getLong(EnvironmentParams.MAX_MEMORY);
        long jvmMemory = MemoryBudget.getRuntimeMaxMemory();
        if (newMaxMemory != 0L) {
            if (jvmMemory < newMaxMemory) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " has a value of " + newMaxMemory + " but the JVM is only configured for " + jvmMemory + ". Consider using je.maxMemoryPercent.");
            }
            if (newMaxMemory < 98304L) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " is " + newMaxMemory + " which is less than the minimum: " + 98304L);
            }
        } else {
            if (jvmMemory == Long.MAX_VALUE) {
                jvmMemory = 0x4000000L;
            }
            int maxMemoryPercent = configManager.getInt(EnvironmentParams.MAX_MEMORY_PERCENT);
            newMaxMemory = (long)maxMemoryPercent * jvmMemory / 100L;
        }
        if ((newLogBufferBudget = configManager.getLong(EnvironmentParams.LOG_MEM_SIZE)) == 0L) {
            newLogBufferBudget = newMaxMemory >> 4;
        } else if (newLogBufferBudget > newMaxMemory / 2L) {
            newLogBufferBudget = newMaxMemory / 2L;
        }
        int numBuffers = configManager.getInt(EnvironmentParams.NUM_LOG_BUFFERS);
        long startingBufferSize = newLogBufferBudget / (long)numBuffers;
        int logBufferSize = configManager.getInt(EnvironmentParams.LOG_BUFFER_MAX_SIZE);
        if (startingBufferSize > (long)logBufferSize) {
            startingBufferSize = logBufferSize;
            newLogBufferBudget = (long)numBuffers * startingBufferSize;
        } else if (startingBufferSize < 2048L) {
            startingBufferSize = 2048L;
            newLogBufferBudget = (long)numBuffers * startingBufferSize;
        }
        long newCriticalThreshold = newMaxMemory * (long)this.envImpl.getConfigManager().getInt(EnvironmentParams.EVICTOR_CRITICAL_PERCENTAGE) / 100L;
        long newTrackerBudget = newMaxMemory * (long)this.envImpl.getConfigManager().getInt(EnvironmentParams.CLEANER_DETAIL_MAX_MEMORY_PERCENTAGE) / 100L;
        this.maxMemory = newMaxMemory;
        this.criticalThreshold = newCriticalThreshold;
        this.logBufferBudget = newLogBufferBudget;
        this.trackerBudget = newTrackerBudget;
        this.cacheBudget = newMaxMemory - newLogBufferBudget;
        this.nLockTables = configManager.getInt(EnvironmentParams.N_LOCK_TABLES);
        this.lockMemoryUsage = new long[this.nLockTables];
    }

    public static long getRuntimeMaxMemory() {
        String jvmVersion;
        if ("Mac OS X".equals(System.getProperty("os.name")) && (jvmVersion = System.getProperty("java.version")) != null && jvmVersion.startsWith("1.4.2")) {
            return Long.MAX_VALUE;
        }
        return Runtime.getRuntime().maxMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCacheMemoryUsage() throws DatabaseException {
        long calculatedUsage = this.calcTreeCacheUsage();
        Object object = this.memoryUsageSynchronizer;
        synchronized (object) {
            this.treeMemoryUsage = calculatedUsage;
        }
        if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long calcTreeCacheUsage() throws DatabaseException {
        long totalSize = 0L;
        INList inList = this.envImpl.getInMemoryINs();
        inList.latchMajor();
        try {
            Iterator iter = inList.iterator();
            while (iter.hasNext()) {
                IN in = (IN)iter.next();
                long size = in.getInMemorySize();
                totalSize += size;
            }
        }
        finally {
            inList.releaseMajorLatch();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTreeMemoryUsage(long increment) {
        Object object = this.memoryUsageSynchronizer;
        synchronized (object) {
            this.treeMemoryUsage += increment;
        }
        if (this.getCacheMemoryUsage() > this.cacheBudget) {
            this.envImpl.alertEvictor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMiscMemoryUsage(long increment) {
        Object object = this.memoryUsageSynchronizer;
        synchronized (object) {
            this.miscMemoryUsage += increment;
        }
        if (this.getCacheMemoryUsage() > this.cacheBudget) {
            this.envImpl.alertEvictor();
        }
    }

    public void updateLockMemoryUsage(long increment, int lockTableIndex) {
        int n = lockTableIndex;
        this.lockMemoryUsage[n] = this.lockMemoryUsage[n] + increment;
        if (this.getCacheMemoryUsage() > this.cacheBudget) {
            this.envImpl.alertEvictor();
        }
    }

    public long accumulateNewUsage(IN in, long newSize) {
        return in.getInMemorySize() + newSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTreeMemoryUsage(long newSize) {
        Object object = this.memoryUsageSynchronizer;
        synchronized (object) {
            this.treeMemoryUsage = newSize;
        }
    }

    public long getCacheMemoryUsage() {
        long accLockMemoryUsage = 0L;
        if (this.nLockTables == 1) {
            accLockMemoryUsage = this.lockMemoryUsage[0];
        } else {
            for (int i = 0; i < this.nLockTables; ++i) {
                accLockMemoryUsage += this.lockMemoryUsage[i];
            }
        }
        return this.treeMemoryUsage + this.miscMemoryUsage + accLockMemoryUsage;
    }

    public long getTreeMemoryUsage() {
        return this.treeMemoryUsage;
    }

    public long getLogBufferBudget() {
        return this.logBufferBudget;
    }

    public long getTrackerBudget() {
        return this.trackerBudget;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getCriticalThreshold() {
        return this.criticalThreshold;
    }

    public long getCacheBudget() {
        return this.cacheBudget;
    }

    public long getINOverhead() {
        return this.inOverhead;
    }

    public long getBINOverhead() {
        return this.binOverhead;
    }

    public long getDINOverhead() {
        return this.dinOverhead;
    }

    public long getDBINOverhead() {
        return this.dbinOverhead;
    }

    public static int byteArraySize(int arrayLen) {
        int size = BYTE_ARRAY_OVERHEAD;
        if (arrayLen > 4) {
            size += (arrayLen - 4 + 7) / 8 * 8;
        }
        return size;
    }

    void loadStats(StatsConfig config, EnvironmentStats stats) {
        stats.setCacheDataBytes(this.getCacheMemoryUsage());
    }

    static {
        $assertionsDisabled = !MemoryBudget.class.desiredAssertionStatus();
        boolean is64 = false;
        boolean isJVM14 = LatchSupport.getJava5LatchClass() == null;
        String overrideArch = System.getProperty(FORCE_JVM_ARCH);
        try {
            if (overrideArch == null) {
                String arch = System.getProperty(JVM_ARCH_PROPERTY);
                if (arch != null) {
                    is64 = Integer.parseInt(arch) == 64;
                }
            } else {
                is64 = Integer.parseInt(overrideArch) == 64;
            }
        }
        catch (NumberFormatException NFE) {
            NFE.printStackTrace(System.err);
        }
        if (is64) {
            if (isJVM14) {
                RuntimeException RE = new RuntimeException("1.4 based 64 bit JVM not supported");
                RE.printStackTrace(System.err);
                throw RE;
            }
            LONG_OVERHEAD = 24;
            BYTE_ARRAY_OVERHEAD = 24;
            OBJECT_OVERHEAD = 16;
            ARRAY_ITEM_OVERHEAD = 8;
            HASHMAP_OVERHEAD = 216;
            HASHMAP_ENTRY_OVERHEAD = 48;
            HASHSET_OVERHEAD = 240;
            HASHSET_ENTRY_OVERHEAD = 48;
            TWOHASHMAPS_OVERHEAD = 432;
            TREEMAP_OVERHEAD = 64;
            TREEMAP_ENTRY_OVERHEAD = 53;
            MAPLN_OVERHEAD = 776;
            LN_OVERHEAD = 32;
            DUPCOUNTLN_OVERHEAD = 40;
            BIN_FIXED_OVERHEAD = 528;
            DIN_FIXED_OVERHEAD = 536;
            DBIN_FIXED_OVERHEAD = 544;
            IN_FIXED_OVERHEAD = 472;
            TXN_OVERHEAD = 293;
            CHECKPOINT_REFERENCE_SIZE = 104;
            KEY_OVERHEAD = 24;
            LOCK_OVERHEAD = 56;
            LOCKINFO_OVERHEAD = 32;
            WRITE_LOCKINFO_OVERHEAD = 40;
            UTILIZATION_PROFILE_ENTRY = 144;
            TFS_LIST_INITIAL_OVERHEAD = 504;
            TFS_LIST_SEGMENT_OVERHEAD = 464;
            LN_INFO_OVERHEAD = 48;
            LONG_LIST_PER_ITEM_OVERHEAD = 32;
        } else {
            LONG_OVERHEAD = 16;
            BYTE_ARRAY_OVERHEAD = 16;
            OBJECT_OVERHEAD = 8;
            ARRAY_ITEM_OVERHEAD = 4;
            HASHMAP_OVERHEAD = 120;
            HASHMAP_ENTRY_OVERHEAD = 24;
            HASHSET_OVERHEAD = 136;
            HASHSET_ENTRY_OVERHEAD = 24;
            TWOHASHMAPS_OVERHEAD = 240;
            TREEMAP_OVERHEAD = 40;
            TREEMAP_ENTRY_OVERHEAD = 32;
            MAPLN_OVERHEAD = 464;
            LN_OVERHEAD = 24;
            DUPCOUNTLN_OVERHEAD = 24;
            if (isJVM14) {
                BIN_FIXED_OVERHEAD = 344;
                DIN_FIXED_OVERHEAD = 352;
                DBIN_FIXED_OVERHEAD = 352;
                IN_FIXED_OVERHEAD = 312;
                TXN_OVERHEAD = 167;
                CHECKPOINT_REFERENCE_SIZE = 56;
            } else {
                BIN_FIXED_OVERHEAD = 360;
                DIN_FIXED_OVERHEAD = 360;
                DBIN_FIXED_OVERHEAD = 368;
                IN_FIXED_OVERHEAD = 320;
                TXN_OVERHEAD = 175;
                CHECKPOINT_REFERENCE_SIZE = 64;
            }
            KEY_OVERHEAD = 16;
            LOCK_OVERHEAD = 32;
            LOCKINFO_OVERHEAD = 16;
            WRITE_LOCKINFO_OVERHEAD = 32;
            UTILIZATION_PROFILE_ENTRY = 96;
            TFS_LIST_INITIAL_OVERHEAD = 464;
            TFS_LIST_SEGMENT_OVERHEAD = 440;
            LN_INFO_OVERHEAD = 24;
            LONG_LIST_PER_ITEM_OVERHEAD = 20;
        }
        MIN_MAX_MEMORY_SIZE_STRING = Long.toString(98304L);
    }
}

