/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.TestHook;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DatabaseImpl
implements Loggable,
Cloneable {
    private static final short NOT_DELETED = 1;
    private static final short DELETED_CLEANUP_INLIST_HARVEST = 2;
    private static final short DELETED_CLEANUP_LOG_HARVEST = 3;
    private static final short DELETED = 4;
    private DatabaseId id;
    private Tree tree;
    private EnvironmentImpl envImpl;
    private boolean duplicatesAllowed;
    private boolean transactional;
    private boolean deferredWrite;
    private Set referringHandles;
    private BtreeStats stats;
    private long eofNodeId;
    private short deleteState;
    private Comparator btreeComparator = null;
    private Comparator duplicateComparator = null;
    private byte[] btreeComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private byte[] duplicateComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private boolean btreeComparatorByClassName = false;
    private boolean duplicateComparatorByClassName = false;
    private int binDeltaPercent;
    private int binMaxDeltas;
    private int maxMainTreeEntriesPerNode;
    private int maxDupTreeEntriesPerNode;
    private String debugDatabaseName;
    private TestHook pendingDeletedHook;
    private static final HaltPreloadException TIME_EXCEEDED_PRELOAD_EXCEPTION;
    private static final HaltPreloadException MEMORY_EXCEEDED_PRELOAD_EXCEPTION;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DatabaseImpl(String dbName, DatabaseId id, EnvironmentImpl envImpl, DatabaseConfig dbConfig) throws DatabaseException {
        this.id = id;
        this.envImpl = envImpl;
        this.setBtreeComparator(dbConfig.getBtreeComparator(), dbConfig.getBtreeComparatorByClassName());
        this.setDuplicateComparator(dbConfig.getDuplicateComparator(), dbConfig.getDuplicateComparatorByClassName());
        this.duplicatesAllowed = dbConfig.getSortedDuplicates();
        this.transactional = dbConfig.getTransactional();
        this.deferredWrite = dbConfig.getDeferredWrite();
        this.maxMainTreeEntriesPerNode = dbConfig.getNodeMaxEntries();
        this.maxDupTreeEntriesPerNode = dbConfig.getNodeMaxDupTreeEntries();
        this.initDefaultSettings();
        this.deleteState = 1;
        this.tree = new Tree(this);
        this.referringHandles = Collections.synchronizedSet(new HashSet());
        this.eofNodeId = Node.getNextNodeId();
        this.debugDatabaseName = dbName;
    }

    public DatabaseImpl() throws DatabaseException {
        this.id = new DatabaseId();
        this.envImpl = null;
        this.deleteState = 1;
        this.tree = new Tree();
        this.referringHandles = Collections.synchronizedSet(new HashSet());
        this.eofNodeId = Node.getNextNodeId();
    }

    public void setDebugDatabaseName(String debugName) {
        this.debugDatabaseName = debugName;
    }

    public String getDebugName() {
        return this.debugDatabaseName;
    }

    public void setPendingDeletedHook(TestHook hook) {
        this.pendingDeletedHook = hook;
    }

    private void initDefaultSettings() throws DatabaseException {
        DbConfigManager configMgr = this.envImpl.getConfigManager();
        this.binDeltaPercent = configMgr.getInt(EnvironmentParams.BIN_DELTA_PERCENT);
        this.binMaxDeltas = configMgr.getInt(EnvironmentParams.BIN_MAX_DELTAS);
        if (this.maxMainTreeEntriesPerNode == 0) {
            this.maxMainTreeEntriesPerNode = configMgr.getInt(EnvironmentParams.NODE_MAX);
        }
        if (this.maxDupTreeEntriesPerNode == 0) {
            this.maxDupTreeEntriesPerNode = configMgr.getInt(EnvironmentParams.NODE_MAX_DUPTREE);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Tree getTree() {
        return this.tree;
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    public DatabaseId getId() {
        return this.id;
    }

    void setId(DatabaseId id) {
        this.id = id;
    }

    public long getEofNodeId() {
        return this.eofNodeId;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isDeferredWrite() {
        return this.deferredWrite;
    }

    public void setDeferredWrite(boolean deferredWrite) {
        this.deferredWrite = deferredWrite;
    }

    public boolean getSortedDuplicates() {
        return this.duplicatesAllowed;
    }

    public int getNodeMaxEntries() {
        return this.maxMainTreeEntriesPerNode;
    }

    public int getNodeMaxDupTreeEntries() {
        return this.maxDupTreeEntriesPerNode;
    }

    public int getAdditionalMemorySize() {
        int val = 0;
        if (this.btreeComparator != null) {
            val += 2 * MemoryBudget.byteArraySize(this.btreeComparatorBytes.length);
        }
        if (this.duplicateComparator != null) {
            val += 2 * MemoryBudget.byteArraySize(this.duplicateComparatorBytes.length);
        }
        return val;
    }

    public void setDuplicateComparator(Comparator comparator, boolean byClassName) throws DatabaseException {
        this.duplicateComparator = comparator;
        this.duplicateComparatorBytes = DatabaseImpl.comparatorToBytes(comparator, byClassName, "Duplicate");
        this.duplicateComparatorByClassName = byClassName;
    }

    public void setBtreeComparator(Comparator comparator, boolean byClassName) throws DatabaseException {
        this.btreeComparator = comparator;
        this.btreeComparatorBytes = DatabaseImpl.comparatorToBytes(comparator, byClassName, "Btree");
        this.btreeComparatorByClassName = byClassName;
    }

    public Comparator getBtreeComparator() {
        return this.btreeComparator;
    }

    public Comparator getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public boolean getBtreeComparatorByClass() {
        return this.btreeComparatorByClassName;
    }

    public boolean getDuplicateComparatorByClass() {
        return this.duplicateComparatorByClassName;
    }

    public void setEnvironmentImpl(EnvironmentImpl envImpl) throws DatabaseException {
        this.envImpl = envImpl;
        this.initDefaultSettings();
        this.tree.setDatabase(this);
    }

    public EnvironmentImpl getDbEnvironment() {
        return this.envImpl;
    }

    public boolean hasOpenHandles() {
        return this.referringHandles.size() > 0;
    }

    public void addReferringHandle(Database db) {
        this.referringHandles.add(db);
    }

    public void removeReferringHandle(Database db) {
        this.referringHandles.remove(db);
    }

    synchronized int getReferringHandleCount() {
        return this.referringHandles.size();
    }

    public synchronized void sync(boolean flushLog) throws DatabaseException {
        if (!this.isDeferredWrite()) {
            throw new DatabaseException("Database.sync() is only supported for deferred-write databases");
        }
        if (this.tree.rootExists()) {
            Checkpointer.syncDatabase(this.envImpl, this, flushLog);
        }
    }

    public Database findPrimaryDatabase() throws DatabaseException {
        Iterator i = this.referringHandles.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof SecondaryDatabase)) continue;
            return ((SecondaryDatabase)obj).getPrimaryDatabase();
        }
        return null;
    }

    public String getName() throws DatabaseException {
        return this.envImpl.getDbMapTree().getDbName(this.id);
    }

    public boolean isDeleted() {
        return this.deleteState != 1;
    }

    public boolean isDeleteFinished() {
        return this.deleteState == 4;
    }

    public void startDeleteProcessing() {
        if (!$assertionsDisabled && this.deleteState != 1) {
            throw new AssertionError();
        }
        this.deleteState = (short)2;
    }

    void finishedINListHarvest() {
        if (!$assertionsDisabled && this.deleteState != 2) {
            throw new AssertionError();
        }
        this.deleteState = (short)3;
    }

    public void deleteAndReleaseINs() throws DatabaseException {
        this.startDeleteProcessing();
        this.releaseDeletedINs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDeletedINs() throws DatabaseException {
        if (this.pendingDeletedHook != null) {
            this.pendingDeletedHook.doHook();
        }
        try {
            long rootLsn = this.tree.getRootLsn();
            UtilizationTracker snapshot = new UtilizationTracker(this.envImpl);
            if (rootLsn != -1L) {
                snapshot.countObsoleteNodeInexact(rootLsn, LogEntryType.LOG_IN, 0);
            }
            boolean fetchLNSize = this.envImpl.getCleaner().getFetchObsoleteSize();
            ObsoleteProcessor obsoleteProcessor = new ObsoleteProcessor(snapshot);
            ObsoleteTreeWalker walker = new ObsoleteTreeWalker(this, rootLsn, fetchLNSize, obsoleteProcessor);
            this.envImpl.getDbMapTree().deleteMapLN(this.id);
            walker.walk();
            this.envImpl.getUtilizationProfile().countAndLogSummaries(snapshot.getTrackedFiles());
        }
        finally {
            this.deleteState = (short)4;
        }
    }

    public void checkIsDeleted(String operation) throws DatabaseException {
        if (this.isDeleted()) {
            throw new DatabaseException("Attempt to " + operation + " a deleted database");
        }
    }

    public DatabaseStats stat(StatsConfig config) throws DatabaseException {
        if (this.stats == null) {
            this.stats = new BtreeStats();
        }
        if (!config.getFast()) {
            if (this.tree == null) {
                return new BtreeStats();
            }
            PrintStream out = config.getShowProgressStream();
            if (out == null) {
                out = System.err;
            }
            StatsAccumulator statsAcc = new StatsAccumulator(out, config.getShowProgressInterval(), this.getEmptyStats());
            this.walkDatabaseTree(statsAcc, out, true);
            statsAcc.copyToStats(this.stats);
        }
        return this.stats;
    }

    public boolean verify(VerifyConfig config, DatabaseStats emptyStats) throws DatabaseException {
        if (this.tree == null) {
            return true;
        }
        PrintStream out = config.getShowProgressStream();
        if (out == null) {
            out = System.err;
        }
        StatsAccumulator statsAcc = new StatsAccumulator(out, config.getShowProgressInterval(), emptyStats){

            void verifyNode(Node node) {
                try {
                    node.verify(null);
                }
                catch (DatabaseException INE) {
                    this.progressStream.println(INE);
                }
            }
        };
        boolean ok = this.walkDatabaseTree(statsAcc, out, config.getPrintInfo());
        statsAcc.copyToStats(emptyStats);
        return ok;
    }

    public DatabaseStats getEmptyStats() {
        return new BtreeStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean walkDatabaseTree(TreeWalkerStatsAccumulator statsAcc, PrintStream out, boolean verbose) throws DatabaseException {
        boolean ok = true;
        ThreadLocker locker = new ThreadLocker(this.envImpl);
        Cursor cursor = null;
        CursorImpl impl = null;
        try {
            EnvironmentImpl.incThreadLocalReferenceCount();
            cursor = DbInternal.newCursor(this, locker, null);
            impl = DbInternal.getCursorImpl(cursor);
            this.tree.setTreeStatsAccumulator(statsAcc);
            impl.setTreeStatsAccumulator(statsAcc);
            DatabaseEntry foundData = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry();
            OperationStatus status = DbInternal.position(cursor, key, foundData, LockMode.READ_UNCOMMITTED, true);
            while (status == OperationStatus.SUCCESS) {
                try {
                    status = DbInternal.retrieveNext(cursor, key, foundData, LockMode.READ_UNCOMMITTED, GetMode.NEXT);
                }
                catch (DatabaseException DBE) {
                    ok = false;
                    if (!DbInternal.advanceCursor(cursor, key, foundData)) throw DBE;
                    if (!verbose) continue;
                    out.println("Error encountered (continuing):");
                    out.println(DBE);
                    this.printErrorRecord(out, key, foundData);
                    continue;
                    return ok;
                }
            }
        }
        finally {
            if (impl != null) {
                impl.setTreeStatsAccumulator(null);
            }
            this.tree.setTreeStatsAccumulator(null);
            EnvironmentImpl.decThreadLocalReferenceCount();
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private void printErrorRecord(PrintStream out, DatabaseEntry key, DatabaseEntry data) {
        byte[] bytes = key.getData();
        StringBuffer sb = new StringBuffer("Error Key ");
        if (bytes == null) {
            sb.append("UNKNOWN");
        } else {
            CmdUtil.formatEntry(sb, bytes, false);
            sb.append(' ');
            CmdUtil.formatEntry(sb, bytes, true);
        }
        out.println(sb);
        bytes = data.getData();
        sb = new StringBuffer("Error Data ");
        if (bytes == null) {
            sb.append("UNKNOWN");
        } else {
            CmdUtil.formatEntry(sb, bytes, false);
            sb.append(' ');
            CmdUtil.formatEntry(sb, bytes, true);
        }
        out.println(sb);
    }

    public PreloadStats preload(PreloadConfig config) throws DatabaseException {
        try {
            long maxBytes = config.getMaxBytes();
            long maxMillisecs = config.getMaxMillisecs();
            long targetTime = Long.MAX_VALUE;
            if (maxMillisecs > 0L) {
                targetTime = System.currentTimeMillis() + maxMillisecs;
            }
            long cacheBudget = this.envImpl.getMemoryBudget().getCacheBudget();
            if (maxBytes == 0L) {
                maxBytes = cacheBudget;
            } else if (maxBytes > cacheBudget) {
                throw new IllegalArgumentException("maxBytes parameter to Database.preload() was specified as " + maxBytes + " bytes \nbut the cache is only " + cacheBudget + " bytes.");
            }
            PreloadStats ret = new PreloadStats();
            PreloadProcessor callback = new PreloadProcessor(this.envImpl, maxBytes, targetTime, ret);
            PreloadLSNTreeWalker walker = new PreloadLSNTreeWalker(this, callback, config);
            try {
                ((SortedLSNTreeWalker)walker).walk();
            }
            catch (HaltPreloadException HPE) {
                ret.status = HPE.getStatus();
            }
            if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                throw new AssertionError();
            }
            return ret;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    public long count() throws DatabaseException {
        try {
            PreloadStats ret = new PreloadStats();
            CountProcessor callback = new CountProcessor(this.envImpl, ret);
            CountExceptionPredicate excPredicate = new CountExceptionPredicate();
            SortedLSNTreeWalker walker = new SortedLSNTreeWalker(this, false, false, this.tree.getRootLsn(), callback, null, excPredicate);
            walker.setProcessDupTree(false);
            if (this.deferredWrite) {
                walker.setPassNullLSNNodes(true);
            }
            walker.walk();
            if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                throw new AssertionError();
            }
            return ret.nLNsLoaded;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    public String dumpString(int nSpaces) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<database id=\"");
        sb.append(this.id.toString());
        sb.append("\"");
        if (this.btreeComparator != null) {
            sb.append(" btc=\"");
            sb.append(DatabaseImpl.getComparatorClassName(this.btreeComparator));
            sb.append("\"");
        }
        if (this.duplicateComparator != null) {
            sb.append(" dupc=\"");
            sb.append(DatabaseImpl.getComparatorClassName(this.duplicateComparator));
            sb.append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    public int getLogSize() {
        return this.id.getLogSize() + this.tree.getLogSize() + LogUtils.getBooleanLogSize() + LogUtils.getByteArrayLogSize(this.btreeComparatorBytes) + LogUtils.getByteArrayLogSize(this.duplicateComparatorBytes) + LogUtils.getIntLogSize() * 2;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        this.id.writeToLog(logBuffer);
        this.tree.writeToLog(logBuffer);
        LogUtils.writeBoolean(logBuffer, this.duplicatesAllowed);
        LogUtils.writeByteArray(logBuffer, this.btreeComparatorBytes);
        LogUtils.writeByteArray(logBuffer, this.duplicateComparatorBytes);
        LogUtils.writeInt(logBuffer, this.maxMainTreeEntriesPerNode);
        LogUtils.writeInt(logBuffer, this.maxDupTreeEntriesPerNode);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        this.id.readFromLog(itemBuffer, entryTypeVersion);
        this.tree.readFromLog(itemBuffer, entryTypeVersion);
        this.duplicatesAllowed = LogUtils.readBoolean(itemBuffer);
        if (entryTypeVersion >= 2) {
            this.btreeComparatorBytes = LogUtils.readByteArray(itemBuffer);
            this.duplicateComparatorBytes = LogUtils.readByteArray(itemBuffer);
        } else {
            String btreeClassName = LogUtils.readString(itemBuffer);
            String dupClassName = LogUtils.readString(itemBuffer);
            this.btreeComparatorBytes = btreeClassName.length() == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : DatabaseImpl.objectToBytes(btreeClassName, "Btree");
            this.duplicateComparatorBytes = dupClassName.length() == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : DatabaseImpl.objectToBytes(dupClassName, "Duplicate");
        }
        if (!EnvironmentImpl.getNoComparators()) {
            try {
                Class<?> cls;
                Object obj;
                if (this.btreeComparatorBytes.length != 0) {
                    obj = DatabaseImpl.bytesToObject(this.btreeComparatorBytes, "Btree");
                    if (obj instanceof String) {
                        cls = Class.forName((String)obj);
                        this.btreeComparator = DatabaseImpl.instantiateComparator(cls, "Btree");
                        this.btreeComparatorByClassName = true;
                    } else if (obj instanceof Comparator) {
                        this.btreeComparator = (Comparator)obj;
                        this.btreeComparatorByClassName = false;
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError((Object)obj.getClass().getName());
                    }
                } else {
                    this.btreeComparator = null;
                    this.btreeComparatorByClassName = false;
                }
                if (this.duplicateComparatorBytes.length != 0) {
                    obj = DatabaseImpl.bytesToObject(this.duplicateComparatorBytes, "Duplicate");
                    if (obj instanceof String) {
                        cls = Class.forName((String)obj);
                        this.duplicateComparator = DatabaseImpl.instantiateComparator(cls, "Duplicate");
                        this.duplicateComparatorByClassName = true;
                    } else if (obj instanceof Comparator) {
                        this.duplicateComparator = (Comparator)obj;
                        this.duplicateComparatorByClassName = false;
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError((Object)obj.getClass().getName());
                    }
                } else {
                    this.duplicateComparator = null;
                    this.duplicateComparatorByClassName = false;
                }
            }
            catch (ClassNotFoundException CNFE) {
                throw new LogException("couldn't instantiate class comparator", CNFE);
            }
        }
        if (entryTypeVersion >= 1) {
            this.maxMainTreeEntriesPerNode = LogUtils.readInt(itemBuffer);
            this.maxDupTreeEntriesPerNode = LogUtils.readInt(itemBuffer);
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<database>");
        this.id.dumpLog(sb, verbose);
        this.tree.dumpLog(sb, verbose);
        sb.append("<dupsort v=\"").append(this.duplicatesAllowed);
        sb.append("\"/>");
        sb.append("<btcf name=\"");
        sb.append(DatabaseImpl.getComparatorClassName(this.btreeComparator));
        sb.append("\"/>");
        sb.append("<dupcf name=\"");
        sb.append(DatabaseImpl.getComparatorClassName(this.duplicateComparator));
        sb.append("\"/>");
        sb.append("</database>");
    }

    public long getTransactionId() {
        return 0L;
    }

    private static String getComparatorClassName(Comparator comparator) {
        if (comparator != null) {
            return comparator.getClass().getName();
        }
        return "";
    }

    public static Comparator instantiateComparator(Class comparator, String comparatorType) throws LogException {
        if (comparator == null) {
            return null;
        }
        try {
            return (Comparator)comparator.newInstance();
        }
        catch (InstantiationException IE) {
            throw new LogException("Exception while trying to load " + comparatorType + " Comparator class: " + IE);
        }
        catch (IllegalAccessException IAE) {
            throw new LogException("Exception while trying to load " + comparatorType + " Comparator class: " + IAE);
        }
    }

    public static Comparator instantiateComparator(Comparator comparator, String comparatorType) throws DatabaseException {
        if (comparator == null) {
            return null;
        }
        return (Comparator)DatabaseImpl.bytesToObject(DatabaseImpl.objectToBytes(comparator, comparatorType), comparatorType);
    }

    private static byte[] comparatorToBytes(Comparator comparator, boolean byClassName, String comparatorType) throws DatabaseException {
        if (comparator == null) {
            return LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        }
        Object obj = byClassName ? comparator.getClass().getName() : comparator;
        return DatabaseImpl.objectToBytes(obj, comparatorType);
    }

    public static byte[] objectToBytes(Object obj, String comparatorType) throws LogException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new LogException("Exception while trying to load " + comparatorType + ": " + e);
        }
    }

    private static Object bytesToObject(byte[] bytes, String comparatorType) throws LogException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException e) {
            throw new LogException("Exception while trying to load " + comparatorType + ": " + e);
        }
        catch (ClassNotFoundException e) {
            throw new LogException("Exception while trying to load " + comparatorType + ": " + e);
        }
    }

    public int getBinDeltaPercent() {
        return this.binDeltaPercent;
    }

    public int getBinMaxDeltas() {
        return this.binMaxDeltas;
    }

    static {
        $assertionsDisabled = !DatabaseImpl.class.desiredAssertionStatus();
        TIME_EXCEEDED_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.EXCEEDED_TIME);
        MEMORY_EXCEEDED_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.FILLED_CACHE);
    }

    private static class CountExceptionPredicate
    implements SortedLSNTreeWalker.ExceptionPredicate {
        private CountExceptionPredicate() {
        }

        public boolean ignoreException(Exception e) {
            return e instanceof LogFileNotFoundException;
        }
    }

    private static class CountProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private EnvironmentImpl envImpl;
        private PreloadStats stats;

        CountProcessor(EnvironmentImpl envImpl, PreloadStats stats) {
            this.envImpl = envImpl;
            this.stats = stats;
        }

        public void processLSN(long childLsn, LogEntryType childType, Node ignore, byte[] ignore2) throws DatabaseException {
            if (childType.equals(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_DUPCOUNTLN)) {
                long dupCount = 0L;
                DupCountLN dcl = (DupCountLN)this.envImpl.getLogManager().get(childLsn);
                dupCount = dcl.getDupCount();
                this.stats.nLNsLoaded = (int)((long)this.stats.nLNsLoaded + dupCount);
            } else if (childType.equals(LogEntryType.LOG_LN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_LN)) {
                ++this.stats.nLNsLoaded;
            }
        }

        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) throws DatabaseException {
        }

        public void processDupCount(long count) {
            this.stats.nLNsLoaded = (int)((long)this.stats.nLNsLoaded + count);
        }
    }

    private static class PreloadLSNTreeWalker
    extends SortedLSNTreeWalker {
        private Map lsnINMap = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        PreloadLSNTreeWalker(DatabaseImpl db, SortedLSNTreeWalker.TreeNodeProcessor callback, PreloadConfig conf) throws DatabaseException {
            super(db, false, false, db.tree.getRootLsn(), callback, null, null);
            this.accumulateLNs = conf.getLoadLNs();
        }

        public void walk() throws DatabaseException {
            PreloadWithRootLatched preloadWRL = new PreloadWithRootLatched();
            this.dbImpl.getTree().withRootLatchedExclusive(preloadWRL);
        }

        protected IN getRootIN(long rootLsn) throws DatabaseException {
            return this.dbImpl.getTree().getRootIN(false);
        }

        protected void releaseRootIN(IN root) throws DatabaseException {
            root.releaseLatch();
        }

        protected void addToLsnINMap(Long lsn, IN in, int index) {
            if (!$assertionsDisabled && in.getDatabase() == null) {
                throw new AssertionError();
            }
            this.lsnINMap.put(lsn, new INEntry(in, index));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Node fetchLSN(long lsn, DatabaseEntry lnKeyEntry) throws DatabaseException {
            INEntry inEntry = (INEntry)this.lsnINMap.remove(new Long(lsn));
            if (!$assertionsDisabled && inEntry == null) {
                throw new AssertionError();
            }
            IN in = inEntry.in;
            in.latch();
            try {
                int index = inEntry.index;
                if (in.isEntryKnownDeleted(index) || in.getLsn(index) != lsn) {
                    Node node = null;
                    return node;
                }
                Node node = in.fetchTarget(index);
                return node;
            }
            finally {
                in.releaseLatch();
            }
        }

        static {
            $assertionsDisabled = !(class$com$sleepycat$je$dbi$DatabaseImpl == null ? (class$com$sleepycat$je$dbi$DatabaseImpl = DatabaseImpl.class$("com.sleepycat.je.dbi.DatabaseImpl")) : class$com$sleepycat$je$dbi$DatabaseImpl).desiredAssertionStatus();
        }

        private final class PreloadWithRootLatched
        implements WithRootLatched {
            private PreloadWithRootLatched() {
            }

            public IN doWork(ChildReference root) throws DatabaseException {
                PreloadLSNTreeWalker.this.walkInternal();
                return null;
            }
        }

        private static class INEntry {
            IN in;
            int index;

            INEntry(IN in, int index) {
                this.in = in;
                this.index = index;
            }
        }
    }

    private static class PreloadProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private EnvironmentImpl envImpl;
        private long maxBytes;
        private long targetTime;
        private PreloadStats stats;
        static final /* synthetic */ boolean $assertionsDisabled;

        PreloadProcessor(EnvironmentImpl envImpl, long maxBytes, long targetTime, PreloadStats stats) {
            this.envImpl = envImpl;
            this.maxBytes = maxBytes;
            this.targetTime = targetTime;
            this.stats = stats;
        }

        public void processLSN(long childLsn, LogEntryType childType, Node ignore, byte[] ignore2) throws DatabaseException {
            if (!$assertionsDisabled && childLsn == -1L) {
                throw new AssertionError();
            }
            if (System.currentTimeMillis() > this.targetTime) {
                throw TIME_EXCEEDED_PRELOAD_EXCEPTION;
            }
            if (this.envImpl.getMemoryBudget().getCacheMemoryUsage() > this.maxBytes) {
                throw MEMORY_EXCEEDED_PRELOAD_EXCEPTION;
            }
            if (childType.equals(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_DUPCOUNTLN)) {
                ++this.stats.nDupCountLNsLoaded;
            } else if (childType.equals(LogEntryType.LOG_LN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_LN)) {
                ++this.stats.nLNsLoaded;
            } else if (childType.equals(LogEntryType.LOG_DBIN)) {
                ++this.stats.nDBINsLoaded;
            } else if (childType.equals(LogEntryType.LOG_BIN)) {
                ++this.stats.nBINsLoaded;
            } else if (childType.equals(LogEntryType.LOG_DIN)) {
                ++this.stats.nDINsLoaded;
            } else if (childType.equals(LogEntryType.LOG_IN)) {
                ++this.stats.nINsLoaded;
            }
        }

        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) throws DatabaseException {
        }

        public void processDupCount(long ignore) {
        }

        static {
            $assertionsDisabled = !(class$com$sleepycat$je$dbi$DatabaseImpl == null ? (class$com$sleepycat$je$dbi$DatabaseImpl = DatabaseImpl.class$("com.sleepycat.je.dbi.DatabaseImpl")) : class$com$sleepycat$je$dbi$DatabaseImpl).desiredAssertionStatus();
        }
    }

    private static class HaltPreloadException
    extends RuntimeException {
        private PreloadStatus status;

        HaltPreloadException(PreloadStatus status) {
            super(status.toString());
            this.status = status;
        }

        PreloadStatus getStatus() {
            return this.status;
        }
    }

    static class StatsAccumulator
    implements TreeWalkerStatsAccumulator {
        private Set inNodeIdsSeen = new HashSet();
        private Set binNodeIdsSeen = new HashSet();
        private Set dinNodeIdsSeen = new HashSet();
        private Set dbinNodeIdsSeen = new HashSet();
        private Set dupCountLNsSeen = new HashSet();
        private long[] insSeenByLevel = null;
        private long[] binsSeenByLevel = null;
        private long[] dinsSeenByLevel = null;
        private long[] dbinsSeenByLevel = null;
        private long lnCount = 0L;
        private long deletedLNCount = 0L;
        private int mainTreeMaxDepth = 0;
        private int duplicateTreeMaxDepth = 0;
        private DatabaseStats useStats;
        PrintStream progressStream;
        int progressInterval;
        private static final int MAX_LEVELS = 100;

        StatsAccumulator(PrintStream progressStream, int progressInterval, DatabaseStats useStats) {
            this.progressStream = progressStream;
            this.progressInterval = progressInterval;
            this.insSeenByLevel = new long[100];
            this.binsSeenByLevel = new long[100];
            this.dinsSeenByLevel = new long[100];
            this.dbinsSeenByLevel = new long[100];
            this.useStats = useStats;
        }

        void verifyNode(Node node) {
        }

        public void processIN(IN node, Long nid, int level) {
            if (this.inNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.insSeenByLevel);
                this.verifyNode(node);
            }
        }

        public void processBIN(BIN node, Long nid, int level) {
            if (this.binNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.binsSeenByLevel);
                this.verifyNode(node);
            }
        }

        public void processDIN(DIN node, Long nid, int level) {
            if (this.dinNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.dinsSeenByLevel);
                this.verifyNode(node);
            }
        }

        public void processDBIN(DBIN node, Long nid, int level) {
            if (this.dbinNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.dbinsSeenByLevel);
                this.verifyNode(node);
            }
        }

        public void processDupCountLN(DupCountLN node, Long nid) {
            this.dupCountLNsSeen.add(nid);
            this.verifyNode(node);
        }

        private void tallyLevel(int levelArg, long[] nodesSeenByLevel) {
            int level = levelArg;
            if (level >= 131072) {
                return;
            }
            if (level >= 65536) {
                if ((level &= 0xFFFEFFFF) > this.mainTreeMaxDepth) {
                    this.mainTreeMaxDepth = level;
                }
            } else if (level > this.duplicateTreeMaxDepth) {
                this.duplicateTreeMaxDepth = level;
            }
            int n = level;
            nodesSeenByLevel[n] = nodesSeenByLevel[n] + 1L;
        }

        public void incrementLNCount() {
            ++this.lnCount;
            if (this.progressInterval != 0 && this.lnCount % (long)this.progressInterval == 0L) {
                this.copyToStats(this.useStats);
                this.progressStream.println(this.useStats);
            }
        }

        public void incrementDeletedLNCount() {
            ++this.deletedLNCount;
        }

        Set getINNodeIdsSeen() {
            return this.inNodeIdsSeen;
        }

        Set getBINNodeIdsSeen() {
            return this.binNodeIdsSeen;
        }

        Set getDINNodeIdsSeen() {
            return this.dinNodeIdsSeen;
        }

        Set getDBINNodeIdsSeen() {
            return this.dbinNodeIdsSeen;
        }

        long[] getINsByLevel() {
            return this.insSeenByLevel;
        }

        long[] getBINsByLevel() {
            return this.binsSeenByLevel;
        }

        long[] getDINsByLevel() {
            return this.dinsSeenByLevel;
        }

        long[] getDBINsByLevel() {
            return this.dbinsSeenByLevel;
        }

        long getLNCount() {
            return this.lnCount;
        }

        Set getDupCountLNCount() {
            return this.dupCountLNsSeen;
        }

        long getDeletedLNCount() {
            return this.deletedLNCount;
        }

        int getMainTreeMaxDepth() {
            return this.mainTreeMaxDepth;
        }

        int getDuplicateTreeMaxDepth() {
            return this.duplicateTreeMaxDepth;
        }

        private void copyToStats(DatabaseStats stats) {
            BtreeStats bStats = (BtreeStats)stats;
            bStats.setInternalNodeCount(this.getINNodeIdsSeen().size());
            bStats.setBottomInternalNodeCount(this.getBINNodeIdsSeen().size());
            bStats.setDuplicateInternalNodeCount(this.getDINNodeIdsSeen().size());
            bStats.setDuplicateBottomInternalNodeCount(this.getDBINNodeIdsSeen().size());
            bStats.setLeafNodeCount(this.getLNCount());
            bStats.setDeletedLeafNodeCount(this.getDeletedLNCount());
            bStats.setDupCountLeafNodeCount(this.getDupCountLNCount().size());
            bStats.setMainTreeMaxDepth(this.getMainTreeMaxDepth());
            bStats.setDuplicateTreeMaxDepth(this.getDuplicateTreeMaxDepth());
            bStats.setINsByLevel(this.getINsByLevel());
            bStats.setBINsByLevel(this.getBINsByLevel());
            bStats.setDINsByLevel(this.getDINsByLevel());
            bStats.setDBINsByLevel(this.getDBINsByLevel());
        }
    }

    private static class ObsoleteProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private UtilizationTracker tracker;
        static final /* synthetic */ boolean $assertionsDisabled;

        ObsoleteProcessor(UtilizationTracker tracker) {
            this.tracker = tracker;
        }

        public void processLSN(long childLsn, LogEntryType childType, Node node, byte[] lnKey) throws DatabaseException {
            if (!$assertionsDisabled && childLsn == -1L) {
                throw new AssertionError();
            }
            int size = 0;
            if (lnKey != null && node instanceof LN) {
                LN ln = (LN)node;
                size = ln.getLastLoggedSize();
            }
            this.tracker.countObsoleteNodeInexact(childLsn, childType, size);
        }

        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) throws DatabaseException {
            if (!$assertionsDisabled && ln == null) {
                throw new AssertionError();
            }
            this.tracker.countObsoleteNodeInexact(childLsn, ln.getLogType(), 0);
        }

        public void processDupCount(long ignore) {
        }

        static {
            $assertionsDisabled = !(class$com$sleepycat$je$dbi$DatabaseImpl == null ? (class$com$sleepycat$je$dbi$DatabaseImpl = DatabaseImpl.class$("com.sleepycat.je.dbi.DatabaseImpl")) : class$com$sleepycat$je$dbi$DatabaseImpl).desiredAssertionStatus();
        }
    }

    private static class ObsoleteTreeWalker
    extends SortedLSNTreeWalker {
        private ObsoleteTreeWalker(DatabaseImpl dbImpl, long rootLsn, boolean fetchLNSize, SortedLSNTreeWalker.TreeNodeProcessor callback) throws DatabaseException {
            super(dbImpl, true, true, rootLsn, callback, null, null);
            this.accumulateLNs = fetchLNSize;
        }
    }
}

