/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.local;

import com.noelios.restlet.local.Entity;
import com.noelios.restlet.local.LocalClientHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.restlet.Client;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.Variant;
import org.restlet.service.MetadataService;

public abstract class EntityClientHelper
extends LocalClientHelper {
    public EntityClientHelper(Client client) {
        super(client);
    }

    public Reference createReference(String scheme, String encodedParentDirPath, String encodedEntityName, String decodedVariantName) {
        Reference result = new Reference(scheme + "://" + encodedParentDirPath + "/" + this.getReencodedVariantEntityName(encodedEntityName, decodedVariantName));
        return result;
    }

    public abstract Entity getEntity(String var1);

    protected String getReencodedVariantEntityName(String encodedEntityName, String decodedVariantEntityName) {
        int i = 0;
        int j = 0;
        boolean stop = false;
        char[] encodeds = encodedEntityName.toCharArray();
        char[] decodeds = decodedVariantEntityName.toCharArray();
        for (i = 0; i < decodeds.length && j < encodeds.length && !stop; ++i) {
            String dec;
            char decodedChar = decodeds[i];
            char encodedChar = encodeds[j];
            if (encodedChar == '%') {
                dec = Reference.decode((String)encodedEntityName.substring(j, j + 3));
                if (decodedChar == dec.charAt(0)) {
                    j += 3;
                    continue;
                }
                stop = true;
                continue;
            }
            if (decodedChar == encodedChar) {
                ++j;
                continue;
            }
            dec = Reference.decode((String)encodedEntityName.substring(j, j + 1));
            if (decodedChar == dec.charAt(0)) {
                ++j;
                continue;
            }
            stop = true;
        }
        if (stop) {
            return encodedEntityName.substring(0, j) + decodedVariantEntityName.substring(i - 1);
        }
        if (j == encodedEntityName.length()) {
            return encodedEntityName.substring(0, j) + decodedVariantEntityName.substring(i);
        }
        return encodedEntityName.substring(0, j - 1);
    }

    public void handle(Request request, Response response) {
        request.getResourceRef().normalize();
        String path = request.getResourceRef().getPath();
        String decodedPath = Reference.decode((String)path);
        MetadataService metadataService = this.getMetadataService(request);
        this.handleEntity(request, response, path, decodedPath, metadataService);
    }

    protected void handleEntity(Request request, Response response, String path, String decodedPath, MetadataService metadataService) {
        if (Method.GET.equals((Object)request.getMethod()) || Method.HEAD.equals((Object)request.getMethod())) {
            this.handleEntityGet(request, response, path, this.getEntity(decodedPath), metadataService);
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
        }
    }

    protected void handleEntityGet(Request request, Response response, String path, Entity entity, MetadataService metadataService) {
        Representation output = null;
        boolean found = false;
        Iterator iterator = request.getClientInfo().getAcceptedMediaTypes().iterator();
        while (iterator.hasNext() && !found) {
            Preference pref = (Preference)iterator.next();
            found = ((MediaType)pref.getMetadata()).equals((Object)MediaType.TEXT_URI_LIST);
        }
        if (found) {
            List<Entity> entities;
            String baseName = entity.getBaseName(metadataService);
            Entity parent = entity.getParent();
            if (parent != null && (entities = parent.getChildren()) != null) {
                ReferenceList rl = new ReferenceList(entities.size());
                String scheme = request.getResourceRef().getScheme();
                String encodedParentDirectoryURI = path.substring(0, path.lastIndexOf("/"));
                String encodedEntityName = path.substring(path.lastIndexOf("/") + 1);
                for (Entity entry : entities) {
                    if (!baseName.equals(entry.getBaseName(metadataService))) continue;
                    rl.add((Object)this.createReference(scheme, encodedParentDirectoryURI, encodedEntityName, entry.getName()));
                }
                output = rl.getTextRepresentation();
            }
        } else if (entity.exists()) {
            if (entity.isDirectory()) {
                List<Entity> children = entity.getChildren();
                ReferenceList rl = new ReferenceList(children.size());
                String directoryUri = request.getResourceRef().toString();
                if (!directoryUri.endsWith("/")) {
                    directoryUri = directoryUri + "/";
                }
                for (Entity entry : children) {
                    rl.add(directoryUri + Reference.encode((String)entry.getName()));
                }
                output = rl.getTextRepresentation();
            } else {
                output = entity.getRepresentation(metadataService.getDefaultMediaType(), this.getTimeToLive());
                output.setIdentifier(request.getResourceRef());
                this.updateMetadata(metadataService, entity.getName(), (Variant)output);
            }
        } else {
            List<Entity> files;
            Entity uniqueVariant = null;
            String baseName = entity.getBaseName(metadataService);
            Collection<String> extensions = entity.getExtensions(metadataService);
            Entity parent = entity.getParent();
            if (parent != null && (files = parent.getChildren()) != null) {
                for (Entity entry : files) {
                    Collection<String> entryExtensions;
                    if (!baseName.equals(entry.getBaseName(metadataService)) || !(entryExtensions = entry.getExtensions(metadataService)).containsAll(extensions) || !extensions.containsAll(entryExtensions)) continue;
                    uniqueVariant = entry;
                    break;
                }
            }
            if (uniqueVariant != null) {
                output = uniqueVariant.getRepresentation(metadataService.getDefaultMediaType(), this.getTimeToLive());
                output.setIdentifier(request.getResourceRef());
                this.updateMetadata(metadataService, entity.getName(), (Variant)output);
            }
        }
        if (output == null) {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        } else {
            output.setIdentifier(request.getResourceRef());
            response.setEntity(output);
            response.setStatus(Status.SUCCESS_OK);
        }
    }
}

