/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.local;

import com.noelios.restlet.local.FileClientHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Variant;

public class WarClientHelper
extends FileClientHelper {
    private boolean restrict;
    private String warPath;
    private boolean webAppArchive;
    private List<String> warEntries;

    public WarClientHelper(Client client) {
        super(client);
        this.getProtocols().clear();
        this.getProtocols().add(Protocol.WAR);
        this.restrict = false;
        this.warPath = null;
        this.webAppArchive = false;
        this.warEntries = null;
    }

    public void handle(Request request, Response response) {
        String scheme = request.getResourceRef().getScheme();
        request.getResourceRef().normalize();
        if (!scheme.equalsIgnoreCase("war")) {
            throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only WAR is supported.");
        }
        this.handleWar(request, response);
    }

    protected void handleWar(Request request, Response response) {
        block12: {
            if (this.webAppArchive) {
                try {
                    String path = request.getResourceRef().getPath();
                    JarFile war = new JarFile(this.getWarPath());
                    JarEntry entry = war.getJarEntry(path);
                    if (entry.isDirectory()) {
                        if (this.warEntries == null) {
                            this.warEntries = new ArrayList<String>();
                            Enumeration<JarEntry> entries = war.entries();
                            while (entries.hasMoreElements()) {
                                this.warEntries.add(entries.nextElement().getName());
                            }
                        }
                        ReferenceList rl = new ReferenceList();
                        rl.setIdentifier(request.getResourceRef());
                        for (String warEntry : this.warEntries) {
                            if (!warEntry.startsWith(path)) continue;
                            rl.add((Object)new Reference(warEntry));
                        }
                        response.setEntity(rl.getTextRepresentation());
                        response.setStatus(Status.SUCCESS_OK);
                        break block12;
                    }
                    InputRepresentation output = new InputRepresentation(war.getInputStream(entry), null);
                    this.updateMetadata(this.getMetadataService(request), path, (Variant)output);
                    output.setIdentifier(request.getResourceRef());
                    response.setEntity((Representation)output);
                    response.setStatus(Status.SUCCESS_OK);
                }
                catch (IOException e) {
                    this.getLogger().log(Level.WARNING, "Unable to access to the WAR file", e);
                    response.setStatus(Status.SERVER_ERROR_INTERNAL);
                }
            } else {
                String path = request.getResourceRef().getPath();
                if (this.isRestrict() && path.toUpperCase().startsWith("/WEB-INF/")) {
                    this.getLogger().warning("Forbidden access to the WEB-INF directory detected. Path requested: " + path);
                    response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                } else if (this.isRestrict() && path.toUpperCase().startsWith("/META-INF/")) {
                    this.getLogger().warning("Forbidden access to the META-INF directory detected. Path requested: " + path);
                    response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                } else {
                    path = this.getWarPath() + path;
                    this.handleFile(request, response, path);
                }
            }
        }
    }

    public String getWarPath() {
        if (this.warPath == null) {
            this.warPath = this.getParameters().getFirstValue("warPath", System.getProperty("user.home") + File.separator + "restlet.war");
            File file = new File(this.warPath);
            if (file.exists()) {
                if (file.isDirectory()) {
                    this.webAppArchive = false;
                    if (this.warPath.endsWith("/")) {
                        this.warPath = this.warPath.substring(0, this.warPath.length() - 1);
                    }
                } else {
                    this.webAppArchive = true;
                }
            } else {
                this.getLogger().warning("Unable to find an existing directory or archive at: " + this.warPath);
            }
        }
        return this.warPath;
    }

    public boolean isRestrict() {
        return this.restrict;
    }

    public void setRestrict(boolean restrict) {
        this.restrict = restrict;
    }
}

