/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet;

import com.noelios.restlet.ConnectorHelper;
import com.noelios.restlet.application.ApplicationHelper;
import com.noelios.restlet.component.ComponentHelper;
import com.noelios.restlet.local.DirectoryResource;
import com.noelios.restlet.util.FormUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Directory;
import org.restlet.Server;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.Variant;
import org.restlet.util.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine
extends org.restlet.util.Engine {
    private static Logger logger = Logger.getLogger(Engine.class.getCanonicalName());
    public static final String VERSION = "1.0.5";
    public static final String VERSION_HEADER = "Noelios-Restlet-Engine/1.0.5";
    private List<ConnectorHelper> registeredClients;
    private List<ConnectorHelper> registeredServers;

    public static void register() {
        Engine.setInstance((org.restlet.util.Engine)new Engine());
    }

    public Engine() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Engine(boolean discoverConnectors) {
        if (discoverConnectors) {
            Class<?> providerClass;
            BufferedReader reader;
            URL configURL;
            Enumeration<URL> configUrls;
            String line = null;
            String provider = null;
            ClassLoader cl = org.restlet.util.Engine.getClassLoader();
            try {
                configUrls = cl.getResources("META-INF/services/com.noelios.restlet.ClientHelper");
                while (configUrls.hasMoreElements()) {
                    configURL = configUrls.nextElement();
                    reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(configURL.openStream(), "utf-8"));
                        line = reader.readLine();
                        while (line != null) {
                            provider = this.getProviderClassName(line);
                            if (provider != null && !provider.equals("")) {
                                try {
                                    providerClass = Class.forName(provider);
                                    this.getRegisteredClients().add((ConnectorHelper)((Object)providerClass.getConstructor(Client.class).newInstance(new Object[]{null})));
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Unable to register the client connector " + provider, e);
                                }
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Unable to read the provider descriptor: " + configURL.toString());
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Exception while detecting the client connectors.", ioe);
            }
            try {
                configUrls = cl.getResources("META-INF/services/com.noelios.restlet.ServerHelper");
                while (configUrls.hasMoreElements()) {
                    configURL = configUrls.nextElement();
                    reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(configURL.openStream(), "utf-8"));
                        line = reader.readLine();
                        while (line != null) {
                            provider = this.getProviderClassName(line);
                            if (provider != null && !provider.equals("")) {
                                try {
                                    providerClass = Class.forName(provider);
                                    this.getRegisteredServers().add((ConnectorHelper)((Object)providerClass.getConstructor(Server.class).newInstance(new Object[]{null})));
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Unable to register the server connector " + provider, e);
                                }
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Unable to read the provider descriptor: " + configURL.toString());
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Exception while detecting the client connectors.", ioe);
            }
        }
    }

    public List<ConnectorHelper> getRegisteredClients() {
        if (this.registeredClients == null) {
            this.registeredClients = new ArrayList<ConnectorHelper>();
        }
        return this.registeredClients;
    }

    public List<ConnectorHelper> getRegisteredServers() {
        if (this.registeredServers == null) {
            this.registeredServers = new ArrayList<ConnectorHelper>();
        }
        return this.registeredServers;
    }

    public Resource createDirectoryResource(Directory handler, Request request, Response response) throws IOException {
        return new DirectoryResource(handler, request, response);
    }

    public Helper createHelper(Application application, Context parentContext) {
        return new ApplicationHelper(application, parentContext);
    }

    public Helper createHelper(Client client) {
        Helper result = null;
        if (client.getProtocols().size() > 0) {
            ConnectorHelper connector = null;
            Iterator<ConnectorHelper> iter = this.getRegisteredClients().iterator();
            while (result == null && iter.hasNext()) {
                connector = iter.next();
                if (!connector.getProtocols().containsAll(client.getProtocols())) continue;
                try {
                    result = (Helper)((Object)((Object)connector)).getClass().getConstructor(Client.class).newInstance(client);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while instantiation the client connector.", e);
                }
            }
            if (result == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No available client connector supports the required protocols: ");
                for (Protocol p : client.getProtocols()) {
                    sb.append(p.getName()).append(" ");
                }
                sb.append(". Please add the JAR of a matching connector to your classpath.");
                logger.log(Level.WARNING, sb.toString());
            }
        }
        return result;
    }

    public Helper createHelper(Component component) {
        return new ComponentHelper(component);
    }

    public Helper createHelper(Server server) {
        Helper result = null;
        if (server.getProtocols().size() > 0) {
            ConnectorHelper connector = null;
            Iterator<ConnectorHelper> iter = this.getRegisteredServers().iterator();
            while (result == null && iter.hasNext()) {
                connector = iter.next();
                if (!connector.getProtocols().containsAll(server.getProtocols())) continue;
                try {
                    result = (Helper)((Object)((Object)connector)).getClass().getConstructor(Server.class).newInstance(server);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while instantiation the server connector.", e);
                }
            }
            if (result == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No available server connector supports the required protocols: ");
                for (Protocol p : server.getProtocols()) {
                    sb.append(p.getName()).append(" ");
                }
                sb.append(". Please add the JAR of a matching connector to your classpath.");
                logger.log(Level.WARNING, sb.toString());
            }
        }
        return result;
    }

    public static int getJavaMajorVersion() {
        int result;
        String javaVersion = System.getProperty("java.version");
        try {
            result = Integer.parseInt(javaVersion.substring(0, javaVersion.indexOf(".")));
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public static int getJavaMinorVersion() {
        int result;
        String javaVersion = System.getProperty("java.version");
        try {
            result = Integer.parseInt(javaVersion.split("\\.")[1]);
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public static int getJavaUpdateVersion() {
        int result;
        String javaVersion = System.getProperty("java.version");
        try {
            result = Integer.parseInt(javaVersion.substring(javaVersion.indexOf(95) + 1));
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public Variant getPreferredVariant(ClientInfo client, List<Variant> variants, Language defaultLanguage) {
        Language language;
        ArrayList<Object> list;
        if (variants == null) {
            return null;
        }
        List variantLanguages = null;
        MediaType variantMediaType = null;
        boolean compatibleLanguage = false;
        boolean compatibleMediaType = false;
        Variant currentVariant22 = null;
        Variant bestVariant = null;
        Preference currentLanguagePref = null;
        Preference bestLanguagePref = null;
        Preference currentMediaTypePref = null;
        Preference bestMediaTypePref = null;
        float bestQuality = 0.0f;
        float bestLanguageScore = 0.0f;
        float bestMediaTypeScore = 0.0f;
        ArrayList<Object> languagePrefs = client.getAcceptedLanguages();
        ArrayList<Preference> primaryLanguagePrefs = new ArrayList<Preference>();
        Preference defaultLanguagePref = defaultLanguage == null ? null : new Preference((Metadata)defaultLanguage, 0.003f);
        Preference allLanguagesPref = new Preference((Metadata)Language.ALL, 0.001f);
        if (languagePrefs.isEmpty()) {
            languagePrefs.add(new Preference((Metadata)Language.ALL));
        } else {
            list = new ArrayList<Object>();
            for (Preference preference : languagePrefs) {
                language = (Language)preference.getMetadata();
                if (language.getSubTags().isEmpty() || list.contains(language.getPrimaryTag())) continue;
                list.add(language.getPrimaryTag());
                primaryLanguagePrefs.add(new Preference((Metadata)new Language(language.getPrimaryTag()), 0.005f + 0.001f * preference.getQuality()));
            }
            if (defaultLanguage != null && !defaultLanguage.getSubTags().isEmpty() && !list.contains(defaultLanguage.getPrimaryTag())) {
                primaryLanguagePrefs.add(new Preference((Metadata)new Language(defaultLanguage.getPrimaryTag()), 0.002f));
            }
        }
        languagePrefs.addAll(primaryLanguagePrefs);
        if (defaultLanguagePref != null) {
            languagePrefs.add(defaultLanguagePref);
            list = new ArrayList();
            for (Preference preference : languagePrefs) {
                language = (Language)preference.getMetadata();
                if (language.equals((Object)Language.ALL)) continue;
                list.add(preference);
            }
            languagePrefs = list;
        }
        languagePrefs.add(allLanguagesPref);
        for (Variant currentVariant22 : variants) {
            variantLanguages = currentVariant22.getLanguages();
            variantMediaType = currentVariant22.getMediaType();
            for (Language language2 : variantLanguages) {
                Iterator iter2 = languagePrefs.iterator();
                while (language2 != null && iter2.hasNext()) {
                    currentLanguagePref = (Preference)iter2.next();
                    float currentScore = this.getScore(language2, (Language)currentLanguagePref.getMetadata());
                    boolean compatiblePref = currentScore != -1.0f;
                    if (!compatiblePref || bestLanguagePref != null && !(currentScore > bestLanguageScore)) continue;
                    bestLanguagePref = currentLanguagePref;
                    bestLanguageScore = currentScore;
                }
            }
            compatibleLanguage = variantLanguages.isEmpty() || bestLanguagePref != null;
            List mediaTypePrefs = client.getAcceptedMediaTypes();
            if (mediaTypePrefs.size() == 0) {
                mediaTypePrefs.add(new Preference((Metadata)MediaType.ALL));
            }
            Iterator iterator = mediaTypePrefs.iterator();
            while (compatibleLanguage && iterator.hasNext()) {
                currentMediaTypePref = (Preference)iterator.next();
                float currentScore = this.getScore(variantMediaType, (MediaType)currentMediaTypePref.getMetadata());
                boolean compatiblePref = currentScore != -1.0f;
                if (!compatiblePref || bestMediaTypePref != null && !(currentScore > bestMediaTypeScore)) continue;
                bestMediaTypePref = currentMediaTypePref;
                bestMediaTypeScore = currentScore;
            }
            boolean bl = compatibleMediaType = variantMediaType == null || bestMediaTypePref != null;
            if (compatibleLanguage && compatibleMediaType) {
                float f = 0.0f;
                if (bestLanguagePref != null) {
                    f += bestLanguagePref.getQuality() * 10.0f;
                } else if (!variantLanguages.isEmpty()) {
                    f += 1.0f;
                }
                if (bestMediaTypePref != null) {
                    f += bestMediaTypePref.getQuality();
                }
                if (bestVariant == null) {
                    bestVariant = currentVariant22;
                    bestQuality = f;
                } else if (f > bestQuality) {
                    bestVariant = currentVariant22;
                    bestQuality = f;
                }
            }
            bestLanguagePref = null;
            bestLanguageScore = 0.0f;
            bestMediaTypePref = null;
            bestMediaTypeScore = 0.0f;
        }
        return bestVariant;
    }

    private float getScore(Language variantLanguage, Language preferenceLanguage) {
        float score = 0.0f;
        boolean compatibleLang = true;
        if (variantLanguage.getPrimaryTag().equalsIgnoreCase(preferenceLanguage.getPrimaryTag())) {
            score += 100.0f;
        } else if (!preferenceLanguage.getPrimaryTag().equals("*")) {
            compatibleLang = false;
        } else if (!preferenceLanguage.getSubTags().isEmpty()) {
            compatibleLang = false;
        } else {
            score += 1.0f;
        }
        if (compatibleLang) {
            if (preferenceLanguage.getSubTags().isEmpty() || variantLanguage.getSubTags().isEmpty()) {
                if (variantLanguage.getSubTags().isEmpty() && preferenceLanguage.getSubTags().isEmpty()) {
                    score += 10.0f;
                }
            } else {
                int maxSize = Math.min(preferenceLanguage.getSubTags().size(), variantLanguage.getSubTags().size());
                for (int i = 0; i < maxSize && compatibleLang; ++i) {
                    if (((String)preferenceLanguage.getSubTags().get(i)).equalsIgnoreCase((String)variantLanguage.getSubTags().get(i))) {
                        score = (float)((double)score + Math.pow(10.0, 1 - i));
                        continue;
                    }
                    compatibleLang = false;
                }
            }
        }
        return compatibleLang ? score : -1.0f;
    }

    private float getScore(MediaType variantMediaType, MediaType preferenceMediaType) {
        float score = 0.0f;
        boolean comptabibleMediaType = true;
        if (preferenceMediaType.getMainType().equals(variantMediaType.getMainType())) {
            score += 1000.0f;
        } else if (!preferenceMediaType.getMainType().equals("*")) {
            comptabibleMediaType = false;
        } else if (!preferenceMediaType.getSubType().equals("*")) {
            comptabibleMediaType = false;
        }
        if (comptabibleMediaType) {
            if (variantMediaType.getSubType().equals(preferenceMediaType.getSubType())) {
                score += 100.0f;
            } else if (!preferenceMediaType.getSubType().equals("*")) {
                comptabibleMediaType = false;
            }
            if (comptabibleMediaType && variantMediaType.getParameters() != null) {
                for (Parameter currentParam : variantMediaType.getParameters()) {
                    if (!this.isParameterFound(currentParam, preferenceMediaType)) continue;
                    score += 1.0f;
                }
            }
        }
        return comptabibleMediaType ? score : -1.0f;
    }

    private String getProviderClassName(String line) {
        int index = line.indexOf(35);
        if (index != -1) {
            line = line.substring(0, index);
        }
        return line.trim();
    }

    private boolean isParameterFound(Parameter searchedParam, MediaType mediaRange) {
        boolean result = false;
        Iterator iter = mediaRange.getParameters().iterator();
        while (!result && iter.hasNext()) {
            result = searchedParam.equals((Object)((Parameter)iter.next()));
        }
        return result;
    }

    public void parse(Logger logger, Form form, Representation webForm) {
        if (webForm != null) {
            FormUtils.parsePost(logger, form, webForm);
        }
    }

    public void parse(Logger logger, Form form, String queryString, CharacterSet characterSet) {
        if (queryString != null && !queryString.equals("")) {
            FormUtils.parseQuery(logger, form, queryString, characterSet);
        }
    }
}

