/*
 * Decompiled with CFR 0.152.
 */
package com.nkstar.lsjkclient.util;

import java.util.HashMap;
import java.util.Map;

public class HtmlCharacterEntityReferences {
    static final char REFERENCE_START = '&';
    static final String DECIMAL_REFERENCE_START = "&#";
    static final String HEX_REFERENCE_START = "&#x";
    static final char REFERENCE_END = ';';
    static final char CHAR_NULL = '\uffff';
    private final String[] characterToEntityReferenceMap = new String[3000];
    private final Map<String, Character> entityReferenceToCharacterMap = new HashMap<String, Character>(252);

    private void initMap(int idx, String reference) {
        this.characterToEntityReferenceMap[idx] = '&' + reference + ';';
        this.entityReferenceToCharacterMap.put(reference, Character.valueOf((char)idx));
    }

    public HtmlCharacterEntityReferences() {
        this.initMap(160, "nbsp");
        this.initMap(34, "quot");
        this.initMap(38, "amp");
        this.initMap(39, "#39");
        this.initMap(60, "lt");
        this.initMap(62, "gt");
    }

    public int getSupportedReferenceCount() {
        return this.entityReferenceToCharacterMap.size();
    }

    public boolean isMappedToReference(char character) {
        return this.isMappedToReference(character, "ISO-8859-1");
    }

    public boolean isMappedToReference(char character, String encoding) {
        return this.convertToReference(character, encoding) != null;
    }

    public String convertToReference(char character) {
        return this.convertToReference(character, "ISO-8859-1");
    }

    public String convertToReference(char character, String encoding) {
        int index;
        String entityReference;
        if (encoding.startsWith("UTF-")) {
            switch (character) {
                case 60: {
                    return "&lt;";
                }
                case 62: {
                    return "&gt;";
                }
                case 34: {
                    return "&quot;";
                }
                case 38: {
                    return "&amp;";
                }
                case 39: {
                    return "&#39;";
                }
            }
        } else if ((character < 1000 || character >= 8000 && character < 10000) && (entityReference = this.characterToEntityReferenceMap[index = character < 1000 ? character : character - 7000]) != null) {
            return entityReference;
        }
        return null;
    }

    public char convertToCharacter(String entityReference) {
        Character referredCharacter = this.entityReferenceToCharacterMap.get(entityReference);
        if (referredCharacter != null) {
            return referredCharacter.charValue();
        }
        return '\uffff';
    }
}

