/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import com.netflix.zuul.context.RequestContext;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRequestUtils {
    private static Logger logger = LoggerFactory.getLogger(HTTPRequestUtils.class);
    private static final HTTPRequestUtils INSTANCE = new HTTPRequestUtils();
    private static final String X_FORWARDED_FOR_HEADER = "x-forwarded-for";

    public final String extractClientIpFromXForwardedFor(String xForwardedFor) {
        if (xForwardedFor == null) {
            return null;
        }
        String[] tokenized = (xForwardedFor = xForwardedFor.trim()).split(",");
        if (tokenized.length == 0) {
            return null;
        }
        return tokenized[0].trim();
    }

    public static HTTPRequestUtils getInstance() {
        return INSTANCE;
    }

    public String getHeaderValue(String sHeaderName) {
        return RequestContext.getCurrentContext().getRequest().getHeader(sHeaderName);
    }

    public String getFormValue(String sHeaderName) {
        return RequestContext.getCurrentContext().getRequest().getParameter(sHeaderName);
    }

    public Map<String, List<String>> getQueryParams() {
        Map<String, List<String>> qp = RequestContext.getCurrentContext().getRequestQueryParams();
        if (qp != null) {
            return qp;
        }
        HttpServletRequest request = RequestContext.getCurrentContext().getRequest();
        qp = new HashMap<String, List<String>>();
        if (request.getQueryString() == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(request.getQueryString(), "&");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int i = s.indexOf("=");
            if (i <= 0 || s.length() <= i + 1) continue;
            String name = s.substring(0, i);
            String value = s.substring(i + 1);
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
            List<String> valueList = qp.get(name);
            if (valueList == null) {
                valueList = new LinkedList<String>();
                qp.put(name, valueList);
            }
            valueList.add(value);
        }
        RequestContext.getCurrentContext().setRequestQueryParams(qp);
        return qp;
    }

    public String getValueFromRequestElements(String sName) {
        List<String> v;
        String sValue = null;
        if (this.getQueryParams() != null && (v = this.getQueryParams().get(sName)) != null && !v.isEmpty()) {
            sValue = v.iterator().next();
        }
        if (sValue != null) {
            return sValue;
        }
        sValue = this.getHeaderValue(sName);
        if (sValue != null) {
            return sValue;
        }
        sValue = this.getFormValue(sName);
        if (sValue != null) {
            return sValue;
        }
        return null;
    }

    public boolean isGzipped(String contentEncoding) {
        return contentEncoding.contains("gzip");
    }

    public static class UnitTest {
        @Test
        public void detectsGzip() {
            Assert.assertTrue((boolean)HTTPRequestUtils.getInstance().isGzipped("gzip"));
        }

        @Test
        public void detectsNonGzip() {
            Assert.assertFalse((boolean)HTTPRequestUtils.getInstance().isGzipped("identity"));
        }

        @Test
        public void detectsGzipAmongOtherEncodings() {
            Assert.assertTrue((boolean)HTTPRequestUtils.getInstance().isGzipped("gzip, deflate"));
        }
    }
}

