/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.http;

import com.netflix.zuul.FilterProcessor;
import com.netflix.zuul.ZuulRunner;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZuulServlet
extends HttpServlet {
    private ZuulRunner zuulRunner = new ZuulRunner();
    private static Logger LOG = LoggerFactory.getLogger(ZuulServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            this.init((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            RequestContext.getCurrentContext().setZuulEngineRan();
            try {
                this.preRoute();
            }
            catch (ZuulException e) {
                this.error(e);
                this.postRoute();
                return;
            }
            try {
                this.route();
            }
            catch (ZuulException e) {
                this.error(e);
                this.postRoute();
                return;
            }
            try {
                this.postRoute();
            }
            catch (ZuulException e) {
                this.error(e);
                return;
            }
        }
        catch (Throwable e) {
            this.error(new ZuulException(e, 500, "UNHANDLED_EXCEPTION_" + e.getClass().getName()));
        }
    }

    void postRoute() throws ZuulException {
        this.zuulRunner.postRoute();
    }

    void route() throws ZuulException {
        this.zuulRunner.route();
    }

    void preRoute() throws ZuulException {
        this.zuulRunner.preRoute();
    }

    void init(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.zuulRunner.init(servletRequest, servletResponse);
    }

    void error(ZuulException e) {
        RequestContext.getCurrentContext().setThrowable(e);
        this.zuulRunner.error();
        LOG.error(e.getMessage(), (Throwable)e);
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        HttpServletRequest servletRequest;
        @Mock
        HttpServletResponse servletResponse;
        @Mock
        FilterProcessor processor;
        @Mock
        PrintWriter writer;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testProcessZuulFilter() {
            ZuulServlet zuulServlet = new ZuulServlet();
            zuulServlet = (ZuulServlet)((Object)Mockito.spy((Object)((Object)zuulServlet)));
            RequestContext context = (RequestContext)Mockito.spy((Object)RequestContext.getCurrentContext());
            try {
                FilterProcessor.setProcessor(this.processor);
                RequestContext.testSetCurrentContext(context);
                Mockito.when((Object)this.servletResponse.getWriter()).thenReturn((Object)this.writer);
                zuulServlet.init(this.servletRequest, this.servletResponse);
                ((ZuulServlet)((Object)Mockito.verify((Object)((Object)zuulServlet), (VerificationMode)Mockito.times((int)1)))).init(this.servletRequest, this.servletResponse);
                Assert.assertTrue((boolean)(RequestContext.getCurrentContext().getRequest() instanceof HttpServletRequestWrapper));
                Assert.assertEquals((Object)RequestContext.getCurrentContext().getResponse(), (Object)this.servletResponse);
                zuulServlet.preRoute();
                ((FilterProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.times((int)1))).preRoute();
                zuulServlet.postRoute();
                ((FilterProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.times((int)1))).postRoute();
                zuulServlet.route();
                ((FilterProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.times((int)1))).route();
                RequestContext.testSetCurrentContext(null);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

