/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters;

import com.netflix.zuul.ZuulRunner;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.monitoring.MonitoringHelper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

public class ZuulServletFilter
implements Filter {
    private ZuulRunner zuulRunner = new ZuulRunner();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.init((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            try {
                this.preRouting();
            }
            catch (ZuulException e) {
                this.error(e);
                this.postRouting();
                RequestContext.getCurrentContext().unset();
                return;
            }
            filterChain.doFilter(servletRequest, servletResponse);
            try {
                this.routing();
            }
            catch (ZuulException e) {
                this.error(e);
                this.postRouting();
                RequestContext.getCurrentContext().unset();
                return;
            }
            try {
                this.postRouting();
            }
            catch (ZuulException e) {
                this.error(e);
                RequestContext.getCurrentContext().unset();
                return;
            }
        }
        catch (Throwable e) {
            this.error(new ZuulException(e, 500, "UNCAUGHT_EXCEPTION_FROM_FILTER_" + e.getClass().getName()));
        }
        finally {
            RequestContext.getCurrentContext().unset();
        }
    }

    void postRouting() throws ZuulException {
        this.zuulRunner.postRoute();
    }

    void routing() throws ZuulException {
        this.zuulRunner.route();
    }

    void preRouting() throws ZuulException {
        this.zuulRunner.preRoute();
    }

    void init(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.zuulRunner.init(servletRequest, servletResponse);
    }

    void error(ZuulException e) {
        RequestContext.getCurrentContext().setThrowable(e);
        this.zuulRunner.error();
        e.printStackTrace();
    }

    public void destroy() {
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        HttpServletRequest servletRequest;
        @Mock
        HttpServletResponse servletResponse;
        @Mock
        FilterChain filterChain;
        @Mock
        ZuulRunner zuulRunner;

        @Before
        public void before() {
            MonitoringHelper.initMocks();
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testRoutingException() {
            RequestContext.getCurrentContext().setRequest(this.servletRequest);
            RequestContext.getCurrentContext().setResponse(this.servletResponse);
            ZuulServletFilter zuulServletFilter = new ZuulServletFilter();
            zuulServletFilter = (ZuulServletFilter)Mockito.spy((Object)zuulServletFilter);
            try {
                zuulServletFilter.zuulRunner = this.zuulRunner;
                Mockito.when((Object)this.servletResponse.getWriter()).thenReturn((Object)new PrintWriter("moo"));
                ZuulException e = new ZuulException("test", 510, "test");
                ((ZuulServletFilter)Mockito.doThrow((Throwable)e).when((Object)zuulServletFilter)).routing();
                zuulServletFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
                ((ZuulServletFilter)Mockito.verify((Object)zuulServletFilter, (VerificationMode)Mockito.times((int)1))).routing();
                ((ZuulServletFilter)Mockito.verify((Object)zuulServletFilter, (VerificationMode)Mockito.times((int)1))).error(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.toString());
            }
        }

        @Test
        public void testPreException() {
            ZuulServletFilter zuulServletFilter = new ZuulServletFilter();
            zuulServletFilter = (ZuulServletFilter)Mockito.spy((Object)zuulServletFilter);
            RequestContext.getCurrentContext().setRequest(this.servletRequest);
            RequestContext.getCurrentContext().setResponse(this.servletResponse);
            try {
                zuulServletFilter.zuulRunner = this.zuulRunner;
                Mockito.when((Object)this.servletResponse.getWriter()).thenReturn((Object)new PrintWriter("moo"));
                ZuulException e = new ZuulException("test", 510, "test");
                ((ZuulServletFilter)Mockito.doThrow((Throwable)e).when((Object)zuulServletFilter)).preRouting();
                zuulServletFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
                ((ZuulServletFilter)Mockito.verify((Object)zuulServletFilter, (VerificationMode)Mockito.times((int)1))).preRouting();
                ((ZuulServletFilter)Mockito.verify((Object)zuulServletFilter, (VerificationMode)Mockito.times((int)1))).error(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.toString());
            }
        }

        @Test
        public void testPostException() {
            RequestContext.getCurrentContext().setRequest(this.servletRequest);
            RequestContext.getCurrentContext().setResponse(this.servletResponse);
            ZuulServletFilter zuulServletFilter = new ZuulServletFilter();
            zuulServletFilter = (ZuulServletFilter)Mockito.spy((Object)zuulServletFilter);
            try {
                zuulServletFilter.zuulRunner = this.zuulRunner;
                Mockito.when((Object)this.servletResponse.getWriter()).thenReturn((Object)new PrintWriter("moo"));
                ZuulException e = new ZuulException("test", 510, "test");
                ((ZuulServletFilter)Mockito.doThrow((Throwable)e).when((Object)zuulServletFilter)).postRouting();
                zuulServletFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
                ((ZuulServletFilter)Mockito.verify((Object)zuulServletFilter, (VerificationMode)Mockito.times((int)1))).postRouting();
                ((ZuulServletFilter)Mockito.verify((Object)zuulServletFilter, (VerificationMode)Mockito.times((int)1))).error(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.toString());
            }
        }

        @Test
        public void testProcessZuulFilter() {
            ZuulServletFilter zuulServletFilter = new ZuulServletFilter();
            zuulServletFilter = (ZuulServletFilter)Mockito.spy((Object)zuulServletFilter);
            try {
                zuulServletFilter.zuulRunner = this.zuulRunner;
                Mockito.when((Object)this.servletResponse.getWriter()).thenReturn((Object)new PrintWriter("moo"));
                zuulServletFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
                ((ZuulRunner)Mockito.verify((Object)this.zuulRunner, (VerificationMode)Mockito.times((int)1))).init(this.servletRequest, this.servletResponse);
                ((ZuulRunner)Mockito.verify((Object)this.zuulRunner, (VerificationMode)Mockito.times((int)1))).preRoute();
                ((ZuulRunner)Mockito.verify((Object)this.zuulRunner, (VerificationMode)Mockito.times((int)1))).route();
                ((ZuulRunner)Mockito.verify((Object)this.zuulRunner, (VerificationMode)Mockito.times((int)1))).postRoute();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.toString());
            }
        }
    }
}

