/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.netflix.zuul.DynamicCodeCompiler;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.filters.FilterRegistry;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterLoader {
    static final FilterLoader INSTANCE = new FilterLoader();
    private static final Logger LOG = LoggerFactory.getLogger(FilterLoader.class);
    private final ConcurrentHashMap<String, Long> filterClassLastModified = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> filterClassCode = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> filterCheck = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ZuulFilter>> hashFiltersByType = new ConcurrentHashMap();
    private FilterRegistry filterRegistry = FilterRegistry.instance();
    static DynamicCodeCompiler COMPILER;

    public void setCompiler(DynamicCodeCompiler compiler) {
        COMPILER = compiler;
    }

    public void setFilterRegistry(FilterRegistry r) {
        this.filterRegistry = r;
    }

    public static FilterLoader getInstance() {
        return INSTANCE;
    }

    public ZuulFilter getFilter(String sCode, String sName) throws Exception {
        Class clazz;
        ZuulFilter filter;
        if (this.filterCheck.get(sName) == null) {
            this.filterCheck.putIfAbsent(sName, sName);
            if (!sCode.equals(this.filterClassCode.get(sName))) {
                LOG.info("reloading code " + sName);
                this.filterRegistry.remove(sName);
            }
        }
        if ((filter = this.filterRegistry.get(sName)) == null && !Modifier.isAbstract((clazz = COMPILER.compile(sCode, sName)).getModifiers())) {
            filter = (ZuulFilter)clazz.newInstance();
        }
        return filter;
    }

    public int filterInstanceMapSize() {
        return this.filterRegistry.size();
    }

    public boolean putFilter(File file) throws Exception {
        Class clazz;
        ZuulFilter filter;
        String sName = file.getAbsolutePath() + file.getName();
        if (this.filterClassLastModified.get(sName) != null && file.lastModified() != this.filterClassLastModified.get(sName).longValue()) {
            LOG.debug("reloading filter " + sName);
            this.filterRegistry.remove(sName);
        }
        if ((filter = this.filterRegistry.get(sName)) == null && !Modifier.isAbstract((clazz = COMPILER.compile(file)).getModifiers())) {
            filter = (ZuulFilter)clazz.newInstance();
            List<ZuulFilter> list = this.hashFiltersByType.get(filter.filterType());
            if (list != null) {
                this.hashFiltersByType.remove(filter.filterType());
            }
            this.filterRegistry.put(file.getAbsolutePath() + file.getName(), filter);
            this.filterClassLastModified.put(sName, file.lastModified());
            return true;
        }
        return false;
    }

    public List<ZuulFilter> getFiltersByType(String filterType) {
        List<ZuulFilter> list = this.hashFiltersByType.get(filterType);
        if (list != null) {
            return list;
        }
        list = new ArrayList<ZuulFilter>();
        Collection<ZuulFilter> filters = this.filterRegistry.getAllFilters();
        for (ZuulFilter filter : filters) {
            if (!filter.filterType().equals(filterType)) continue;
            list.add(filter);
        }
        Collections.sort(list);
        this.hashFiltersByType.putIfAbsent(filterType, list);
        return list;
    }

    public static class UnitTest {
        @Mock
        File file;
        @Mock
        DynamicCodeCompiler compiler;
        @Mock
        FilterRegistry registry;
        FilterLoader loader;
        TestZuulFilter filter = new TestZuulFilter();

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
            this.loader = (FilterLoader)Mockito.spy((Object)new FilterLoader());
            this.loader.setCompiler(this.compiler);
            this.loader.setFilterRegistry(this.registry);
        }

        @Test
        public void testGetFilterFromFile() throws Exception {
            ((DynamicCodeCompiler)Mockito.doReturn(TestZuulFilter.class).when((Object)this.compiler)).compile(this.file);
            Assert.assertTrue((boolean)this.loader.putFilter(this.file));
            ((FilterRegistry)Mockito.verify((Object)this.registry)).put((String)Matchers.any(String.class), (ZuulFilter)Matchers.any(ZuulFilter.class));
        }

        @Test
        public void testGetFiltersByType() throws Exception {
            ((DynamicCodeCompiler)Mockito.doReturn(TestZuulFilter.class).when((Object)this.compiler)).compile(this.file);
            Assert.assertTrue((boolean)this.loader.putFilter(this.file));
            ((FilterRegistry)Mockito.verify((Object)this.registry)).put((String)Matchers.any(String.class), (ZuulFilter)Matchers.any(ZuulFilter.class));
            ArrayList<TestZuulFilter> filters = new ArrayList<TestZuulFilter>();
            filters.add(this.filter);
            Mockito.when(this.registry.getAllFilters()).thenReturn(filters);
            List<ZuulFilter> list = this.loader.getFiltersByType("test");
            Assert.assertTrue((list != null ? 1 : 0) != 0);
            Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            ZuulFilter filter = list.get(0);
            Assert.assertTrue((filter != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)filter.filterType().equals("test"));
        }

        @Test
        public void testGetFilterFromString() throws Exception {
            String string = "";
            ((DynamicCodeCompiler)Mockito.doReturn(TestZuulFilter.class).when((Object)this.compiler)).compile(string, string);
            ZuulFilter filter = this.loader.getFilter(string, string);
            Assert.assertNotNull((Object)filter);
            Assert.assertTrue((filter.getClass() == TestZuulFilter.class ? 1 : 0) != 0);
        }
    }

    public static class TestZuulFilter
    extends ZuulFilter {
        @Override
        public String filterType() {
            return "test";
        }

        @Override
        public int filterOrder() {
            return 0;
        }

        @Override
        public boolean shouldFilter() {
            return false;
        }

        @Override
        public Object run() {
            return null;
        }
    }
}

