/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.netflix.zuul.FilterLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

public class FilterFileManager {
    String[] aDirectories;
    int pollingIntervalSeconds;
    Thread poller;
    boolean bRunning = true;
    static FilenameFilter FILENAME_FILTER;
    static FilterFileManager INSTANCE;

    private FilterFileManager() {
    }

    public static void setFilenameFilter(FilenameFilter filter) {
        FILENAME_FILTER = filter;
    }

    public static void init(int pollingIntervalSeconds, String ... directories) throws Exception, IllegalAccessException, InstantiationException {
        if (INSTANCE == null) {
            INSTANCE = new FilterFileManager();
        }
        FilterFileManager.INSTANCE.aDirectories = directories;
        FilterFileManager.INSTANCE.pollingIntervalSeconds = pollingIntervalSeconds;
        INSTANCE.manageFiles();
        INSTANCE.startPoller();
    }

    public static void shutdown() {
        INSTANCE.stopPoller();
    }

    void stopPoller() {
        this.bRunning = false;
    }

    void startPoller() {
        this.poller = new Thread("GroovyFilterFileManagerPoller"){

            @Override
            public void run() {
                while (FilterFileManager.this.bRunning) {
                    try {
                        1.sleep(FilterFileManager.this.pollingIntervalSeconds * 1000);
                        FilterFileManager.this.manageFiles();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.poller.start();
    }

    public File getDirectory(String sPath) {
        File directory = new File(sPath);
        if (!directory.isDirectory()) {
            throw new RuntimeException(sPath + " is not a valid directory");
        }
        return directory;
    }

    List<File> getFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (String sDirectory : this.aDirectories) {
            File directory = this.getDirectory(sDirectory);
            File[] aFiles = directory.listFiles(FILENAME_FILTER);
            if (aFiles == null) continue;
            list.addAll(Arrays.asList(aFiles));
        }
        return list;
    }

    void processGroovyFiles(List<File> aFiles) throws Exception, InstantiationException, IllegalAccessException {
        for (File file : aFiles) {
            FilterLoader.getInstance().putFilter(file);
        }
    }

    void manageFiles() throws Exception, IllegalAccessException, InstantiationException {
        List<File> aFiles = this.getFiles();
        this.processGroovyFiles(aFiles);
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        private File nonGroovyFile;
        @Mock
        private File groovyFile;
        @Mock
        private File directory;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testFileManagerInit() throws Exception, InstantiationException, IllegalAccessException {
            FilterFileManager manager = new FilterFileManager();
            manager = (FilterFileManager)Mockito.spy((Object)manager);
            INSTANCE = manager;
            ((FilterFileManager)Mockito.doNothing().when((Object)INSTANCE)).manageFiles();
            FilterFileManager.init(1, "test", "test1");
            ((FilterFileManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.atLeast((int)1))).manageFiles();
            ((FilterFileManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.times((int)1))).startPoller();
            Assert.assertNotNull((Object)manager.poller);
        }
    }
}

