/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.servopublisher;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixMetrics;
import com.netflix.hystrix.contrib.servopublisher.HystrixServoMetricsPublisherAbstract;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCollapser;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceLevel;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import java.util.ArrayList;
import java.util.List;

public class HystrixServoMetricsPublisherCollapser
extends HystrixServoMetricsPublisherAbstract
implements HystrixMetricsPublisherCollapser {
    private final HystrixCollapserKey key;
    private final HystrixCollapserMetrics metrics;
    private final HystrixCollapserProperties properties;
    private final Tag servoInstanceTag;
    private final Tag servoTypeTag;

    public HystrixServoMetricsPublisherCollapser(HystrixCollapserKey threadPoolKey, HystrixCollapserMetrics metrics, HystrixCollapserProperties properties) {
        this.key = threadPoolKey;
        this.metrics = metrics;
        this.properties = properties;
        this.servoInstanceTag = new Tag(){

            public String getKey() {
                return "instance";
            }

            public String getValue() {
                return HystrixServoMetricsPublisherCollapser.this.key.name();
            }

            public String tagString() {
                return HystrixServoMetricsPublisherCollapser.this.key.name();
            }
        };
        this.servoTypeTag = new Tag(){

            public String getKey() {
                return "type";
            }

            public String getValue() {
                return "HystrixCollapser";
            }

            public String tagString() {
                return "HystrixCollapser";
            }
        };
    }

    public void initialize() {
        List<Monitor<?>> monitors = this.getServoMonitors();
        MonitorConfig commandMetricsConfig = MonitorConfig.builder((String)("HystrixCollapser_" + this.key.name())).build();
        BasicCompositeMonitor commandMetricsMonitor = new BasicCompositeMonitor(commandMetricsConfig, monitors);
        DefaultMonitorRegistry.getInstance().register((Monitor)commandMetricsMonitor);
    }

    @Override
    protected Tag getServoTypeTag() {
        return this.servoTypeTag;
    }

    @Override
    protected Tag getServoInstanceTag() {
        return this.servoInstanceTag;
    }

    private List<Monitor<?>> getServoMonitors() {
        ArrayList monitors = new ArrayList();
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"name").build()){

            @Override
            public String getValue() {
                return HystrixServoMetricsPublisherCollapser.this.key.name();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"currentTime").withTag((Tag)DataSourceLevel.DEBUG).build()){

            @Override
            public Number getValue() {
                return System.currentTimeMillis();
            }
        });
        monitors.add(this.getCumulativeCountForEvent("countRequestsBatched", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.COLLAPSER_REQUEST_BATCHED));
        monitors.add(this.getCumulativeCountForEvent("countBatches", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.COLLAPSER_BATCH));
        monitors.add(this.getCumulativeCountForEvent("countResponsesFromCache", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"batchSize_mean").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizeMean();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"batchSize_percentile_25").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(25.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"batchSize_percentile_50").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(50.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"batchSize_percentile_75").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(75.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"batchSize_percentile_95").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(95.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"batchSize_percentile_99").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(99.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"batchSize_percentile_99_5").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(99.5);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"batchSize_percentile_100").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(100.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"shardSize_mean").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizeMean();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"shardSize_percentile_25").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizePercentile(25.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"shardSize_percentile_50").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizePercentile(50.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"shardSize_percentile_75").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizePercentile(75.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"shardSize_percentile_90").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizePercentile(90.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"shardSize_percentile_95").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizePercentile(95.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"shardSize_percentile_99").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizePercentile(99.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"shardSize_percentile_99_5").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizePercentile(99.5);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"shardSize_percentile_100").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizePercentile(100.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_rollingStatisticalWindowInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCollapser.this.properties.metricsRollingStatisticalWindowInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_requestCacheEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCollapser.this.properties.requestCacheEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_maxRequestsInBatch").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCollapser.this.properties.maxRequestsInBatch().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_timerDelayInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCollapser.this.properties.timerDelayInMilliseconds().get();
            }
        });
        return monitors;
    }
}

