/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.servopublisher;

import com.netflix.hystrix.HystrixMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import com.netflix.servo.annotations.DataSourceLevel;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;

abstract class HystrixServoMetricsPublisherAbstract {
    HystrixServoMetricsPublisherAbstract() {
    }

    protected abstract Tag getServoTypeTag();

    protected abstract Tag getServoInstanceTag();

    protected Monitor<?> getCumulativeCountForEvent(String name, final HystrixMetrics metrics, final HystrixRollingNumberEvent event) {
        return new CounterMetric(MonitorConfig.builder((String)name).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                return metrics.getCumulativeCount(event);
            }
        };
    }

    protected Monitor<?> getRollingCountForEvent(String name, final HystrixMetrics metrics, final HystrixRollingNumberEvent event) {
        return new GaugeMetric(MonitorConfig.builder((String)name).withTag((Tag)DataSourceLevel.DEBUG).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Number getValue() {
                return metrics.getRollingCount(event);
            }
        };
    }

    protected abstract class GaugeMetric
    extends AbstractMonitor<Number>
    implements Gauge<Number> {
        public GaugeMetric(MonitorConfig config) {
            super(config.withAdditionalTag((Tag)DataSourceType.GAUGE).withAdditionalTag(HystrixServoMetricsPublisherAbstract.this.getServoTypeTag()).withAdditionalTag(HystrixServoMetricsPublisherAbstract.this.getServoInstanceTag()));
        }

        public Number getValue(int n) {
            return this.getValue();
        }

        public abstract Number getValue();
    }

    protected abstract class CounterMetric
    extends AbstractMonitor<Number>
    implements Counter {
        public CounterMetric(MonitorConfig config) {
            super(config.withAdditionalTag((Tag)DataSourceType.COUNTER).withAdditionalTag(HystrixServoMetricsPublisherAbstract.this.getServoTypeTag()).withAdditionalTag(HystrixServoMetricsPublisherAbstract.this.getServoInstanceTag()));
        }

        public Number getValue(int n) {
            return this.getValue();
        }

        public abstract Number getValue();

        public void increment() {
            throw new IllegalStateException("We are wrapping a value instead.");
        }

        public void increment(long arg0) {
            throw new IllegalStateException("We are wrapping a value instead.");
        }
    }

    protected abstract class InformationalMetric<K>
    extends AbstractMonitor<K> {
        public InformationalMetric(MonitorConfig config) {
            super(config.withAdditionalTag((Tag)DataSourceType.INFORMATIONAL).withAdditionalTag(HystrixServoMetricsPublisherAbstract.this.getServoTypeTag()).withAdditionalTag(HystrixServoMetricsPublisherAbstract.this.getServoInstanceTag()));
        }

        public K getValue(int n) {
            return this.getValue();
        }

        public abstract K getValue();
    }
}

