/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.util.proxy;

import com.jpattern.javassist.util.proxy.MethodHandler;
import com.jpattern.javassist.util.proxy.Proxy;
import com.jpattern.javassist.util.proxy.ProxyFactory;
import com.jpattern.javassist.util.proxy.ProxyObject;
import com.jpattern.javassist.util.proxy.SecurityActions;
import com.jpattern.javassist.util.proxy.SerializedProxy;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Method;

public class RuntimeSupport {
    public static MethodHandler default_interceptor = new DefaultMethodHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void find2Methods(Object object, String string, String string2, int n, String string3, Method[] methodArray) {
        Method[] methodArray2 = methodArray;
        synchronized (methodArray) {
            if (methodArray[n] == null) {
                methodArray[n + 1] = string2 == null ? null : RuntimeSupport.findMethod(object, string2, string3);
                methodArray[n] = RuntimeSupport.findSuperMethod(object, string, string3);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public static Method findMethod(Object object, String string, String string2) {
        Method method = RuntimeSupport.findMethod2(object.getClass(), string, string2);
        if (method == null) {
            RuntimeSupport.error(object, string, string2);
        }
        return method;
    }

    public static Method findSuperMethod(Object object, String string, String string2) {
        Class<?> clazz = object.getClass();
        Method method = RuntimeSupport.findSuperMethod2(clazz.getSuperclass(), string, string2);
        if (method == null) {
            method = RuntimeSupport.searchInterfaces(clazz, string, string2);
        }
        if (method == null) {
            RuntimeSupport.error(object, string, string2);
        }
        return method;
    }

    private static void error(Object object, String string, String string2) {
        throw new RuntimeException("not found " + string + ":" + string2 + " in " + object.getClass().getName());
    }

    private static Method findSuperMethod2(Class clazz, String string, String string2) {
        Method method = RuntimeSupport.findMethod2(clazz, string, string2);
        if (method != null) {
            return method;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (method = RuntimeSupport.findSuperMethod2(clazz2, string, string2)) != null) {
            return method;
        }
        return RuntimeSupport.searchInterfaces(clazz, string, string2);
    }

    private static Method searchInterfaces(Class clazz, String string, String string2) {
        Method method = null;
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            method = RuntimeSupport.findSuperMethod2(classArray[i], string, string2);
            if (method == null) continue;
            return method;
        }
        return method;
    }

    private static Method findMethod2(Class clazz, String string, String string2) {
        Method[] methodArray = SecurityActions.getDeclaredMethods(clazz);
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            if (!methodArray[i].getName().equals(string) || !RuntimeSupport.makeDescriptor(methodArray[i]).equals(string2)) continue;
            return methodArray[i];
        }
        return null;
    }

    public static String makeDescriptor(Method method) {
        Class[] classArray = method.getParameterTypes();
        return RuntimeSupport.makeDescriptor(classArray, method.getReturnType());
    }

    public static String makeDescriptor(Class[] classArray, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            RuntimeSupport.makeDesc(stringBuffer, classArray[i]);
        }
        stringBuffer.append(')');
        if (clazz != null) {
            RuntimeSupport.makeDesc(stringBuffer, clazz);
        }
        return stringBuffer.toString();
    }

    public static String makeDescriptor(String string, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer(string);
        RuntimeSupport.makeDesc(stringBuffer, clazz);
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void makeDesc(StringBuffer stringBuffer, Class clazz) {
        if (clazz.isArray()) {
            stringBuffer.append('[');
            RuntimeSupport.makeDesc(stringBuffer, clazz.getComponentType());
            return;
        } else if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                stringBuffer.append('V');
                return;
            } else if (clazz == Integer.TYPE) {
                stringBuffer.append('I');
                return;
            } else if (clazz == Byte.TYPE) {
                stringBuffer.append('B');
                return;
            } else if (clazz == Long.TYPE) {
                stringBuffer.append('J');
                return;
            } else if (clazz == Double.TYPE) {
                stringBuffer.append('D');
                return;
            } else if (clazz == Float.TYPE) {
                stringBuffer.append('F');
                return;
            } else if (clazz == Character.TYPE) {
                stringBuffer.append('C');
                return;
            } else if (clazz == Short.TYPE) {
                stringBuffer.append('S');
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new RuntimeException("bad type: " + clazz.getName());
                stringBuffer.append('Z');
            }
            return;
        } else {
            stringBuffer.append('L').append(clazz.getName().replace('.', '/')).append(';');
        }
    }

    public static SerializedProxy makeSerializedProxy(Object object) throws InvalidClassException {
        Class<?> clazz = object.getClass();
        MethodHandler methodHandler = null;
        if (object instanceof ProxyObject) {
            methodHandler = ((ProxyObject)object).getHandler();
        } else if (object instanceof Proxy) {
            methodHandler = ProxyFactory.getHandler((Proxy)object);
        }
        return new SerializedProxy(clazz, ProxyFactory.getFilterSignature(clazz), methodHandler);
    }

    static class DefaultMethodHandler
    implements MethodHandler,
    Serializable {
        DefaultMethodHandler() {
        }

        @Override
        public Object invoke(Object object, Method method, Method method2, Object[] objectArray) throws Exception {
            return method2.invoke(object, objectArray);
        }
    }
}

