/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.tools.rmi;

import com.jpattern.javassist.CannotCompileException;
import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.CtConstructor;
import com.jpattern.javassist.CtField;
import com.jpattern.javassist.CtMethod;
import com.jpattern.javassist.CtNewConstructor;
import com.jpattern.javassist.CtNewMethod;
import com.jpattern.javassist.Modifier;
import com.jpattern.javassist.NotFoundException;
import com.jpattern.javassist.Translator;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class StubGenerator
implements Translator {
    private static final String fieldImporter = "importer";
    private static final String fieldObjectId = "objectId";
    private static final String accessorObjectId = "_getObjectId";
    private static final String sampleClass = "javassist.tools.rmi.Sample";
    private ClassPool classPool;
    private Hashtable proxyClasses = new Hashtable();
    private CtMethod forwardMethod;
    private CtMethod forwardStaticMethod;
    private CtClass[] proxyConstructorParamTypes;
    private CtClass[] interfacesForProxy;
    private CtClass[] exceptionForProxy;

    @Override
    public void start(ClassPool classPool) throws NotFoundException {
        this.classPool = classPool;
        CtClass ctClass = classPool.get(sampleClass);
        this.forwardMethod = ctClass.getDeclaredMethod("forward");
        this.forwardStaticMethod = ctClass.getDeclaredMethod("forwardStatic");
        this.proxyConstructorParamTypes = classPool.get(new String[]{"javassist.tools.rmi.ObjectImporter", "int"});
        this.interfacesForProxy = classPool.get(new String[]{"java.io.Serializable", "javassist.tools.rmi.Proxy"});
        this.exceptionForProxy = new CtClass[]{classPool.get("javassist.tools.rmi.RemoteException")};
    }

    @Override
    public void onLoad(ClassPool classPool, String string) {
    }

    public boolean isProxyClass(String string) {
        return this.proxyClasses.get(string) != null;
    }

    public synchronized boolean makeProxyClass(Class clazz) throws CannotCompileException, NotFoundException {
        String string = clazz.getName();
        if (this.proxyClasses.get(string) != null) {
            return false;
        }
        CtClass ctClass = this.produceProxyClass(this.classPool.get(string), clazz);
        this.proxyClasses.put(string, ctClass);
        this.modifySuperclass(ctClass);
        return true;
    }

    private CtClass produceProxyClass(CtClass ctClass, Class clazz) throws CannotCompileException, NotFoundException {
        int n = ctClass.getModifiers();
        if (Modifier.isAbstract(n) || Modifier.isNative(n) || !Modifier.isPublic(n)) {
            throw new CannotCompileException(ctClass.getName() + " must be public, non-native, and non-abstract.");
        }
        CtClass ctClass2 = this.classPool.makeClass(ctClass.getName(), ctClass.getSuperclass());
        ctClass2.setInterfaces(this.interfacesForProxy);
        CtField ctField = new CtField(this.classPool.get("javassist.tools.rmi.ObjectImporter"), fieldImporter, ctClass2);
        ctField.setModifiers(2);
        ctClass2.addField(ctField, CtField.Initializer.byParameter(0));
        ctField = new CtField(CtClass.intType, fieldObjectId, ctClass2);
        ctField.setModifiers(2);
        ctClass2.addField(ctField, CtField.Initializer.byParameter(1));
        ctClass2.addMethod(CtNewMethod.getter(accessorObjectId, ctField));
        ctClass2.addConstructor(CtNewConstructor.defaultConstructor(ctClass2));
        CtConstructor ctConstructor = CtNewConstructor.skeleton(this.proxyConstructorParamTypes, null, ctClass2);
        ctClass2.addConstructor(ctConstructor);
        try {
            this.addMethods(ctClass2, clazz.getMethods());
            return ctClass2;
        }
        catch (SecurityException securityException) {
            throw new CannotCompileException(securityException);
        }
    }

    private CtClass toCtClass(Class clazz) throws NotFoundException {
        String string;
        if (!clazz.isArray()) {
            string = clazz.getName();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                stringBuffer.append("[]");
            } while ((clazz = clazz.getComponentType()).isArray());
            stringBuffer.insert(0, clazz.getName());
            string = stringBuffer.toString();
        }
        return this.classPool.get(string);
    }

    private CtClass[] toCtClass(Class[] classArray) throws NotFoundException {
        int n = classArray.length;
        CtClass[] ctClassArray = new CtClass[n];
        for (int i = 0; i < n; ++i) {
            ctClassArray[i] = this.toCtClass(classArray[i]);
        }
        return ctClassArray;
    }

    private void addMethods(CtClass ctClass, Method[] methodArray) throws CannotCompileException, NotFoundException {
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n = method.getModifiers();
            if (method.getDeclaringClass() == Object.class || Modifier.isFinal(n)) continue;
            if (Modifier.isPublic(n)) {
                CtMethod ctMethod = Modifier.isStatic(n) ? this.forwardStaticMethod : this.forwardMethod;
                CtMethod ctMethod2 = CtNewMethod.wrapped(this.toCtClass(method.getReturnType()), method.getName(), this.toCtClass(method.getParameterTypes()), this.exceptionForProxy, ctMethod, CtMethod.ConstParameter.integer(i), ctClass);
                ctMethod2.setModifiers(n);
                ctClass.addMethod(ctMethod2);
                continue;
            }
            if (Modifier.isProtected(n) || Modifier.isPrivate(n)) continue;
            throw new CannotCompileException("the methods must be public, protected, or private.");
        }
    }

    private void modifySuperclass(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtClass ctClass2;
        while ((ctClass2 = ctClass.getSuperclass()) != null) {
            try {
                ctClass2.getDeclaredConstructor(null);
                break;
            }
            catch (NotFoundException notFoundException) {
                ctClass2.addConstructor(CtNewConstructor.defaultConstructor(ctClass2));
                ctClass = ctClass2;
            }
        }
    }
}

