/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.expr;

import com.jpattern.javassist.CannotCompileException;
import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.CtBehavior;
import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.CtConstructor;
import com.jpattern.javassist.NotFoundException;
import com.jpattern.javassist.bytecode.BadBytecode;
import com.jpattern.javassist.bytecode.Bytecode;
import com.jpattern.javassist.bytecode.CodeAttribute;
import com.jpattern.javassist.bytecode.CodeIterator;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.Descriptor;
import com.jpattern.javassist.bytecode.MethodInfo;
import com.jpattern.javassist.compiler.CompileError;
import com.jpattern.javassist.compiler.Javac;
import com.jpattern.javassist.compiler.JvstCodeGen;
import com.jpattern.javassist.compiler.JvstTypeChecker;
import com.jpattern.javassist.compiler.ProceedHandler;
import com.jpattern.javassist.compiler.ast.ASTList;
import com.jpattern.javassist.expr.Expr;

public class NewExpr
extends Expr {
    String newTypeName;
    int newPos;

    protected NewExpr(int n, CodeIterator codeIterator, CtClass ctClass, MethodInfo methodInfo, String string, int n2) {
        super(n, codeIterator, ctClass, methodInfo);
        this.newTypeName = string;
        this.newPos = n2;
    }

    @Override
    public CtBehavior where() {
        return super.where();
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    private CtClass getCtClass() throws NotFoundException {
        return this.thisClass.getClassPool().get(this.newTypeName);
    }

    public String getClassName() {
        return this.newTypeName;
    }

    public String getSignature() {
        ConstPool constPool = this.getConstPool();
        int n = this.iterator.u16bitAt(this.currentPos + 1);
        return constPool.getMethodrefType(n);
    }

    public CtConstructor getConstructor() throws NotFoundException {
        ConstPool constPool = this.getConstPool();
        int n = this.iterator.u16bitAt(this.currentPos + 1);
        String string = constPool.getMethodrefType(n);
        return this.getCtClass().getConstructor(string);
    }

    @Override
    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    private int canReplace() throws CannotCompileException {
        int n = this.iterator.byteAt(this.newPos + 3);
        if (n == 89) {
            return 4;
        }
        if (n == 90 && this.iterator.byteAt(this.newPos + 4) == 95) {
            return 5;
        }
        return 3;
    }

    @Override
    public void replace(String string) throws CannotCompileException {
        this.thisClass.getClassFile();
        int n = this.newPos;
        int n2 = this.iterator.u16bitAt(n + 1);
        int n3 = this.canReplace();
        int n4 = n + n3;
        for (int i = n; i < n4; ++i) {
            this.iterator.writeByte(0, i);
        }
        ConstPool constPool = this.getConstPool();
        n = this.currentPos;
        int n5 = this.iterator.u16bitAt(n + 1);
        String string2 = constPool.getMethodrefType(n5);
        Javac javac = new Javac(this.thisClass);
        ClassPool classPool = this.thisClass.getClassPool();
        CodeAttribute codeAttribute = this.iterator.get();
        try {
            CtClass[] ctClassArray = Descriptor.getParameterTypes(string2, classPool);
            CtClass ctClass = classPool.get(this.newTypeName);
            int n6 = codeAttribute.getMaxLocals();
            javac.recordParams(this.newTypeName, ctClassArray, true, n6, this.withinStatic());
            int n7 = javac.recordReturnType(ctClass, true);
            javac.recordProceed(new ProceedForNew(ctClass, n2, n5));
            NewExpr.checkResultValue(ctClass, string);
            Bytecode bytecode = javac.getBytecode();
            NewExpr.storeStack(ctClassArray, true, n6, bytecode);
            javac.recordLocalVariables(codeAttribute, n);
            bytecode.addConstZero(ctClass);
            bytecode.addStore(n7, ctClass);
            javac.compileStmnt(string);
            if (n3 > 3) {
                bytecode.addAload(n7);
            }
            this.replace0(n, bytecode, 3);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException("broken method");
        }
    }

    static class ProceedForNew
    implements ProceedHandler {
        CtClass newType;
        int newIndex;
        int methodIndex;

        ProceedForNew(CtClass ctClass, int n, int n2) {
            this.newType = ctClass;
            this.newIndex = n;
            this.methodIndex = n2;
        }

        @Override
        public void doit(JvstCodeGen jvstCodeGen, Bytecode bytecode, ASTList aSTList) throws CompileError {
            bytecode.addOpcode(187);
            bytecode.addIndex(this.newIndex);
            bytecode.addOpcode(89);
            jvstCodeGen.atMethodCallCore(this.newType, "<init>", aSTList, false, true, -1, null);
            jvstCodeGen.setType(this.newType);
        }

        @Override
        public void setReturnType(JvstTypeChecker jvstTypeChecker, ASTList aSTList) throws CompileError {
            jvstTypeChecker.atMethodCallCore(this.newType, "<init>", aSTList);
            jvstTypeChecker.setType(this.newType);
        }
    }
}

