/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.compiler.ast;

import com.jpattern.javassist.compiler.CompileError;
import com.jpattern.javassist.compiler.TokenId;
import com.jpattern.javassist.compiler.ast.ASTList;
import com.jpattern.javassist.compiler.ast.ASTree;
import com.jpattern.javassist.compiler.ast.Visitor;

public class CastExpr
extends ASTList
implements TokenId {
    protected int castType;
    protected int arrayDim;

    public CastExpr(ASTList aSTList, int n, ASTree aSTree) {
        super(aSTList, new ASTList(aSTree));
        this.castType = 307;
        this.arrayDim = n;
    }

    public CastExpr(int n, int n2, ASTree aSTree) {
        super(null, new ASTList(aSTree));
        this.castType = n;
        this.arrayDim = n2;
    }

    public int getType() {
        return this.castType;
    }

    public int getArrayDim() {
        return this.arrayDim;
    }

    public ASTList getClassName() {
        return (ASTList)this.getLeft();
    }

    public ASTree getOprand() {
        return this.getRight().getLeft();
    }

    public void setOprand(ASTree aSTree) {
        this.getRight().setLeft(aSTree);
    }

    @Override
    public String getTag() {
        return "cast:" + this.castType + ":" + this.arrayDim;
    }

    @Override
    public void accept(Visitor visitor) throws CompileError {
        visitor.atCastExpr(this);
    }
}

