/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.stackmap;

import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.bytecode.BadBytecode;
import com.jpattern.javassist.bytecode.CodeAttribute;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.MethodInfo;
import com.jpattern.javassist.bytecode.StackMap;
import com.jpattern.javassist.bytecode.StackMapTable;
import com.jpattern.javassist.bytecode.stackmap.BasicBlock;
import com.jpattern.javassist.bytecode.stackmap.Tracer;
import com.jpattern.javassist.bytecode.stackmap.TypeData;
import com.jpattern.javassist.bytecode.stackmap.TypedBlock;

public class MapMaker
extends Tracer {
    public static StackMapTable make(ClassPool classPool, MethodInfo methodInfo) throws BadBytecode {
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        TypedBlock[] typedBlockArray = TypedBlock.makeBlocks(methodInfo, codeAttribute, true);
        if (typedBlockArray == null) {
            return null;
        }
        MapMaker mapMaker = new MapMaker(classPool, methodInfo, codeAttribute);
        mapMaker.make(typedBlockArray, codeAttribute.getCode());
        return mapMaker.toStackMap(typedBlockArray);
    }

    public static StackMap make2(ClassPool classPool, MethodInfo methodInfo) throws BadBytecode {
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        TypedBlock[] typedBlockArray = TypedBlock.makeBlocks(methodInfo, codeAttribute, true);
        if (typedBlockArray == null) {
            return null;
        }
        MapMaker mapMaker = new MapMaker(classPool, methodInfo, codeAttribute);
        mapMaker.make(typedBlockArray, codeAttribute.getCode());
        return mapMaker.toStackMap2(methodInfo.getConstPool(), typedBlockArray);
    }

    public MapMaker(ClassPool classPool, MethodInfo methodInfo, CodeAttribute codeAttribute) {
        super(classPool, methodInfo.getConstPool(), codeAttribute.getMaxStack(), codeAttribute.getMaxLocals(), TypedBlock.getRetType(methodInfo.getDescriptor()));
    }

    protected MapMaker(MapMaker mapMaker, boolean bl) {
        super(mapMaker, bl);
    }

    void make(TypedBlock[] typedBlockArray, byte[] byArray) throws BadBytecode {
        TypedBlock typedBlock = typedBlockArray[0];
        this.fixParamTypes(typedBlock);
        TypeData[] typeDataArray = typedBlock.localsTypes;
        MapMaker.copyFrom(typeDataArray.length, typeDataArray, this.localsTypes);
        this.make(byArray, typedBlock);
        int n = typedBlockArray.length;
        for (int i = 0; i < n; ++i) {
            this.evalExpected(typedBlockArray[i]);
        }
    }

    private void fixParamTypes(TypedBlock typedBlock) throws BadBytecode {
        for (TypeData typeData : typedBlock.localsTypes) {
            if (!(typeData instanceof TypeData.ClassName)) continue;
            TypeData.setType(typeData, typeData.getName(), this.classPool);
        }
    }

    private void make(byte[] byArray, TypedBlock typedBlock) throws BadBytecode {
        int n;
        BasicBlock.Catch catch_ = typedBlock.toCatch;
        while (catch_ != null) {
            this.traceException(byArray, catch_);
            catch_ = catch_.next;
        }
        int n2 = n + typedBlock.length;
        for (n = typedBlock.position; n < n2; n += this.doOpcode(n, byArray)) {
        }
        if (typedBlock.exit != null) {
            for (int i = 0; i < typedBlock.exit.length; ++i) {
                TypedBlock typedBlock2 = (TypedBlock)typedBlock.exit[i];
                if (typedBlock2.alreadySet()) {
                    this.mergeMap(typedBlock2, true);
                    continue;
                }
                this.recordStackMap(typedBlock2);
                MapMaker mapMaker = new MapMaker(this, true);
                mapMaker.make(byArray, typedBlock2);
            }
        }
    }

    private void traceException(byte[] byArray, BasicBlock.Catch catch_) throws BadBytecode {
        TypedBlock typedBlock = (TypedBlock)catch_.body;
        if (typedBlock.alreadySet()) {
            this.mergeMap(typedBlock, false);
        } else {
            this.recordStackMap(typedBlock, catch_.typeIndex);
            MapMaker mapMaker = new MapMaker(this, false);
            mapMaker.stackTypes[0] = typedBlock.stackTypes[0].getSelf();
            mapMaker.stackTop = 1;
            mapMaker.make(byArray, typedBlock);
        }
    }

    private void mergeMap(TypedBlock typedBlock, boolean bl) {
        int n;
        boolean[] blArray = typedBlock.inputs;
        int n2 = blArray.length;
        for (n = 0; n < n2; ++n) {
            if (!blArray[n]) continue;
            this.merge(this.localsTypes[n], typedBlock.localsTypes[n]);
        }
        if (bl) {
            n2 = this.stackTop;
            for (n = 0; n < n2; ++n) {
                this.merge(this.stackTypes[n], typedBlock.stackTypes[n]);
            }
        }
    }

    private void merge(TypeData typeData, TypeData typeData2) {
        boolean bl = false;
        boolean bl2 = false;
        if (typeData != TOP && typeData.isObjectType()) {
            bl = true;
        }
        if (typeData2 != TOP && typeData2.isObjectType()) {
            bl2 = true;
        }
        if (bl && bl2) {
            typeData2.merge(typeData);
        }
    }

    private void recordStackMap(TypedBlock typedBlock) throws BadBytecode {
        TypeData[] typeDataArray = new TypeData[this.stackTypes.length];
        int n = this.stackTop;
        MapMaker.copyFrom(n, this.stackTypes, typeDataArray);
        this.recordStackMap0(typedBlock, n, typeDataArray);
    }

    private void recordStackMap(TypedBlock typedBlock, int n) throws BadBytecode {
        String string = n == 0 ? "java.lang.Throwable" : this.cpool.getClassInfo(n);
        TypeData[] typeDataArray = new TypeData[this.stackTypes.length];
        typeDataArray[0] = new TypeData.ClassName(string);
        this.recordStackMap0(typedBlock, 1, typeDataArray);
    }

    private void recordStackMap0(TypedBlock typedBlock, int n, TypeData[] typeDataArray) throws BadBytecode {
        int n2 = this.localsTypes.length;
        TypeData[] typeDataArray2 = new TypeData[n2];
        int n3 = MapMaker.copyFrom(n2, this.localsTypes, typeDataArray2);
        boolean[] blArray = typedBlock.inputs;
        for (int i = 0; i < n2; ++i) {
            if (blArray[i]) continue;
            typeDataArray2[i] = TOP;
        }
        typedBlock.setStackMap(n, typeDataArray, n3, typeDataArray2);
    }

    void evalExpected(TypedBlock typedBlock) throws BadBytecode {
        ClassPool classPool = this.classPool;
        MapMaker.evalExpected(classPool, typedBlock.stackTop, typedBlock.stackTypes);
        TypeData[] typeDataArray = typedBlock.localsTypes;
        if (typeDataArray != null) {
            MapMaker.evalExpected(classPool, typeDataArray.length, typeDataArray);
        }
    }

    private static void evalExpected(ClassPool classPool, int n, TypeData[] typeDataArray) throws BadBytecode {
        for (int i = 0; i < n; ++i) {
            TypeData typeData = typeDataArray[i];
            if (typeData == null) continue;
            typeData.evalExpectedType(classPool);
        }
    }

    public StackMapTable toStackMap(TypedBlock[] typedBlockArray) {
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        int n = typedBlockArray.length;
        TypedBlock typedBlock = typedBlockArray[0];
        int n2 = typedBlock.length;
        if (typedBlock.incoming > 0) {
            writer.sameFrame(0);
            --n2;
        }
        for (int i = 1; i < n; ++i) {
            TypedBlock typedBlock2 = typedBlockArray[i];
            if (this.isTarget(typedBlock2, typedBlockArray[i - 1])) {
                typedBlock2.resetNumLocals();
                int n3 = MapMaker.stackMapDiff(typedBlock.numLocals, typedBlock.localsTypes, typedBlock2.numLocals, typedBlock2.localsTypes);
                this.toStackMapBody(writer, typedBlock2, n3, n2, typedBlock);
                n2 = typedBlock2.length - 1;
                typedBlock = typedBlock2;
                continue;
            }
            n2 += typedBlock2.length;
        }
        return writer.toStackMapTable(this.cpool);
    }

    private boolean isTarget(TypedBlock typedBlock, TypedBlock typedBlock2) {
        int n = typedBlock.incoming;
        if (n > 1) {
            return true;
        }
        if (n < 1) {
            return false;
        }
        return typedBlock2.stop;
    }

    private void toStackMapBody(StackMapTable.Writer writer, TypedBlock typedBlock, int n, int n2, TypedBlock typedBlock2) {
        Object object;
        int n3 = typedBlock.stackTop;
        if (n3 == 0) {
            if (n == 0) {
                writer.sameFrame(n2);
                return;
            }
            if (0 > n && n >= -3) {
                writer.chopFrame(n2, -n);
                return;
            }
            if (0 < n && n <= 3) {
                int[] nArray = new int[n];
                int[] nArray2 = this.fillStackMap(typedBlock.numLocals - typedBlock2.numLocals, typedBlock2.numLocals, nArray, typedBlock.localsTypes);
                writer.appendFrame(n2, nArray2, nArray);
                return;
            }
        } else {
            if (n3 == 1 && n == 0) {
                TypeData typeData = typedBlock.stackTypes[0];
                if (typeData == TOP) {
                    writer.sameLocals(n2, 0, 0);
                } else {
                    writer.sameLocals(n2, typeData.getTypeTag(), typeData.getTypeData(this.cpool));
                }
                return;
            }
            if (n3 == 2 && n == 0 && (object = (Object)typedBlock.stackTypes[0]) != TOP && ((TypeData)object).is2WordType()) {
                writer.sameLocals(n2, ((TypeData)object).getTypeTag(), ((TypeData)object).getTypeData(this.cpool));
                return;
            }
        }
        object = new int[n3];
        int[] nArray = this.fillStackMap(n3, 0, (int[])object, typedBlock.stackTypes);
        int[] nArray3 = new int[typedBlock.numLocals];
        int[] nArray4 = this.fillStackMap(typedBlock.numLocals, 0, nArray3, typedBlock.localsTypes);
        writer.fullFrame(n2, nArray4, nArray3, nArray, (int[])object);
    }

    private int[] fillStackMap(int n, int n2, int[] nArray, TypeData[] typeDataArray) {
        int n3 = MapMaker.diffSize(typeDataArray, n2, n2 + n);
        ConstPool constPool = this.cpool;
        int[] nArray2 = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            TypeData typeData = typeDataArray[n2 + i];
            if (typeData == TOP) {
                nArray2[n4] = 0;
                nArray[n4] = 0;
            } else {
                nArray2[n4] = typeData.getTypeTag();
                nArray[n4] = typeData.getTypeData(constPool);
                if (typeData.is2WordType()) {
                    ++i;
                }
            }
            ++n4;
        }
        return nArray2;
    }

    private static int stackMapDiff(int n, TypeData[] typeDataArray, int n2, TypeData[] typeDataArray2) {
        int n3 = n2 - n;
        int n4 = n3 > 0 ? n : n2;
        if (MapMaker.stackMapEq(typeDataArray, typeDataArray2, n4)) {
            if (n3 > 0) {
                return MapMaker.diffSize(typeDataArray2, n4, n2);
            }
            return -MapMaker.diffSize(typeDataArray, n4, n);
        }
        return -100;
    }

    private static boolean stackMapEq(TypeData[] typeDataArray, TypeData[] typeDataArray2, int n) {
        for (int i = 0; i < n; ++i) {
            TypeData typeData = typeDataArray[i];
            if (!(typeData == TOP ? typeDataArray2[i] != TOP : !typeDataArray[i].equals(typeDataArray2[i]))) continue;
            return false;
        }
        return true;
    }

    private static int diffSize(TypeData[] typeDataArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            TypeData typeData = typeDataArray[n++];
            ++n3;
            if (typeData == TOP || !typeData.is2WordType()) continue;
            ++n;
        }
        return n3;
    }

    public StackMap toStackMap2(ConstPool constPool, TypedBlock[] typedBlockArray) {
        int n;
        StackMap.Writer writer = new StackMap.Writer();
        int n2 = typedBlockArray.length;
        boolean[] blArray = new boolean[n2];
        TypedBlock typedBlock = typedBlockArray[0];
        blArray[0] = typedBlock.incoming > 0;
        int n3 = blArray[0] ? 1 : 0;
        for (n = 1; n < n2; ++n) {
            TypedBlock typedBlock2 = typedBlockArray[n];
            blArray[n] = this.isTarget(typedBlock2, typedBlockArray[n - 1]);
            if (!blArray[n]) continue;
            typedBlock2.resetNumLocals();
            typedBlock = typedBlock2;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        writer.write16bit(n3);
        for (n = 0; n < n2; ++n) {
            if (!blArray[n]) continue;
            this.writeStackFrame(writer, constPool, typedBlockArray[n].position, typedBlockArray[n]);
        }
        return writer.toStackMap(constPool);
    }

    private void writeStackFrame(StackMap.Writer writer, ConstPool constPool, int n, TypedBlock typedBlock) {
        writer.write16bit(n);
        this.writeVerifyTypeInfo(writer, constPool, typedBlock.localsTypes, typedBlock.numLocals);
        this.writeVerifyTypeInfo(writer, constPool, typedBlock.stackTypes, typedBlock.stackTop);
    }

    private void writeVerifyTypeInfo(StackMap.Writer writer, ConstPool constPool, TypeData[] typeDataArray, int n) {
        TypeData typeData;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            typeData = typeDataArray[n2];
            if (typeData == null || !typeData.is2WordType()) continue;
            ++n3;
            ++n2;
        }
        writer.write16bit(n - n3);
        for (n2 = 0; n2 < n; ++n2) {
            typeData = typeDataArray[n2];
            if (typeData == TOP) {
                writer.writeVerifyTypeInfo(0, 0);
                continue;
            }
            writer.writeVerifyTypeInfo(typeData.getTypeTag(), typeData.getTypeData(constPool));
            if (!typeData.is2WordType()) continue;
            ++n2;
        }
    }
}

