/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.stackmap;

import com.jpattern.javassist.bytecode.BadBytecode;
import com.jpattern.javassist.bytecode.CodeIterator;
import com.jpattern.javassist.bytecode.stackmap.BasicBlock;
import com.jpattern.javassist.bytecode.stackmap.TypeData;
import com.jpattern.javassist.bytecode.stackmap.TypeTag;
import com.jpattern.javassist.bytecode.stackmap.TypedBlock;

public class Liveness {
    protected static final byte UNKNOWN = 0;
    protected static final byte READ = 1;
    protected static final byte UPDATED = 2;
    protected byte[] localsUsage;
    public static boolean useArgs = true;
    static final int NOT_YET = 0;
    static final int CHANGED_LAST = 1;
    static final int DONE = 2;
    static final int CHANGED_NOW = 3;

    public void compute(CodeIterator codeIterator, TypedBlock[] typedBlockArray, int n, TypeData[] typeDataArray) throws BadBytecode {
        this.computeUsage(codeIterator, typedBlockArray, n);
        if (useArgs) {
            this.useAllArgs(typedBlockArray, typeDataArray);
        }
        this.computeLiveness1(typedBlockArray[0]);
        while (this.hasChanged(typedBlockArray)) {
            this.computeLiveness2(typedBlockArray[0]);
        }
    }

    private void useAllArgs(TypedBlock[] typedBlockArray, TypeData[] typeDataArray) {
        for (int i = 0; i < typedBlockArray.length; ++i) {
            byte[] byArray = typedBlockArray[i].localsUsage;
            for (int j = 0; j < typeDataArray.length; ++j) {
                if (typeDataArray[j] == TypeTag.TOP) continue;
                byArray[j] = 1;
            }
        }
    }

    private void computeLiveness1(TypedBlock typedBlock) {
        if (typedBlock.updating) {
            this.computeLiveness1u(typedBlock);
            return;
        }
        if (typedBlock.inputs != null) {
            return;
        }
        typedBlock.updating = true;
        byte[] byArray = typedBlock.localsUsage;
        int n = byArray.length;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = byArray[i] == 1;
        }
        BasicBlock.Catch catch_ = typedBlock.toCatch;
        while (catch_ != null) {
            TypedBlock typedBlock2 = (TypedBlock)catch_.body;
            this.computeLiveness1(typedBlock2);
            for (int i = 0; i < n; ++i) {
                if (!typedBlock2.inputs[i]) continue;
                blArray[i] = true;
            }
            catch_ = catch_.next;
        }
        if (typedBlock.exit != null) {
            for (int i = 0; i < typedBlock.exit.length; ++i) {
                TypedBlock typedBlock3 = (TypedBlock)typedBlock.exit[i];
                this.computeLiveness1(typedBlock3);
                for (int j = 0; j < n; ++j) {
                    if (blArray[j]) continue;
                    blArray[j] = byArray[j] == 0 && typedBlock3.inputs[j];
                }
            }
        }
        typedBlock.updating = false;
        if (typedBlock.inputs == null) {
            typedBlock.inputs = blArray;
            typedBlock.status = 2;
        } else {
            for (int i = 0; i < n; ++i) {
                if (!blArray[i] || typedBlock.inputs[i]) continue;
                typedBlock.inputs[i] = true;
                typedBlock.status = 3;
            }
        }
    }

    private void computeLiveness1u(TypedBlock typedBlock) {
        if (typedBlock.inputs == null) {
            byte[] byArray = typedBlock.localsUsage;
            int n = byArray.length;
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = byArray[i] == 1;
            }
            typedBlock.inputs = blArray;
            typedBlock.status = 2;
        }
    }

    private void computeLiveness2(TypedBlock typedBlock) {
        if (typedBlock.updating || typedBlock.status >= 2) {
            return;
        }
        typedBlock.updating = true;
        if (typedBlock.exit == null) {
            typedBlock.status = 2;
        } else {
            boolean bl = false;
            for (int i = 0; i < typedBlock.exit.length; ++i) {
                TypedBlock typedBlock2 = (TypedBlock)typedBlock.exit[i];
                this.computeLiveness2(typedBlock2);
                if (typedBlock2.status == 2) continue;
                bl = true;
            }
            if (bl) {
                bl = false;
                byte[] byArray = typedBlock.localsUsage;
                int n = byArray.length;
                for (int i = 0; i < typedBlock.exit.length; ++i) {
                    TypedBlock typedBlock3 = (TypedBlock)typedBlock.exit[i];
                    if (typedBlock3.status == 2) continue;
                    for (int j = 0; j < n; ++j) {
                        if (typedBlock.inputs[j] || byArray[j] != 0 || !typedBlock3.inputs[j]) continue;
                        typedBlock.inputs[j] = true;
                        bl = true;
                    }
                }
                typedBlock.status = bl ? 3 : 2;
            } else {
                typedBlock.status = 2;
            }
        }
        if (this.computeLiveness2except(typedBlock)) {
            typedBlock.status = 3;
        }
        typedBlock.updating = false;
    }

    private boolean computeLiveness2except(TypedBlock typedBlock) {
        BasicBlock.Catch catch_ = typedBlock.toCatch;
        boolean bl = false;
        while (catch_ != null) {
            TypedBlock typedBlock2 = (TypedBlock)catch_.body;
            this.computeLiveness2(typedBlock2);
            if (typedBlock2.status != 2) {
                boolean[] blArray = typedBlock.inputs;
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    if (blArray[i] || !typedBlock2.inputs[i]) continue;
                    blArray[i] = true;
                    bl = true;
                }
            }
            catch_ = catch_.next;
        }
        return bl;
    }

    private boolean hasChanged(TypedBlock[] typedBlockArray) {
        int n = typedBlockArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            TypedBlock typedBlock = typedBlockArray[i];
            if (typedBlock.status == 3) {
                typedBlock.status = 1;
                bl = true;
                continue;
            }
            typedBlock.status = 0;
        }
        return bl;
    }

    private void computeUsage(CodeIterator codeIterator, TypedBlock[] typedBlockArray, int n) throws BadBytecode {
        for (TypedBlock typedBlock : typedBlockArray) {
            typedBlock.localsUsage = new byte[n];
            this.localsUsage = typedBlock.localsUsage;
            int n2 = typedBlock.position;
            this.analyze(codeIterator, n2, n2 + typedBlock.length);
            this.localsUsage = null;
        }
    }

    protected final void readLocal(int n) {
        if (this.localsUsage[n] == 0) {
            this.localsUsage[n] = 1;
        }
    }

    protected final void writeLocal(int n) {
        if (this.localsUsage[n] == 0) {
            this.localsUsage[n] = 2;
        }
    }

    protected void analyze(CodeIterator codeIterator, int n, int n2) throws BadBytecode {
        int n3;
        codeIterator.begin();
        codeIterator.move(n);
        while (codeIterator.hasNext() && (n3 = codeIterator.next()) < n2) {
            int n4 = codeIterator.byteAt(n3);
            if (n4 < 96) {
                if (n4 < 54) {
                    this.doOpcode0_53(codeIterator, n3, n4);
                    continue;
                }
                this.doOpcode54_95(codeIterator, n3, n4);
                continue;
            }
            if (n4 == 132) {
                this.readLocal(codeIterator.byteAt(n3 + 1));
                continue;
            }
            if (n4 != 196) continue;
            this.doWIDE(codeIterator, n3);
        }
    }

    private void doOpcode0_53(CodeIterator codeIterator, int n, int n2) {
        switch (n2) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.readLocal(codeIterator.byteAt(n + 1));
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.readLocal(n2 - 26);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.readLocal(n2 - 30);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.readLocal(n2 - 34);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.readLocal(n2 - 38);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.readLocal(n2 - 42);
            }
        }
    }

    private void doOpcode54_95(CodeIterator codeIterator, int n, int n2) {
        switch (n2) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this.writeLocal(codeIterator.byteAt(n + 1));
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.writeLocal(n2 - 59);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.writeLocal(n2 - 63);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.writeLocal(n2 - 67);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.writeLocal(n2 - 71);
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.writeLocal(n2 - 75);
            }
        }
    }

    private void doWIDE(CodeIterator codeIterator, int n) throws BadBytecode {
        int n2 = codeIterator.byteAt(n + 1);
        int n3 = codeIterator.u16bitAt(n + 2);
        switch (n2) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.readLocal(n3);
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this.writeLocal(n3);
                break;
            }
            case 132: {
                this.readLocal(n3);
            }
        }
    }
}

