/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.annotation;

import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.annotation.AnnotationsWriter;
import com.jpattern.javassist.bytecode.annotation.MemberValue;
import com.jpattern.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class ShortMemberValue
extends MemberValue {
    int valueIndex;

    public ShortMemberValue(int n, ConstPool constPool) {
        super('S', constPool);
        this.valueIndex = n;
    }

    public ShortMemberValue(short s, ConstPool constPool) {
        super('S', constPool);
        this.setValue(s);
    }

    public ShortMemberValue(ConstPool constPool) {
        super('S', constPool);
        this.setValue((short)0);
    }

    @Override
    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Short(this.getValue());
    }

    @Override
    Class getType(ClassLoader classLoader) {
        return Short.TYPE;
    }

    public short getValue() {
        return (short)this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(short s) {
        this.valueIndex = this.cp.addIntegerInfo(s);
    }

    public String toString() {
        return Short.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitShortMemberValue(this);
    }
}

