/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.annotation;

import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.annotation.AnnotationsWriter;
import com.jpattern.javassist.bytecode.annotation.MemberValue;
import com.jpattern.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class FloatMemberValue
extends MemberValue {
    int valueIndex;

    public FloatMemberValue(int n, ConstPool constPool) {
        super('F', constPool);
        this.valueIndex = n;
    }

    public FloatMemberValue(float f, ConstPool constPool) {
        super('F', constPool);
        this.setValue(f);
    }

    public FloatMemberValue(ConstPool constPool) {
        super('F', constPool);
        this.setValue(0.0f);
    }

    @Override
    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Float(this.getValue());
    }

    @Override
    Class getType(ClassLoader classLoader) {
        return Float.TYPE;
    }

    public float getValue() {
        return this.cp.getFloatInfo(this.valueIndex);
    }

    public void setValue(float f) {
        this.valueIndex = this.cp.addFloatInfo(f);
    }

    public String toString() {
        return Float.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitFloatMemberValue(this);
    }
}

