/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.annotation;

import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.annotation.AnnotationsWriter;
import com.jpattern.javassist.bytecode.annotation.MemberValue;
import com.jpattern.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class ByteMemberValue
extends MemberValue {
    int valueIndex;

    public ByteMemberValue(int n, ConstPool constPool) {
        super('B', constPool);
        this.valueIndex = n;
    }

    public ByteMemberValue(byte by, ConstPool constPool) {
        super('B', constPool);
        this.setValue(by);
    }

    public ByteMemberValue(ConstPool constPool) {
        super('B', constPool);
        this.setValue((byte)0);
    }

    @Override
    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Byte(this.getValue());
    }

    @Override
    Class getType(ClassLoader classLoader) {
        return Byte.TYPE;
    }

    public byte getValue() {
        return (byte)this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(byte by) {
        this.valueIndex = this.cp.addIntegerInfo(by);
    }

    public String toString() {
        return Byte.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitByteMemberValue(this);
    }
}

