/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.annotation;

import com.jpattern.javassist.bytecode.ByteArray;
import com.jpattern.javassist.bytecode.ConstPool;
import java.io.IOException;
import java.io.OutputStream;

public class AnnotationsWriter {
    private OutputStream output;
    private ConstPool pool;

    public AnnotationsWriter(OutputStream outputStream, ConstPool constPool) {
        this.output = outputStream;
        this.pool = constPool;
    }

    public ConstPool getConstPool() {
        return this.pool;
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void numParameters(int n) throws IOException {
        this.output.write(n);
    }

    public void numAnnotations(int n) throws IOException {
        this.write16bit(n);
    }

    public void annotation(String string, int n) throws IOException {
        this.annotation(this.pool.addUtf8Info(string), n);
    }

    public void annotation(int n, int n2) throws IOException {
        this.write16bit(n);
        this.write16bit(n2);
    }

    public void memberValuePair(String string) throws IOException {
        this.memberValuePair(this.pool.addUtf8Info(string));
    }

    public void memberValuePair(int n) throws IOException {
        this.write16bit(n);
    }

    public void constValueIndex(boolean bl) throws IOException {
        this.constValueIndex(90, this.pool.addIntegerInfo(bl ? 1 : 0));
    }

    public void constValueIndex(byte by) throws IOException {
        this.constValueIndex(66, this.pool.addIntegerInfo(by));
    }

    public void constValueIndex(char c) throws IOException {
        this.constValueIndex(67, this.pool.addIntegerInfo(c));
    }

    public void constValueIndex(short s) throws IOException {
        this.constValueIndex(83, this.pool.addIntegerInfo(s));
    }

    public void constValueIndex(int n) throws IOException {
        this.constValueIndex(73, this.pool.addIntegerInfo(n));
    }

    public void constValueIndex(long l) throws IOException {
        this.constValueIndex(74, this.pool.addLongInfo(l));
    }

    public void constValueIndex(float f) throws IOException {
        this.constValueIndex(70, this.pool.addFloatInfo(f));
    }

    public void constValueIndex(double d) throws IOException {
        this.constValueIndex(68, this.pool.addDoubleInfo(d));
    }

    public void constValueIndex(String string) throws IOException {
        this.constValueIndex(115, this.pool.addUtf8Info(string));
    }

    public void constValueIndex(int n, int n2) throws IOException {
        this.output.write(n);
        this.write16bit(n2);
    }

    public void enumConstValue(String string, String string2) throws IOException {
        this.enumConstValue(this.pool.addUtf8Info(string), this.pool.addUtf8Info(string2));
    }

    public void enumConstValue(int n, int n2) throws IOException {
        this.output.write(101);
        this.write16bit(n);
        this.write16bit(n2);
    }

    public void classInfoIndex(String string) throws IOException {
        this.classInfoIndex(this.pool.addUtf8Info(string));
    }

    public void classInfoIndex(int n) throws IOException {
        this.output.write(99);
        this.write16bit(n);
    }

    public void annotationValue() throws IOException {
        this.output.write(64);
    }

    public void arrayValue(int n) throws IOException {
        this.output.write(91);
        this.write16bit(n);
    }

    private void write16bit(int n) throws IOException {
        byte[] byArray = new byte[2];
        ByteArray.write16bit(n, byArray, 0);
        this.output.write(byArray);
    }
}

