/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode;

import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.bytecode.AttributeInfo;
import com.jpattern.javassist.bytecode.BadBytecode;
import com.jpattern.javassist.bytecode.ByteArray;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.Descriptor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SignatureAttribute
extends AttributeInfo {
    public static final String tag = "Signature";

    SignatureAttribute(ConstPool constPool, int n, DataInputStream dataInputStream) throws IOException {
        super(constPool, n, dataInputStream);
    }

    public SignatureAttribute(ConstPool constPool, String string) {
        super(constPool, tag);
        int n = constPool.addUtf8Info(string);
        byte[] byArray = new byte[]{(byte)(n >>> 8), (byte)n};
        this.set(byArray);
    }

    public String getSignature() {
        return this.getConstPool().getUtf8Info(ByteArray.readU16bit(this.get(), 0));
    }

    public void setSignature(String string) {
        int n = this.getConstPool().addUtf8Info(string);
        ByteArray.write16bit(n, this.info, 0);
    }

    @Override
    public AttributeInfo copy(ConstPool constPool, Map map) {
        return new SignatureAttribute(constPool, this.getSignature());
    }

    @Override
    void renameClass(String string, String string2) {
        String string3 = SignatureAttribute.renameClass(this.getSignature(), string, string2);
        this.setSignature(string3);
    }

    @Override
    void renameClass(Map map) {
        String string = SignatureAttribute.renameClass(this.getSignature(), map);
        this.setSignature(string);
    }

    static String renameClass(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        return SignatureAttribute.renameClass(string, hashMap);
    }

    static String renameClass(String string, Map map) {
        int n;
        if (map == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf(76, n3)) >= 0) {
            char c;
            StringBuilder stringBuilder2 = new StringBuilder();
            int n4 = n;
            try {
                while ((c = string.charAt(++n4)) != ';') {
                    stringBuilder2.append(c);
                    if (c != '<') continue;
                    while ((c = string.charAt(++n4)) != '>') {
                        stringBuilder2.append(c);
                    }
                    stringBuilder2.append(c);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            n3 = n4 + 1;
            String string2 = stringBuilder2.toString();
            String string3 = (String)map.get(string2);
            if (string3 == null) continue;
            stringBuilder.append(string.substring(n2, n));
            stringBuilder.append('L');
            stringBuilder.append(string3);
            stringBuilder.append(c);
            n2 = n3;
        }
        if (n2 == 0) {
            return string;
        }
        n = string.length();
        if (n2 < n) {
            stringBuilder.append(string.substring(n2, n));
        }
        return stringBuilder.toString();
    }

    private static boolean isNamePart(int n) {
        return n != 59 && n != 60;
    }

    public static ClassSignature toClassSignature(String string) throws BadBytecode {
        try {
            return SignatureAttribute.parseSig(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    public static MethodSignature toMethodSignature(String string) throws BadBytecode {
        try {
            return SignatureAttribute.parseMethodSig(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    public static ObjectType toFieldSignature(String string) throws BadBytecode {
        try {
            return SignatureAttribute.parseObjectType(string, new Cursor(), false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    private static ClassSignature parseSig(String string) throws BadBytecode, IndexOutOfBoundsException {
        Cursor cursor = new Cursor();
        TypeParameter[] typeParameterArray = SignatureAttribute.parseTypeParams(string, cursor);
        ClassType classType = SignatureAttribute.parseClassType(string, cursor);
        int n = string.length();
        ArrayList<ClassType> arrayList = new ArrayList<ClassType>();
        while (cursor.position < n && string.charAt(cursor.position) == 'L') {
            arrayList.add(SignatureAttribute.parseClassType(string, cursor));
        }
        ClassType[] classTypeArray = arrayList.toArray(new ClassType[arrayList.size()]);
        return new ClassSignature(typeParameterArray, classType, classTypeArray);
    }

    private static MethodSignature parseMethodSig(String string) throws BadBytecode {
        Object object;
        Type type;
        Cursor cursor = new Cursor();
        TypeParameter[] typeParameterArray = SignatureAttribute.parseTypeParams(string, cursor);
        if (string.charAt(cursor.position++) != '(') {
            throw SignatureAttribute.error(string);
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while (string.charAt(cursor.position) != ')') {
            type = SignatureAttribute.parseType(string, cursor);
            arrayList.add(type);
        }
        ++cursor.position;
        type = SignatureAttribute.parseType(string, cursor);
        int n = string.length();
        ArrayList<Type[]> arrayList2 = new ArrayList<Type[]>();
        while (cursor.position < n && string.charAt(cursor.position) == '^') {
            ++cursor.position;
            object = SignatureAttribute.parseObjectType(string, cursor, false);
            if (object instanceof ArrayType) {
                throw SignatureAttribute.error(string);
            }
            arrayList2.add((Type[])object);
        }
        object = arrayList.toArray(new Type[arrayList.size()]);
        ObjectType[] objectTypeArray = arrayList2.toArray(new ObjectType[arrayList2.size()]);
        return new MethodSignature(typeParameterArray, (Type[])object, type, objectTypeArray);
    }

    private static TypeParameter[] parseTypeParams(String string, Cursor cursor) throws BadBytecode {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string.charAt(cursor.position) == '<') {
            ++cursor.position;
            while (string.charAt(cursor.position) != '>') {
                Object object;
                int n = cursor.position;
                int n2 = cursor.indexOf(string, 58);
                ObjectType objectType = SignatureAttribute.parseObjectType(string, cursor, true);
                ArrayList<ObjectType> arrayList2 = new ArrayList<ObjectType>();
                while (string.charAt(cursor.position) == ':') {
                    ++cursor.position;
                    object = SignatureAttribute.parseObjectType(string, cursor, false);
                    arrayList2.add((ObjectType)object);
                }
                object = new TypeParameter(string, n, n2, objectType, arrayList2.toArray(new ObjectType[arrayList2.size()]));
                arrayList.add(object);
            }
            ++cursor.position;
        }
        return arrayList.toArray(new TypeParameter[arrayList.size()]);
    }

    private static ObjectType parseObjectType(String string, Cursor cursor, boolean bl) throws BadBytecode {
        int n = cursor.position;
        switch (string.charAt(n)) {
            case 'L': {
                return SignatureAttribute.parseClassType2(string, cursor, null);
            }
            case 'T': {
                int n2 = cursor.indexOf(string, 59);
                return new TypeVariable(string, n + 1, n2);
            }
            case '[': {
                return SignatureAttribute.parseArray(string, cursor);
            }
        }
        if (bl) {
            return null;
        }
        throw SignatureAttribute.error(string);
    }

    private static ClassType parseClassType(String string, Cursor cursor) throws BadBytecode {
        if (string.charAt(cursor.position) == 'L') {
            return SignatureAttribute.parseClassType2(string, cursor, null);
        }
        throw SignatureAttribute.error(string);
    }

    private static ClassType parseClassType2(String string, Cursor cursor, ClassType classType) throws BadBytecode {
        TypeArgument[] typeArgumentArray;
        char c;
        int n = ++cursor.position;
        while ((c = string.charAt(cursor.position++)) != '$' && c != '<' && c != ';') {
        }
        int n2 = cursor.position - 1;
        if (c == '<') {
            typeArgumentArray = SignatureAttribute.parseTypeArgs(string, cursor);
            c = string.charAt(cursor.position++);
        } else {
            typeArgumentArray = null;
        }
        ClassType classType2 = ClassType.make(string, n, n2, typeArgumentArray, classType);
        if (c == '$') {
            --cursor.position;
            return SignatureAttribute.parseClassType2(string, cursor, classType2);
        }
        return classType2;
    }

    private static TypeArgument[] parseTypeArgs(String string, Cursor cursor) throws BadBytecode {
        char c;
        ArrayList<TypeArgument> arrayList = new ArrayList<TypeArgument>();
        while ((c = string.charAt(cursor.position++)) != '>') {
            TypeArgument typeArgument;
            if (c == '*') {
                typeArgument = new TypeArgument(null, '*');
            } else {
                if (c != '+' && c != '-') {
                    c = ' ';
                    --cursor.position;
                }
                typeArgument = new TypeArgument(SignatureAttribute.parseObjectType(string, cursor, false), c);
            }
            arrayList.add(typeArgument);
        }
        return arrayList.toArray(new TypeArgument[arrayList.size()]);
    }

    private static ObjectType parseArray(String string, Cursor cursor) throws BadBytecode {
        int n = 1;
        while (string.charAt(++cursor.position) == '[') {
            ++n;
        }
        return new ArrayType(n, SignatureAttribute.parseType(string, cursor));
    }

    private static Type parseType(String string, Cursor cursor) throws BadBytecode {
        Type type = SignatureAttribute.parseObjectType(string, cursor, true);
        if (type == null) {
            type = new BaseType(string.charAt(cursor.position++));
        }
        return type;
    }

    private static BadBytecode error(String string) {
        return new BadBytecode("bad signature: " + string);
    }

    public static class TypeVariable
    extends ObjectType {
        String name;

        TypeVariable(String string, int n, int n2) {
            this.name = string.substring(n, n2);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ArrayType
    extends ObjectType {
        int dim;
        Type componentType;

        public ArrayType(int n, Type type) {
            this.dim = n;
            this.componentType = type;
        }

        public int getDimension() {
            return this.dim;
        }

        public Type getComponentType() {
            return this.componentType;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.componentType.toString());
            for (int i = 0; i < this.dim; ++i) {
                stringBuffer.append("[]");
            }
            return stringBuffer.toString();
        }
    }

    public static class NestedClassType
    extends ClassType {
        ClassType parent;

        NestedClassType(String string, int n, int n2, TypeArgument[] typeArgumentArray, ClassType classType) {
            super(string, n, n2, typeArgumentArray);
            this.parent = classType;
        }

        @Override
        public ClassType getDeclaringClass() {
            return this.parent;
        }
    }

    public static class ClassType
    extends ObjectType {
        String name;
        TypeArgument[] arguments;

        static ClassType make(String string, int n, int n2, TypeArgument[] typeArgumentArray, ClassType classType) {
            if (classType == null) {
                return new ClassType(string, n, n2, typeArgumentArray);
            }
            return new NestedClassType(string, n, n2, typeArgumentArray, classType);
        }

        ClassType(String string, int n, int n2, TypeArgument[] typeArgumentArray) {
            this.name = string.substring(n, n2).replace('/', '.');
            this.arguments = typeArgumentArray;
        }

        public String getName() {
            return this.name;
        }

        public TypeArgument[] getTypeArguments() {
            return this.arguments;
        }

        public ClassType getDeclaringClass() {
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            ClassType classType = this.getDeclaringClass();
            if (classType != null) {
                stringBuffer.append(classType.toString()).append('.');
            }
            stringBuffer.append(this.name);
            if (this.arguments != null) {
                stringBuffer.append('<');
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.arguments[i].toString());
                }
                stringBuffer.append('>');
            }
            return stringBuffer.toString();
        }
    }

    public static abstract class ObjectType
    extends Type {
    }

    public static class BaseType
    extends Type {
        char descriptor;

        BaseType(char c) {
            this.descriptor = c;
        }

        public char getDescriptor() {
            return this.descriptor;
        }

        public CtClass getCtlass() {
            return Descriptor.toPrimitiveClass(this.descriptor);
        }

        public String toString() {
            return Descriptor.toClassName(Character.toString(this.descriptor));
        }
    }

    public static abstract class Type {
        static void toString(StringBuffer stringBuffer, Type[] typeArray) {
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(typeArray[i]);
            }
        }
    }

    public static class TypeArgument {
        ObjectType arg;
        char wildcard;

        TypeArgument(ObjectType objectType, char c) {
            this.arg = objectType;
            this.wildcard = c;
        }

        public char getKind() {
            return this.wildcard;
        }

        public boolean isWildcard() {
            return this.wildcard != ' ';
        }

        public ObjectType getType() {
            return this.arg;
        }

        public String toString() {
            if (this.wildcard == '*') {
                return "?";
            }
            String string = this.arg.toString();
            if (this.wildcard == ' ') {
                return string;
            }
            if (this.wildcard == '+') {
                return "? extends " + string;
            }
            return "? super " + string;
        }
    }

    public static class TypeParameter {
        String name;
        ObjectType superClass;
        ObjectType[] superInterfaces;

        TypeParameter(String string, int n, int n2, ObjectType objectType, ObjectType[] objectTypeArray) {
            this.name = string.substring(n, n2);
            this.superClass = objectType;
            this.superInterfaces = objectTypeArray;
        }

        public String getName() {
            return this.name;
        }

        public ObjectType getClassBound() {
            return this.superClass;
        }

        public ObjectType[] getInterfaceBound() {
            return this.superInterfaces;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer(this.getName());
            if (this.superClass != null) {
                stringBuffer.append(" extends ").append(this.superClass.toString());
            }
            if ((n = this.superInterfaces.length) > 0) {
                for (int i = 0; i < n; ++i) {
                    if (i > 0 || this.superClass != null) {
                        stringBuffer.append(" & ");
                    } else {
                        stringBuffer.append(" extends ");
                    }
                    stringBuffer.append(this.superInterfaces[i].toString());
                }
            }
            return stringBuffer.toString();
        }

        static void toString(StringBuffer stringBuffer, TypeParameter[] typeParameterArray) {
            stringBuffer.append('<');
            for (int i = 0; i < typeParameterArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(typeParameterArray[i]);
            }
            stringBuffer.append('>');
        }
    }

    public static class MethodSignature {
        TypeParameter[] typeParams;
        Type[] params;
        Type retType;
        ObjectType[] exceptions;

        MethodSignature(TypeParameter[] typeParameterArray, Type[] typeArray, Type type, ObjectType[] objectTypeArray) {
            this.typeParams = typeParameterArray;
            this.params = typeArray;
            this.retType = type;
            this.exceptions = objectTypeArray;
        }

        public TypeParameter[] getTypeParameters() {
            return this.typeParams;
        }

        public Type[] getParameterTypes() {
            return this.params;
        }

        public Type getReturnType() {
            return this.retType;
        }

        public ObjectType[] getExceptionTypes() {
            return this.exceptions;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            TypeParameter.toString(stringBuffer, this.typeParams);
            stringBuffer.append(" (");
            Type.toString(stringBuffer, this.params);
            stringBuffer.append(") ");
            stringBuffer.append(this.retType);
            if (this.exceptions.length > 0) {
                stringBuffer.append(" throws ");
                Type.toString(stringBuffer, this.exceptions);
            }
            return stringBuffer.toString();
        }
    }

    public static class ClassSignature {
        TypeParameter[] params;
        ClassType superClass;
        ClassType[] interfaces;

        ClassSignature(TypeParameter[] typeParameterArray, ClassType classType, ClassType[] classTypeArray) {
            this.params = typeParameterArray;
            this.superClass = classType;
            this.interfaces = classTypeArray;
        }

        public TypeParameter[] getParameters() {
            return this.params;
        }

        public ClassType getSuperClass() {
            return this.superClass;
        }

        public ClassType[] getInterfaces() {
            return this.interfaces;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            TypeParameter.toString(stringBuffer, this.params);
            stringBuffer.append(" extends ").append(this.superClass);
            if (this.interfaces.length > 0) {
                stringBuffer.append(" implements ");
                Type.toString(stringBuffer, this.interfaces);
            }
            return stringBuffer.toString();
        }
    }

    private static class Cursor {
        int position = 0;

        private Cursor() {
        }

        int indexOf(String string, int n) throws BadBytecode {
            int n2 = string.indexOf(n, this.position);
            if (n2 < 0) {
                throw SignatureAttribute.error(string);
            }
            this.position = n2 + 1;
            return n2;
        }
    }
}

