/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode;

import com.jpattern.javassist.bytecode.AttributeInfo;
import com.jpattern.javassist.bytecode.ByteArray;
import com.jpattern.javassist.bytecode.ConstPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class ConstantAttribute
extends AttributeInfo {
    public static final String tag = "ConstantValue";

    ConstantAttribute(ConstPool constPool, int n, DataInputStream dataInputStream) throws IOException {
        super(constPool, n, dataInputStream);
    }

    public ConstantAttribute(ConstPool constPool, int n) {
        super(constPool, tag);
        byte[] byArray = new byte[]{(byte)(n >>> 8), (byte)n};
        this.set(byArray);
    }

    public int getConstantValue() {
        return ByteArray.readU16bit(this.get(), 0);
    }

    @Override
    public AttributeInfo copy(ConstPool constPool, Map map) {
        int n = this.getConstPool().copy(this.getConstantValue(), constPool, map);
        return new ConstantAttribute(constPool, n);
    }
}

