/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode;

import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.bytecode.ClassInfo;
import com.jpattern.javassist.bytecode.ConstInfo;
import com.jpattern.javassist.bytecode.ConstInfoPadding;
import com.jpattern.javassist.bytecode.Descriptor;
import com.jpattern.javassist.bytecode.DoubleInfo;
import com.jpattern.javassist.bytecode.FieldrefInfo;
import com.jpattern.javassist.bytecode.FloatInfo;
import com.jpattern.javassist.bytecode.IntegerInfo;
import com.jpattern.javassist.bytecode.InterfaceMethodrefInfo;
import com.jpattern.javassist.bytecode.LongInfo;
import com.jpattern.javassist.bytecode.LongVector;
import com.jpattern.javassist.bytecode.MemberrefInfo;
import com.jpattern.javassist.bytecode.MethodrefInfo;
import com.jpattern.javassist.bytecode.NameAndTypeInfo;
import com.jpattern.javassist.bytecode.StringInfo;
import com.jpattern.javassist.bytecode.Utf8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ConstPool {
    LongVector items;
    int numOfItems;
    int thisClassInfo;
    HashMap itemsCache;
    public static final int CONST_Class = 7;
    public static final int CONST_Fieldref = 9;
    public static final int CONST_Methodref = 10;
    public static final int CONST_InterfaceMethodref = 11;
    public static final int CONST_String = 8;
    public static final int CONST_Integer = 3;
    public static final int CONST_Float = 4;
    public static final int CONST_Long = 5;
    public static final int CONST_Double = 6;
    public static final int CONST_NameAndType = 12;
    public static final int CONST_Utf8 = 1;
    public static final CtClass THIS = null;

    public ConstPool(String string) {
        this.items = new LongVector();
        this.itemsCache = null;
        this.numOfItems = 0;
        this.addItem0(null);
        this.thisClassInfo = this.addClassInfo(string);
    }

    public ConstPool(DataInputStream dataInputStream) throws IOException {
        this.itemsCache = null;
        this.thisClassInfo = 0;
        this.read(dataInputStream);
    }

    void prune() {
        this.itemsCache = null;
    }

    public int getSize() {
        return this.numOfItems;
    }

    public String getClassName() {
        return this.getClassInfo(this.thisClassInfo);
    }

    public int getThisClassInfo() {
        return this.thisClassInfo;
    }

    void setThisClassInfo(int n) {
        this.thisClassInfo = n;
    }

    ConstInfo getItem(int n) {
        return this.items.elementAt(n);
    }

    public int getTag(int n) {
        return this.getItem(n).getTag();
    }

    public String getClassInfo(int n) {
        ClassInfo classInfo = (ClassInfo)this.getItem(n);
        if (classInfo == null) {
            return null;
        }
        return Descriptor.toJavaName(this.getUtf8Info(classInfo.name));
    }

    public String getClassInfoByDescriptor(int n) {
        ClassInfo classInfo = (ClassInfo)this.getItem(n);
        if (classInfo == null) {
            return null;
        }
        String string = this.getUtf8Info(classInfo.name);
        if (string.charAt(0) == '[') {
            return string;
        }
        return Descriptor.of(string);
    }

    public int getNameAndTypeName(int n) {
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(n);
        return nameAndTypeInfo.memberName;
    }

    public int getNameAndTypeDescriptor(int n) {
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(n);
        return nameAndTypeInfo.typeDescriptor;
    }

    public int getMemberClass(int n) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(n);
        return memberrefInfo.classIndex;
    }

    public int getMemberNameAndType(int n) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(n);
        return memberrefInfo.nameAndTypeIndex;
    }

    public int getFieldrefClass(int n) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n);
        return fieldrefInfo.classIndex;
    }

    public String getFieldrefClassName(int n) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n);
        if (fieldrefInfo == null) {
            return null;
        }
        return this.getClassInfo(fieldrefInfo.classIndex);
    }

    public int getFieldrefNameAndType(int n) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n);
        return fieldrefInfo.nameAndTypeIndex;
    }

    public String getFieldrefName(int n) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n);
        if (fieldrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(fieldrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.memberName);
    }

    public String getFieldrefType(int n) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n);
        if (fieldrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(fieldrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public int getMethodrefClass(int n) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n);
        return methodrefInfo.classIndex;
    }

    public String getMethodrefClassName(int n) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n);
        if (methodrefInfo == null) {
            return null;
        }
        return this.getClassInfo(methodrefInfo.classIndex);
    }

    public int getMethodrefNameAndType(int n) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n);
        return methodrefInfo.nameAndTypeIndex;
    }

    public String getMethodrefName(int n) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n);
        if (methodrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(methodrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.memberName);
    }

    public String getMethodrefType(int n) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n);
        if (methodrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(methodrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public int getInterfaceMethodrefClass(int n) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n);
        return interfaceMethodrefInfo.classIndex;
    }

    public String getInterfaceMethodrefClassName(int n) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n);
        return this.getClassInfo(interfaceMethodrefInfo.classIndex);
    }

    public int getInterfaceMethodrefNameAndType(int n) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n);
        return interfaceMethodrefInfo.nameAndTypeIndex;
    }

    public String getInterfaceMethodrefName(int n) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n);
        if (interfaceMethodrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(interfaceMethodrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.memberName);
    }

    public String getInterfaceMethodrefType(int n) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n);
        if (interfaceMethodrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(interfaceMethodrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public Object getLdcValue(int n) {
        ConstInfo constInfo = this.getItem(n);
        Object object = null;
        object = constInfo instanceof StringInfo ? this.getStringInfo(n) : (constInfo instanceof FloatInfo ? (Number)new Float(this.getFloatInfo(n)) : (Number)(constInfo instanceof IntegerInfo ? (Number)new Integer(this.getIntegerInfo(n)) : (Number)(constInfo instanceof LongInfo ? (Number)new Long(this.getLongInfo(n)) : (Number)(constInfo instanceof DoubleInfo ? new Double(this.getDoubleInfo(n)) : null))));
        return object;
    }

    public int getIntegerInfo(int n) {
        IntegerInfo integerInfo = (IntegerInfo)this.getItem(n);
        return integerInfo.value;
    }

    public float getFloatInfo(int n) {
        FloatInfo floatInfo = (FloatInfo)this.getItem(n);
        return floatInfo.value;
    }

    public long getLongInfo(int n) {
        LongInfo longInfo = (LongInfo)this.getItem(n);
        return longInfo.value;
    }

    public double getDoubleInfo(int n) {
        DoubleInfo doubleInfo = (DoubleInfo)this.getItem(n);
        return doubleInfo.value;
    }

    public String getStringInfo(int n) {
        StringInfo stringInfo = (StringInfo)this.getItem(n);
        return this.getUtf8Info(stringInfo.string);
    }

    public String getUtf8Info(int n) {
        Utf8Info utf8Info = (Utf8Info)this.getItem(n);
        return utf8Info.string;
    }

    public int isConstructor(String string, int n) {
        return this.isMember(string, "<init>", n);
    }

    public int isMember(String string, String string2, int n) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(n);
        if (this.getClassInfo(memberrefInfo.classIndex).equals(string)) {
            NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
            if (this.getUtf8Info(nameAndTypeInfo.memberName).equals(string2)) {
                return nameAndTypeInfo.typeDescriptor;
            }
        }
        return 0;
    }

    public String eqMember(String string, String string2, int n) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(n);
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
        if (this.getUtf8Info(nameAndTypeInfo.memberName).equals(string) && this.getUtf8Info(nameAndTypeInfo.typeDescriptor).equals(string2)) {
            return this.getClassInfo(memberrefInfo.classIndex);
        }
        return null;
    }

    private int addItem0(ConstInfo constInfo) {
        this.items.addElement(constInfo);
        return this.numOfItems++;
    }

    private int addItem(ConstInfo constInfo) {
        ConstInfo constInfo2;
        if (this.itemsCache == null) {
            this.itemsCache = ConstPool.makeItemsCache(this.items);
        }
        if ((constInfo2 = (ConstInfo)this.itemsCache.get(constInfo)) != null) {
            return constInfo2.index;
        }
        this.items.addElement(constInfo);
        this.itemsCache.put(constInfo, constInfo);
        return this.numOfItems++;
    }

    public int copy(int n, ConstPool constPool, Map map) {
        if (n == 0) {
            return 0;
        }
        ConstInfo constInfo = this.getItem(n);
        return constInfo.copy(this, constPool, map);
    }

    int addConstInfoPadding() {
        return this.addItem0(new ConstInfoPadding(this.numOfItems));
    }

    public int addClassInfo(CtClass ctClass) {
        if (ctClass == THIS) {
            return this.thisClassInfo;
        }
        if (!ctClass.isArray()) {
            return this.addClassInfo(ctClass.getName());
        }
        return this.addClassInfo(Descriptor.toJvmName(ctClass));
    }

    public int addClassInfo(String string) {
        int n = this.addUtf8Info(Descriptor.toJvmName(string));
        return this.addItem(new ClassInfo(n, this.numOfItems));
    }

    public int addNameAndTypeInfo(String string, String string2) {
        return this.addNameAndTypeInfo(this.addUtf8Info(string), this.addUtf8Info(string2));
    }

    public int addNameAndTypeInfo(int n, int n2) {
        return this.addItem(new NameAndTypeInfo(n, n2, this.numOfItems));
    }

    public int addFieldrefInfo(int n, String string, String string2) {
        int n2 = this.addNameAndTypeInfo(string, string2);
        return this.addFieldrefInfo(n, n2);
    }

    public int addFieldrefInfo(int n, int n2) {
        return this.addItem(new FieldrefInfo(n, n2, this.numOfItems));
    }

    public int addMethodrefInfo(int n, String string, String string2) {
        int n2 = this.addNameAndTypeInfo(string, string2);
        return this.addMethodrefInfo(n, n2);
    }

    public int addMethodrefInfo(int n, int n2) {
        return this.addItem(new MethodrefInfo(n, n2, this.numOfItems));
    }

    public int addInterfaceMethodrefInfo(int n, String string, String string2) {
        int n2 = this.addNameAndTypeInfo(string, string2);
        return this.addInterfaceMethodrefInfo(n, n2);
    }

    public int addInterfaceMethodrefInfo(int n, int n2) {
        return this.addItem(new InterfaceMethodrefInfo(n, n2, this.numOfItems));
    }

    public int addStringInfo(String string) {
        int n = this.addUtf8Info(string);
        return this.addItem(new StringInfo(n, this.numOfItems));
    }

    public int addIntegerInfo(int n) {
        return this.addItem(new IntegerInfo(n, this.numOfItems));
    }

    public int addFloatInfo(float f) {
        return this.addItem(new FloatInfo(f, this.numOfItems));
    }

    public int addLongInfo(long l) {
        int n = this.addItem(new LongInfo(l, this.numOfItems));
        if (n == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return n;
    }

    public int addDoubleInfo(double d) {
        int n = this.addItem(new DoubleInfo(d, this.numOfItems));
        if (n == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return n;
    }

    public int addUtf8Info(String string) {
        return this.addItem(new Utf8Info(string, this.numOfItems));
    }

    public Set getClassNames() {
        HashSet<String> hashSet = new HashSet<String>();
        LongVector longVector = this.items;
        int n = this.numOfItems;
        for (int i = 1; i < n; ++i) {
            String string = longVector.elementAt(i).getClassName(this);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void renameClass(String string, String string2) {
        LongVector longVector = this.items;
        int n = this.numOfItems;
        for (int i = 1; i < n; ++i) {
            ConstInfo constInfo = longVector.elementAt(i);
            constInfo.renameClass(this, string, string2, this.itemsCache);
        }
    }

    public void renameClass(Map map) {
        LongVector longVector = this.items;
        int n = this.numOfItems;
        for (int i = 1; i < n; ++i) {
            ConstInfo constInfo = longVector.elementAt(i);
            constInfo.renameClass(this, map, this.itemsCache);
        }
    }

    private void read(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        this.items = new LongVector(n);
        this.numOfItems = 0;
        this.addItem0(null);
        while (--n > 0) {
            int n2 = this.readOne(dataInputStream);
            if (n2 != 5 && n2 != 6) continue;
            this.addConstInfoPadding();
            --n;
        }
    }

    private static HashMap makeItemsCache(LongVector longVector) {
        ConstInfo constInfo;
        HashMap<ConstInfo, ConstInfo> hashMap = new HashMap<ConstInfo, ConstInfo>();
        int n = 1;
        while ((constInfo = longVector.elementAt(n++)) != null) {
            hashMap.put(constInfo, constInfo);
        }
        return hashMap;
    }

    private int readOne(DataInputStream dataInputStream) throws IOException {
        ConstInfo constInfo;
        int n = dataInputStream.readUnsignedByte();
        switch (n) {
            case 1: {
                constInfo = new Utf8Info(dataInputStream, this.numOfItems);
                break;
            }
            case 3: {
                constInfo = new IntegerInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 4: {
                constInfo = new FloatInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 5: {
                constInfo = new LongInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 6: {
                constInfo = new DoubleInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 7: {
                constInfo = new ClassInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 8: {
                constInfo = new StringInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 9: {
                constInfo = new FieldrefInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 10: {
                constInfo = new MethodrefInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 11: {
                constInfo = new InterfaceMethodrefInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 12: {
                constInfo = new NameAndTypeInfo(dataInputStream, this.numOfItems);
                break;
            }
            default: {
                throw new IOException("invalid constant type: " + n + " at " + this.numOfItems);
            }
        }
        this.addItem0(constInfo);
        return n;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.numOfItems);
        LongVector longVector = this.items;
        int n = this.numOfItems;
        for (int i = 1; i < n; ++i) {
            longVector.elementAt(i).write(dataOutputStream);
        }
    }

    public void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public void print(PrintWriter printWriter) {
        int n = this.numOfItems;
        for (int i = 1; i < n; ++i) {
            printWriter.print(i);
            printWriter.print(" ");
            this.items.elementAt(i).print(printWriter);
        }
    }
}

