/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.AbstractConnectionStrategy;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.ConnectionPartition;
import com.jolbox.bonecp.PoolUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class DefaultConnectionStrategy
extends AbstractConnectionStrategy {
    private static final long serialVersionUID = 962520166486807512L;

    public DefaultConnectionStrategy(BoneCP pool) {
        this.pool = pool;
    }

    public ConnectionHandle pollConnection() {
        ConnectionHandle result = null;
        int partition = (int)(Thread.currentThread().getId() % (long)this.pool.partitionCount);
        ConnectionPartition connectionPartition = this.pool.partitions[partition];
        result = (ConnectionHandle)connectionPartition.getFreeConnections().poll();
        if (result == null) {
            for (int i = 0; i < this.pool.partitionCount; ++i) {
                if (i == partition) continue;
                result = (ConnectionHandle)this.pool.partitions[i].getFreeConnections().poll();
                connectionPartition = this.pool.partitions[i];
                if (result != null) break;
            }
        }
        if (!connectionPartition.isUnableToCreateMoreTransactions()) {
            this.pool.maybeSignalForMoreConnections(connectionPartition);
        }
        return result;
    }

    protected Connection getConnectionInternal() throws SQLException {
        ConnectionHandle result = this.pollConnection();
        int partition = (int)(Thread.currentThread().getId() % (long)this.pool.partitionCount);
        ConnectionPartition connectionPartition = this.pool.partitions[partition];
        if (result == null) {
            try {
                result = connectionPartition.getFreeConnections().poll(this.pool.connectionTimeoutInMs, TimeUnit.MILLISECONDS);
                if (result == null) {
                    if (this.pool.nullOnConnectionTimeout) {
                        return null;
                    }
                    throw new SQLException("Timed out waiting for a free available connection.", "08001");
                }
            }
            catch (InterruptedException e) {
                if (this.pool.nullOnConnectionTimeout) {
                    return null;
                }
                throw PoolUtil.generateSQLException(e.getMessage(), e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateAllConnections() {
        this.terminationLock.lock();
        try {
            for (int i = 0; i < this.pool.partitionCount; ++i) {
                this.pool.partitions[i].setUnableToCreateMoreTransactions(false);
                LinkedList clist = new LinkedList();
                this.pool.partitions[i].getFreeConnections().drainTo(clist);
                for (ConnectionHandle c : clist) {
                    this.pool.destroyConnection(c);
                }
            }
        }
        finally {
            this.terminationLock.unlock();
        }
    }
}

