/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagging.StandardNamespaces;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.RoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.RoleMappingResolverPdf2;
import com.itextpdf.kernel.pdf.tagutils.RootTagNormalizer;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.tagutils.WaitingTagsManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagStructureContext {
    private static final Set<String> allowedRootTagRoles = new HashSet<String>();
    private PdfDocument document;
    private PdfStructElem rootTagElement;
    protected TagTreePointer autoTaggingPointer;
    private PdfVersion tagStructureTargetVersion;
    private boolean forbidUnknownRoles;
    private WaitingTagsManager waitingTagsManager;
    private Set<PdfDictionary> namespaces;
    private Map<String, PdfNamespace> nameToNamespace;
    private PdfNamespace documentDefaultNamespace;

    public TagStructureContext(PdfDocument document) {
        this(document, document.getPdfVersion());
    }

    public TagStructureContext(PdfDocument document, PdfVersion tagStructureTargetVersion) {
        this.document = document;
        if (!document.isTagged()) {
            throw new PdfException("Must be a tagged document.");
        }
        this.waitingTagsManager = new WaitingTagsManager();
        this.namespaces = new LinkedHashSet<PdfDictionary>();
        this.nameToNamespace = new HashMap<String, PdfNamespace>();
        this.tagStructureTargetVersion = tagStructureTargetVersion;
        this.forbidUnknownRoles = true;
        if (this.targetTagStructureVersionIs2()) {
            this.initRegisteredNamespaces();
            this.setNamespaceForNewTagsBasedOnExistingRoot();
        }
    }

    public TagStructureContext setForbidUnknownRoles(boolean forbidUnknownRoles) {
        this.forbidUnknownRoles = forbidUnknownRoles;
        return this;
    }

    public PdfVersion getTagStructureTargetVersion() {
        return this.tagStructureTargetVersion;
    }

    public TagTreePointer getAutoTaggingPointer() {
        if (this.autoTaggingPointer == null) {
            this.autoTaggingPointer = new TagTreePointer(this.document);
        }
        return this.autoTaggingPointer;
    }

    public WaitingTagsManager getWaitingTagsManager() {
        return this.waitingTagsManager;
    }

    public PdfNamespace getDocumentDefaultNamespace() {
        return this.documentDefaultNamespace;
    }

    public TagStructureContext setDocumentDefaultNamespace(PdfNamespace namespace) {
        this.documentDefaultNamespace = namespace;
        return this;
    }

    public PdfNamespace fetchNamespace(String namespaceName) {
        PdfNamespace ns = this.nameToNamespace.get(namespaceName);
        if (ns == null) {
            ns = new PdfNamespace(namespaceName);
            this.nameToNamespace.put(namespaceName, ns);
        }
        return ns;
    }

    public IRoleMappingResolver getRoleMappingResolver(String role) {
        return this.getRoleMappingResolver(role, null);
    }

    public IRoleMappingResolver getRoleMappingResolver(String role, PdfNamespace namespace) {
        if (this.targetTagStructureVersionIs2()) {
            return new RoleMappingResolverPdf2(role, namespace, this.getDocument());
        }
        return new RoleMappingResolver(role, this.getDocument());
    }

    public boolean checkIfRoleShallBeMappedToStandardRole(String role, PdfNamespace namespace) {
        return this.resolveMappingToStandardOrDomainSpecificRole(role, namespace) != null;
    }

    public IRoleMappingResolver resolveMappingToStandardOrDomainSpecificRole(String role, PdfNamespace namespace) {
        IRoleMappingResolver mappingResolver = this.getRoleMappingResolver(role, namespace);
        mappingResolver.resolveNextMapping();
        int i = 0;
        int maxIters = 100;
        while (mappingResolver.currentRoleShallBeMappedToStandard()) {
            if (++i > maxIters) {
                Logger logger = LoggerFactory.getLogger(TagStructureContext.class);
                logger.error(this.composeTooMuchTransitiveMappingsException(role, namespace));
                return null;
            }
            if (mappingResolver.resolveNextMapping()) continue;
            return null;
        }
        return mappingResolver;
    }

    public TagTreePointer removeAnnotationTag(PdfAnnotation annotation) {
        PdfObjRef objRef;
        PdfStructElem structElem = null;
        PdfDictionary annotDic = (PdfDictionary)annotation.getPdfObject();
        PdfNumber structParentIndex = (PdfNumber)annotDic.get(PdfName.StructParent);
        if (structParentIndex != null && (objRef = this.document.getStructTreeRoot().findObjRefByStructParentIndex(annotDic.getAsDictionary(PdfName.P), structParentIndex.intValue())) != null) {
            PdfStructElem parent = (PdfStructElem)objRef.getParent();
            parent.removeKid(objRef);
            structElem = parent;
        }
        annotDic.remove(PdfName.StructParent);
        annotDic.setModified();
        if (structElem != null) {
            return new TagTreePointer(this.document).setCurrentStructElem(structElem);
        }
        return null;
    }

    public TagTreePointer removeContentItem(PdfPage page, int mcid) {
        PdfMcr mcr = this.document.getStructTreeRoot().findMcrByMcid((PdfDictionary)page.getPdfObject(), mcid);
        if (mcr == null) {
            return null;
        }
        PdfStructElem parent = (PdfStructElem)mcr.getParent();
        parent.removeKid(mcr);
        return new TagTreePointer(this.document).setCurrentStructElem(parent);
    }

    public TagStructureContext removePageTags(PdfPage page) {
        PdfStructTreeRoot structTreeRoot = this.document.getStructTreeRoot();
        Collection<PdfMcr> pageMcrs = structTreeRoot.getPageMarkedContentReferences(page);
        if (pageMcrs != null) {
            ArrayList<PdfMcr> mcrsList = new ArrayList<PdfMcr>(pageMcrs);
            for (PdfMcr mcr : mcrsList) {
                this.removePageTagFromParent(mcr, mcr.getParent());
            }
        }
        return this;
    }

    public TagStructureContext flushPageTags(PdfPage page) {
        PdfStructTreeRoot structTreeRoot = this.document.getStructTreeRoot();
        Collection<PdfMcr> pageMcrs = structTreeRoot.getPageMarkedContentReferences(page);
        if (pageMcrs != null) {
            for (PdfMcr mcr : pageMcrs) {
                PdfStructElem parent = (PdfStructElem)mcr.getParent();
                this.flushParentIfBelongsToPage(parent, page);
            }
        }
        return this;
    }

    public void normalizeDocumentRootTag() {
        boolean forbid = this.forbidUnknownRoles;
        this.forbidUnknownRoles = false;
        List<IStructureNode> rootKids = this.document.getStructTreeRoot().getKids();
        IRoleMappingResolver mapping = null;
        if (rootKids.size() > 0) {
            PdfStructElem firstKid = (PdfStructElem)rootKids.get(0);
            mapping = this.resolveMappingToStandardOrDomainSpecificRole(firstKid.getRole().getValue(), firstKid.getNamespace());
        }
        if (rootKids.size() == 1 && mapping != null && mapping.currentRoleIsStandard() && this.isRoleAllowedToBeRoot(mapping.getRole())) {
            this.rootTagElement = (PdfStructElem)rootKids.get(0);
        } else {
            ((PdfDictionary)this.document.getStructTreeRoot().getPdfObject()).remove(PdfName.K);
            this.rootTagElement = new RootTagNormalizer(this, this.rootTagElement, this.document).makeSingleStandardRootTag(rootKids);
        }
        this.forbidUnknownRoles = forbid;
    }

    public void prepareToDocumentClosing() {
        this.waitingTagsManager.removeAllWaitingStates();
        this.actualizeNamespacesInStructTreeRoot();
    }

    public PdfStructElem getPointerStructElem(TagTreePointer pointer) {
        return pointer.getCurrentStructElem();
    }

    public TagTreePointer createPointerForStructElem(PdfStructElem structElem) {
        return new TagTreePointer(structElem, this.document);
    }

    PdfStructElem getRootTag() {
        if (this.rootTagElement == null) {
            this.normalizeDocumentRootTag();
        }
        return this.rootTagElement;
    }

    PdfDocument getDocument() {
        return this.document;
    }

    void ensureNamespaceRegistered(PdfNamespace namespace) {
        if (namespace != null) {
            PdfDictionary namespaceObj = (PdfDictionary)namespace.getPdfObject();
            if (!this.namespaces.contains(namespaceObj)) {
                this.namespaces.add(namespaceObj);
            }
            this.nameToNamespace.put(namespace.getNamespaceName(), namespace);
        }
    }

    void throwExceptionIfRoleIsInvalid(AccessibilityProperties properties, PdfNamespace pointerCurrentNamespace) {
        PdfNamespace namespace = properties.getNamespace();
        if (namespace == null) {
            namespace = pointerCurrentNamespace;
        }
        this.throwExceptionIfRoleIsInvalid(properties.getRole(), namespace);
    }

    void throwExceptionIfRoleIsInvalid(String role, PdfNamespace namespace) {
        if (!this.checkIfRoleShallBeMappedToStandardRole(role, namespace)) {
            String exMessage = this.composeInvalidRoleException(role, namespace);
            if (this.forbidUnknownRoles) {
                throw new PdfException(exMessage);
            }
            Logger logger = LoggerFactory.getLogger(TagStructureContext.class);
            logger.warn(exMessage);
        }
    }

    boolean targetTagStructureVersionIs2() {
        return PdfVersion.PDF_2_0.compareTo(this.tagStructureTargetVersion) <= 0;
    }

    void flushParentIfBelongsToPage(PdfStructElem parent, PdfPage currentPage) {
        if (parent.isFlushed() || this.waitingTagsManager.getObjForStructDict((PdfDictionary)parent.getPdfObject()) != null || parent.getParent() instanceof PdfStructTreeRoot) {
            return;
        }
        List<IStructureNode> kids = parent.getKids();
        boolean readyToBeFlushed = true;
        for (IStructureNode kid : kids) {
            if (kid instanceof PdfMcr) {
                PdfDictionary kidPage = ((PdfMcr)kid).getPageObject();
                if (kidPage.isFlushed() || currentPage != null && kidPage.equals(currentPage.getPdfObject())) continue;
                readyToBeFlushed = false;
                break;
            }
            if (!(kid instanceof PdfStructElem)) continue;
            readyToBeFlushed = false;
            break;
        }
        if (readyToBeFlushed) {
            IStructureNode parentsParent = parent.getParent();
            parent.flush();
            if (parentsParent instanceof PdfStructElem) {
                this.flushParentIfBelongsToPage((PdfStructElem)parentsParent, currentPage);
            }
        }
    }

    private boolean isRoleAllowedToBeRoot(String role) {
        if (this.targetTagStructureVersionIs2()) {
            return "Document".equals(role);
        }
        return allowedRootTagRoles.contains(role);
    }

    private void setNamespaceForNewTagsBasedOnExistingRoot() {
        List<IStructureNode> rootKids = this.document.getStructTreeRoot().getKids();
        if (rootKids.size() > 0) {
            PdfStructElem firstKid = (PdfStructElem)rootKids.get(0);
            IRoleMappingResolver resolvedMapping = this.resolveMappingToStandardOrDomainSpecificRole(firstKid.getRole().getValue(), firstKid.getNamespace());
            if (resolvedMapping == null || !resolvedMapping.currentRoleIsStandard()) {
                Logger logger = LoggerFactory.getLogger(TagStructureContext.class);
                String nsStr = firstKid.getNamespace() != null ? firstKid.getNamespace().getNamespaceName() : StandardNamespaces.getDefault();
                logger.warn(MessageFormat.format("Existing tag structure of the document has a root of \"{0}\" role in \"{1}\" namespace that is not mapped to the standard role.", firstKid.getRole().getValue(), nsStr));
            }
            if (resolvedMapping == null || !"http://iso.org/pdf/ssn".equals(resolvedMapping.getNamespace().getNamespaceName())) {
                this.documentDefaultNamespace = this.fetchNamespace("http://iso.org/pdf2/ssn");
            }
        } else {
            this.documentDefaultNamespace = this.fetchNamespace("http://iso.org/pdf2/ssn");
        }
    }

    private String composeInvalidRoleException(String role, PdfNamespace namespace) {
        return this.composeExceptionBasedOnNamespacePresence(role, namespace, "Role \"{0}\" is not mapped to any standard role.", "Role \"{0}\" in namespace {1} is not mapped to any standard role.");
    }

    private String composeTooMuchTransitiveMappingsException(String role, PdfNamespace namespace) {
        return this.composeExceptionBasedOnNamespacePresence(role, namespace, "Cannot resolve \"{0}\" role mapping to standard role, because of the too much transitive mappings.", "Cannot resolve \"{0}\" role in {1} namespace mapping to standard role, because of the too much transitive mappings.");
    }

    private void initRegisteredNamespaces() {
        PdfStructTreeRoot structTreeRoot = this.document.getStructTreeRoot();
        for (PdfNamespace namespace : structTreeRoot.getNamespaces()) {
            this.namespaces.add((PdfDictionary)namespace.getPdfObject());
            this.nameToNamespace.put(namespace.getNamespaceName(), namespace);
        }
    }

    private void actualizeNamespacesInStructTreeRoot() {
        if (this.namespaces.size() > 0) {
            PdfStructTreeRoot structTreeRoot = this.getDocument().getStructTreeRoot();
            PdfArray rootNamespaces = structTreeRoot.getNamespacesObject();
            LinkedHashSet<PdfDictionary> newNamespaces = new LinkedHashSet<PdfDictionary>(this.namespaces);
            for (int i = 0; i < rootNamespaces.size(); ++i) {
                newNamespaces.remove(rootNamespaces.getAsDictionary(i));
            }
            for (PdfDictionary newNs : newNamespaces) {
                rootNamespaces.add(newNs);
            }
            if (!newNamespaces.isEmpty()) {
                structTreeRoot.setModified();
            }
        }
    }

    private void removePageTagFromParent(IStructureNode pageTag, IStructureNode parent) {
        if (parent instanceof PdfStructElem) {
            PdfStructElem structParent = (PdfStructElem)parent;
            if (!structParent.isFlushed()) {
                structParent.removeKid(pageTag);
                PdfDictionary parentStructDict = (PdfDictionary)structParent.getPdfObject();
                if (this.waitingTagsManager.getObjForStructDict(parentStructDict) == null && parent.getKids().size() == 0 && !(structParent.getParent() instanceof PdfStructTreeRoot)) {
                    this.removePageTagFromParent(structParent, parent.getParent());
                    PdfIndirectReference indRef = parentStructDict.getIndirectReference();
                    if (indRef != null) {
                        indRef.setFree();
                    }
                }
            } else if (pageTag instanceof PdfMcr) {
                throw new PdfException("Cannot remove tag, because its parent is flushed.");
            }
        }
    }

    private String composeExceptionBasedOnNamespacePresence(String role, PdfNamespace namespace, String withoutNsEx, String withNsEx) {
        if (namespace == null) {
            return MessageFormat.format(withoutNsEx, role);
        }
        String nsName = namespace.getNamespaceName();
        PdfIndirectReference ref = ((PdfDictionary)namespace.getPdfObject()).getIndirectReference();
        if (ref != null) {
            nsName = nsName + " (" + Integer.toString(ref.getObjNumber()) + " " + Integer.toString(ref.getGenNumber()) + " obj)";
        }
        return MessageFormat.format(withNsEx, role, nsName);
    }

    static {
        allowedRootTagRoles.add("Document");
        allowedRootTagRoles.add("Part");
        allowedRootTagRoles.add("Art");
        allowedRootTagRoles.add("Sect");
        allowedRootTagRoles.add("Div");
    }
}

