/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.VersionConforming;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfMcrDictionary;
import com.itextpdf.kernel.pdf.tagging.PdfMcrNumber;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfStructElem
extends PdfObjectWrapper<PdfDictionary>
implements IStructureNode {
    private static final long serialVersionUID = 7204356181229674005L;

    public PdfStructElem(PdfDictionary pdfObject) {
        super(pdfObject);
        this.setForbidRelease();
    }

    public PdfStructElem(PdfDocument document, PdfName role, PdfPage page) {
        this(document, role);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Pg, (PdfObject)page.getPdfObject());
    }

    public PdfStructElem(PdfDocument document, PdfName role, PdfAnnotation annot) {
        this(document, role);
        if (annot.getPage() == null) {
            throw new PdfException("Annotation shall have reference to page.");
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Pg, (PdfObject)annot.getPage().getPdfObject());
    }

    public PdfStructElem(PdfDocument document, PdfName role) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(document));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.StructElem);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.S, role);
    }

    public static boolean isStructElem(PdfDictionary dictionary) {
        return PdfName.StructElem.equals(dictionary.getAsName(PdfName.Type)) || dictionary.containsKey(PdfName.S);
    }

    public PdfObject getAttributes(boolean createNewIfNull) {
        PdfObject attributes = ((PdfDictionary)this.getPdfObject()).get(PdfName.A);
        if (attributes == null && createNewIfNull) {
            attributes = new PdfDictionary();
            this.setAttributes(attributes);
        }
        return attributes;
    }

    public void setAttributes(PdfObject attributes) {
        this.put(PdfName.A, attributes);
    }

    public PdfString getLang() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Lang);
    }

    public void setLang(PdfString lang) {
        this.put(PdfName.Lang, lang);
    }

    public PdfString getAlt() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Alt);
    }

    public void setAlt(PdfString alt) {
        this.put(PdfName.Alt, alt);
    }

    public PdfString getActualText() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.ActualText);
    }

    public void setActualText(PdfString actualText) {
        this.put(PdfName.ActualText, actualText);
    }

    public PdfString getE() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.E);
    }

    public void setE(PdfString e) {
        this.put(PdfName.E, e);
    }

    @Override
    public PdfName getRole() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.S);
    }

    public void setRole(PdfName role) {
        this.put(PdfName.S, role);
    }

    public PdfStructElem addKid(PdfStructElem kid) {
        return this.addKid(-1, kid);
    }

    public PdfStructElem addKid(int index, PdfStructElem kid) {
        PdfStructElem.addKidObject((PdfDictionary)this.getPdfObject(), index, kid.getPdfObject());
        return kid;
    }

    public PdfMcr addKid(PdfMcr kid) {
        return this.addKid(-1, kid);
    }

    public PdfMcr addKid(int index, PdfMcr kid) {
        this.getDocEnsureIndirectForKids().getStructTreeRoot().getParentTreeHandler().registerMcr(kid);
        PdfStructElem.addKidObject((PdfDictionary)this.getPdfObject(), index, kid.getPdfObject());
        return kid;
    }

    public IStructureNode removeKid(int index) {
        return this.removeKid(index, false);
    }

    public IStructureNode removeKid(int index, boolean prepareForReAdding) {
        PdfObject k = this.getK();
        if (k == null || !k.isArray() && index != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (k.isArray()) {
            PdfArray kidsArray = (PdfArray)k;
            k = kidsArray.get(index);
            kidsArray.remove(index);
            if (kidsArray.isEmpty()) {
                ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
            }
        } else {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
        }
        this.setModified();
        IStructureNode removedKid = this.convertPdfObjectToIPdfStructElem(k);
        PdfDocument doc = this.getDocument();
        if (removedKid instanceof PdfMcr && doc != null && !prepareForReAdding) {
            doc.getStructTreeRoot().getParentTreeHandler().unregisterMcr((PdfMcr)removedKid);
        }
        return removedKid;
    }

    public int removeKid(IStructureNode kid) {
        if (kid instanceof PdfMcr) {
            PdfMcr mcr = (PdfMcr)kid;
            PdfDocument doc = this.getDocument();
            if (doc != null) {
                doc.getStructTreeRoot().getParentTreeHandler().unregisterMcr(mcr);
            }
            return this.removeKidObject((PdfObject)mcr.getPdfObject());
        }
        if (kid instanceof PdfStructElem) {
            return this.removeKidObject((PdfObject)((PdfStructElem)kid).getPdfObject());
        }
        return -1;
    }

    @Override
    public IStructureNode getParent() {
        PdfDictionary parent = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.P);
        if (parent == null) {
            return null;
        }
        if (parent.isFlushed()) {
            PdfDocument pdfDoc = this.getDocument();
            if (pdfDoc == null) {
                return null;
            }
            PdfStructTreeRoot structTreeRoot = pdfDoc.getStructTreeRoot();
            return structTreeRoot.getPdfObject() == parent ? structTreeRoot : new PdfStructElem(parent);
        }
        if (PdfStructElem.isStructElem(parent)) {
            return new PdfStructElem(parent);
        }
        PdfDocument pdfDoc = this.getDocument();
        boolean parentIsRoot = pdfDoc != null && PdfName.StructTreeRoot.equals(parent.getAsName(PdfName.Type));
        boolean bl = parentIsRoot = parentIsRoot || pdfDoc != null && pdfDoc.getStructTreeRoot().getPdfObject() == parent;
        if (parentIsRoot) {
            return pdfDoc.getStructTreeRoot();
        }
        return null;
    }

    @Override
    public List<IStructureNode> getKids() {
        PdfObject k = this.getK();
        ArrayList<IStructureNode> kids = new ArrayList<IStructureNode>();
        if (k != null) {
            if (k.isArray()) {
                PdfArray a = (PdfArray)k;
                for (int i = 0; i < a.size(); ++i) {
                    this.addKidObjectToStructElemList(a.get(i), kids);
                }
            } else {
                this.addKidObjectToStructElemList(k, kids);
            }
        }
        return kids;
    }

    public PdfObject getK() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.K);
    }

    public List<PdfStructElem> getRefsList() {
        PdfArray refsArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Ref);
        if (refsArray == null) {
            return Collections.emptyList();
        }
        ArrayList<PdfStructElem> refs = new ArrayList<PdfStructElem>(refsArray.size());
        for (int i = 0; i < refsArray.size(); ++i) {
            refs.add(new PdfStructElem(refsArray.getAsDictionary(i)));
        }
        return refs;
    }

    public void addRef(PdfStructElem ref) {
        if (!((PdfDictionary)ref.getPdfObject()).isIndirect()) {
            throw new PdfException("Ref array items in structure element dictionary shall be indirect objects.");
        }
        VersionConforming.validatePdfVersionForDictEntry(this.getDocument(), PdfVersion.PDF_2_0, PdfName.Ref, PdfName.StructElem);
        PdfArray refsArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Ref);
        if (refsArray == null) {
            refsArray = new PdfArray();
            this.put(PdfName.Ref, refsArray);
        }
        refsArray.add((PdfObject)ref.getPdfObject());
        this.setModified();
    }

    public PdfNamespace getNamespace() {
        PdfDictionary nsDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.NS);
        return nsDict != null ? new PdfNamespace(nsDict) : null;
    }

    public void setNamespace(PdfNamespace namespace) {
        VersionConforming.validatePdfVersionForDictEntry(this.getDocument(), PdfVersion.PDF_2_0, PdfName.NS, PdfName.StructElem);
        if (namespace != null) {
            this.put(PdfName.NS, (PdfObject)namespace.getPdfObject());
        } else {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.NS);
            this.setModified();
        }
    }

    public void setPhoneme(PdfString elementPhoneme) {
        VersionConforming.validatePdfVersionForDictEntry(this.getDocument(), PdfVersion.PDF_2_0, PdfName.Phoneme, PdfName.StructElem);
        this.put(PdfName.Phoneme, elementPhoneme);
    }

    public PdfString getPhoneme() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Phoneme);
    }

    public void setPhoneticAlphabet(PdfName phoneticAlphabet) {
        VersionConforming.validatePdfVersionForDictEntry(this.getDocument(), PdfVersion.PDF_2_0, PdfName.PhoneticAlphabet, PdfName.StructElem);
        this.put(PdfName.PhoneticAlphabet, phoneticAlphabet);
    }

    public PdfName getPhoneticAlphabet() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.PhoneticAlphabet);
    }

    public void addAssociatedFile(String description, PdfFileSpec fs) {
        PdfArray afArray;
        if (null == ((PdfDictionary)fs.getPdfObject()).get(PdfName.AFRelationship)) {
            Logger logger = LoggerFactory.getLogger(PdfStructElem.class);
            logger.error("For associated files their associated file specification dictionaries shall include the AFRelationship key.");
        }
        if (null != description) {
            this.getDocument().getCatalog().getNameTree(PdfName.EmbeddedFiles).addEntry(description, (PdfObject)fs.getPdfObject());
        }
        if ((afArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.AF)) == null) {
            afArray = new PdfArray();
            this.put(PdfName.AF, afArray);
        }
        afArray.add((PdfObject)fs.getPdfObject());
    }

    public void addAssociatedFile(PdfFileSpec fs) {
        this.addAssociatedFile(null, fs);
    }

    public PdfArray getAssociatedFiles(boolean create) {
        PdfArray afArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.AF);
        if (afArray == null && create) {
            afArray = new PdfArray();
            this.put(PdfName.AF, afArray);
        }
        return afArray;
    }

    public PdfStructElem put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    @Override
    public void flush() {
        PdfDocument doc;
        PdfDictionary pageDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Pg);
        if (pageDict == null || pageDict.getIndirectReference() != null && pageDict.getIndirectReference().isFree()) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.Pg);
        }
        if ((doc = this.getDocument()) != null) {
            doc.checkIsoConformance(this.getPdfObject(), IsoKey.TAG_STRUCTURE_ELEMENT);
        }
        super.flush();
    }

    static void addKidObject(PdfDictionary parent, int index, PdfObject kid) {
        if (parent.isFlushed()) {
            throw new PdfException("Cannot add kid to the flushed element.");
        }
        if (!parent.containsKey(PdfName.P)) {
            throw new PdfException("StructureElement shall contain parent object.", parent);
        }
        PdfObject k = parent.get(PdfName.K);
        if (k == null) {
            parent.put(PdfName.K, kid);
        } else {
            PdfArray a;
            if (k instanceof PdfArray) {
                a = (PdfArray)k;
            } else {
                a = new PdfArray();
                a.add(k);
                parent.put(PdfName.K, a);
            }
            if (index == -1) {
                a.add(kid);
            } else {
                a.add(index, kid);
            }
        }
        parent.setModified();
        if (kid instanceof PdfDictionary && PdfStructElem.isStructElem((PdfDictionary)kid)) {
            if (!parent.isIndirect()) {
                throw new PdfException("Structure element dictionary shall be an indirect object in order to have children.");
            }
            ((PdfDictionary)kid).put(PdfName.P, parent);
            kid.setModified();
        }
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfDocument getDocument() {
        PdfDictionary structDict = (PdfDictionary)this.getPdfObject();
        PdfIndirectReference indRef = structDict.getIndirectReference();
        if (indRef == null && structDict.getAsDictionary(PdfName.P) != null) {
            indRef = structDict.getAsDictionary(PdfName.P).getIndirectReference();
        }
        return indRef != null ? indRef.getDocument() : null;
    }

    private PdfDocument getDocEnsureIndirectForKids() {
        PdfDocument doc = this.getDocument();
        if (doc == null) {
            throw new PdfException("Structure element dictionary shall be an indirect object in order to have children.");
        }
        return doc;
    }

    private void addKidObjectToStructElemList(PdfObject k, List<IStructureNode> list) {
        if (k.isFlushed()) {
            list.add(null);
            return;
        }
        list.add(this.convertPdfObjectToIPdfStructElem(k));
    }

    private IStructureNode convertPdfObjectToIPdfStructElem(PdfObject obj) {
        PdfObjectWrapper elem = null;
        switch (obj.getType()) {
            case 3: {
                PdfDictionary d = (PdfDictionary)obj;
                if (PdfStructElem.isStructElem(d)) {
                    elem = new PdfStructElem(d);
                    break;
                }
                if (PdfName.MCR.equals(d.getAsName(PdfName.Type))) {
                    elem = new PdfMcrDictionary(d, this);
                    break;
                }
                if (!PdfName.OBJR.equals(d.getAsName(PdfName.Type))) break;
                elem = new PdfObjRef(d, this);
                break;
            }
            case 8: {
                elem = new PdfMcrNumber((PdfNumber)obj, this);
                break;
            }
        }
        return elem;
    }

    private int removeKidObject(PdfObject kid) {
        PdfObject k = this.getK();
        if (k == null || !k.isArray() && k != kid && k != kid.getIndirectReference()) {
            return -1;
        }
        int removedIndex = -1;
        if (k.isArray()) {
            PdfArray kidsArray = (PdfArray)k;
            removedIndex = PdfStructElem.removeObjectFromArray(kidsArray, kid);
        }
        if (!k.isArray() || k.isArray() && ((PdfArray)k).isEmpty()) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
            removedIndex = 0;
        }
        this.setModified();
        return removedIndex;
    }

    private static int removeObjectFromArray(PdfArray array, PdfObject toRemove) {
        int i;
        for (i = 0; i < array.size(); ++i) {
            PdfObject obj = array.get(i);
            if (obj != toRemove && obj != toRemove.getIndirectReference()) continue;
            array.remove(i);
            break;
        }
        return i;
    }
}

