/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.numbering;

public class ArmenianNumbering {
    private static final ArmenianDigit[] DIGITS = new ArmenianDigit[]{new ArmenianDigit('\u0531', 1), new ArmenianDigit('\u0532', 2), new ArmenianDigit('\u0533', 3), new ArmenianDigit('\u0534', 4), new ArmenianDigit('\u0535', 5), new ArmenianDigit('\u0536', 6), new ArmenianDigit('\u0537', 7), new ArmenianDigit('\u0538', 8), new ArmenianDigit('\u0539', 9), new ArmenianDigit('\u053a', 10), new ArmenianDigit('\u053b', 20), new ArmenianDigit('\u053c', 30), new ArmenianDigit('\u053d', 40), new ArmenianDigit('\u053e', 50), new ArmenianDigit('\u053f', 60), new ArmenianDigit('\u0540', 70), new ArmenianDigit('\u0541', 80), new ArmenianDigit('\u0542', 90), new ArmenianDigit('\u0543', 100), new ArmenianDigit('\u0544', 200), new ArmenianDigit('\u0545', 300), new ArmenianDigit('\u0546', 400), new ArmenianDigit('\u0547', 500), new ArmenianDigit('\u0548', 600), new ArmenianDigit('\u0549', 700), new ArmenianDigit('\u054a', 800), new ArmenianDigit('\u054b', 900), new ArmenianDigit('\u054c', 1000), new ArmenianDigit('\u054d', 2000), new ArmenianDigit('\u054e', 3000), new ArmenianDigit('\u054f', 4000), new ArmenianDigit('\u0550', 5000), new ArmenianDigit('\u0551', 6000), new ArmenianDigit('\u0552', 7000), new ArmenianDigit('\u0553', 8000), new ArmenianDigit('\u0554', 9000)};

    private ArmenianNumbering() {
    }

    public static String toArmenian(int number) {
        StringBuilder result = new StringBuilder();
        for (int i = DIGITS.length - 1; i >= 0; --i) {
            ArmenianDigit curDigit = DIGITS[i];
            while (number >= curDigit.value) {
                result.append(curDigit.digit);
                number -= curDigit.value;
            }
        }
        return result.toString();
    }

    private static class ArmenianDigit {
        char digit;
        int value;

        ArmenianDigit(char digit, int value) {
            this.digit = digit;
            this.value = value;
        }
    }
}

