/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.geom;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.BezierCurve;
import com.itextpdf.kernel.geom.IShape;
import com.itextpdf.kernel.geom.Line;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Path;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Subpath;
import java.util.Arrays;
import java.util.List;

public final class ShapeTransformUtil {
    public static BezierCurve transformBezierCurve(BezierCurve bezierCurve, Matrix ctm) {
        return (BezierCurve)ShapeTransformUtil.transformSegment(bezierCurve, ctm);
    }

    public static Line transformLine(Line line, Matrix ctm) {
        return (Line)ShapeTransformUtil.transformSegment(line, ctm);
    }

    public static Path transformPath(Path path, Matrix ctm) {
        Path newPath = new Path();
        for (Subpath subpath : path.getSubpaths()) {
            Subpath transformedSubpath = ShapeTransformUtil.transformSubpath(subpath, ctm);
            newPath.addSubpath(transformedSubpath);
        }
        return newPath;
    }

    private static Subpath transformSubpath(Subpath subpath, Matrix ctm) {
        Subpath newSubpath = new Subpath();
        newSubpath.setClosed(subpath.isClosed());
        for (IShape segment : subpath.getSegments()) {
            IShape transformedSegment = ShapeTransformUtil.transformSegment(segment, ctm);
            newSubpath.addSegment(transformedSegment);
        }
        return newSubpath;
    }

    private static IShape transformSegment(IShape segment, Matrix ctm) {
        List<Point> basePoints = segment.getBasePoints();
        Point[] newBasePoints = ShapeTransformUtil.transformPoints(ctm, basePoints.toArray(new Point[basePoints.size()]));
        IShape newSegment = segment instanceof BezierCurve ? new BezierCurve(Arrays.asList(newBasePoints)) : new Line(newBasePoints[0], newBasePoints[1]);
        return newSegment;
    }

    private static Point[] transformPoints(Matrix ctm, Point ... points) {
        try {
            AffineTransform t = new AffineTransform(ctm.get(0), ctm.get(1), ctm.get(3), ctm.get(4), ctm.get(6), ctm.get(7));
            t = t.createInverse();
            Point[] newPoints = new Point[points.length];
            t.transform(points, 0, newPoints, 0, points.length);
            return newPoints;
        }
        catch (NoninvertibleTransformException e) {
            throw new PdfException("A noninvertible matrix has been parsed. The behaviour is unpredictable.", e);
        }
    }
}

