/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.List;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.MethodInvoker;
import org.beetl.core.om.ObjectAA;
import org.beetl.core.om.ObjectUtil;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IVarIndex;
import org.beetl.core.statement.Type;
import org.beetl.core.statement.VarAttribute;

public class VarRef
extends Expression
implements IVarIndex {
    public VarAttribute[] attributes;
    public Expression safe;
    public int varIndex;
    public boolean hasSafe;
    private GrammarToken firstToken = null;

    public VarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token) {
        this(attributes, hasSafe, safe, token, token);
    }

    public VarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token, GrammarToken firstToken) {
        super(token);
        this.attributes = attributes;
        this.safe = safe;
        this.hasSafe = hasSafe;
        this.firstToken = firstToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Context ctx) {
        Object attr;
        Object value;
        block23: {
            value = ctx.vars[this.varIndex];
            if (value == Context.NOT_EXIST_OBJECT) {
                if (ctx.globalVar != null && ctx.globalVar.containsKey("_root")) {
                    Object root = ctx.getGlobal("_root");
                    attr = this.firstToken.text;
                    if (root == null) {
                        if (!this.hasSafe) {
                            BeetlException be = new BeetlException("NULL", "\u6839\u5bf9\u8c61\u4e3a\u7a7a\u6307\u9488\uff0c\u65e0" + this.firstToken.text + "\u503c");
                            be.pushToken(this.firstToken);
                            throw be;
                        }
                        if (this.safe == null) {
                            return null;
                        }
                        Object object = this.safe.evaluate(ctx);
                        return object;
                    }
                    if (!this.hasAttr(root, (String)attr)) {
                        BeetlException ex = new BeetlException("ATTRIBUTE_INVALID", "\u6839\u5bf9\u8c61 " + root.getClass() + " \u65e0\u6b64\u5c5e\u6027");
                        ex.pushToken(this.firstToken);
                        throw ex;
                    }
                    value = ObjectAA.defaultObjectAA().value(root, attr);
                    if (value == null && this.hasSafe) {
                        if (this.safe == null) {
                            return null;
                        }
                        Object object = this.safe.evaluate(ctx);
                        return object;
                    }
                    ctx.vars[this.varIndex] = value;
                    break block23;
                } else {
                    if (!this.hasSafe) {
                        BeetlException ex = new BeetlException("VAR_NOT_DEFINED");
                        ex.pushToken(this.firstToken);
                        throw ex;
                    }
                    if (this.safe == null) {
                        return null;
                    }
                    Object object = this.safe.evaluate(ctx);
                    return object;
                }
            }
            if (value == null && this.hasSafe) {
                if (this.safe == null) {
                    return null;
                }
                Object object = this.safe.evaluate(ctx);
                return object;
            }
        }
        if (this.attributes.length == 0) {
            return value;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            attr = this.attributes[i];
            if (value == null) {
                if (this.hasSafe) {
                    if (this.safe == null) {
                        return null;
                    }
                    Object object = this.safe.evaluate(ctx);
                    return object;
                }
                BeetlException be = new BeetlException("NULL", "\u7a7a\u6307\u9488");
                if (i == 0) {
                    be.pushToken(this.firstToken);
                    throw be;
                }
                be.pushToken(this.attributes[i - 1].token);
                throw be;
            }
            try {
                value = ((VarAttribute)attr).evaluate(ctx, value);
                continue;
            }
            catch (BeetlException ex) {
                ex.pushToken(((VarAttribute)attr).token);
                throw ex;
            }
            catch (RuntimeException ex) {
                BeetlException be = new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex);
                be.pushToken(((VarAttribute)attr).token);
                throw be;
            }
        }
        if (value != null) return value;
        if (!this.hasSafe) return value;
        if (this.safe == null) {
            return null;
        }
        Object object = this.safe.evaluate(ctx);
        return object;
    }

    private boolean hasAttr(Object o, String attr) {
        if (o instanceof Map) {
            return ((Map)o).containsKey(attr);
        }
        if (o instanceof List) {
            return true;
        }
        Class<?> c = o.getClass();
        MethodInvoker invoker = ObjectUtil.getInvokder(c, attr);
        return invoker != null;
    }

    public Object evaluateUntilLast(Context ctx) {
        if (this.attributes.length == 0) {
            throw new RuntimeException();
        }
        Object value = ctx.vars[this.varIndex];
        if (value == Context.NOT_EXIST_OBJECT) {
            BeetlException ex = new BeetlException("VAR_NOT_DEFINED");
            ex.pushToken(this.firstToken);
            throw ex;
        }
        if (value == null) {
            BeetlException ex = new BeetlException("NULL");
            ex.pushToken(this.firstToken);
            throw ex;
        }
        for (int i = 0; i < this.attributes.length - 1; ++i) {
            VarAttribute attr = this.attributes[i];
            if (value == null) {
                BeetlException be = new BeetlException("NULL", "\u7a7a\u6307\u9488");
                if (i == 0) {
                    be.pushToken(this.firstToken);
                } else {
                    be.pushToken(this.attributes[i - 1].token);
                }
                throw be;
            }
            try {
                value = attr.evaluate(ctx, value);
                continue;
            }
            catch (BeetlException ex) {
                ex.pushToken(attr.token);
                throw ex;
            }
            catch (RuntimeException ex) {
                BeetlException be = new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex);
                be.pushToken(attr.token);
                throw be;
            }
        }
        return value;
    }

    @Override
    public void setVarIndex(int index) {
        this.varIndex = index;
    }

    @Override
    public int getVarIndex() {
        return this.varIndex;
    }

    @Override
    public void infer(InferContext inferCtx) {
        Type type;
        Type lastType = type = inferCtx.types[this.varIndex];
        Type t = null;
        for (VarAttribute attr : this.attributes) {
            inferCtx.temp = lastType;
            attr.infer(inferCtx);
            t = lastType;
            lastType = attr.type;
            attr.type = t;
        }
        this.type = lastType;
        if (this.safe != null) {
            this.safe.infer(inferCtx);
            if (!this.safe.type.equals(this.type)) {
                this.type = Type.ObjectType;
            }
        }
    }
}

