/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Configuration {
    String charset = "UTF-8";
    String placeholderStart = "${";
    String placeholderEnd = "}";
    String statementStart = "<%";
    String statementEnd = "%>";
    String htmlTagFlag = "#";
    boolean isHtmlTagSupport = false;
    boolean nativeCall = false;
    boolean directByteOutput = false;
    boolean isStrict = false;
    boolean isIgnoreClientIOError = true;
    String errorHandlerClass = "org.beetl.core.ConsoleErrorHandler";
    String htmlTagStart = "<" + this.htmlTagFlag;
    String htmlTagEnd = "</" + this.htmlTagFlag;
    String htmlTagBindingAttribute = "var";
    Set<String> pkgList = new HashSet<String>();
    String webAppExt = null;
    boolean hasFunctionLimiter = false;
    String functionLimiterStart = null;
    String functionLimiterEnd = null;
    String engine = "org.beetl.core.FastRuntimeEngine";
    String nativeSecurity = "org.beetl.core.DefaultNativeSecurityManager";
    String resourceLoader = "org.beetl.core.resource.ClasspathResourceLoader";
    Map<String, String> fnMap = new HashMap<String, String>();
    Map<String, String> fnPkgMap = new HashMap<String, String>();
    Map<String, String> formatMap = new HashMap<String, String>();
    Map<String, String> defaultFormatMap = new HashMap<String, String>(0);
    Set<String> generalVirtualAttributeSet = new HashSet<String>();
    Map<String, String> virtualClass = new HashMap<String, String>();
    Map<String, String> tagFactoryMap = new HashMap<String, String>();
    Map<String, String> tagMap = new HashMap<String, String>();
    Map<String, String> resourceMap = new HashMap<String, String>();
    public static String DELIMITER_PLACEHOLDER_START = "DELIMITER_PLACEHOLDER_START";
    public static String DELIMITER_PLACEHOLDER_END = "DELIMITER_PLACEHOLDER_END";
    public static String DELIMITER_STATEMENT_START = "DELIMITER_STATEMENT_START";
    public static String DELIMITER_STATEMENT_END = "DELIMITER_STATEMENT_END";
    public static String NATIVE_CALL = "NATIVE_CALL";
    public static String IGNORE_CLIENT_IO_ERROR = "IGNORE_CLIENT_IO_ERROR";
    public static String DIRECT_BYTE_OUTPUT = "DIRECT_BYTE_OUTPUT";
    public static String TEMPLATE_ROOT = "TEMPLATE_ROOT";
    public static String TEMPLATE_CHARSET = "TEMPLATE_CHARSET";
    public static String ERROR_HANDLER = "ERROR_HANDLER";
    public static String MVC_STRICT = "MVC_STRICT";
    public static String WEBAPP_EXT = "WEBAPP_EXT";
    public static String HTML_TAG_SUPPORT = "HTML_TAG_SUPPORT";
    public static String HTML_TAG_FLAG = "HTML_TAG_FLAG";
    public static String IMPORT_PACKAGE = "IMPORT_PACKAGE";
    public static String ENGINE = "ENGINE";
    public static String NATIVE_SECUARTY_MANAGER = "NATIVE_SECUARTY_MANAGER";
    public static String RESOURCE_LOADER = "RESOURCE_LOADER";
    public static String HTML_TAG_BINDING_ATTRIBUTE = "HTML_TAG_BINDING_ATTRIBUTE";
    public static String FUNCTION_TAG_LIMITER = "FUNCTION_TAG_LIMITER";
    Properties ps = null;

    public Configuration() throws IOException {
        this.pkgList.add("java.util.");
        this.pkgList.add("java.lang.");
        this.ps = new Properties();
        this.ps.load(Configuration.class.getResourceAsStream("/org/beetl/core/beetl-default.properties"));
        this.parseProperties(this.ps);
        InputStream ins = Configuration.class.getResourceAsStream("/beetl.properties");
        if (ins != null) {
            this.ps.clear();
            this.ps.load(ins);
            this.parseProperties(this.ps);
        }
    }

    public Configuration(Properties ps) throws IOException {
        this();
        this.parseProperties(ps);
    }

    public void add(File path) throws IOException {
        Properties ps = new Properties();
        ps.load(new FileReader(path));
        this.parseProperties(ps);
    }

    public void add(String path) throws IOException {
        Properties ps = new Properties();
        ps.load(Configuration.class.getResourceAsStream(path));
        this.parseProperties(ps);
    }

    protected void parseProperties(Properties ps) {
        Set<Map.Entry<Object, Object>> set = ps.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setValue(key, value == null ? null : value.trim());
        }
    }

    protected void setValue(String key, String value) {
        if (key.equalsIgnoreCase(TEMPLATE_CHARSET)) {
            this.charset = value;
        } else if (key.equalsIgnoreCase(DELIMITER_PLACEHOLDER_START)) {
            this.placeholderStart = value;
        } else if (key.equalsIgnoreCase(DELIMITER_PLACEHOLDER_END)) {
            this.placeholderEnd = value;
        } else if (key.equalsIgnoreCase(DELIMITER_STATEMENT_START)) {
            this.statementStart = value;
        } else if (key.equalsIgnoreCase(DELIMITER_STATEMENT_END)) {
            this.statementEnd = value == null | value.length() == 0 || value.equals("null") ? null : value;
        } else if (key.equalsIgnoreCase(NATIVE_CALL)) {
            this.nativeCall = this.isBoolean(value, false);
        } else if (key.equalsIgnoreCase(IGNORE_CLIENT_IO_ERROR)) {
            this.isIgnoreClientIOError = this.isBoolean(value, false);
        } else if (key.equalsIgnoreCase(DIRECT_BYTE_OUTPUT)) {
            this.directByteOutput = this.isBoolean(value, false);
        } else if (key.equalsIgnoreCase(ERROR_HANDLER)) {
            this.errorHandlerClass = value == null | value.length() == 0 || value.equals("null") ? null : value;
        } else if (key.equalsIgnoreCase(WEBAPP_EXT)) {
            this.webAppExt = value == null || value.length() == 0 ? null : value;
        } else if (key.equalsIgnoreCase(MVC_STRICT)) {
            this.isStrict = this.isBoolean(value, false);
        } else if (key.equalsIgnoreCase(HTML_TAG_SUPPORT)) {
            this.isHtmlTagSupport = this.isBoolean(value, false);
        } else if (key.equalsIgnoreCase(HTML_TAG_FLAG)) {
            this.htmlTagFlag = value;
            this.htmlTagStart = "<" + this.htmlTagFlag;
            this.htmlTagEnd = "</" + this.htmlTagFlag;
        } else if (key.equalsIgnoreCase(HTML_TAG_BINDING_ATTRIBUTE)) {
            this.htmlTagBindingAttribute = value;
        } else if (key.equalsIgnoreCase(IMPORT_PACKAGE)) {
            String[] strs;
            for (String pkg : strs = value.split(";")) {
                this.pkgList.add(pkg);
            }
        } else if (key.equalsIgnoreCase(ENGINE)) {
            this.engine = value;
        } else if (key.equalsIgnoreCase(NATIVE_SECUARTY_MANAGER)) {
            this.nativeSecurity = value;
        } else if (key.equalsIgnoreCase(RESOURCE_LOADER)) {
            this.resourceLoader = value;
        } else if (key.equalsIgnoreCase(FUNCTION_TAG_LIMITER)) {
            if (value != null && value.trim().length() != 0) {
                this.hasFunctionLimiter = true;
                String[] pair = value.split(";");
                this.functionLimiterStart = pair[0];
                this.functionLimiterEnd = pair[1];
                if (this.functionLimiterEnd.equalsIgnoreCase("null")) {
                    this.functionLimiterEnd = null;
                }
            }
        } else if (key.startsWith("fn.") || key.startsWith("FN.")) {
            this.addFunction(key, value);
        } else if (key.startsWith("fnp.") || key.startsWith("FNP.")) {
            this.addFunctionPackage(key, value);
        } else if (key.startsWith("ft.") || key.startsWith("FT.")) {
            this.addFormat(key, value);
        } else if (key.startsWith("ftc.") || key.startsWith("FTC.")) {
            this.addDefaultFormat(key, value);
        } else if (key.startsWith("virtual.") || key.startsWith("VIRTUAL.")) {
            this.addVirtual(key, value);
        } else if (key.startsWith("general_virtual.") || key.startsWith("GENERAL_VIRTUAL.")) {
            String[] allCls;
            for (String cls : allCls = value.split(";")) {
                this.generalVirtualAttributeSet.add(cls);
            }
        } else if (key.startsWith("tag.") || key.startsWith("TAG.")) {
            this.addTag(key, value);
        } else if (key.startsWith("tagf.") || key.startsWith("TAGF.")) {
            this.addTagFactory(key, value);
        } else if (key.startsWith("resource.") || key.startsWith("RESOURCE.")) {
            this.addResource(key, value);
        }
    }

    private void addResource(String key, String value) {
        String name = this.getExtName(key);
        this.resourceMap.put(name, value);
    }

    private void addTagFactory(String key, String value) {
        String name = this.getExtName(key);
        this.tagFactoryMap.put(name, value);
    }

    private void addTag(String key, String value) {
        String name = this.getExtName(key);
        this.tagMap.put(name, value);
    }

    private void addVirtual(String key, String value) {
        String name = this.getExtName(key);
        this.virtualClass.put(name, value);
    }

    private void addDefaultFormat(String key, String value) {
        String name = this.getExtName(key);
        this.defaultFormatMap.put(name, value);
    }

    private void addFormat(String key, String value) {
        String name = this.getExtName(key);
        this.formatMap.put(name, value);
    }

    private void addFunction(String key, String value) {
        String name = this.getExtName(key);
        this.fnMap.put(name, value);
    }

    private void addFunctionPackage(String key, String value) {
        String name = this.getExtName(key);
        this.fnPkgMap.put(name, value);
    }

    private String getExtName(String key) {
        int index = key.indexOf(".");
        String name = key.substring(index + 1);
        return name;
    }

    private boolean isBoolean(String value, boolean defaultValue) {
        if (this.isNotEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public boolean isNotEmpty(String str) {
        return str != null && str.length() != 0;
    }

    public String getCharset() {
        return this.charset;
    }

    public static Configuration defaultConfiguration() throws IOException {
        return new Configuration();
    }

    public String getPlaceholderStart() {
        return this.placeholderStart;
    }

    public void setPlaceholderStart(String placeholderStart) {
        this.placeholderStart = placeholderStart;
    }

    public String getPlaceholderEnd() {
        return this.placeholderEnd;
    }

    public void setPlaceholderEnd(String placeholderEnd) {
        this.placeholderEnd = placeholderEnd;
    }

    public String getStatementStart() {
        return this.statementStart;
    }

    public void setStatementStart(String statementStart) {
        this.statementStart = statementStart;
    }

    public String getStatementEnd() {
        return this.statementEnd;
    }

    public void setStatementEnd(String statementEnd) {
        this.statementEnd = statementEnd;
    }

    public String getHtmlTagFlag() {
        return this.htmlTagFlag;
    }

    public void setHtmlTagFlag(String htmlTagFlag) {
        this.htmlTagFlag = htmlTagFlag;
    }

    public boolean isHtmlTagSupport() {
        return this.isHtmlTagSupport;
    }

    public void setHtmlTagSupport(boolean isHtmlTagSupport) {
        this.isHtmlTagSupport = isHtmlTagSupport;
    }

    public boolean isNativeCall() {
        return this.nativeCall;
    }

    public void setNativeCall(boolean nativeCall) {
        this.nativeCall = nativeCall;
    }

    public boolean isDirectByteOutput() {
        return this.directByteOutput;
    }

    public void setDirectByteOutput(boolean directByteOutput) {
        this.directByteOutput = directByteOutput;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean isStrict) {
        this.isStrict = isStrict;
    }

    public String getHtmlTagStart() {
        return this.htmlTagStart;
    }

    public void setHtmlTagStart(String htmlTagStart) {
        this.htmlTagStart = htmlTagStart;
    }

    public String getHtmlTagEnd() {
        return this.htmlTagEnd;
    }

    public void setHtmlTagEnd(String htmlTagEnd) {
        this.htmlTagEnd = htmlTagEnd;
    }

    public String getHtmlTagBindingAttribute() {
        return this.htmlTagBindingAttribute;
    }

    public void setHtmlTagBindingAttribute(String htmlTagBindingAttribute) {
        this.htmlTagBindingAttribute = htmlTagBindingAttribute;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Set<String> getPkgList() {
        return this.pkgList;
    }

    public void addPkg(String pkg) {
        this.pkgList.add(pkg.concat("."));
    }

    public void setPkgList(Set<String> pkgList) {
        this.pkgList = pkgList;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getNativeSecurity() {
        return this.nativeSecurity;
    }

    public void setNativeSecurity(String nativeSecurity) {
        this.nativeSecurity = nativeSecurity;
    }

    public String getWebAppExt() {
        return this.webAppExt;
    }

    public void setWebAppExt(String webAppExt) {
        this.webAppExt = webAppExt;
    }

    public boolean isIgnoreClientIOError() {
        return this.isIgnoreClientIOError;
    }

    public void setIgnoreClientIOError(boolean isIgnoreClientIOError) {
        this.isIgnoreClientIOError = isIgnoreClientIOError;
    }

    public String getErrorHandlerClass() {
        return this.errorHandlerClass;
    }

    public void setErrorHandlerClass(String errorHandlerClass) {
        this.errorHandlerClass = errorHandlerClass;
    }

    public Map<String, String> getFnMap() {
        return this.fnMap;
    }

    public void setFnMap(Map<String, String> fnMap) {
        this.fnMap = fnMap;
    }

    public Map<String, String> getFnPkgMap() {
        return this.fnPkgMap;
    }

    public void setFnPkgMap(Map<String, String> fnPkgMap) {
        this.fnPkgMap = fnPkgMap;
    }

    public Map<String, String> getFormatMap() {
        return this.formatMap;
    }

    public void setFormatMap(Map<String, String> formatMap) {
        this.formatMap = formatMap;
    }

    public Map<String, String> getDefaultFormatMap() {
        return this.defaultFormatMap;
    }

    public void setDefaultFormatMap(Map<String, String> defaultFormatMap) {
        this.defaultFormatMap = defaultFormatMap;
    }

    public Set<String> getGeneralVirtualAttributeSet() {
        return this.generalVirtualAttributeSet;
    }

    public void setGeneralVirtualAttributeSet(Set<String> generalVirtualAttributeSet) {
        this.generalVirtualAttributeSet = generalVirtualAttributeSet;
    }

    public Map<String, String> getVirtualClass() {
        return this.virtualClass;
    }

    public void setVirtualClass(Map<String, String> virtualClass) {
        this.virtualClass = virtualClass;
    }

    public Map<String, String> getTagFactoryMap() {
        return this.tagFactoryMap;
    }

    public void setTagFactoryMap(Map<String, String> tagFactoryMap) {
        this.tagFactoryMap = tagFactoryMap;
    }

    public Map<String, String> getTagMap() {
        return this.tagMap;
    }

    public void setTagMap(Map<String, String> tagMap) {
        this.tagMap = tagMap;
    }

    public String getProperty(String name) {
        return this.ps.getProperty(name);
    }

    public String getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(String resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Map<String, String> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(Map<String, String> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public Properties getPs() {
        return this.ps;
    }

    public void setPs(Properties ps) {
        this.ps = ps;
    }

    public boolean isHasFunctionLimiter() {
        return this.hasFunctionLimiter;
    }

    public void setHasFunctionLimiter(boolean hasFunctionLimiter) {
        this.hasFunctionLimiter = hasFunctionLimiter;
    }

    public String getFunctionLimiterStart() {
        return this.functionLimiterStart;
    }

    public void setFunctionLimiterStart(String functionLimiterStart) {
        this.functionLimiterStart = functionLimiterStart;
    }

    public String getFunctionLimiterEnd() {
        return this.functionLimiterEnd;
    }

    public void setFunctionLimiterEnd(String functionLimiterEnd) {
        this.functionLimiterEnd = functionLimiterEnd;
    }
}

