/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.Signature;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class SmartHandle {
    private final Signature signature;
    private final MethodHandle handle;

    SmartHandle(Signature signature, MethodHandle handle) {
        this.signature = signature;
        this.handle = handle;
    }

    public static SmartHandle from(Signature signature, MethodHandle handle) {
        return new SmartHandle(signature, handle);
    }

    public static SmartHandle findStaticQuiet(MethodHandles.Lookup lookup, Class target, String name, Signature signature) {
        try {
            return new SmartHandle(signature, lookup.findStatic(target, name, signature.type()));
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
        catch (IllegalAccessException nae) {
            throw new RuntimeException(nae);
        }
    }

    public Signature signature() {
        return this.signature;
    }

    public MethodHandle handle() {
        return this.handle;
    }

    public SmartHandle apply(int index, Object arg) {
        return new SmartHandle(this.signature.dropArg(index), MethodHandles.insertArguments(this.handle, index, arg));
    }

    public SmartHandle apply(String name, Object arg) {
        return new SmartHandle(this.signature.dropArg(name), MethodHandles.insertArguments(this.handle, this.signature.argOffset(name), arg));
    }

    public SmartHandle applyLast(Object arg) {
        return new SmartHandle(this.signature.dropLast(), MethodHandles.insertArguments(this.handle, this.signature.type().parameterCount(), arg));
    }

    public SmartHandle drop(String beforeName, String newName, Class type) {
        return new SmartHandle(this.signature.insertArg(beforeName, newName, type), MethodHandles.dropArguments(this.handle, this.signature.argOffset(beforeName), new Class[]{type}));
    }

    public SmartHandle drop(int index, String newName, Class type) {
        return new SmartHandle(this.signature.insertArg(index, newName, type), MethodHandles.dropArguments(this.handle, index, new Class[]{type}));
    }

    public SmartHandle dropLast(String newName, Class type) {
        return new SmartHandle(this.signature.appendArg(newName, type), MethodHandles.dropArguments(this.handle, this.signature.argOffset(newName), new Class[]{type}));
    }

    public MethodHandle guard(MethodHandle target, MethodHandle fallback) {
        return MethodHandles.guardWithTest(this.handle, target, fallback);
    }

    public SmartHandle guard(SmartHandle target, SmartHandle fallback) {
        return new SmartHandle(target.signature, MethodHandles.guardWithTest(this.handle, target.handle, fallback.handle));
    }

    public SmartHandle bindTo(Object obj) {
        return new SmartHandle(this.signature.dropFirst(), this.handle.bindTo(obj));
    }

    public SmartHandle convert(MethodType incoming) {
        return new SmartHandle(new Signature(incoming, this.signature.argNames()), this.handle.asType(incoming));
    }

    public SmartHandle convert(Class returnType, Class ... argTypes) {
        return this.convert(MethodType.methodType(returnType, argTypes));
    }

    public SmartHandle convert(Signature incoming) {
        return new SmartHandle(incoming, this.handle.asType(incoming.type()));
    }

    public SmartHandle cast(MethodType incoming) {
        return new SmartHandle(new Signature(incoming, this.signature.argNames()), MethodHandles.explicitCastArguments(this.handle, incoming));
    }

    public SmartHandle cast(Signature incoming) {
        return new SmartHandle(incoming, MethodHandles.explicitCastArguments(this.handle, incoming.type()));
    }

    public SmartHandle cast(Class returnType, Class ... argTypes) {
        return this.cast(MethodType.methodType(returnType, argTypes));
    }

    public SmartHandle returnValue(Class type, Object value) {
        return new SmartHandle(this.signature.changeReturn(type), MethodHandles.filterReturnValue(this.handle, MethodHandles.constant(type, value)));
    }

    public String toString() {
        return this.signature.toString() + "=>" + this.handle;
    }
}

